/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Sphere3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrSegment3Sphere3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 3230285419117670503L;
    public float ZeroThreshold = 1.0E-6f;
    private Segment3f m_rkSegment;
    private Sphere3f m_rkSphere;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[]{new Vector3f(), new Vector3f()};
    private float[] m_afSegmentT = new float[2];

    public IntrSegment3Sphere3f(Segment3f rkSegment, Sphere3f rkSphere) {
        this.m_rkSegment = new Segment3f(rkSegment);
        this.m_rkSphere = new Sphere3f(rkSphere);
        this.m_iQuantity = 0;
        this.ZeroThreshold = 1.0E-6f;
    }

    public void dispose() {
        if (this.m_rkSegment != null) {
            this.m_rkSegment.dispose();
            this.m_rkSegment = null;
        }
        if (this.m_rkSphere != null) {
            this.m_rkSphere.dispose();
            this.m_rkSphere = null;
        }
        for (int i = 0; i < 2; ++i) {
            this.m_akPoint[i] = null;
        }
        this.m_akPoint = null;
        this.m_afSegmentT = null;
    }

    @Override
    public boolean Find() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkSegment.Center, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        float fA1 = this.m_rkSegment.Direction.Dot(kDiff);
        kDiff = null;
        float fDiscr = fA1 * fA1 - fA0;
        if (fDiscr < 0.0f) {
            this.m_iQuantity = 0;
            return false;
        }
        float fTmp0 = this.m_rkSegment.Extent * this.m_rkSegment.Extent + fA0;
        float fTmp1 = 2.0f * fA1 * this.m_rkSegment.Extent;
        float fQM = fTmp0 - fTmp1;
        float fQP = fTmp0 + fTmp1;
        if (fQM * fQP <= 0.0f) {
            float fRoot = (float)Math.sqrt(fDiscr);
            this.m_afSegmentT[0] = fQM > 0.0f ? -fA1 - fRoot : -fA1 + fRoot;
            Vector3f kScale = new Vector3f(this.m_rkSegment.Direction);
            kScale.Scale(this.m_afSegmentT[0]);
            this.m_akPoint[0].Add(this.m_rkSegment.Center, kScale);
            this.m_iQuantity = 1;
            kScale = null;
            return true;
        }
        if (fQM > 0.0f && Math.abs(fA1) < this.m_rkSegment.Extent) {
            if (fDiscr >= this.ZeroThreshold) {
                float fRoot = (float)Math.sqrt(fDiscr);
                this.m_afSegmentT[0] = -fA1 - fRoot;
                this.m_afSegmentT[1] = -fA1 + fRoot;
                Vector3f kScale = new Vector3f(this.m_rkSegment.Direction);
                kScale.Scale(this.m_afSegmentT[0]);
                this.m_akPoint[0].Add(this.m_rkSegment.Center, kScale);
                kScale.Copy(this.m_rkSegment.Direction);
                kScale.Scale(this.m_afSegmentT[1]);
                this.m_akPoint[1].Add(this.m_rkSegment.Center, kScale);
                this.m_iQuantity = 2;
                kScale = null;
            } else {
                this.m_afSegmentT[0] = -fA1;
                Vector3f kScale = new Vector3f(this.m_rkSegment.Direction);
                kScale.Scale(this.m_afSegmentT[0]);
                this.m_akPoint[0].Add(this.m_rkSegment.Center, kScale);
                kScale = null;
                this.m_iQuantity = 1;
            }
        } else {
            this.m_iQuantity = 0;
        }
        return this.m_iQuantity > 0;
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public final int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Segment3f GetSegment() {
        return this.m_rkSegment;
    }

    public final float GetSegmentT(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_afSegmentT[i];
    }

    public final Sphere3f GetSphere() {
        return this.m_rkSphere;
    }

    @Override
    public boolean Test() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkSegment.Center, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        float fA1 = this.m_rkSegment.Direction.Dot(kDiff);
        kDiff = null;
        float fDiscr = fA1 * fA1 - fA0;
        if (fDiscr < 0.0f) {
            return false;
        }
        float fTmp0 = this.m_rkSegment.Extent * this.m_rkSegment.Extent + fA0;
        float fTmp1 = 2.0f * fA1 * this.m_rkSegment.Extent;
        float fQM = fTmp0 - fTmp1;
        float fQP = fTmp0 + fTmp1;
        if (fQM * fQP <= 0.0f) {
            return true;
        }
        return fQM > 0.0f && Math.abs(fA1) < this.m_rkSegment.Extent;
    }
}

