/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class ColorRGB
implements Serializable {
    private static final long serialVersionUID = 5464603208600330459L;
    public static final ColorRGB BLACK = new ColorRGB(0.0f, 0.0f, 0.0f);
    public static final ColorRGB WHITE = new ColorRGB(1.0f, 1.0f, 1.0f);
    public static final ColorRGB INVALID = new ColorRGB(-1.0f, -1.0f, -1.0f);
    public float R = 0.0f;
    public float G = 0.0f;
    public float B = 0.0f;

    public ColorRGB() {
    }

    public ColorRGB(ColorRGB rkC) {
        this.R = rkC.R;
        this.G = rkC.G;
        this.B = rkC.B;
    }

    public ColorRGB(float fR, float fG, float fB) {
        this.R = fR;
        this.G = fG;
        this.B = fB;
    }

    public void Clamp() {
        if (this.R > 1.0f) {
            this.R = 1.0f;
        } else if (this.R < 0.0f) {
            this.R = 0.0f;
        }
        if (this.G > 1.0f) {
            this.G = 1.0f;
        } else if (this.G < 0.0f) {
            this.G = 0.0f;
        }
        if (this.B > 1.0f) {
            this.B = 1.0f;
        } else if (this.B < 0.0f) {
            this.B = 0.0f;
        }
    }

    public void Copy(ColorRGB rkC) {
        this.R = rkC.R;
        this.G = rkC.G;
        this.B = rkC.B;
    }

    public boolean equals(Object kObject) {
        ColorRGB kV = (ColorRGB)kObject;
        return this.R == kV.R && this.G == kV.G && this.B == kV.B;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.R) + Float.floatToIntBits(this.G) + Float.floatToIntBits(this.B);
    }

    public void Max(ColorRGB kC) {
        this.R = Math.max(this.R, kC.R);
        this.G = Math.max(this.G, kC.G);
        this.B = Math.max(this.B, kC.B);
    }

    public void Min(ColorRGB kC) {
        this.R = Math.min(this.R, kC.R);
        this.G = Math.min(this.G, kC.G);
        this.B = Math.min(this.B, kC.B);
    }

    public void ScaleByMax() {
        float fMax = this.R;
        if (this.G > fMax) {
            fMax = this.G;
        }
        if (this.B > fMax) {
            fMax = this.B;
        }
        if (fMax > 1.0f) {
            float fInvMax = 1.0f / fMax;
            this.R *= fInvMax;
            this.G *= fInvMax;
            this.B *= fInvMax;
        }
    }

    public void Set(float fR, float fG, float fB) {
        this.R = fR;
        this.G = fG;
        this.B = fB;
    }
}

