/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.Eigenf;

public class Ellipsoid3f {
    public Vector3f Center;
    public Vector3f[] Axis = new Vector3f[3];
    public float[] Extent = new float[3];

    public Ellipsoid3f() {
    }

    public Ellipsoid3f(Vector3f rkCenter, Vector3f[] akAxis, float[] afExtent) {
        this.Center = new Vector3f(rkCenter);
        for (int i = 0; i < 3; ++i) {
            this.Axis[i] = akAxis[i];
            this.Extent[i] = afExtent[i];
        }
    }

    public Ellipsoid3f(Vector3f rkCenter, Vector3f rkAxis0, Vector3f rkAxis1, Vector3f rkAxis2, float fExtent0, float fExtent1, float fExtent2) {
        this.Center = new Vector3f(rkCenter);
        this.Axis[0] = rkAxis0;
        this.Axis[1] = rkAxis1;
        this.Axis[2] = rkAxis2;
        this.Extent[0] = fExtent0;
        this.Extent[1] = fExtent1;
        this.Extent[2] = fExtent2;
    }

    public void dispose() {
    }

    public void GetM(Matrix3f rkM) {
        Vector3f kRatio0 = new Vector3f(this.Axis[0]);
        kRatio0.Scale(1.0f / this.Extent[0]);
        Vector3f kRatio1 = new Vector3f(this.Axis[1]);
        kRatio1.Scale(1.0f / this.Extent[1]);
        Vector3f kRatio2 = new Vector3f(this.Axis[2]);
        kRatio2.Scale(1.0f / this.Extent[2]);
        rkM = new Matrix3f();
        Matrix3f kT0 = new Matrix3f(kRatio0, kRatio0);
        Matrix3f kT1 = new Matrix3f(kRatio1, kRatio1);
        Matrix3f kT2 = new Matrix3f(kRatio2, kRatio2);
        rkM.Add(kT0, kT1);
        rkM.Add(kT2);
    }

    public void GetMInverse(Matrix3f rkMInverse) {
        Vector3f kRatio0 = new Vector3f(this.Axis[0]);
        kRatio0.Scale(this.Extent[0]);
        Vector3f kRatio1 = new Vector3f(this.Axis[1]);
        kRatio1.Scale(this.Extent[1]);
        Vector3f kRatio2 = new Vector3f(this.Axis[2]);
        kRatio2.Scale(this.Extent[2]);
        rkMInverse = new Matrix3f();
        Matrix3f kT0 = new Matrix3f(kRatio0, kRatio0);
        Matrix3f kT1 = new Matrix3f(kRatio1, kRatio1);
        Matrix3f kT2 = new Matrix3f(kRatio2, kRatio2);
        rkMInverse.Add(kT0, kT1);
        rkMInverse.Add(kT2);
    }

    public void ToCoefficients(float[] afCoeff) {
        Matrix3f kA = new Matrix3f();
        Vector3f kB = new Vector3f();
        float[] fC = new float[1];
        this.ToCoefficients(kA, kB, fC);
        Ellipsoid3f.Convert(kA, kB, fC[0], afCoeff);
        float fMax = Math.abs(afCoeff[4]);
        int iMax = 4;
        float fAbs = Math.abs(afCoeff[7]);
        if (fAbs > fMax) {
            fMax = fAbs;
            iMax = 7;
        }
        if ((fAbs = Math.abs(afCoeff[9])) > fMax) {
            fMax = fAbs;
            iMax = 9;
        }
        float fInvMax = 1.0f / fMax;
        for (int i = 0; i < 10; ++i) {
            if (i != iMax) {
                int n = i;
                afCoeff[n] = afCoeff[n] * fInvMax;
                continue;
            }
            afCoeff[i] = 1.0f;
        }
    }

    public void ToCoefficients(Matrix3f rkA, Vector3f rkB, float[] rfC) {
        Vector3f kRatio0 = new Vector3f(this.Axis[0]);
        kRatio0.Scale(1.0f / this.Extent[0]);
        Vector3f kRatio1 = new Vector3f(this.Axis[1]);
        kRatio1.Scale(1.0f / this.Extent[1]);
        Vector3f kRatio2 = new Vector3f(this.Axis[2]);
        kRatio2.Scale(1.0f / this.Extent[2]);
        rkA = new Matrix3f();
        Matrix3f kT0 = new Matrix3f(kRatio0, kRatio0);
        Matrix3f kT1 = new Matrix3f(kRatio1, kRatio1);
        Matrix3f kT2 = new Matrix3f(kRatio2, kRatio2);
        rkA.Add(kT0, kT1);
        rkA.Add(kT2);
        rkB = new Vector3f();
        rkA.Mult(this.Center, rkB);
        rkB.Scale(-2.0f);
        rfC[0] = rkA.QForm(this.Center, this.Center) - 1.0f;
    }

    public boolean FromCoefficients(float[] afCoeff) {
        Matrix3f kA = new Matrix3f();
        Vector3f kB = new Vector3f();
        float[] fC = new float[1];
        Ellipsoid3f.Convert(afCoeff, kA, kB, fC);
        return this.FromCoefficients(kA, kB, fC[0]);
    }

    public boolean FromCoefficients(Matrix3f rkA, Vector3f rkB, float fC) {
        Matrix3f kInvA = new Matrix3f();
        kInvA.Inverse(rkA);
        if (kInvA == Matrix3f.ZERO) {
            return false;
        }
        this.Center = new Vector3f();
        kInvA.Mult(rkB, this.Center);
        this.Center.Scale(-0.5f);
        float fRHS = -0.5f * this.Center.Dot(rkB) - fC;
        if (Math.abs(fRHS) < 1.0E-6f) {
            return false;
        }
        float fInvRHS = 1.0f / fRHS;
        Matrix3f kM = new Matrix3f(rkA);
        kM.Scale(fInvRHS);
        Eigenf kES = new Eigenf(kM);
        kES.IncrSortEigenStuff();
        for (int i = 0; i < 3; ++i) {
            if ((double)kES.GetEigenvalue(i) <= 0.0) {
                return false;
            }
            this.Extent[i] = Mathf.InvSqrt(kES.GetEigenvalue(i));
            kES.GetEigenvector(i, this.Axis[i]);
        }
        return true;
    }

    public float Evaluate(Vector3f rkPoint) {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(rkPoint, this.Center);
        float fRatio0 = this.Axis[0].Dot(kDiff) / this.Extent[0];
        float fRatio1 = this.Axis[1].Dot(kDiff) / this.Extent[1];
        float fRatio2 = this.Axis[2].Dot(kDiff) / this.Extent[2];
        float fValue = fRatio0 * fRatio0 + fRatio1 * fRatio1 + fRatio2 * fRatio2 - 1.0f;
        return fValue;
    }

    public boolean Contains(Vector3f rkPoint) {
        return this.Evaluate(rkPoint) <= 0.0f;
    }

    private static void Convert(float[] afCoeff, Matrix3f rkA, Vector3f rkB, float[] rfC) {
        rfC[0] = afCoeff[0];
        rkB.X = afCoeff[1];
        rkB.Y = afCoeff[2];
        rkB.X = afCoeff[3];
        rkA.Set(0, 0, afCoeff[4]);
        rkA.Set(0, 1, 0.5f * afCoeff[5]);
        rkA.Set(0, 2, 0.5f * afCoeff[6]);
        rkA.Set(1, 0, rkA.Get(0, 1));
        rkA.Set(1, 1, afCoeff[7]);
        rkA.Set(1, 2, 0.5f * afCoeff[8]);
        rkA.Set(2, 0, rkA.Get(0, 2));
        rkA.Set(2, 1, rkA.Get(1, 2));
        rkA.Set(2, 2, afCoeff[9]);
    }

    private static void Convert(Matrix3f rkA, Vector3f rkB, float fC, float[] afCoeff) {
        afCoeff[0] = fC;
        afCoeff[1] = rkB.X;
        afCoeff[2] = rkB.Y;
        afCoeff[3] = rkB.Z;
        afCoeff[4] = rkA.Get(0, 0);
        afCoeff[5] = 2.0f * rkA.Get(0, 1);
        afCoeff[6] = 2.0f * rkA.Get(0, 2);
        afCoeff[7] = rkA.Get(1, 1);
        afCoeff[8] = 2.0f * rkA.Get(1, 2);
        afCoeff[9] = rkA.Get(2, 2);
    }
}

