/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.GVectorf;
import java.io.Serializable;

public class GMatrixf
implements Serializable {
    private static final long serialVersionUID = -1176828476792837614L;
    private int m_iRows;
    private int m_iCols;
    private int m_iQuantity;
    private float[] m_afData = null;

    public GMatrixf() {
        this.SetSize(0, 0);
    }

    public GMatrixf(GMatrixf rkM) {
        this.SetMatrix(rkM.GetRows(), rkM.GetColumns(), rkM.GetData());
    }

    public GMatrixf(int iRows, int iCols) {
        this.SetSize(iRows, iCols);
    }

    public GMatrixf(int iRows, int iCols, float[] afEntry) {
        this.SetMatrix(iRows, iCols, afEntry);
    }

    public GMatrixf(int iRows, int iCols, float[][] aafMatrix) {
        this.SetMatrix(iRows, iCols, aafMatrix);
    }

    public GMatrixf(int iRows, int iCols, double[][] aafMatrix) {
        this.SetMatrix(iRows, iCols, aafMatrix);
    }

    public void Copy(GMatrixf rkM) {
        this.SetMatrix(rkM.GetRows(), rkM.GetColumns(), rkM.GetData());
    }

    public void dispose() {
        this.Deallocate();
    }

    public float Get(int iRow, int iCol) {
        assert (0 <= iRow && iRow < this.m_iRows && 0 <= iCol && iCol < this.m_iCols);
        return this.m_afData[iRow * this.m_iCols + iCol];
    }

    public GVectorf GetColumn(int iCol) {
        assert (0 <= iCol && iCol < this.m_iCols);
        GVectorf kV = new GVectorf(this.m_iRows);
        for (int iRow = 0; iRow < this.m_iRows; ++iRow) {
            kV.Set(iRow, this.m_afData[iRow * this.m_iCols + iCol]);
        }
        return kV;
    }

    public int GetColumns() {
        return this.m_iCols;
    }

    public float[] GetData() {
        return this.m_afData;
    }

    public void GetData(float[][] aafMatrix) {
        for (int iRow = 0; iRow < this.m_iRows; ++iRow) {
            for (int iCol = 0; iCol < this.m_iCols; ++iCol) {
                aafMatrix[iRow][iCol] = this.m_afData[iRow * this.m_iCols + iCol];
            }
        }
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public GVectorf GetRow(int iRow) {
        assert (0 <= iRow && iRow < this.m_iRows);
        GVectorf kV = new GVectorf(this.m_iCols);
        for (int iCol = 0; iCol < this.m_iCols; ++iCol) {
            kV.Set(iCol, this.m_afData[iRow * this.m_iCols + iCol]);
        }
        return kV;
    }

    public int GetRows() {
        return this.m_iRows;
    }

    public boolean Inverse() {
        float fSave;
        int i2;
        int i1;
        if (this.GetRows() > 0 && this.GetRows() != this.GetColumns()) {
            return false;
        }
        int iSize = this.GetRows();
        GMatrixf rkInverse = new GMatrixf(this);
        int[] aiColIndex = new int[iSize];
        int[] aiRowIndex = new int[iSize];
        boolean[] abPivoted = new boolean[iSize];
        for (int i0 = 0; i0 < iSize; ++i0) {
            abPivoted[i0] = false;
        }
        int iRow = 0;
        int iCol = 0;
        for (int i0 = 0; i0 < iSize; ++i0) {
            float fMax = 0.0f;
            for (i1 = 0; i1 < iSize; ++i1) {
                if (abPivoted[i1]) continue;
                for (i2 = 0; i2 < iSize; ++i2) {
                    float fAbs;
                    if (abPivoted[i2] || !((fAbs = Math.abs(rkInverse.Get(i1, i2))) > fMax)) continue;
                    fMax = fAbs;
                    iRow = i1;
                    iCol = i2;
                }
            }
            if (fMax == 0.0f) {
                return false;
            }
            abPivoted[iCol] = true;
            if (iRow != iCol) {
                rkInverse.SwapRows(iRow, iCol);
            }
            aiRowIndex[i0] = iRow;
            aiColIndex[i0] = iCol;
            float fInv = 1.0f / rkInverse.Get(iCol, iCol);
            rkInverse.Set(iCol, iCol, 1.0f);
            for (i2 = 0; i2 < iSize; ++i2) {
                rkInverse.Set(iCol, i2, rkInverse.Get(iCol, i2) * fInv);
            }
            for (i1 = 0; i1 < iSize; ++i1) {
                if (i1 == iCol) continue;
                fSave = rkInverse.Get(i1, iCol);
                rkInverse.Set(i1, iCol, 0.0f);
                for (i2 = 0; i2 < iSize; ++i2) {
                    rkInverse.Set(i1, i2, rkInverse.Get(i1, i2) - rkInverse.Get(iCol, i2) * fSave);
                }
            }
        }
        for (i1 = iSize - 1; i1 >= 0; --i1) {
            if (aiRowIndex[i1] == aiColIndex[i1]) continue;
            for (i2 = 0; i2 < iSize; ++i2) {
                fSave = rkInverse.Get(i2, aiRowIndex[i1]);
                rkInverse.Set(i2, aiRowIndex[i1], rkInverse.Get(i2, aiColIndex[i1]));
                rkInverse.Set(i2, aiColIndex[i1], fSave);
            }
        }
        this.Copy(rkInverse);
        return true;
    }

    public GMatrixf Mult(GMatrixf rkM) {
        assert (this.m_iCols == rkM.m_iRows);
        GMatrixf kProd = new GMatrixf(this.m_iRows, rkM.m_iCols);
        for (int iRow = 0; iRow < kProd.m_iRows; ++iRow) {
            for (int iCol = 0; iCol < kProd.m_iCols; ++iCol) {
                for (int iMid = 0; iMid < this.m_iCols; ++iMid) {
                    int n = iRow * kProd.m_iCols + iCol;
                    kProd.m_afData[n] = kProd.m_afData[n] + this.m_afData[iRow * this.m_iCols + iMid] * rkM.m_afData[iMid * rkM.m_iCols + iCol];
                }
            }
        }
        return kProd;
    }

    public void Set(int iRow, int iCol, float fValue) {
        assert (0 <= iRow && iRow < this.m_iRows && 0 <= iCol && iCol < this.m_iCols);
        this.m_afData[iRow * this.m_iCols + iCol] = fValue;
    }

    public void SetColumn(int iCol, GVectorf rkV) {
        assert (0 <= iCol && iCol < this.m_iCols && rkV.GetSize() == this.m_iRows);
        for (int iRow = 0; iRow < this.m_iRows; ++iRow) {
            this.m_afData[iRow * this.m_iCols + iCol] = rkV.Get(iRow);
        }
    }

    public void SetMatrix(int iRows, int iCols, float[] afEntry) {
        this.Deallocate();
        if (iRows > 0 && iCols > 0) {
            this.m_iRows = iRows;
            this.m_iCols = iCols;
            this.m_iQuantity = this.m_iRows * this.m_iCols;
            this.Allocate(false);
            for (int i = 0; i < this.m_iQuantity; ++i) {
                this.m_afData[i] = afEntry[i];
            }
        } else {
            this.m_iRows = 0;
            this.m_iCols = 0;
            this.m_iQuantity = 0;
            this.m_afData = null;
        }
    }

    public void SetMatrix(int iRows, int iCols, float[][] aafMatrix) {
        this.Deallocate();
        if (iRows > 0 && iCols > 0) {
            this.m_iRows = iRows;
            this.m_iCols = iCols;
            this.m_iQuantity = this.m_iRows * this.m_iCols;
            this.Allocate(false);
            for (int iRow = 0; iRow < this.m_iRows; ++iRow) {
                for (int iCol = 0; iCol < this.m_iCols; ++iCol) {
                    this.m_afData[iRow * this.m_iCols + iCol] = aafMatrix[iRow][iCol];
                }
            }
        } else {
            this.m_iRows = 0;
            this.m_iCols = 0;
            this.m_iQuantity = 0;
            this.m_afData = null;
        }
    }

    public void SetMatrix(int iRows, int iCols, double[][] aafMatrix) {
        this.Deallocate();
        if (iRows > 0 && iCols > 0) {
            this.m_iRows = iRows;
            this.m_iCols = iCols;
            this.m_iQuantity = this.m_iRows * this.m_iCols;
            this.Allocate(false);
            for (int iRow = 0; iRow < this.m_iRows; ++iRow) {
                for (int iCol = 0; iCol < this.m_iCols; ++iCol) {
                    this.m_afData[iRow * this.m_iCols + iCol] = (float)aafMatrix[iRow][iCol];
                }
            }
        } else {
            this.m_iRows = 0;
            this.m_iCols = 0;
            this.m_iQuantity = 0;
            this.m_afData = null;
        }
    }

    public void SetRow(int iRow, GVectorf rkV) {
        assert (0 <= iRow && iRow < this.m_iRows && rkV.GetSize() == this.m_iCols);
        for (int iCol = 0; iCol < this.m_iCols; ++iCol) {
            this.m_afData[iRow * this.m_iCols + iCol] = rkV.Get(iCol);
        }
    }

    public void SetSize(int iRows, int iCols) {
        this.Deallocate();
        if (iRows > 0 && iCols > 0) {
            this.m_iRows = iRows;
            this.m_iCols = iCols;
            this.m_iQuantity = this.m_iRows * this.m_iCols;
            this.Allocate(true);
        } else {
            this.m_iRows = 0;
            this.m_iCols = 0;
            this.m_iQuantity = 0;
            this.m_afData = null;
        }
    }

    public void SwapRows(int iRow0, int iRow1) {
        assert (0 <= iRow0 && iRow0 < this.m_iRows && 0 <= iRow1 && iRow1 < this.m_iRows);
        for (int i = 0; i < this.m_iCols; ++i) {
            float fSave = this.m_afData[iRow0 * this.m_iCols + i];
            this.m_afData[iRow0 * this.m_iCols + i] = this.m_afData[iRow1 * this.m_iCols + i];
            this.m_afData[iRow1 * this.m_iCols + i] = fSave;
        }
    }

    public String toString() {
        String kString = new String();
        for (int i = 0; i < this.m_iRows; ++i) {
            for (int j = 0; j < this.m_iCols; ++j) {
                kString = kString + new String(this.m_afData[i * this.m_iCols + j] + " ");
            }
            kString = kString + new String("\n");
        }
        return kString;
    }

    private void Allocate(boolean bSetToZero) {
        this.m_afData = new float[this.m_iQuantity];
        if (bSetToZero) {
            for (int i = 0; i < this.m_iQuantity; ++i) {
                this.m_afData[i] = 0.0f;
            }
        }
    }

    private void Deallocate() {
        this.m_afData = null;
    }
}

