/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class GVectorf
implements Serializable {
    private static final long serialVersionUID = -6504449004727292612L;
    private int m_iSize;
    private float[] m_afTuple = null;

    public GVectorf() {
        this.m_iSize = 0;
    }

    public GVectorf(GVectorf rkV) {
        this.m_iSize = rkV.m_iSize;
        if (this.m_iSize > 0) {
            this.m_afTuple = new float[this.m_iSize];
            for (int i = 0; i < this.m_iSize; ++i) {
                this.m_afTuple[i] = rkV.m_afTuple[i];
            }
        }
    }

    public GVectorf(int iSize) {
        if (iSize > 0) {
            this.m_iSize = iSize;
            this.m_afTuple = new float[this.m_iSize];
        } else {
            this.m_iSize = 0;
        }
    }

    public GVectorf(int iSize, float[] afTuple) {
        if (iSize > 0) {
            this.m_iSize = iSize;
            this.m_afTuple = new float[this.m_iSize];
            for (int i = 0; i < this.m_iSize; ++i) {
                this.m_afTuple[i] = afTuple[i];
            }
        } else {
            this.m_iSize = 0;
        }
    }

    public void dispose() {
        this.m_afTuple = null;
    }

    public float Dot(GVectorf rkV) {
        float fDot = 0.0f;
        for (int i = 0; i < this.m_iSize; ++i) {
            fDot += this.m_afTuple[i] * rkV.m_afTuple[i];
        }
        return fDot;
    }

    public float Get(int i) {
        assert (0 <= i && i < this.m_iSize);
        return this.m_afTuple[i];
    }

    public int GetSize() {
        return this.m_iSize;
    }

    public float Length() {
        float fSqrLen = 0.0f;
        for (int i = 0; i < this.m_iSize; ++i) {
            fSqrLen += this.m_afTuple[i] * this.m_afTuple[i];
        }
        return (float)Math.sqrt(fSqrLen);
    }

    public float Normalize() {
        float fLength = this.Length();
        if (fLength > 1.0E-6f) {
            float fInvLength = 1.0f / fLength;
            int i = 0;
            while (i < this.m_iSize) {
                int n = i++;
                this.m_afTuple[n] = this.m_afTuple[n] * fInvLength;
            }
        } else {
            fLength = 0.0f;
            for (int i = 0; i < this.m_iSize; ++i) {
                this.m_afTuple[i] = 0.0f;
            }
        }
        return fLength;
    }

    public void Set(int i, float fValue) {
        assert (0 <= i && i < this.m_iSize);
        this.m_afTuple[i] = fValue;
    }

    public void SetSize(int iSize) {
        this.m_afTuple = null;
        if (iSize > 0) {
            this.m_iSize = iSize;
            this.m_afTuple = new float[this.m_iSize];
        } else {
            this.m_iSize = 0;
        }
    }

    public float SquaredLength() {
        float fSqrLen = 0.0f;
        for (int i = 0; i < this.m_iSize; ++i) {
            fSqrLen += this.m_afTuple[i] * this.m_afTuple[i];
        }
        return fSqrLen;
    }

    public boolean equals(GVectorf in) {
        if (this.m_iSize != in.m_iSize) {
            return false;
        }
        for (int i = 0; i < this.m_iSize; ++i) {
            if (this.m_afTuple[i] == in.m_afTuple[i]) continue;
            return false;
        }
        return true;
    }
}

