/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public abstract class LinCompf
implements Serializable {
    private static final long serialVersionUID = -5082158611993935031L;
    protected ComponentType m_iType = ComponentType.CT_EMPTY;
    protected float m_fMin = Float.MAX_VALUE;
    protected float m_fMax = Float.MIN_VALUE;

    protected LinCompf() {
    }

    public static ComponentType GetTypeFromInterval(float fMin, float fMax) {
        if (fMin < fMax) {
            if (fMax == Float.MAX_VALUE) {
                if (fMin == Float.MIN_VALUE) {
                    return ComponentType.CT_LINE;
                }
                return ComponentType.CT_RAY;
            }
            if (fMin == Float.MIN_VALUE) {
                return ComponentType.CT_RAY;
            }
            return ComponentType.CT_SEGMENT;
        }
        if (fMin == fMax && fMin != Float.MIN_VALUE && fMax != Float.MAX_VALUE) {
            return ComponentType.CT_POINT;
        }
        return ComponentType.CT_EMPTY;
    }

    public boolean Contains(float fParam) {
        return this.m_fMin <= fParam && fParam <= this.m_fMax;
    }

    public final float GetMax() {
        return this.m_fMax;
    }

    public final float GetMin() {
        return this.m_fMin;
    }

    public final ComponentType GetType() {
        return this.m_iType;
    }

    public boolean IsCanonical() {
        if (this.m_iType == ComponentType.CT_RAY) {
            return this.m_fMin == 0.0f && this.m_fMax == Float.MAX_VALUE;
        }
        if (this.m_iType == ComponentType.CT_SEGMENT) {
            return this.m_fMin == -this.m_fMax;
        }
        if (this.m_iType == ComponentType.CT_POINT) {
            return this.m_fMin == 0.0f;
        }
        if (this.m_iType == ComponentType.CT_EMPTY) {
            return this.m_fMin == Float.MAX_VALUE && this.m_fMax == Float.MIN_VALUE;
        }
        return true;
    }

    public abstract void MakeCanonical();

    public void SetInterval(float fMin, float fMax) {
        this.m_iType = LinCompf.GetTypeFromInterval(fMin, fMax);
        this.m_fMin = fMin;
        this.m_fMax = fMax;
    }

    public static enum ComponentType {
        CT_EMPTY(0),
        CT_POINT(1),
        CT_SEGMENT(2),
        CT_RAY(3),
        CT_LINE(4);

        private int m_iValue;

        private ComponentType(int iValue) {
            this.m_iValue = iValue;
        }

        public int Value() {
            return this.m_iValue;
        }
    }
}

