/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector3d;
import WildMagic.LibFoundation.Mathematics.Vector4d;
import java.io.Serializable;

public class Matrix4d
implements Serializable {
    public static final Matrix4d ZERO = new Matrix4d(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final Matrix4d IDENTITY = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    public double M00 = 0.0;
    public double M01 = 0.0;
    public double M02 = 0.0;
    public double M03 = 0.0;
    public double M10 = 0.0;
    public double M11 = 0.0;
    public double M12 = 0.0;
    public double M13 = 0.0;
    public double M20 = 0.0;
    public double M21 = 0.0;
    public double M22 = 0.0;
    public double M23 = 0.0;
    public double M30 = 0.0;
    public double M31 = 0.0;
    public double M32 = 0.0;
    public double M33 = 0.0;

    public Matrix4d() {
        this.MakeZero();
    }

    public Matrix4d(boolean bZero) {
        if (bZero) {
            this.MakeZero();
        } else {
            this.MakeIdentity();
        }
    }

    public Matrix4d(double fM00, double fM01, double fM02, double fM03, double fM10, double fM11, double fM12, double fM13, double fM20, double fM21, double fM22, double fM23, double fM30, double fM31, double fM32, double fM33) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M02 = fM02;
        this.M03 = fM03;
        this.M10 = fM10;
        this.M11 = fM11;
        this.M12 = fM12;
        this.M13 = fM13;
        this.M20 = fM20;
        this.M21 = fM21;
        this.M22 = fM22;
        this.M23 = fM23;
        this.M30 = fM30;
        this.M31 = fM31;
        this.M32 = fM32;
        this.M33 = fM33;
    }

    public Matrix4d(double[] afEntry, boolean bRowMajor) {
        if (bRowMajor) {
            this.M00 = afEntry[0];
            this.M01 = afEntry[1];
            this.M02 = afEntry[2];
            this.M03 = afEntry[3];
            this.M10 = afEntry[4];
            this.M11 = afEntry[5];
            this.M12 = afEntry[6];
            this.M13 = afEntry[7];
            this.M20 = afEntry[8];
            this.M21 = afEntry[9];
            this.M22 = afEntry[10];
            this.M23 = afEntry[11];
            this.M30 = afEntry[12];
            this.M31 = afEntry[13];
            this.M32 = afEntry[14];
            this.M33 = afEntry[15];
        } else {
            this.M00 = afEntry[0];
            this.M01 = afEntry[4];
            this.M02 = afEntry[8];
            this.M03 = afEntry[12];
            this.M10 = afEntry[1];
            this.M11 = afEntry[5];
            this.M12 = afEntry[9];
            this.M13 = afEntry[13];
            this.M20 = afEntry[2];
            this.M21 = afEntry[6];
            this.M22 = afEntry[10];
            this.M23 = afEntry[14];
            this.M30 = afEntry[3];
            this.M31 = afEntry[7];
            this.M32 = afEntry[11];
            this.M33 = afEntry[15];
        }
    }

    public Matrix4d(Matrix4d rkM) {
        this.Copy(rkM);
    }

    public void Adjoint() {
        double fA0 = this.M00 * this.M11 - this.M01 * this.M10;
        double fA1 = this.M00 * this.M12 - this.M02 * this.M10;
        double fA2 = this.M00 * this.M13 - this.M03 * this.M10;
        double fA3 = this.M01 * this.M12 - this.M02 * this.M11;
        double fA4 = this.M01 * this.M13 - this.M03 * this.M11;
        double fA5 = this.M02 * this.M13 - this.M03 * this.M12;
        double fB0 = this.M20 * this.M31 - this.M21 * this.M30;
        double fB1 = this.M20 * this.M32 - this.M22 * this.M30;
        double fB2 = this.M20 * this.M33 - this.M23 * this.M30;
        double fB3 = this.M21 * this.M32 - this.M22 * this.M31;
        double fB4 = this.M21 * this.M33 - this.M23 * this.M31;
        double fB5 = this.M22 * this.M33 - this.M23 * this.M32;
        this.Set(this.M11 * fB5 - this.M12 * fB4 + this.M13 * fB3, -this.M01 * fB5 + this.M02 * fB4 - this.M03 * fB3, this.M31 * fA5 - this.M32 * fA4 + this.M33 * fA3, -this.M21 * fA5 + this.M22 * fA4 - this.M23 * fA3, -this.M10 * fB5 + this.M12 * fB2 - this.M13 * fB1, this.M00 * fB5 - this.M02 * fB2 + this.M03 * fB1, -this.M30 * fA5 + this.M32 * fA2 - this.M33 * fA1, this.M20 * fA5 - this.M22 * fA2 + this.M23 * fA1, this.M10 * fB4 - this.M11 * fB2 + this.M13 * fB0, -this.M00 * fB4 + this.M01 * fB2 - this.M03 * fB0, this.M30 * fA4 - this.M31 * fA2 + this.M33 * fA0, -this.M20 * fA4 + this.M21 * fA2 - this.M23 * fA0, -this.M10 * fB3 + this.M11 * fB1 - this.M12 * fB0, this.M00 * fB3 - this.M01 * fB1 + this.M02 * fB0, -this.M30 * fA3 + this.M31 * fA1 - this.M32 * fA0, this.M20 * fA3 - this.M21 * fA1 + this.M22 * fA0);
    }

    public void Copy(Matrix4d rkM) {
        this.M00 = rkM.M00;
        this.M01 = rkM.M01;
        this.M02 = rkM.M02;
        this.M03 = rkM.M03;
        this.M10 = rkM.M10;
        this.M11 = rkM.M11;
        this.M12 = rkM.M12;
        this.M13 = rkM.M13;
        this.M20 = rkM.M20;
        this.M21 = rkM.M21;
        this.M22 = rkM.M22;
        this.M23 = rkM.M23;
        this.M30 = rkM.M30;
        this.M31 = rkM.M31;
        this.M32 = rkM.M32;
        this.M33 = rkM.M33;
    }

    public double Determinant() {
        double fA0 = this.M00 * this.M11 - this.M01 * this.M10;
        double fA1 = this.M00 * this.M12 - this.M02 * this.M10;
        double fA2 = this.M00 * this.M13 - this.M03 * this.M10;
        double fA3 = this.M01 * this.M12 - this.M02 * this.M11;
        double fA4 = this.M01 * this.M13 - this.M03 * this.M11;
        double fA5 = this.M02 * this.M13 - this.M03 * this.M12;
        double fB0 = this.M20 * this.M31 - this.M21 * this.M30;
        double fB1 = this.M20 * this.M32 - this.M22 * this.M30;
        double fB2 = this.M20 * this.M33 - this.M23 * this.M30;
        double fB3 = this.M21 * this.M32 - this.M22 * this.M31;
        double fB4 = this.M21 * this.M33 - this.M23 * this.M31;
        double fB5 = this.M22 * this.M33 - this.M23 * this.M32;
        double fDet = fA0 * fB5 - fA1 * fB4 + fA2 * fB3 + fA3 * fB2 - fA4 * fB1 + fA5 * fB0;
        return fDet;
    }

    public boolean equals(Object kObject) {
        Matrix4d rkM = (Matrix4d)kObject;
        return this.M00 == rkM.M00 && this.M01 == rkM.M01 && this.M02 == rkM.M02 && this.M03 == rkM.M03 && this.M10 == rkM.M10 && this.M11 == rkM.M11 && this.M12 == rkM.M12 && this.M13 == rkM.M13 && this.M20 == rkM.M20 && this.M21 == rkM.M21 && this.M22 == rkM.M22 && this.M23 == rkM.M23 && this.M30 == rkM.M30 && this.M31 == rkM.M31 && this.M32 == rkM.M32 && this.M33 == rkM.M33;
    }

    public final double Get(int iRow, int iCol) {
        switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        return this.M00;
                    }
                    case 1: {
                        return this.M01;
                    }
                    case 2: {
                        return this.M02;
                    }
                    case 3: {
                        return this.M03;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        return this.M10;
                    }
                    case 1: {
                        return this.M11;
                    }
                    case 2: {
                        return this.M12;
                    }
                    case 3: {
                        return this.M13;
                    }
                }
                break;
            }
            case 2: {
                switch (iCol) {
                    case 0: {
                        return this.M20;
                    }
                    case 1: {
                        return this.M21;
                    }
                    case 2: {
                        return this.M22;
                    }
                    case 3: {
                        return this.M23;
                    }
                }
                break;
            }
            case 3: {
                switch (iCol) {
                    case 0: {
                        return this.M30;
                    }
                    case 1: {
                        return this.M31;
                    }
                    case 2: {
                        return this.M32;
                    }
                    case 3: {
                        return this.M33;
                    }
                }
            }
        }
        return -1.0;
    }

    public void GetColumnMajor(double[] afCMajor) {
        afCMajor[0] = this.M00;
        afCMajor[1] = this.M10;
        afCMajor[2] = this.M20;
        afCMajor[3] = this.M30;
        afCMajor[4] = this.M01;
        afCMajor[5] = this.M11;
        afCMajor[6] = this.M21;
        afCMajor[7] = this.M31;
        afCMajor[8] = this.M02;
        afCMajor[9] = this.M12;
        afCMajor[10] = this.M22;
        afCMajor[11] = this.M32;
        afCMajor[12] = this.M03;
        afCMajor[13] = this.M13;
        afCMajor[14] = this.M23;
        afCMajor[15] = this.M33;
    }

    public void GetData(double[] afData) {
        afData[0] = this.M00;
        afData[1] = this.M01;
        afData[2] = this.M02;
        afData[3] = this.M03;
        afData[4] = this.M10;
        afData[5] = this.M11;
        afData[6] = this.M12;
        afData[7] = this.M13;
        afData[8] = this.M20;
        if (afData.length <= 9) {
            return;
        }
        afData[9] = this.M21;
        afData[10] = this.M22;
        afData[11] = this.M23;
        afData[12] = this.M30;
        afData[13] = this.M31;
        afData[14] = this.M32;
        afData[15] = this.M33;
    }

    public void GetData(float[] afData) {
        afData[0] = (float)this.M00;
        afData[1] = (float)this.M01;
        afData[2] = (float)this.M02;
        afData[3] = (float)this.M03;
        afData[4] = (float)this.M10;
        afData[5] = (float)this.M11;
        afData[6] = (float)this.M12;
        afData[7] = (float)this.M13;
        afData[8] = (float)this.M20;
        if (afData.length <= 9) {
            return;
        }
        afData[9] = (float)this.M21;
        afData[10] = (float)this.M22;
        afData[11] = (float)this.M23;
        afData[12] = (float)this.M30;
        afData[13] = (float)this.M31;
        afData[14] = (float)this.M32;
        afData[15] = (float)this.M33;
    }

    public void Inverse() {
        double fA0 = this.M00 * this.M11 - this.M01 * this.M10;
        double fB5 = this.M22 * this.M33 - this.M23 * this.M32;
        double fA1 = this.M00 * this.M12 - this.M02 * this.M10;
        double fB4 = this.M21 * this.M33 - this.M23 * this.M31;
        double fA2 = this.M00 * this.M13 - this.M03 * this.M10;
        double fB3 = this.M21 * this.M32 - this.M22 * this.M31;
        double fA3 = this.M01 * this.M12 - this.M02 * this.M11;
        double fB2 = this.M20 * this.M33 - this.M23 * this.M30;
        double fA4 = this.M01 * this.M13 - this.M03 * this.M11;
        double fB1 = this.M20 * this.M32 - this.M22 * this.M30;
        double fA5 = this.M02 * this.M13 - this.M03 * this.M12;
        double fB0 = this.M20 * this.M31 - this.M21 * this.M30;
        double fDet = fA0 * fB5 - fA1 * fB4 + fA2 * fB3 + fA3 * fB2 - fA4 * fB1 + fA5 * fB0;
        if (Math.abs(fDet) <= 1.0E-12) {
            this.Copy(ZERO);
        }
        double inv_M00 = this.M11 * fB5 - this.M12 * fB4 + this.M13 * fB3;
        double inv_M10 = -this.M10 * fB5 + this.M12 * fB2 - this.M13 * fB1;
        double inv_M20 = this.M10 * fB4 - this.M11 * fB2 + this.M13 * fB0;
        double inv_M30 = -this.M10 * fB3 + this.M11 * fB1 - this.M12 * fB0;
        double inv_M01 = -this.M01 * fB5 + this.M02 * fB4 - this.M03 * fB3;
        double inv_M11 = this.M00 * fB5 - this.M02 * fB2 + this.M03 * fB1;
        double inv_M21 = -this.M00 * fB4 + this.M01 * fB2 - this.M03 * fB0;
        double inv_M31 = this.M00 * fB3 - this.M01 * fB1 + this.M02 * fB0;
        double inv_M02 = this.M31 * fA5 - this.M32 * fA4 + this.M33 * fA3;
        double inv_M12 = -this.M30 * fA5 + this.M32 * fA2 - this.M33 * fA1;
        double inv_M22 = this.M30 * fA4 - this.M31 * fA2 + this.M33 * fA0;
        double inv_M32 = -this.M30 * fA3 + this.M31 * fA1 - this.M32 * fA0;
        double inv_M03 = -this.M21 * fA5 + this.M22 * fA4 - this.M23 * fA3;
        double inv_M13 = this.M20 * fA5 - this.M22 * fA2 + this.M23 * fA1;
        double inv_M23 = -this.M20 * fA4 + this.M21 * fA2 - this.M23 * fA0;
        double inv_M33 = this.M20 * fA3 - this.M21 * fA1 + this.M22 * fA0;
        double fInvDet = 1.0 / fDet;
        inv_M00 *= fInvDet;
        inv_M01 *= fInvDet;
        inv_M02 *= fInvDet;
        inv_M03 *= fInvDet;
        inv_M10 *= fInvDet;
        inv_M11 *= fInvDet;
        this.Set(inv_M00, inv_M01, inv_M02, inv_M03, inv_M10, inv_M11, inv_M12 *= fInvDet, inv_M13 *= fInvDet, inv_M20 *= fInvDet, inv_M21 *= fInvDet, inv_M22 *= fInvDet, inv_M23 *= fInvDet, inv_M30 *= fInvDet, inv_M31 *= fInvDet, inv_M32 *= fInvDet, inv_M33 *= fInvDet);
    }

    public void Inverse(Matrix4d kM) {
        this.Copy(kM);
        this.Inverse();
    }

    public void MakeIdentity() {
        this.M00 = 1.0;
        this.M01 = 0.0;
        this.M02 = 0.0;
        this.M03 = 0.0;
        this.M10 = 0.0;
        this.M11 = 1.0;
        this.M12 = 0.0;
        this.M13 = 0.0;
        this.M20 = 0.0;
        this.M21 = 0.0;
        this.M22 = 1.0;
        this.M23 = 0.0;
        this.M30 = 0.0;
        this.M31 = 0.0;
        this.M32 = 0.0;
        this.M33 = 1.0;
    }

    public void MakeObliqueProjection(Vector3d rkNormal, Vector3d rkPoint, Vector3d rkDirection) {
        double fNdD = rkNormal.Dot(rkDirection);
        double fNdP = rkNormal.Dot(rkPoint);
        this.M00 = rkDirection.X * rkNormal.X - fNdD;
        this.M01 = rkDirection.X * rkNormal.Y;
        this.M02 = rkDirection.X * rkNormal.Z;
        this.M03 = -fNdP * rkDirection.X;
        this.M10 = rkDirection.Y * rkNormal.X;
        this.M11 = rkDirection.Y * rkNormal.Y - fNdD;
        this.M12 = rkDirection.Y * rkNormal.Z;
        this.M13 = -fNdP * rkDirection.Y;
        this.M20 = rkDirection.Z * rkNormal.X;
        this.M21 = rkDirection.Z * rkNormal.Y;
        this.M22 = rkDirection.Z * rkNormal.Z - fNdD;
        this.M23 = -fNdP * rkDirection.Z;
        this.M30 = 0.0;
        this.M31 = 0.0;
        this.M32 = 0.0;
        this.M33 = -fNdD;
    }

    public void MakePerspectiveProjection(Vector3d rkNormal, Vector3d rkPoint, Vector3d rkEye) {
        Vector3d kDiff = new Vector3d();
        kDiff.Sub(rkEye, rkPoint);
        double fNdEmP = rkNormal.Dot(kDiff);
        kDiff = null;
        this.M00 = fNdEmP - rkEye.X * rkNormal.X;
        this.M01 = -rkEye.X * rkNormal.Y;
        this.M02 = -rkEye.X * rkNormal.Z;
        this.M03 = -(this.M00 * rkEye.X + this.M01 * rkEye.Y + this.M02 * rkEye.Z);
        this.M10 = -rkEye.Y * rkNormal.X;
        this.M11 = fNdEmP - rkEye.Y * rkNormal.Y;
        this.M12 = -rkEye.Y * rkNormal.Z;
        this.M13 = -(this.M10 * rkEye.X + this.M11 * rkEye.Y + this.M12 * rkEye.Z);
        this.M20 = -rkEye.Z * rkNormal.X;
        this.M21 = -rkEye.Z * rkNormal.Y;
        this.M22 = fNdEmP - rkEye.Z * rkNormal.Z;
        this.M23 = -(this.M20 * rkEye.X + this.M21 * rkEye.Y + this.M22 * rkEye.Z);
        this.M30 = -rkNormal.X;
        this.M31 = -rkNormal.Y;
        this.M32 = -rkNormal.Z;
        this.M33 = rkNormal.Dot(rkEye);
    }

    public void MakeReflection(Vector3d rkNormal, Vector3d rkPoint) {
        double fTwoNdP = 2.0 * rkNormal.Dot(rkPoint);
        this.M00 = 1.0 - 2.0 * rkNormal.X * rkNormal.X;
        this.M01 = -2.0 * rkNormal.X * rkNormal.Y;
        this.M02 = -2.0 * rkNormal.X * rkNormal.Z;
        this.M03 = fTwoNdP * rkNormal.X;
        this.M10 = -2.0 * rkNormal.Y * rkNormal.X;
        this.M11 = 1.0 - 2.0 * rkNormal.Y * rkNormal.Y;
        this.M12 = -2.0 * rkNormal.Y * rkNormal.Z;
        this.M13 = fTwoNdP * rkNormal.Y;
        this.M20 = -2.0 * rkNormal.Z * rkNormal.X;
        this.M21 = -2.0 * rkNormal.Z * rkNormal.Y;
        this.M22 = 1.0 - 2.0 * rkNormal.Z * rkNormal.Z;
        this.M23 = fTwoNdP * rkNormal.Z;
        this.M30 = 0.0;
        this.M31 = 0.0;
        this.M32 = 0.0;
        this.M33 = 1.0;
    }

    public void MakeZero() {
        this.M00 = 0.0;
        this.M01 = 0.0;
        this.M02 = 0.0;
        this.M03 = 0.0;
        this.M10 = 0.0;
        this.M11 = 0.0;
        this.M12 = 0.0;
        this.M13 = 0.0;
        this.M20 = 0.0;
        this.M21 = 0.0;
        this.M22 = 0.0;
        this.M23 = 0.0;
        this.M30 = 0.0;
        this.M31 = 0.0;
        this.M32 = 0.0;
        this.M33 = 0.0;
    }

    public void Mult(Matrix4d kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M10 + this.M02 * kM.M20 + this.M03 * kM.M30, this.M00 * kM.M01 + this.M01 * kM.M11 + this.M02 * kM.M21 + this.M03 * kM.M31, this.M00 * kM.M02 + this.M01 * kM.M12 + this.M02 * kM.M22 + this.M03 * kM.M32, this.M00 * kM.M03 + this.M01 * kM.M13 + this.M02 * kM.M23 + this.M03 * kM.M33, this.M10 * kM.M00 + this.M11 * kM.M10 + this.M12 * kM.M20 + this.M13 * kM.M30, this.M10 * kM.M01 + this.M11 * kM.M11 + this.M12 * kM.M21 + this.M13 * kM.M31, this.M10 * kM.M02 + this.M11 * kM.M12 + this.M12 * kM.M22 + this.M13 * kM.M32, this.M10 * kM.M03 + this.M11 * kM.M13 + this.M12 * kM.M23 + this.M13 * kM.M33, this.M20 * kM.M00 + this.M21 * kM.M10 + this.M22 * kM.M20 + this.M23 * kM.M30, this.M20 * kM.M01 + this.M21 * kM.M11 + this.M22 * kM.M21 + this.M23 * kM.M31, this.M20 * kM.M02 + this.M21 * kM.M12 + this.M22 * kM.M22 + this.M23 * kM.M32, this.M20 * kM.M03 + this.M21 * kM.M13 + this.M22 * kM.M23 + this.M23 * kM.M33, this.M30 * kM.M00 + this.M31 * kM.M10 + this.M32 * kM.M20 + this.M33 * kM.M30, this.M30 * kM.M01 + this.M31 * kM.M11 + this.M32 * kM.M21 + this.M33 * kM.M31, this.M30 * kM.M02 + this.M31 * kM.M12 + this.M32 * kM.M22 + this.M33 * kM.M32, this.M30 * kM.M03 + this.M31 * kM.M13 + this.M32 * kM.M23 + this.M33 * kM.M33);
    }

    public void Mult(Matrix4d kM1, Matrix4d kM2) {
        this.Set(kM1.M00 * kM2.M00 + kM1.M01 * kM2.M10 + kM1.M02 * kM2.M20 + kM1.M03 * kM2.M30, kM1.M00 * kM2.M01 + kM1.M01 * kM2.M11 + kM1.M02 * kM2.M21 + kM1.M03 * kM2.M31, kM1.M00 * kM2.M02 + kM1.M01 * kM2.M12 + kM1.M02 * kM2.M22 + kM1.M03 * kM2.M32, kM1.M00 * kM2.M03 + kM1.M01 * kM2.M13 + kM1.M02 * kM2.M23 + kM1.M03 * kM2.M33, kM1.M10 * kM2.M00 + kM1.M11 * kM2.M10 + kM1.M12 * kM2.M20 + kM1.M13 * kM2.M30, kM1.M10 * kM2.M01 + kM1.M11 * kM2.M11 + kM1.M12 * kM2.M21 + kM1.M13 * kM2.M31, kM1.M10 * kM2.M02 + kM1.M11 * kM2.M12 + kM1.M12 * kM2.M22 + kM1.M13 * kM2.M32, kM1.M10 * kM2.M03 + kM1.M11 * kM2.M13 + kM1.M12 * kM2.M23 + kM1.M13 * kM2.M33, kM1.M20 * kM2.M00 + kM1.M21 * kM2.M10 + kM1.M22 * kM2.M20 + kM1.M23 * kM2.M30, kM1.M20 * kM2.M01 + kM1.M21 * kM2.M11 + kM1.M22 * kM2.M21 + kM1.M23 * kM2.M31, kM1.M20 * kM2.M02 + kM1.M21 * kM2.M12 + kM1.M22 * kM2.M22 + kM1.M23 * kM2.M32, kM1.M20 * kM2.M03 + kM1.M21 * kM2.M13 + kM1.M22 * kM2.M23 + kM1.M23 * kM2.M33, kM1.M30 * kM2.M00 + kM1.M31 * kM2.M10 + kM1.M32 * kM2.M20 + kM1.M33 * kM2.M30, kM1.M30 * kM2.M01 + kM1.M31 * kM2.M11 + kM1.M32 * kM2.M21 + kM1.M33 * kM2.M31, kM1.M30 * kM2.M02 + kM1.M31 * kM2.M12 + kM1.M32 * kM2.M22 + kM1.M33 * kM2.M32, kM1.M30 * kM2.M03 + kM1.M31 * kM2.M13 + kM1.M32 * kM2.M23 + kM1.M33 * kM2.M33);
    }

    public void Mult(Vector4d kIn, Vector4d kOut) {
        kOut.Set(this.M00 * kIn.X + this.M01 * kIn.Y + this.M02 * kIn.Z + this.M03 * kIn.W, this.M10 * kIn.X + this.M11 * kIn.Y + this.M12 * kIn.Z + this.M13 * kIn.W, this.M20 * kIn.X + this.M21 * kIn.Y + this.M22 * kIn.Z + this.M23 * kIn.W, this.M30 * kIn.X + this.M31 * kIn.Y + this.M32 * kIn.Z + this.M33 * kIn.W);
    }

    public void MultLeft(Matrix4d kM) {
        this.Set(kM.M00 * this.M00 + kM.M01 * this.M10 + kM.M02 * this.M20 + kM.M03 * this.M30, kM.M00 * this.M01 + kM.M01 * this.M11 + kM.M02 * this.M21 + kM.M03 * this.M31, kM.M00 * this.M02 + kM.M01 * this.M12 + kM.M02 * this.M22 + kM.M03 * this.M32, kM.M00 * this.M03 + kM.M01 * this.M13 + kM.M02 * this.M23 + kM.M03 * this.M33, kM.M10 * this.M00 + kM.M11 * this.M10 + kM.M12 * this.M20 + kM.M13 * this.M30, kM.M10 * this.M01 + kM.M11 * this.M11 + kM.M12 * this.M21 + kM.M13 * this.M31, kM.M10 * this.M02 + kM.M11 * this.M12 + kM.M12 * this.M22 + kM.M13 * this.M32, kM.M10 * this.M03 + kM.M11 * this.M13 + kM.M12 * this.M23 + kM.M13 * this.M33, kM.M20 * this.M00 + kM.M21 * this.M10 + kM.M22 * this.M20 + kM.M23 * this.M30, kM.M20 * this.M01 + kM.M21 * this.M11 + kM.M22 * this.M21 + kM.M23 * this.M31, kM.M20 * this.M02 + kM.M21 * this.M12 + kM.M22 * this.M22 + kM.M23 * this.M32, kM.M20 * this.M03 + kM.M21 * this.M13 + kM.M22 * this.M23 + kM.M23 * this.M33, kM.M30 * this.M00 + kM.M31 * this.M10 + kM.M32 * this.M20 + kM.M33 * this.M30, kM.M30 * this.M01 + kM.M31 * this.M11 + kM.M32 * this.M21 + kM.M33 * this.M31, kM.M30 * this.M02 + kM.M31 * this.M12 + kM.M32 * this.M22 + kM.M33 * this.M32, kM.M30 * this.M03 + kM.M31 * this.M13 + kM.M32 * this.M23 + kM.M33 * this.M33);
    }

    public void MultLeft(Vector4d kIn, Vector4d rkOut) {
        rkOut.Set(kIn.X * this.M00 + kIn.Y * this.M10 + kIn.Z * this.M20 + kIn.W * this.M30, kIn.X * this.M01 + kIn.Y * this.M11 + kIn.Z * this.M21 + kIn.W * this.M31, kIn.X * this.M02 + kIn.Y * this.M12 + kIn.Z * this.M22 + kIn.W * this.M32, kIn.X * this.M03 + kIn.Y * this.M13 + kIn.Z * this.M23 + kIn.W * this.M33);
    }

    public void MultRight(Vector4d kIn, Vector4d kOut) {
        kOut.Set(this.M00 * kIn.X + this.M01 * kIn.Y + this.M02 * kIn.Z + this.M03 * kIn.W, this.M10 * kIn.X + this.M11 * kIn.Y + this.M12 * kIn.Z + this.M13 * kIn.W, this.M20 * kIn.X + this.M21 * kIn.Y + this.M22 * kIn.Z + this.M23 * kIn.W, this.M30 * kIn.X + this.M31 * kIn.Y + this.M32 * kIn.Z + this.M33 * kIn.W);
    }

    public double QForm(Vector4d rkU, Vector4d rkV) {
        Vector4d kResult = new Vector4d();
        this.Mult(rkV, kResult);
        return rkU.Dot(kResult);
    }

    public final void Set(double fM00, double fM01, double fM02, double fM03, double fM10, double fM11, double fM12, double fM13, double fM20, double fM21, double fM22, double fM23, double fM30, double fM31, double fM32, double fM33) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M02 = fM02;
        this.M03 = fM03;
        this.M10 = fM10;
        this.M11 = fM11;
        this.M12 = fM12;
        this.M13 = fM13;
        this.M20 = fM20;
        this.M21 = fM21;
        this.M22 = fM22;
        this.M23 = fM23;
        this.M30 = fM30;
        this.M31 = fM31;
        this.M32 = fM32;
        this.M33 = fM33;
    }

    public final void Set(int iRow, int iCol, double fValue) {
        block0 : switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        this.M00 = fValue;
                        break;
                    }
                    case 1: {
                        this.M01 = fValue;
                        break;
                    }
                    case 2: {
                        this.M02 = fValue;
                        break;
                    }
                    case 3: {
                        this.M03 = fValue;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        this.M10 = fValue;
                        break;
                    }
                    case 1: {
                        this.M11 = fValue;
                        break;
                    }
                    case 2: {
                        this.M12 = fValue;
                        break;
                    }
                    case 3: {
                        this.M13 = fValue;
                    }
                }
                break;
            }
            case 2: {
                switch (iCol) {
                    case 0: {
                        this.M20 = fValue;
                        break;
                    }
                    case 1: {
                        this.M21 = fValue;
                        break;
                    }
                    case 2: {
                        this.M22 = fValue;
                        break;
                    }
                    case 3: {
                        this.M23 = fValue;
                    }
                }
                break;
            }
            case 3: {
                switch (iCol) {
                    case 0: {
                        this.M30 = fValue;
                        break block0;
                    }
                    case 1: {
                        this.M31 = fValue;
                        break block0;
                    }
                    case 2: {
                        this.M32 = fValue;
                        break block0;
                    }
                    case 3: {
                        this.M33 = fValue;
                    }
                }
            }
        }
    }

    public void TimesTranspose(Matrix4d kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M01 + this.M02 * kM.M02 + this.M03 * kM.M03, this.M00 * kM.M10 + this.M01 * kM.M11 + this.M02 * kM.M12 + this.M03 * kM.M13, this.M00 * kM.M20 + this.M01 * kM.M21 + this.M02 * kM.M22 + this.M03 * kM.M23, this.M00 * kM.M30 + this.M01 * kM.M31 + this.M02 * kM.M32 + this.M03 * kM.M33, this.M10 * kM.M00 + this.M11 * kM.M01 + this.M12 * kM.M02 + this.M13 * kM.M03, this.M10 * kM.M10 + this.M11 * kM.M11 + this.M12 * kM.M12 + this.M13 * kM.M13, this.M10 * kM.M20 + this.M11 * kM.M21 + this.M12 * kM.M22 + this.M13 * kM.M23, this.M10 * kM.M30 + this.M11 * kM.M31 + this.M12 * kM.M32 + this.M13 * kM.M33, this.M20 * kM.M00 + this.M21 * kM.M01 + this.M22 * kM.M02 + this.M23 * kM.M03, this.M20 * kM.M10 + this.M21 * kM.M11 + this.M22 * kM.M12 + this.M23 * kM.M13, this.M20 * kM.M20 + this.M21 * kM.M21 + this.M22 * kM.M22 + this.M23 * kM.M23, this.M20 * kM.M30 + this.M21 * kM.M31 + this.M22 * kM.M32 + this.M23 * kM.M33, this.M30 * kM.M00 + this.M31 * kM.M01 + this.M32 * kM.M02 + this.M33 * kM.M03, this.M30 * kM.M10 + this.M31 * kM.M11 + this.M32 * kM.M12 + this.M33 * kM.M13, this.M30 * kM.M20 + this.M31 * kM.M21 + this.M32 * kM.M22 + this.M33 * kM.M23, this.M30 * kM.M30 + this.M31 * kM.M31 + this.M32 * kM.M32 + this.M33 * kM.M33);
    }

    public String toString() {
        return new String(this.M00 + " " + this.M01 + " " + this.M02 + " " + this.M03 + " " + this.M10 + " " + this.M11 + " " + this.M12 + " " + this.M13 + " " + this.M20 + " " + this.M21 + " " + this.M22 + " " + this.M23 + " " + this.M30 + " " + this.M31 + " " + this.M32 + " " + this.M33);
    }

    public void Transpose() {
        this.Set(this.M00, this.M10, this.M20, this.M30, this.M01, this.M11, this.M21, this.M31, this.M02, this.M12, this.M22, this.M32, this.M03, this.M13, this.M23, this.M33);
    }

    public void Transpose(Matrix4d kM) {
        this.Set(kM.M00, kM.M10, kM.M20, kM.M30, kM.M01, kM.M11, kM.M21, kM.M31, kM.M02, kM.M12, kM.M22, kM.M32, kM.M03, kM.M13, kM.M23, kM.M33);
    }

    public void TransposeTimes(Matrix4d kM) {
        this.Set(this.M00 * kM.M00 + this.M10 * kM.M10 + this.M20 * kM.M20 + this.M30 * kM.M30, this.M00 * kM.M01 + this.M10 * kM.M11 + this.M20 * kM.M21 + this.M30 * kM.M31, this.M00 * kM.M02 + this.M10 * kM.M12 + this.M20 * kM.M22 + this.M30 * kM.M32, this.M00 * kM.M03 + this.M10 * kM.M13 + this.M20 * kM.M23 + this.M30 * kM.M33, this.M01 * kM.M00 + this.M11 * kM.M10 + this.M21 * kM.M20 + this.M31 * kM.M30, this.M01 * kM.M01 + this.M11 * kM.M11 + this.M21 * kM.M21 + this.M31 * kM.M31, this.M01 * kM.M02 + this.M11 * kM.M12 + this.M21 * kM.M22 + this.M31 * kM.M32, this.M01 * kM.M03 + this.M11 * kM.M13 + this.M21 * kM.M23 + this.M31 * kM.M33, this.M02 * kM.M00 + this.M12 * kM.M10 + this.M22 * kM.M20 + this.M32 * kM.M30, this.M02 * kM.M01 + this.M12 * kM.M11 + this.M22 * kM.M21 + this.M32 * kM.M31, this.M02 * kM.M02 + this.M12 * kM.M12 + this.M22 * kM.M22 + this.M32 * kM.M32, this.M02 * kM.M03 + this.M12 * kM.M13 + this.M22 * kM.M23 + this.M32 * kM.M33, this.M03 * kM.M00 + this.M13 * kM.M10 + this.M23 * kM.M20 + this.M33 * kM.M30, this.M03 * kM.M01 + this.M13 * kM.M11 + this.M23 * kM.M21 + this.M33 * kM.M31, this.M03 * kM.M02 + this.M13 * kM.M12 + this.M23 * kM.M22 + this.M33 * kM.M32, this.M03 * kM.M03 + this.M13 * kM.M13 + this.M23 * kM.M23 + this.M33 * kM.M33);
    }

    public void TransposeTimes(Matrix4d kM1, Matrix4d kM2) {
        this.Set(kM1.M00 * kM2.M00 + kM1.M10 * kM2.M10 + kM1.M20 * kM2.M20 + kM1.M30 * kM2.M30, kM1.M00 * kM2.M01 + kM1.M10 * kM2.M11 + kM1.M20 * kM2.M21 + kM1.M30 * kM2.M31, kM1.M00 * kM2.M02 + kM1.M10 * kM2.M12 + kM1.M20 * kM2.M22 + kM1.M30 * kM2.M32, kM1.M00 * kM2.M03 + kM1.M10 * kM2.M13 + kM1.M20 * kM2.M23 + kM1.M30 * kM2.M33, kM1.M01 * kM2.M00 + kM1.M11 * kM2.M10 + kM1.M21 * kM2.M20 + kM1.M31 * kM2.M30, kM1.M01 * kM2.M01 + kM1.M11 * kM2.M11 + kM1.M21 * kM2.M21 + kM1.M31 * kM2.M31, kM1.M01 * kM2.M02 + kM1.M11 * kM2.M12 + kM1.M21 * kM2.M22 + kM1.M31 * kM2.M32, kM1.M01 * kM2.M03 + kM1.M11 * kM2.M13 + kM1.M21 * kM2.M23 + kM1.M31 * kM2.M33, kM1.M02 * kM2.M00 + kM1.M12 * kM2.M10 + kM1.M22 * kM2.M20 + kM1.M32 * kM2.M30, kM1.M02 * kM2.M01 + kM1.M12 * kM2.M11 + kM1.M22 * kM2.M21 + kM1.M32 * kM2.M31, kM1.M02 * kM2.M02 + kM1.M12 * kM2.M12 + kM1.M22 * kM2.M22 + kM1.M32 * kM2.M32, kM1.M02 * kM2.M03 + kM1.M12 * kM2.M13 + kM1.M22 * kM2.M23 + kM1.M32 * kM2.M33, kM1.M03 * kM2.M00 + kM1.M13 * kM2.M10 + kM1.M23 * kM2.M20 + kM1.M33 * kM2.M30, kM1.M03 * kM2.M01 + kM1.M13 * kM2.M11 + kM1.M23 * kM2.M21 + kM1.M33 * kM2.M31, kM1.M03 * kM2.M02 + kM1.M13 * kM2.M12 + kM1.M23 * kM2.M22 + kM1.M33 * kM2.M32, kM1.M03 * kM2.M03 + kM1.M13 * kM2.M13 + kM1.M23 * kM2.M23 + kM1.M33 * kM2.M33);
    }
}

