/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Plane3f
implements Serializable {
    private static final long serialVersionUID = -8506404531526244197L;
    public Vector3f Normal = new Vector3f();
    public float Constant;

    public Plane3f() {
    }

    public Plane3f(Plane3f rkPlane) {
        this.Normal.Copy(rkPlane.Normal);
        this.Constant = rkPlane.Constant;
    }

    public Plane3f(Vector3f rkNormal, float fConstant) {
        this.Normal.Copy(rkNormal);
        this.Constant = fConstant;
    }

    public Plane3f(Vector3f rkNormal, Vector3f rkP) {
        this.Normal.Copy(rkNormal);
        this.Constant = rkNormal.Dot(rkP);
    }

    public Plane3f(Vector3f rkP0, Vector3f rkP1, Vector3f rkP2) {
        Vector3f kEdge1 = new Vector3f();
        kEdge1.Sub(rkP1, rkP0);
        Vector3f kEdge2 = new Vector3f();
        kEdge2.Sub(rkP2, rkP0);
        this.Normal.Copy(kEdge1);
        this.Normal.UnitCross(kEdge2);
        this.Constant = this.Normal.Dot(rkP0);
        kEdge1 = null;
        kEdge2 = null;
    }

    public void dispose() {
        this.Normal = null;
    }

    public float DistanceTo(Vector3f rkP) {
        return this.Normal.Dot(rkP) - this.Constant;
    }

    public int WhichSide(Vector3f rkQ) {
        float fDistance = this.DistanceTo(rkQ);
        if (fDistance < 0.0f) {
            return -1;
        }
        if (fDistance > 0.0f) {
            return 1;
        }
        return 0;
    }
}

