/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7095058360131555196L;
    public static final Quaternion IDENTITY = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Quaternion ZERO = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    private static int[] ms_iNext = new int[]{1, 2, 0};
    private float[] m_afTuple = new float[4];

    public Quaternion() {
    }

    public Quaternion(float fW, float fX, float fY, float fZ) {
        this.m_afTuple[0] = fW;
        this.m_afTuple[1] = fX;
        this.m_afTuple[2] = fY;
        this.m_afTuple[3] = fZ;
    }

    public Quaternion(Matrix3f rkRot) {
        this.FromRotationMatrix(rkRot);
    }

    public Quaternion(Quaternion rkQ) {
        this.m_afTuple[0] = rkQ.m_afTuple[0];
        this.m_afTuple[1] = rkQ.m_afTuple[1];
        this.m_afTuple[2] = rkQ.m_afTuple[2];
        this.m_afTuple[3] = rkQ.m_afTuple[3];
    }

    public Quaternion(Vector3f rkAxis, float fAngle) {
        this.FromAxisAngle(rkAxis, fAngle);
    }

    public Quaternion(Vector3f[] akRotColumn) {
        this.FromRotationMatrix(akRotColumn);
    }

    public final Quaternion Add(Quaternion rkQ) {
        Quaternion kSum = new Quaternion();
        for (int i = 0; i < 4; ++i) {
            kSum.m_afTuple[i] = this.m_afTuple[i] + rkQ.m_afTuple[i];
        }
        return kSum;
    }

    public void Align(Vector3f rkV1, Vector3f rkV2) {
        float fCosHalfAngle;
        Vector3f kBisector = new Vector3f();
        kBisector.Add(rkV1, rkV2);
        kBisector.Normalize();
        this.m_afTuple[0] = fCosHalfAngle = rkV1.Dot(kBisector);
        if ((double)fCosHalfAngle != 0.0) {
            Vector3f kCross = new Vector3f();
            kCross.Cross(rkV1, kBisector);
            this.m_afTuple[1] = kCross.X;
            this.m_afTuple[2] = kCross.Y;
            this.m_afTuple[3] = kCross.Z;
            kCross = null;
        } else if (Math.abs(rkV1.X) >= Math.abs(rkV1.Y)) {
            float fInvLength = Mathf.InvSqrt(rkV1.X * rkV1.X + rkV1.Z * rkV1.Z);
            this.m_afTuple[1] = -rkV1.Z * fInvLength;
            this.m_afTuple[2] = 0.0f;
            this.m_afTuple[3] = rkV1.X * fInvLength;
        } else {
            float fInvLength = Mathf.InvSqrt(rkV1.Y * rkV1.Y + rkV1.Z * rkV1.Z);
            this.m_afTuple[1] = 0.0f;
            this.m_afTuple[2] = rkV1.Z * fInvLength;
            this.m_afTuple[3] = -rkV1.Y * fInvLength;
        }
        kBisector = null;
    }

    public final float Dot(Quaternion rkQ) {
        float fDot = 0.0f;
        for (int i = 0; i < 4; ++i) {
            fDot += this.m_afTuple[i] * rkQ.m_afTuple[i];
        }
        return fDot;
    }

    public void FromAxisAngle(Vector3f rkAxis, float fAngle) {
        float fHalfAngle = 0.5f * fAngle;
        float fSin = (float)Math.sin(fHalfAngle);
        this.m_afTuple[0] = (float)Math.cos(fHalfAngle);
        this.m_afTuple[1] = fSin * rkAxis.X;
        this.m_afTuple[2] = fSin * rkAxis.Y;
        this.m_afTuple[3] = fSin * rkAxis.Z;
    }

    public void FromRotationMatrix(Matrix3f rkRot) {
        float fTrace = rkRot.M00 + rkRot.M11 + rkRot.M22;
        if (fTrace > 0.0f) {
            float fRoot = (float)Math.sqrt(fTrace + 1.0f);
            this.m_afTuple[0] = 0.5f * fRoot;
            fRoot = 0.5f / fRoot;
            this.m_afTuple[1] = (rkRot.M21 - rkRot.M12) * fRoot;
            this.m_afTuple[2] = (rkRot.M02 - rkRot.M20) * fRoot;
            this.m_afTuple[3] = (rkRot.M10 - rkRot.M01) * fRoot;
        } else {
            int i = 0;
            if (rkRot.M11 > rkRot.M00) {
                i = 1;
            }
            if (rkRot.M22 > rkRot.M11) {
                i = 2;
            }
            int j = ms_iNext[i];
            int k = ms_iNext[j];
            float fRoot = (float)Math.sqrt(rkRot.Get(i, i) - rkRot.Get(j, j) - rkRot.Get(k, k) + 1.0f);
            this.m_afTuple[i + 1] = 0.5f * fRoot;
            fRoot = 0.5f / fRoot;
            this.m_afTuple[0] = (rkRot.Get(k, j) - rkRot.Get(j, k)) * fRoot;
            this.m_afTuple[j + 1] = (rkRot.Get(j, i) + rkRot.Get(i, j)) * fRoot;
            this.m_afTuple[k + 1] = (rkRot.Get(k, i) + rkRot.Get(i, k)) * fRoot;
        }
    }

    public void FromRotationMatrix(Vector3f[] akRotColumn) {
        Matrix3f kRot = new Matrix3f();
        kRot.M00 = akRotColumn[0].X;
        kRot.M10 = akRotColumn[0].Y;
        kRot.M20 = akRotColumn[0].Z;
        kRot.M01 = akRotColumn[1].X;
        kRot.M11 = akRotColumn[1].Y;
        kRot.M21 = akRotColumn[1].Z;
        kRot.M02 = akRotColumn[2].X;
        kRot.M12 = akRotColumn[2].Y;
        kRot.M22 = akRotColumn[2].Z;
        this.FromRotationMatrix(kRot);
    }

    public final Quaternion Neg() {
        Quaternion kNeg = new Quaternion();
        for (int i = 0; i < 4; ++i) {
            kNeg.m_afTuple[i] = -this.m_afTuple[i];
        }
        return kNeg;
    }

    public final void Normalize() {
        float n = (float)Math.sqrt(this.Norm());
        this.m_afTuple[1] = this.m_afTuple[1] / n;
        this.m_afTuple[2] = this.m_afTuple[2] / n;
        this.m_afTuple[3] = this.m_afTuple[3] / n;
        this.m_afTuple[4] = this.m_afTuple[4] / n;
    }

    public final Quaternion Scale(float fScalar) {
        Quaternion kProd = new Quaternion();
        for (int i = 0; i < 4; ++i) {
            kProd.m_afTuple[i] = fScalar * this.m_afTuple[i];
        }
        return kProd;
    }

    public final Quaternion Sub(Quaternion rkQ) {
        Quaternion kDiff = new Quaternion();
        for (int i = 0; i < 4; ++i) {
            kDiff.m_afTuple[i] = this.m_afTuple[i] - rkQ.m_afTuple[i];
        }
        return kDiff;
    }

    public float ToAxisAngle(Vector3f rkAxis) {
        float rfAngle = 0.0f;
        float fSqrLength = this.m_afTuple[1] * this.m_afTuple[1] + this.m_afTuple[2] * this.m_afTuple[2] + this.m_afTuple[3] * this.m_afTuple[3];
        if (fSqrLength > 1.0E-6f) {
            rfAngle = (float)(2.0 * Math.acos(this.m_afTuple[0]));
            float fInvLength = Mathf.InvSqrt(fSqrLength);
            rkAxis.X = this.m_afTuple[1] * fInvLength;
            rkAxis.Y = this.m_afTuple[2] * fInvLength;
            rkAxis.Z = this.m_afTuple[3] * fInvLength;
        } else {
            rfAngle = 0.0f;
            rkAxis.X = 1.0f;
            rkAxis.Y = 0.0f;
            rkAxis.Z = 0.0f;
        }
        return rfAngle;
    }

    public void ToRotationMatrix(Matrix3f rkRot) {
        float fTx = 2.0f * this.m_afTuple[1];
        float fTy = 2.0f * this.m_afTuple[2];
        float fTz = 2.0f * this.m_afTuple[3];
        float fTwx = fTx * this.m_afTuple[0];
        float fTwy = fTy * this.m_afTuple[0];
        float fTwz = fTz * this.m_afTuple[0];
        float fTxx = fTx * this.m_afTuple[1];
        float fTxy = fTy * this.m_afTuple[1];
        float fTxz = fTz * this.m_afTuple[1];
        float fTyy = fTy * this.m_afTuple[2];
        float fTyz = fTz * this.m_afTuple[2];
        float fTzz = fTz * this.m_afTuple[3];
        rkRot.M00 = 1.0f - (fTyy + fTzz);
        rkRot.M01 = fTxy - fTwz;
        rkRot.M02 = fTxz + fTwy;
        rkRot.M10 = fTxy + fTwz;
        rkRot.M11 = 1.0f - (fTxx + fTzz);
        rkRot.M12 = fTyz - fTwx;
        rkRot.M20 = fTxz - fTwy;
        rkRot.M21 = fTyz + fTwx;
        rkRot.M22 = 1.0f - (fTxx + fTyy);
    }

    public void ToRotationMatrix(Vector3f[] akRotColumn) {
        Matrix3f kRot = new Matrix3f();
        this.ToRotationMatrix(kRot);
        akRotColumn[0].X = kRot.M00;
        akRotColumn[0].Y = kRot.M10;
        akRotColumn[0].Z = kRot.M20;
        akRotColumn[1].X = kRot.M01;
        akRotColumn[1].Y = kRot.M11;
        akRotColumn[1].Z = kRot.M21;
        akRotColumn[2].X = kRot.M02;
        akRotColumn[2].Y = kRot.M12;
        akRotColumn[2].Z = kRot.M22;
    }

    public float W() {
        return this.m_afTuple[0];
    }

    public float X() {
        return this.m_afTuple[1];
    }

    public float Y() {
        return this.m_afTuple[2];
    }

    public float Z() {
        return this.m_afTuple[3];
    }

    private final float Norm() {
        return this.m_afTuple[1] * this.m_afTuple[1] + this.m_afTuple[2] * this.m_afTuple[2] + this.m_afTuple[3] * this.m_afTuple[3] + this.m_afTuple[0] * this.m_afTuple[0];
    }
}

