/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Sphere3f
implements Serializable {
    private static final long serialVersionUID = -501070892370197136L;
    public Vector3f Center;
    public float Radius;

    public Sphere3f() {
    }

    public Sphere3f(Sphere3f rkSphere) {
        this.Center = new Vector3f(rkSphere.Center);
        this.Radius = rkSphere.Radius;
    }

    public Sphere3f(Vector3f rkCenter, float fRadius) {
        this.Center = new Vector3f(rkCenter);
        this.Radius = fRadius;
    }

    public static Sphere3f ContSphereAverage(int iQuantity, Vector3f[] akPoint) {
        int i;
        Sphere3f kSphere = new Sphere3f();
        kSphere.Center = new Vector3f(akPoint[0]);
        for (i = 1; i < iQuantity; ++i) {
            kSphere.Center.Add(akPoint[i]);
        }
        kSphere.Center.Div(iQuantity);
        Vector3f kDiff = new Vector3f();
        for (i = 0; i < iQuantity; ++i) {
            kDiff.Sub(akPoint[i], kSphere.Center);
            float fRadiusSqr = kDiff.SquaredLength();
            if (!(fRadiusSqr > kSphere.Radius)) continue;
            kSphere.Radius = fRadiusSqr;
        }
        kDiff = null;
        kSphere.Radius = (float)Math.sqrt(kSphere.Radius);
        return kSphere;
    }

    public static boolean InSphere(Vector3f rkPoint, Sphere3f rkSphere) {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(rkPoint, rkSphere.Center);
        boolean bReturn = kDiff.Length() <= rkSphere.Radius;
        kDiff = null;
        return bReturn;
    }

    public static Sphere3f MergeSpheres(Sphere3f rkSphere0, Sphere3f rkSphere1) {
        Vector3f kCDiff = new Vector3f();
        kCDiff.Sub(rkSphere1.Center, rkSphere0.Center);
        float fLSqr = kCDiff.SquaredLength();
        float fRDiff = rkSphere1.Radius - rkSphere0.Radius;
        float fRDiffSqr = fRDiff * fRDiff;
        if (fRDiffSqr >= fLSqr) {
            return fRDiff >= 0.0f ? rkSphere1 : rkSphere0;
        }
        float fLength = (float)Math.sqrt(fLSqr);
        Sphere3f kSphere = new Sphere3f();
        if (fLength > 1.0E-6f) {
            float fCoeff = (fLength + fRDiff) / (2.0f * fLength);
            kCDiff.Scale(fCoeff);
            kSphere.Center.Add(rkSphere0.Center, kCDiff);
        } else {
            kSphere.Center = rkSphere0.Center;
        }
        kSphere.Radius = 0.5f * (fLength + rkSphere0.Radius + rkSphere1.Radius);
        kCDiff = null;
        return kSphere;
    }

    public void Copy(Sphere3f rkSphere) {
        this.Center = new Vector3f(rkSphere.Center);
        this.Radius = rkSphere.Radius;
    }

    public void dispose() {
        this.Center = null;
    }

    public void MergeSpheres(Sphere3f rkSphere) {
        float fRDiff = rkSphere.Radius - this.Radius;
        float fRDiffSqr = fRDiff * fRDiff;
        float fX = this.Center.X - rkSphere.Center.X;
        float fY = this.Center.Y - rkSphere.Center.Y;
        float fZ = this.Center.Z - rkSphere.Center.Z;
        float fLSqr = fX * fX + fY * fY + fZ * fZ;
        if (fRDiffSqr >= fLSqr) {
            if (fRDiff >= 0.0f) {
                this.Center.Copy(rkSphere.Center);
                this.Radius = rkSphere.Radius;
            }
            return;
        }
        float fLength = (float)Math.sqrt(fLSqr);
        if (fLength > 1.0E-6f) {
            float fCoeff = (fLength + fRDiff) / (2.0f * fLength);
            this.Center.Set(fX * fCoeff, fY * fCoeff, fZ * fCoeff);
            this.Center.Add(rkSphere.Center);
        } else {
            this.Center.Copy(rkSphere.Center);
        }
        this.Radius = 0.5f * (fLength + rkSphere.Radius + this.Radius);
    }
}

