/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Triangle3f
implements Serializable {
    private static final long serialVersionUID = -4521305136296187164L;
    public Vector3f[] V = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};

    public Triangle3f() {
    }

    public Triangle3f(Triangle3f kTri) {
        this.V[0].Copy(kTri.V[0]);
        this.V[1].Copy(kTri.V[1]);
        this.V[2].Copy(kTri.V[2]);
    }

    public Triangle3f(Vector3f kV0, Vector3f kV1, Vector3f kV2) {
        this.V[0].Copy(kV0);
        this.V[1].Copy(kV1);
        this.V[2].Copy(kV2);
    }

    public void dispose() {
        for (int i = 0; i < 3; ++i) {
            this.V[i] = null;
        }
        this.V = null;
    }

    public float DistanceTo(Vector3f rkQ) {
        float fSqrDist;
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.V[0], rkQ);
        Vector3f kE0 = new Vector3f();
        kE0.Sub(this.V[1], this.V[0]);
        Vector3f kE1 = new Vector3f();
        kE1.Sub(this.V[2], this.V[0]);
        float fA00 = kE0.SquaredLength();
        float fA01 = kE0.Dot(kE1);
        float fA11 = kE1.SquaredLength();
        float fB0 = kDiff.Dot(kE0);
        float fB1 = kDiff.Dot(kE1);
        float fC = kDiff.SquaredLength();
        float fDet = Math.abs(fA00 * fA11 - fA01 * fA01);
        float fS = fA01 * fB1 - fA11 * fB0;
        float fT = fA01 * fB0 - fA00 * fB1;
        if (fS + fT <= fDet) {
            if (fS < 0.0f) {
                fSqrDist = fT < 0.0f ? (fB0 < 0.0f ? (-fB0 >= fA00 ? fA00 + 2.0f * fB0 + fC : fC - fB0 * fB0 / fA00) : (fB1 >= 0.0f ? fC : (-fB1 >= fA11 ? fA11 + 2.0f * fB1 + fC : fC - fB1 * fB1 / fA11))) : (fB1 >= 0.0f ? fC : (-fB1 >= fA11 ? fA11 + 2.0f * fB1 + fC : fC - fB1 * fB1 / fA11));
            } else if (fT < 0.0f) {
                fSqrDist = fB0 >= 0.0f ? fC : (-fB0 >= fA00 ? fA00 + 2.0f * fB0 + fC : fC - fB0 * fB0 / fA00);
            } else {
                float fInvDet = 1.0f / fDet;
                fSqrDist = (fS *= fInvDet) * (fA00 * fS + fA01 * (fT *= fInvDet) + 2.0f * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0f * fB1) + fC;
            }
        } else if (fS < 0.0f) {
            float fTmp1 = fA11 + fB1;
            float fTmp0 = fA01 + fB0;
            if (fTmp1 > fTmp0) {
                float fNumer = fTmp1 - fTmp0;
                float fDenom = fA00 - 2.0f * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fSqrDist = fA00 + 2.0f * fB0 + fC;
                } else {
                    fS = fNumer / fDenom;
                    fT = 1.0f - fS;
                    fSqrDist = fS * (fA00 * fS + fA01 * fT + 2.0f * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0f * fB1) + fC;
                }
            } else {
                fSqrDist = fTmp1 <= 0.0f ? fA11 + 2.0f * fB1 + fC : (fB1 >= 0.0f ? fC : fC - fB1 * fB1 / fA11);
            }
        } else if (fT < 0.0f) {
            float fTmp1 = fA00 + fB0;
            float fTmp0 = fA01 + fB1;
            if (fTmp1 > fTmp0) {
                float fNumer = fTmp1 - fTmp0;
                float fDenom = fA00 - 2.0f * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fT = 1.0f;
                    fS = 0.0f;
                    fSqrDist = fA11 + 2.0f * fB1 + fC;
                } else {
                    fT = fNumer / fDenom;
                    fS = 1.0f - fT;
                    fSqrDist = fS * (fA00 * fS + fA01 * fT + 2.0f * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0f * fB1) + fC;
                }
            } else {
                fSqrDist = fTmp1 <= 0.0f ? fA00 + 2.0f * fB0 + fC : (fB0 >= 0.0f ? fC : fC - fB0 * fB0 / fA00);
            }
        } else {
            float fNumer = fA11 + fB1 - fA01 - fB0;
            if (fNumer <= 0.0f) {
                fSqrDist = fA11 + 2.0f * fB1 + fC;
            } else {
                float fDenom = fA00 - 2.0f * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fSqrDist = fA00 + 2.0f * fB0 + fC;
                } else {
                    fS = fNumer / fDenom;
                    fT = 1.0f - fS;
                    fSqrDist = fS * (fA00 * fS + fA01 * fT + 2.0f * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0f * fB1) + fC;
                }
            }
        }
        kDiff = null;
        kE0 = null;
        kE1 = null;
        return (float)Math.sqrt(Math.abs(fSqrDist));
    }
}

