/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector2f;
import java.io.Serializable;

public class Vector2d
implements Serializable {
    public static final Vector2d ZERO = new Vector2d(0.0, 0.0);
    public static final Vector2d UNIT_X = new Vector2d(1.0, 0.0);
    public static final Vector2d UNIT_Y = new Vector2d(0.0, 1.0);
    public static final Vector2d ONE = new Vector2d(1.0, 1.0);
    public double X = 0.0;
    public double Y = 0.0;

    public Vector2d() {
    }

    public Vector2d(float fX, float fY) {
        this.X = fX;
        this.Y = fY;
    }

    public Vector2d(double dX, double dY) {
        this.X = dX;
        this.Y = dY;
    }

    public Vector2d(Vector2f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public Vector2d(Vector2d rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public void Add(float fX, float fY) {
        this.X += (double)fX;
        this.Y += (double)fY;
    }

    public void Add(double dX, double dY) {
        this.X += dX;
        this.Y += dY;
    }

    public void Add(Vector2f rkV) {
        this.X += (double)rkV.X;
        this.Y += (double)rkV.Y;
    }

    public void Add(Vector2d rkV) {
        this.X += rkV.X;
        this.Y += rkV.Y;
    }

    public void Add(Vector2f rkV1, Vector2f rkV2) {
        this.X = rkV1.X + rkV2.X;
        this.Y = rkV1.Y + rkV2.Y;
    }

    public void Add(Vector2d rkV1, Vector2d rkV2) {
        this.X = rkV1.X + rkV2.X;
        this.Y = rkV1.Y + rkV2.Y;
    }

    public final void Copy(Vector2f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public final void Copy(Vector2d rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public double Cross(Vector2f kV) {
        return this.X * (double)kV.Y - this.Y * (double)kV.X;
    }

    public double Cross(Vector2d kV) {
        return this.X * kV.Y - this.Y * kV.X;
    }

    public double Dot(Vector2f rkV) {
        return this.X * (double)rkV.X + this.Y * (double)rkV.Y;
    }

    public double Dot(Vector2d rkV) {
        return this.X * rkV.X + this.Y * rkV.Y;
    }

    public boolean equals(Object kObject) {
        Vector2d kV = (Vector2d)kObject;
        return this.X == kV.X && this.Y == kV.Y;
    }

    public double Length() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y);
    }

    public void Neg() {
        this.X = -this.X;
        this.Y = -this.Y;
    }

    public double Normalize() {
        double dLength = this.Length();
        if (dLength > 1.0E-12) {
            double dInvLength = 1.0 / dLength;
            this.X *= dInvLength;
            this.Y *= dInvLength;
        } else {
            dLength = 0.0;
            this.X = 0.0;
            this.Y = 0.0;
        }
        return dLength;
    }

    public void Perp(Vector2d kVector) {
        this.Set(kVector.Y, -kVector.X);
    }

    public void Scale(double dScalar) {
        this.X *= dScalar;
        this.Y *= dScalar;
    }

    public void Scale(double dScalar, Vector2d rkV) {
        this.X = dScalar * rkV.X;
        this.Y = dScalar * rkV.Y;
    }

    public void ScaleAdd(double dScalar, Vector2d rkV1, Vector2d rkV2) {
        this.X = dScalar * rkV1.X + rkV2.X;
        this.Y = dScalar * rkV1.Y + rkV2.Y;
    }

    public final void Set(double dX, double dY) {
        this.X = dX;
        this.Y = dY;
    }

    public double SquaredLength() {
        return this.X * this.X + this.Y * this.Y;
    }

    public void Sub(double dX, double dY) {
        this.X -= dX;
        this.Y -= dY;
    }

    public void Sub(Vector2d rkV) {
        this.X -= rkV.X;
        this.Y -= rkV.Y;
    }

    public void Sub(Vector2d rkV1, Vector2d rkV2) {
        this.X = rkV1.X - rkV2.X;
        this.Y = rkV1.Y - rkV2.Y;
    }

    public String toString() {
        return new String(this.X + " " + this.Y);
    }
}

