/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class Vector2f
implements Serializable {
    private static final long serialVersionUID = -358760571132983587L;
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2f UNIT_X = new Vector2f(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = new Vector2f(0.0f, 1.0f);
    public static final Vector2f ONE = new Vector2f(1.0f, 1.0f);
    public float X = 0.0f;
    public float Y = 0.0f;

    public Vector2f() {
    }

    public Vector2f(float fX, float fY) {
        this.X = fX;
        this.Y = fY;
    }

    public Vector2f(Vector2f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public void Add(float fX, float fY) {
        this.X += fX;
        this.Y += fY;
    }

    public void Add(Vector2f rkV) {
        this.X += rkV.X;
        this.Y += rkV.Y;
    }

    public void Add(Vector2f rkV1, Vector2f rkV2) {
        this.X = rkV1.X + rkV2.X;
        this.Y = rkV1.Y + rkV2.Y;
    }

    public final void Copy(Vector2f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
    }

    public float Cross(Vector2f kV) {
        return this.X * kV.Y - this.Y * kV.X;
    }

    public float Dot(Vector2f rkV) {
        return this.X * rkV.X + this.Y * rkV.Y;
    }

    public boolean equals(Object kObject) {
        Vector2f kV = (Vector2f)kObject;
        return this.X == kV.X && this.Y == kV.Y;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.X) + Float.floatToIntBits(this.Y);
    }

    public float Length() {
        return (float)Math.sqrt(this.X * this.X + this.Y * this.Y);
    }

    public void Neg() {
        this.X = -this.X;
        this.Y = -this.Y;
    }

    public float Normalize() {
        float fLength = this.Length();
        if (fLength > 1.0E-6f) {
            float fInvLength = 1.0f / fLength;
            this.X *= fInvLength;
            this.Y *= fInvLength;
        } else {
            fLength = 0.0f;
            this.X = 0.0f;
            this.Y = 0.0f;
        }
        return fLength;
    }

    public void Perp(Vector2f kVector) {
        this.Set(kVector.Y, -kVector.X);
    }

    public void Scale(float fScalar) {
        this.X *= fScalar;
        this.Y *= fScalar;
    }

    public void Scale(float fScalar, Vector2f rkV) {
        this.X = fScalar * rkV.X;
        this.Y = fScalar * rkV.Y;
    }

    public void ScaleAdd(float fScalar, Vector2f rkV1, Vector2f rkV2) {
        this.X = fScalar * rkV1.X + rkV2.X;
        this.Y = fScalar * rkV1.Y + rkV2.Y;
    }

    public final void Set(float fX, float fY) {
        this.X = fX;
        this.Y = fY;
    }

    public float SquaredLength() {
        return this.X * this.X + this.Y * this.Y;
    }

    public void Sub(float fX, float fY) {
        this.X -= fX;
        this.Y -= fY;
    }

    public void Sub(Vector2f rkV) {
        this.X -= rkV.X;
        this.Y -= rkV.Y;
    }

    public void Sub(Vector2f rkV1, Vector2f rkV2) {
        this.X = rkV1.X - rkV2.X;
        this.Y = rkV1.Y - rkV2.Y;
    }

    public String toString() {
        return new String(this.X + " " + this.Y);
    }
}

