/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class Vector4f
implements Serializable {
    private static final long serialVersionUID = -7798291120624047012L;
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_X = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Y = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Z = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f UNIT_W = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public float X = 0.0f;
    public float Y = 0.0f;
    public float Z = 0.0f;
    public float W = 0.0f;

    public Vector4f() {
    }

    public Vector4f(float fX, float fY, float fZ, float fW) {
        this.X = fX;
        this.Y = fY;
        this.Z = fZ;
        this.W = fW;
    }

    public Vector4f(float[] afTuple) {
        this.X = afTuple[0];
        this.Y = afTuple[1];
        this.Z = afTuple[2];
        this.W = afTuple[3];
    }

    public Vector4f(Vector4f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
        this.W = rkV.W;
    }

    public void Copy(Vector4f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
        this.W = rkV.W;
    }

    public float Dot(Vector4f rkV) {
        return this.X * rkV.X + this.Y * rkV.Y + this.Z * rkV.Z + this.W * rkV.W;
    }

    public boolean equals(Object kObject) {
        Vector4f kV = (Vector4f)kObject;
        return this.X == kV.X && this.Y == kV.Y && this.Z == kV.Z && this.W == kV.W;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.X) + Float.floatToIntBits(this.Y) + Float.floatToIntBits(this.Z) + Float.floatToIntBits(this.W);
    }

    public boolean IsEqual(Vector4f rkV) {
        return Math.abs(this.X - rkV.X) < 1.0E-6f && Math.abs(this.Y - rkV.Y) < 1.0E-6f && Math.abs(this.Z - rkV.Z) < 1.0E-6f && Math.abs(this.W - rkV.W) < 1.0E-6f;
    }

    public float Length() {
        return (float)Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z + this.W * this.W);
    }

    public void Neg(Vector4f kV) {
        this.X = -kV.X;
        this.Y = -kV.Y;
        this.Z = -kV.Z;
        this.W = -kV.W;
    }

    public float Normalize() {
        float fLength = this.Length();
        if (fLength > 1.0E-6f) {
            float fInvLength = 1.0f / fLength;
            this.X *= fInvLength;
            this.Y *= fInvLength;
            this.Z *= fInvLength;
            this.W *= fInvLength;
        } else {
            fLength = 0.0f;
            this.X = 0.0f;
            this.Y = 0.0f;
            this.Z = 0.0f;
            this.W = 0.0f;
        }
        return fLength;
    }

    public void Scale(float fScalar) {
        this.X *= fScalar;
        this.Y *= fScalar;
        this.Z *= fScalar;
    }

    public void Set(float fX, float fY, float fZ, float fW) {
        this.X = fX;
        this.Y = fY;
        this.Z = fZ;
        this.W = fW;
    }

    public float SquaredLength() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z + this.W * this.W;
    }

    public String toString() {
        return new String(this.X + " " + this.Y + " " + this.Z + " " + this.W);
    }
}

