/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Meshes;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.Meshes.EdgeKey;
import java.io.Serializable;
import java.util.HashMap;

public class BasicMesh
implements Serializable {
    private static final long serialVersionUID = -4357145370574146237L;
    protected int m_iVQuantity;
    protected int m_iEQuantity;
    protected int m_iTQuantity;
    protected Vector3f[] m_akPoint;
    protected int[] m_aiIndex;
    protected Vertex[] m_akVertex;
    protected Edge[] m_akEdge;
    protected Triangle[] m_akTriangle;
    protected boolean m_bIsValid;

    public BasicMesh(int iVQuantity, Vector3f[] akPoint, int iTQuantity, int[] aiIndex) {
        int i;
        assert (iVQuantity > 0 && iTQuantity > 0 && aiIndex != null);
        if (iVQuantity <= 0 || iTQuantity <= 0 || aiIndex == null) {
            this.m_iVQuantity = 0;
            this.m_iEQuantity = 0;
            this.m_iTQuantity = 0;
            this.m_akVertex = null;
            this.m_akEdge = null;
            this.m_akTriangle = null;
            this.m_akPoint = null;
            this.m_aiIndex = null;
            this.m_bIsValid = false;
            return;
        }
        this.m_iVQuantity = iVQuantity;
        this.m_iEQuantity = 0;
        this.m_iTQuantity = iTQuantity;
        this.m_akPoint = akPoint;
        this.m_aiIndex = aiIndex;
        this.m_bIsValid = true;
        this.m_akVertex = new Vertex[this.m_iVQuantity];
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_akVertex[i] = new Vertex();
        }
        this.m_akEdge = new Edge[3 * this.m_iTQuantity];
        for (i = 0; i < 3 * this.m_iTQuantity; ++i) {
            this.m_akEdge[i] = new Edge();
        }
        this.m_akTriangle = new Triangle[this.m_iTQuantity];
        for (i = 0; i < this.m_iTQuantity; ++i) {
            this.m_akTriangle[i] = new Triangle();
        }
        HashMap<EdgeKey, Integer> kEMap = new HashMap<EdgeKey, Integer>();
        for (int iT = 0; iT < this.m_iTQuantity; ++iT) {
            Triangle rkT = this.m_akTriangle[iT];
            rkT.V[0] = aiIndex[iT * 3 + 0];
            rkT.V[1] = aiIndex[iT * 3 + 1];
            rkT.V[2] = aiIndex[iT * 3 + 2];
            int i0 = 2;
            int i1 = 0;
            while (i1 < 3) {
                this.m_akVertex[rkT.V[i1]].InsertTriangle(iT);
                EdgeKey kKey = new EdgeKey(rkT.V[i0], rkT.V[i1]);
                if (!kEMap.containsKey(kKey)) {
                    kEMap.put(kKey, this.m_iEQuantity);
                    Edge rkE = this.m_akEdge[this.m_iEQuantity];
                    rkE.V[0] = rkT.V[i0];
                    rkE.V[1] = rkT.V[i1];
                    rkE.T[0] = iT;
                    this.m_akVertex[rkE.V[0]].InsertEdge(rkE.V[1], this.m_iEQuantity);
                    this.m_akVertex[rkE.V[1]].InsertEdge(rkE.V[0], this.m_iEQuantity);
                    rkT.E[i0] = this.m_iEQuantity++;
                } else {
                    int iE = (Integer)kEMap.get(kKey);
                    Edge rkE = this.m_akEdge[iE];
                    assert (rkE.T[1] == -1);
                    if (rkE.T[1] != -1) {
                        this.m_akVertex = null;
                        this.m_akEdge = null;
                        this.m_akTriangle = null;
                        this.m_iVQuantity = 0;
                        this.m_iEQuantity = 0;
                        this.m_iTQuantity = 0;
                        this.m_akVertex = null;
                        this.m_akEdge = null;
                        this.m_akTriangle = null;
                        this.m_akPoint = null;
                        this.m_aiIndex = null;
                        this.m_bIsValid = false;
                        return;
                    }
                    rkE.T[1] = iT;
                    int iAdj = rkE.T[0];
                    Triangle rkAdj = this.m_akTriangle[iAdj];
                    for (int j = 0; j < 3; ++j) {
                        if (rkAdj.E[j] != iE) continue;
                        rkAdj.T[j] = iT;
                        break;
                    }
                    rkT.E[i0] = iE;
                    rkT.T[i0] = iAdj;
                }
                i0 = i1++;
            }
        }
    }

    public void dispose() {
        this.m_akVertex = null;
        this.m_akEdge = null;
        this.m_akTriangle = null;
    }

    public final Edge[] GetEdges() {
        return this.m_akEdge;
    }

    public int GetEQuantity() {
        return this.m_iEQuantity;
    }

    public final int[] GetIndices() {
        return this.m_aiIndex;
    }

    public final Vector3f[] GetPoints() {
        return this.m_akPoint;
    }

    public int GetTQuantity() {
        return this.m_iTQuantity;
    }

    public final Triangle[] GetTriangles() {
        return this.m_akTriangle;
    }

    public final Vertex[] GetVertices() {
        return this.m_akVertex;
    }

    public int GetVQuantity() {
        return this.m_iVQuantity;
    }

    public boolean IsValid() {
        return this.m_bIsValid;
    }

    public class Vertex {
        public int VQuantity = 0;
        public int[] V = null;
        public int[] E = null;
        public int TQuantity = 0;
        public int[] T = null;

        public void InsertEdge(int iV, int iE) {
            for (int i = 0; i < this.VQuantity; ++i) {
                if (iV != this.V[i]) continue;
                return;
            }
            if (this.VQuantity % 8 == 0) {
                int[] aiSave = this.V;
                this.V = new int[this.VQuantity + 9];
                if (aiSave != null) {
                    System.arraycopy(aiSave, 0, this.V, 0, aiSave.length);
                    aiSave = null;
                }
                aiSave = this.E;
                this.E = new int[this.VQuantity + 9];
                if (aiSave != null) {
                    System.arraycopy(aiSave, 0, this.E, 0, aiSave.length);
                    Object var3_4 = null;
                }
            }
            this.V[this.VQuantity] = iV;
            this.E[this.VQuantity] = iE;
            ++this.VQuantity;
        }

        public void InsertTriangle(int iT) {
            for (int i = 0; i < this.TQuantity; ++i) {
                if (iT != this.T[i]) continue;
                return;
            }
            if (this.TQuantity % 8 == 0) {
                int[] aiSave = this.T;
                this.T = new int[this.TQuantity + 8];
                if (aiSave != null) {
                    System.arraycopy(aiSave, 0, this.T, 0, aiSave.length);
                    Object var2_3 = null;
                }
            }
            this.T[this.TQuantity] = iT;
            ++this.TQuantity;
        }
    }

    public class Triangle {
        public int[] V = new int[3];
        public int[] E = new int[3];
        public int[] T = new int[3];

        public Triangle() {
            for (int i = 0; i < 3; ++i) {
                this.V[i] = -1;
                this.E[i] = -1;
                this.T[i] = -1;
            }
        }

        public String toString() {
            return new String(this.V[0] + " " + this.V[1] + " " + this.V[2] + ";    " + this.E[0] + " " + this.E[1] + " " + this.E[2] + ";     " + this.T[0] + " " + this.T[1] + " " + this.T[2]);
        }
    }

    public class Edge {
        public int[] V = new int[2];
        public int[] T = new int[2];

        public Edge() {
            for (int i = 0; i < 2; ++i) {
                this.V[i] = -1;
                this.T[i] = -1;
            }
        }
    }
}

