/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Meshes;

import WildMagic.LibFoundation.Mathematics.Polynomial1f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.Meshes.BasicMesh;
import WildMagic.LibFoundation.NumericalAnalysis.LinearSystem;
import WildMagic.LibFoundation.NumericalAnalysis.SparseMatrix;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class ConformalMap
implements Serializable {
    private static final long serialVersionUID = 3829118487507935611L;
    private Vector2f[] m_akPlane;
    private Vector2f m_kPlaneMin;
    private Vector2f m_kPlaneMax;
    private Vector3f[] m_akSphere;
    private float m_fRadius;

    public ConformalMap(BasicMesh kMesh, int iVQuantity, Vector3f[] akPoint, int iTQuantity, int iPunctureTriangle) {
        int i;
        float fMin;
        int i2;
        int iV2;
        int iV1;
        int iV0;
        int iEQuantity = kMesh.GetEQuantity();
        BasicMesh.Edge[] akEdge = kMesh.GetEdges();
        BasicMesh.Triangle[] akTriangle = kMesh.GetTriangles();
        this.m_akPlane = new Vector2f[iVQuantity];
        this.m_akSphere = new Vector3f[iVQuantity];
        SparseMatrix kAMat = new SparseMatrix();
        float fValue = 0.0f;
        Vector3f kE0 = new Vector3f();
        Vector3f kE1 = new Vector3f();
        Vector3f kCross = new Vector3f();
        for (int iE = 0; iE < iEQuantity; ++iE) {
            BasicMesh.Edge rkE = akEdge[iE];
            iV0 = rkE.V[0];
            iV1 = rkE.V[1];
            BasicMesh.Triangle rkT0 = akTriangle[rkE.T[0]];
            for (int i3 = 0; i3 < 3; ++i3) {
                iV2 = rkT0.V[i3];
                if (iV2 == iV0 || iV2 == iV1) continue;
                kE0.Sub(akPoint[iV0], akPoint[iV2]);
                kE1.Sub(akPoint[iV1], akPoint[iV2]);
                kCross.Cross(kE0, kE1);
                fValue = kE0.Dot(kE1) / kCross.Length();
            }
            BasicMesh.Triangle rkT1 = akTriangle[rkE.T[1]];
            for (int i4 = 0; i4 < 3; ++i4) {
                iV2 = rkT1.V[i4];
                if (iV2 == iV0 || iV2 == iV1) continue;
                kE0.Sub(akPoint[iV0], akPoint[iV2]);
                kE1.Sub(akPoint[iV1], akPoint[iV2]);
                kCross.Cross(kE0, kE1);
                fValue += kE0.Dot(kE1) / kCross.Length();
            }
            kAMat.setElement(iV0, iV1, fValue *= -0.5f);
        }
        float[] afTmp = new float[iVQuantity];
        for (int i5 = 0; i5 < iVQuantity; ++i5) {
            afTmp[i5] = 0.0f;
        }
        Iterator<Map.Entry<SparseMatrix.Index, Float>> pkIter = kAMat.iterator();
        while (pkIter.hasNext()) {
            Map.Entry<SparseMatrix.Index, Float> kEntry = pkIter.next();
            SparseMatrix.Index kIndex = kEntry.getKey();
            Float kValue = kEntry.getValue();
            iV0 = kIndex.m_iRow;
            iV1 = kIndex.m_iCol;
            fValue = kValue.floatValue();
            assert (iV0 != iV1);
            int n = iV0;
            afTmp[n] = afTmp[n] - fValue;
            int n2 = iV1;
            afTmp[n2] = afTmp[n2] - fValue;
        }
        for (int iV = 0; iV < iVQuantity; ++iV) {
            kAMat.setElement(iV, iV, afTmp[iV]);
        }
        assert (iVQuantity + iEQuantity == kAMat.size());
        BasicMesh.Triangle rkT = akTriangle[iPunctureTriangle];
        iV0 = rkT.V[0];
        iV1 = rkT.V[1];
        iV2 = rkT.V[2];
        Vector3f kV0 = akPoint[iV0];
        Vector3f kV1 = akPoint[iV1];
        Vector3f kV2 = akPoint[iV2];
        Vector3f kE10 = new Vector3f();
        kE10.Sub(kV1, kV0);
        Vector3f kE20 = new Vector3f();
        kE20.Sub(kV2, kV0);
        Vector3f kE12 = new Vector3f();
        kE12.Sub(kV1, kV2);
        kCross.Cross(kE20, kE10);
        float fLen10 = kE10.Length();
        float fInvLen10 = 1.0f / fLen10;
        float fTwoArea = kCross.Length();
        float fInvLenCross = 1.0f / fTwoArea;
        float fInvProd = fInvLen10 * fInvLenCross;
        float fRe0 = -fInvLen10;
        float fIm0 = fInvProd * kE12.Dot(kE10);
        float fRe1 = fInvLen10;
        float fIm1 = fInvProd * kE20.Dot(kE10);
        float fRe2 = 0.0f;
        float fIm2 = -fLen10 * fInvLenCross;
        for (int i6 = 0; i6 < iVQuantity; ++i6) {
            afTmp[i6] = 0.0f;
        }
        afTmp[iV0] = fRe0;
        afTmp[iV1] = fRe1;
        afTmp[iV2] = fRe2;
        float[] afResult = new float[iVQuantity];
        boolean bSolved = LinearSystem.SolveSymmetricCG(iVQuantity, kAMat, afTmp, afResult);
        assert (bSolved);
        for (i2 = 0; i2 < iVQuantity; ++i2) {
            if (this.m_akPlane[i2] == null) {
                this.m_akPlane[i2] = new Vector2f();
            }
            this.m_akPlane[i2].X = afResult[i2];
        }
        for (i2 = 0; i2 < iVQuantity; ++i2) {
            afTmp[i2] = 0.0f;
        }
        afTmp[iV0] = -fIm0;
        afTmp[iV1] = -fIm1;
        afTmp[iV2] = -fIm2;
        bSolved = LinearSystem.SolveSymmetricCG(iVQuantity, kAMat, afTmp, afResult);
        assert (bSolved);
        for (i2 = 0; i2 < iVQuantity; ++i2) {
            this.m_akPlane[i2].Y = afResult[i2];
        }
        afTmp = null;
        afResult = null;
        float fMax = fMin = this.m_akPlane[0].X;
        for (int i7 = 0; i7 < iVQuantity; ++i7) {
            if (this.m_akPlane[i7].X < fMin) {
                fMin = this.m_akPlane[i7].X;
            } else if (this.m_akPlane[i7].X > fMax) {
                fMax = this.m_akPlane[i7].X;
            }
            if (this.m_akPlane[i7].Y < fMin) {
                fMin = this.m_akPlane[i7].Y;
                continue;
            }
            if (!(this.m_akPlane[i7].Y > fMax)) continue;
            fMax = this.m_akPlane[i7].Y;
        }
        float fHalfRange = 0.5f * (fMax - fMin);
        float fInvHalfRange = 1.0f / fHalfRange;
        for (int i8 = 0; i8 < iVQuantity; ++i8) {
            this.m_akPlane[i8].X = -1.0f + fInvHalfRange * (this.m_akPlane[i8].X - fMin);
            this.m_akPlane[i8].Y = -1.0f + fInvHalfRange * (this.m_akPlane[i8].Y - fMin);
        }
        Vector2f kOrigin = new Vector2f(0.0f, 0.0f);
        for (i = 0; i < iVQuantity; ++i) {
            kOrigin.Add(this.m_akPlane[i]);
        }
        kOrigin.Scale(1.0f / (float)iVQuantity);
        for (i = 0; i < iVQuantity; ++i) {
            this.m_akPlane[i].Sub(kOrigin);
        }
        this.m_kPlaneMin = new Vector2f(this.m_akPlane[0]);
        this.m_kPlaneMax = new Vector2f(this.m_akPlane[0]);
        for (i = 1; i < iVQuantity; ++i) {
            if (this.m_akPlane[i].X < this.m_kPlaneMin.X) {
                this.m_kPlaneMin.X = this.m_akPlane[i].X;
            } else if (this.m_akPlane[i].X > this.m_kPlaneMax.X) {
                this.m_kPlaneMax.X = this.m_akPlane[i].X;
            }
            if (this.m_akPlane[i].Y < this.m_kPlaneMin.Y) {
                this.m_kPlaneMin.Y = this.m_akPlane[i].Y;
                continue;
            }
            if (!(this.m_akPlane[i].Y > this.m_kPlaneMax.Y)) continue;
            this.m_kPlaneMax.Y = this.m_akPlane[i].Y;
        }
        float fTwoTotalArea = 0.0f;
        for (int iT = 0; iT < iTQuantity; ++iT) {
            BasicMesh.Triangle rkT0 = akTriangle[iT];
            Vector3f rkV0 = akPoint[rkT0.V[0]];
            Vector3f rkV1 = akPoint[rkT0.V[1]];
            Vector3f rkV2 = akPoint[rkT0.V[2]];
            kE0.Sub(rkV1, rkV0);
            kE1.Sub(rkV2, rkV0);
            kCross.Cross(kE0, kE1);
            fTwoTotalArea += kCross.Length();
        }
        this.m_fRadius = this.ComputeRadius(this.m_akPlane[iV0], this.m_akPlane[iV1], this.m_akPlane[iV2], fTwoArea / fTwoTotalArea);
        float fRadiusSqr = this.m_fRadius * this.m_fRadius;
        for (int i9 = 0; i9 < iVQuantity; ++i9) {
            float fRSqr = this.m_akPlane[i9].SquaredLength();
            float fMult = 1.0f / (fRSqr + fRadiusSqr);
            float fX = 2.0f * fMult * fRadiusSqr * this.m_akPlane[i9].X;
            float fY = 2.0f * fMult * fRadiusSqr * this.m_akPlane[i9].Y;
            float fZ = fMult * this.m_fRadius * (fRSqr - fRadiusSqr);
            this.m_akSphere[i9] = new Vector3f(fX / this.m_fRadius, fY / this.m_fRadius, fZ / this.m_fRadius);
        }
    }

    public ConformalMap(int iVQuantity, Vector3f[] akPoint, int iTQuantity, int[] aiIndex, int iPunctureTriangle) {
        this(new BasicMesh(iVQuantity, akPoint, iTQuantity, aiIndex), iVQuantity, akPoint, iTQuantity, iPunctureTriangle);
    }

    public void dispose() {
        this.m_akPlane = null;
        this.m_akSphere = null;
    }

    public Vector2f[] GetPlaneCoordinates() {
        return this.m_akPlane;
    }

    public final Vector2f GetPlaneMax() {
        return this.m_kPlaneMax;
    }

    public final Vector2f GetPlaneMin() {
        return this.m_kPlaneMin;
    }

    public final Vector3f[] GetSphereCoordinates() {
        return this.m_akSphere;
    }

    public float GetSphereRadius() {
        return this.m_fRadius;
    }

    private float ComputeRadius(Vector2f rkV0, Vector2f rkV1, Vector2f rkV2, float fAreaFraction) {
        float fR0Sqr = rkV0.SquaredLength();
        float fR1Sqr = rkV1.SquaredLength();
        float fR2Sqr = rkV2.SquaredLength();
        float fDR10 = fR1Sqr - fR0Sqr;
        float fDR20 = fR2Sqr - fR0Sqr;
        float fDX10 = rkV1.X - rkV0.X;
        float fDY10 = rkV1.Y - rkV0.Y;
        float fDX20 = rkV2.X - rkV0.X;
        float fDY20 = rkV2.Y - rkV0.Y;
        float fDRX10 = rkV1.X * fR0Sqr - rkV0.X * fR1Sqr;
        float fDRY10 = rkV1.Y * fR0Sqr - rkV0.Y * fR1Sqr;
        float fDRX20 = rkV2.X * fR0Sqr - rkV0.X * fR2Sqr;
        float fDRY20 = rkV2.Y * fR0Sqr - rkV0.Y * fR2Sqr;
        float fC0 = fDR20 * fDRY10 - fDR10 * fDRY20;
        float fC1 = fDR20 * fDY10 - fDR10 * fDY20;
        float fD0 = fDR10 * fDRX20 - fDR20 * fDRX10;
        float fD1 = fDR10 * fDX20 - fDR20 * fDX10;
        float fE0 = fDRX10 * fDRY20 - fDRX20 * fDRY10;
        float fE1 = fDRX10 * fDY20 - fDRX20 * fDY10;
        float fE2 = fDX10 * fDY20 - fDX20 * fDY10;
        Polynomial1f kP0 = new Polynomial1f(6);
        kP0.SetCoeff(0, 0.0f);
        kP0.SetCoeff(1, 0.0f);
        kP0.SetCoeff(2, fE0 * fE0);
        kP0.SetCoeff(3, fC0 * fC0 + fD0 * fD0 + 2.0f * fE0 * fE1);
        kP0.SetCoeff(4, 2.0f * (fC0 * fC1 + fD0 * fD1 + fE0 * fE1) + fE1 * fE1);
        kP0.SetCoeff(5, fC1 * fC1 + fD1 * fD1 + 2.0f * fE1 * fE2);
        kP0.SetCoeff(6, fE2 * fE2);
        Polynomial1f kQ0 = new Polynomial1f(1);
        Polynomial1f kQ1 = new Polynomial1f(1);
        Polynomial1f kQ2 = new Polynomial1f(1);
        kQ0.SetCoeff(0, fR0Sqr);
        kQ0.SetCoeff(1, 1.0f);
        kQ1.SetCoeff(0, fR1Sqr);
        kQ1.SetCoeff(1, 1.0f);
        kQ2.SetCoeff(0, fR2Sqr);
        kQ2.SetCoeff(1, 1.0f);
        float fTmp = (float)((double)fAreaFraction * Math.PI);
        float fAmp = fTmp * fTmp;
        Polynomial1f kP1 = new Polynomial1f(kQ0);
        kP1.Scale(fAmp);
        kP1.Mult(kP1, kQ0);
        kP1.Mult(kP1, kQ0);
        kP1.Mult(kP1, kQ0);
        kP1.Mult(kP1, kQ1);
        kP1.Mult(kP1, kQ1);
        kP1.Mult(kP1, kQ2);
        kP1.Mult(kP1, kQ2);
        Polynomial1f kFinal = new Polynomial1f(0);
        kFinal.Sub(kP1, kP0);
        assert (kFinal.GetDegree() <= 8);
        float fTMin = 0.0f;
        float fFMin = kFinal.Eval(fTMin);
        float fTMax = 1.0f;
        float fFMax = kFinal.Eval(fTMax);
        assert (fFMin > 0.0f && fFMax < 0.0f);
        int iDigits = 6;
        float fTmp0 = (float)Math.log(fTMax - fTMin);
        float fTmp1 = (float)(6.0 * Math.log(10.0));
        float fArg = (float)((double)(fTmp0 + fTmp1) / Math.log(2.0));
        int iMaxIter = (int)(fArg + 0.5f);
        float fTMid = 0.0f;
        for (int i = 0; i < iMaxIter; ++i) {
            fTMid = 0.5f * (fTMin + fTMax);
            float fFMid = kFinal.Eval(fTMid);
            float fProduct = fFMid * fFMin;
            if (fProduct < 0.0f) {
                fTMax = fTMid;
                fFMax = fFMid;
                continue;
            }
            fTMin = fTMid;
            fFMin = fFMid;
        }
        float fRadius = (float)Math.sqrt(fTMid);
        return fRadius;
    }
}

