/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Meshes;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class MeshSmoother
implements Serializable {
    private static final long serialVersionUID = 3202802896382637793L;
    protected int m_iVQuantity;
    protected Vector3f[] m_akVertex;
    protected int m_iTQuantity;
    protected int[] m_aiIndex;
    protected Vector3f[] m_akNormal;
    protected Vector3f[] m_akMean;
    protected int[] m_aiNeighborCount;

    public MeshSmoother() {
        this.m_iVQuantity = 0;
        this.m_akVertex = null;
        this.m_iTQuantity = 0;
        this.m_aiIndex = null;
        this.m_akNormal = null;
        this.m_akMean = null;
        this.m_aiNeighborCount = null;
    }

    public MeshSmoother(int iVQuantity, Vector3f[] akVertex, int iTQuantity, int[] aiIndex) {
        this.m_akVertex = null;
        this.m_akNormal = null;
        this.m_aiIndex = null;
        this.m_akMean = null;
        this.m_aiNeighborCount = null;
        this.Create(iVQuantity, akVertex, iTQuantity, aiIndex);
    }

    public void Create(int iVQuantity, Vector3f[] akVertex, int iTQuantity, int[] aiIndex) {
        int i;
        this.Destroy();
        this.m_iVQuantity = iVQuantity;
        this.m_akVertex = akVertex;
        this.m_iTQuantity = iTQuantity;
        this.m_aiIndex = aiIndex;
        this.m_akNormal = new Vector3f[this.m_iVQuantity];
        this.m_akMean = new Vector3f[this.m_iVQuantity];
        this.m_aiNeighborCount = new int[this.m_iVQuantity];
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_aiNeighborCount[i] = 0;
        }
        for (i = 0; i < this.m_iTQuantity; ++i) {
            int n = this.m_aiIndex[i * 3 + 0];
            this.m_aiNeighborCount[n] = this.m_aiNeighborCount[n] + 2;
            int n2 = this.m_aiIndex[i * 3 + 1];
            this.m_aiNeighborCount[n2] = this.m_aiNeighborCount[n2] + 2;
            int n3 = this.m_aiIndex[i * 3 + 2];
            this.m_aiNeighborCount[n3] = this.m_aiNeighborCount[n3] + 2;
        }
    }

    public void Destroy() {
        this.m_akNormal = null;
        this.m_akMean = null;
        this.m_aiNeighborCount = null;
    }

    public void dispose() {
        this.Destroy();
    }

    public int[] GetIndices() {
        return this.m_aiIndex;
    }

    public Vector3f[] GetMeans() {
        return this.m_akMean;
    }

    public Vector3f[] GetNormals() {
        return this.m_akNormal;
    }

    public int GetTQuantity() {
        return this.m_iTQuantity;
    }

    public Vector3f[] GetVertices() {
        return this.m_akVertex;
    }

    public int GetVQuantity() {
        return this.m_iVQuantity;
    }

    public void Update() {
        this.Update(0.0f);
    }

    public void Update(float fTime) {
        int i;
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_akNormal[i].Copy(Vector3f.ZERO);
            this.m_akMean[i].Copy(Vector3f.ZERO);
        }
        Vector3f kEdge1 = new Vector3f();
        Vector3f kEdge2 = new Vector3f();
        Vector3f kNormal = new Vector3f();
        for (i = 0; i < this.m_iTQuantity; ++i) {
            int iV0 = this.m_aiIndex[i * 3 + 0];
            int iV1 = this.m_aiIndex[i * 3 + 1];
            int iV2 = this.m_aiIndex[i * 3 + 2];
            Vector3f rkV0 = this.m_akVertex[iV0];
            Vector3f rkV1 = this.m_akVertex[iV1];
            Vector3f rkV2 = this.m_akVertex[iV2];
            kEdge1.Sub(rkV1, rkV0);
            kEdge2.Sub(rkV2, rkV0);
            kNormal.Cross(kEdge1, kEdge2);
            this.m_akNormal[iV0].Add(kNormal);
            this.m_akNormal[iV1].Add(kNormal);
            this.m_akNormal[iV2].Add(kNormal);
            this.m_akMean[iV0].Add(rkV1);
            this.m_akMean[iV0].Add(rkV2);
            this.m_akMean[iV1].Add(rkV2);
            this.m_akMean[iV1].Add(rkV0);
            this.m_akMean[iV2].Add(rkV0);
            this.m_akMean[iV2].Add(rkV1);
        }
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_akNormal[i].Normalize();
            this.m_akMean[i].Scale(1.0f / (float)this.m_aiNeighborCount[i]);
        }
        Vector3f kLocalDiff = new Vector3f();
        Vector3f kSurfaceNormal = new Vector3f();
        Vector3f kTangent = new Vector3f();
        for (i = 0; i < this.m_iVQuantity; ++i) {
            if (!this.VertexInfluenced(i, fTime)) continue;
            kLocalDiff.Sub(this.m_akMean[i], this.m_akVertex[i]);
            kSurfaceNormal.Scale(kLocalDiff.Dot(this.m_akNormal[i]), this.m_akNormal[i]);
            kTangent.Sub(kLocalDiff, kSurfaceNormal);
            float fTWeight = this.GetTangentWeight(i, fTime);
            float fNWeight = this.GetNormalWeight(i, fTime);
            this.m_akVertex[i].X += fTWeight * kTangent.X + fNWeight * this.m_akNormal[i].X;
            this.m_akVertex[i].Y += fTWeight * kTangent.Y + fNWeight * this.m_akNormal[i].Y;
            this.m_akVertex[i].Z += fTWeight * kTangent.Z + fNWeight * this.m_akNormal[i].Z;
        }
    }

    protected float GetNormalWeight(int i, float fTime) {
        return 0.0f;
    }

    protected float GetTangentWeight(int i, float fTime) {
        return 0.5f;
    }

    protected boolean VertexInfluenced(int i, float fTime) {
        return true;
    }
}

