/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import WildMagic.LibFoundation.Mathematics.GMatrixf;
import WildMagic.LibFoundation.NumericalAnalysis.SparseMatrix;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class LinearSystem
implements Serializable {
    private static final long serialVersionUID = 1226515858084681719L;

    public static boolean Inverse(GMatrixf rkA, GMatrixf rkInvA) {
        float fSave;
        int i2;
        int i1;
        assert (rkA.GetRows() == rkA.GetColumns());
        int iSize = rkInvA.GetRows();
        rkInvA = new GMatrixf(rkA);
        int[] aiColIndex = new int[iSize];
        int[] aiRowIndex = new int[iSize];
        boolean[] abPivoted = new boolean[iSize];
        for (int i = 0; i < iSize; ++i) {
            abPivoted[i] = false;
        }
        int iRow = 0;
        int iCol = 0;
        for (int i0 = 0; i0 < iSize; ++i0) {
            float fMax = 0.0f;
            for (i1 = 0; i1 < iSize; ++i1) {
                if (abPivoted[i1]) continue;
                for (i2 = 0; i2 < iSize; ++i2) {
                    float fAbs;
                    if (abPivoted[i2] || !((fAbs = Math.abs(rkInvA.Get(i1, i2))) > fMax)) continue;
                    fMax = fAbs;
                    iRow = i1;
                    iCol = i2;
                }
            }
            if (fMax == 0.0f) {
                aiColIndex = null;
                aiRowIndex = null;
                abPivoted = null;
                return false;
            }
            abPivoted[iCol] = true;
            if (iRow != iCol) {
                rkInvA.SwapRows(iRow, iCol);
            }
            aiRowIndex[i0] = iRow;
            aiColIndex[i0] = iCol;
            float fInv = 1.0f / rkInvA.Get(iCol, iCol);
            rkInvA.Set(iCol, iCol, 1.0f);
            for (i2 = 0; i2 < iSize; ++i2) {
                rkInvA.Set(iCol, i2, rkInvA.Get(iCol, i2) * fInv);
            }
            for (i1 = 0; i1 < iSize; ++i1) {
                if (i1 == iCol) continue;
                fSave = rkInvA.Get(i1, iCol);
                rkInvA.Set(i1, iCol, 0.0f);
                for (i2 = 0; i2 < iSize; ++i2) {
                    rkInvA.Set(i1, i2, rkInvA.Get(i1, i2) - rkInvA.Get(iCol, i2) * fSave);
                }
            }
        }
        for (i1 = iSize - 1; i1 >= 0; --i1) {
            if (aiRowIndex[i1] == aiColIndex[i1]) continue;
            for (i2 = 0; i2 < iSize; ++i2) {
                fSave = rkInvA.Get(i2, aiRowIndex[i1]);
                rkInvA.Set(i2, aiRowIndex[i1], rkInvA.Get(i2, aiColIndex[i1]));
                rkInvA.Set(i2, aiColIndex[i1], fSave);
            }
        }
        aiColIndex = null;
        aiRowIndex = null;
        abPivoted = null;
        return true;
    }

    public static boolean Solve(GMatrixf rkA, float[] afB, float[] afX) {
        float fSave;
        int i2;
        int i1;
        int iSize = rkA.GetColumns();
        GMatrixf kInvA = new GMatrixf(rkA);
        for (int i = 0; i < iSize; ++i) {
            afX[i] = afB[i];
        }
        int[] aiColIndex = new int[iSize];
        int[] aiRowIndex = new int[iSize];
        boolean[] abPivoted = new boolean[iSize];
        for (int i = 0; i < iSize; ++i) {
            abPivoted[i] = false;
        }
        int iRow = 0;
        int iCol = 0;
        for (int i0 = 0; i0 < iSize; ++i0) {
            float fMax = 0.0f;
            for (i1 = 0; i1 < iSize; ++i1) {
                if (abPivoted[i1]) continue;
                for (i2 = 0; i2 < iSize; ++i2) {
                    float fAbs;
                    if (abPivoted[i2] || !((fAbs = Math.abs(kInvA.Get(i1, i2))) > fMax)) continue;
                    fMax = fAbs;
                    iRow = i1;
                    iCol = i2;
                }
            }
            if (fMax == 0.0f) {
                aiColIndex = null;
                aiRowIndex = null;
                abPivoted = null;
                return false;
            }
            abPivoted[iCol] = true;
            if (iRow != iCol) {
                kInvA.SwapRows(iRow, iCol);
                fSave = afX[iRow];
                afX[iRow] = afX[iCol];
                afX[iCol] = fSave;
            }
            aiRowIndex[i0] = iRow;
            aiColIndex[i0] = iCol;
            float fInv = 1.0f / kInvA.Get(iCol, iCol);
            kInvA.Set(iCol, iCol, 1.0f);
            for (i2 = 0; i2 < iSize; ++i2) {
                kInvA.Set(iCol, i2, kInvA.Get(iCol, i2) * fInv);
            }
            int n = iCol;
            afX[n] = afX[n] * fInv;
            for (i1 = 0; i1 < iSize; ++i1) {
                if (i1 == iCol) continue;
                fSave = kInvA.Get(i1, iCol);
                kInvA.Set(i1, iCol, 0.0f);
                for (i2 = 0; i2 < iSize; ++i2) {
                    kInvA.Set(i1, i2, kInvA.Get(i1, i2) - kInvA.Get(iCol, i2) * fSave);
                }
                int n2 = i1;
                afX[n2] = afX[n2] - afX[iCol] * fSave;
            }
        }
        for (i1 = iSize - 1; i1 >= 0; --i1) {
            if (aiRowIndex[i1] == aiColIndex[i1]) continue;
            for (i2 = 0; i2 < iSize; ++i2) {
                fSave = kInvA.Get(i2, aiRowIndex[i1]);
                kInvA.Set(i2, aiRowIndex[i1], kInvA.Get(i2, aiColIndex[i1]));
                kInvA.Set(i2, aiColIndex[i1], fSave);
            }
        }
        aiColIndex = null;
        aiRowIndex = null;
        abPivoted = null;
        return true;
    }

    public static boolean Solve2(float[][] aafA, float[] afB, float[] afX) {
        float fDet = aafA[0][0] * aafA[1][1] - aafA[0][1] * aafA[1][0];
        if (Math.abs(fDet) < 1.0E-6f) {
            return false;
        }
        float fInvDet = 1.0f / fDet;
        afX[0] = (aafA[1][1] * afB[0] - aafA[0][1] * afB[1]) * fInvDet;
        afX[1] = (aafA[0][0] * afB[1] - aafA[1][0] * afB[0]) * fInvDet;
        return true;
    }

    public static boolean Solve3(float[][] aafA, float[] afB, float[] afX) {
        float[][] aafAInv = new float[3][3];
        aafAInv[0][0] = aafA[1][1] * aafA[2][2] - aafA[1][2] * aafA[2][1];
        aafAInv[0][1] = aafA[0][2] * aafA[2][1] - aafA[0][1] * aafA[2][2];
        aafAInv[0][2] = aafA[0][1] * aafA[1][2] - aafA[0][2] * aafA[1][1];
        aafAInv[1][0] = aafA[1][2] * aafA[2][0] - aafA[1][0] * aafA[2][2];
        aafAInv[1][1] = aafA[0][0] * aafA[2][2] - aafA[0][2] * aafA[2][0];
        aafAInv[1][2] = aafA[0][2] * aafA[1][0] - aafA[0][0] * aafA[1][2];
        aafAInv[2][0] = aafA[1][0] * aafA[2][1] - aafA[1][1] * aafA[2][0];
        aafAInv[2][1] = aafA[0][1] * aafA[2][0] - aafA[0][0] * aafA[2][1];
        aafAInv[2][2] = aafA[0][0] * aafA[1][1] - aafA[0][1] * aafA[1][0];
        float fDet = aafA[0][0] * aafAInv[0][0] + aafA[0][1] * aafAInv[1][0] + aafA[0][2] * aafAInv[2][0];
        if (Math.abs(fDet) < 1.0E-6f) {
            return false;
        }
        float fInvDet = 1.0f / fDet;
        for (int iRow = 0; iRow < 3; ++iRow) {
            int iCol = 0;
            while (iCol < 3) {
                float[] fArray = aafAInv[iRow];
                int n = iCol++;
                fArray[n] = fArray[n] * fInvDet;
            }
        }
        afX[0] = aafAInv[0][0] * afB[0] + aafAInv[0][1] * afB[1] + aafAInv[0][2] * afB[2];
        afX[1] = aafAInv[1][0] * afB[0] + aafAInv[1][1] * afB[1] + aafAInv[1][2] * afB[2];
        afX[2] = aafAInv[2][0] * afB[0] + aafAInv[2][1] * afB[1] + aafAInv[2][2] * afB[2];
        return true;
    }

    public static boolean SolveSymmetricCG(GMatrixf rkA, float[] afB, float[] afX) {
        float fNorm;
        float fRoot1;
        float fRoot0;
        int i;
        assert (rkA.GetRows() == rkA.GetColumns());
        int iSize = rkA.GetRows();
        float[] afR = new float[iSize];
        float[] afP = new float[iSize];
        float[] afW = new float[iSize];
        for (int i2 = 0; i2 < afX.length; ++i2) {
            afX[i2] = 0.0f;
            afR[i2] = afB[i2];
            afP[i2] = afR[i2];
        }
        float fRho0 = LinearSystem.Dot(iSize, afR, afR);
        LinearSystem.Multiply(rkA, afP, afW);
        float fAlpha = fRho0 / LinearSystem.Dot(iSize, afP, afW);
        LinearSystem.UpdateX(iSize, afX, fAlpha, afP);
        LinearSystem.UpdateR(iSize, afR, fAlpha, afW);
        float fRho1 = LinearSystem.Dot(iSize, afR, afR);
        int iMax = 1024;
        for (i = 1; i < 1024 && !((fRoot0 = (float)Math.sqrt(fRho1)) <= 1.0E-6f * (fRoot1 = (float)Math.sqrt(fNorm = LinearSystem.Dot(iSize, afB, afB)))); ++i) {
            float fBeta = fRho1 / fRho0;
            LinearSystem.UpdateP(iSize, afP, fBeta, afR);
            LinearSystem.Multiply(rkA, afP, afW);
            fAlpha = fRho1 / LinearSystem.Dot(iSize, afP, afW);
            LinearSystem.UpdateX(iSize, afX, fAlpha, afP);
            LinearSystem.UpdateR(iSize, afR, fAlpha, afW);
            fRho0 = fRho1;
            fRho1 = LinearSystem.Dot(iSize, afR, afR);
        }
        afW = null;
        afP = null;
        afR = null;
        return i < 1024;
    }

    public static boolean SolveSymmetricCG(int iSize, SparseMatrix rkA, float[] afB, float[] afX) {
        float fNorm;
        float fRoot1;
        float fRoot0;
        int i;
        float[] afR = new float[iSize];
        float[] afP = new float[iSize];
        float[] afW = new float[iSize];
        for (int i2 = 0; i2 < afX.length; ++i2) {
            afX[i2] = 0.0f;
            afR[i2] = afB[i2];
            afP[i2] = afR[i2];
        }
        float fRho0 = LinearSystem.Dot(iSize, afR, afR);
        LinearSystem.Multiply(iSize, rkA, afP, afW);
        float fAlpha = fRho0 / LinearSystem.Dot(iSize, afP, afW);
        LinearSystem.UpdateX(iSize, afX, fAlpha, afP);
        LinearSystem.UpdateR(iSize, afR, fAlpha, afW);
        float fRho1 = LinearSystem.Dot(iSize, afR, afR);
        int iMax = 1024;
        for (i = 1; i < 1024 && !((fRoot0 = (float)Math.sqrt(fRho1)) <= 1.0E-6f * (fRoot1 = (float)Math.sqrt(fNorm = LinearSystem.Dot(iSize, afB, afB)))); ++i) {
            float fBeta = fRho1 / fRho0;
            LinearSystem.UpdateP(iSize, afP, fBeta, afR);
            LinearSystem.Multiply(iSize, rkA, afP, afW);
            fAlpha = fRho1 / LinearSystem.Dot(iSize, afP, afW);
            LinearSystem.UpdateX(iSize, afX, fAlpha, afP);
            LinearSystem.UpdateR(iSize, afR, fAlpha, afW);
            fRho0 = fRho1;
            fRho1 = LinearSystem.Dot(iSize, afR, afR);
        }
        afW = null;
        afP = null;
        afR = null;
        return i < 1024;
    }

    private static float Dot(int iSize, float[] afU, float[] afV) {
        float fDot = 0.0f;
        for (int i = 0; i < iSize; ++i) {
            fDot += afU[i] * afV[i];
        }
        return fDot;
    }

    private static void Multiply(GMatrixf rkA, float[] afX, float[] afProd) {
        int iSize = rkA.GetRows();
        for (int i = 0; i < afProd.length; ++i) {
            afProd[i] = 0.0f;
        }
        for (int iRow = 0; iRow < iSize; ++iRow) {
            for (int iCol = 0; iCol < iSize; ++iCol) {
                int n = iRow;
                afProd[n] = afProd[n] + rkA.Get(iRow, iCol) * afX[iCol];
            }
        }
    }

    private static void Multiply(int iSize, SparseMatrix rkA, float[] afX, float[] afProd) {
        for (int i = 0; i < afProd.length; ++i) {
            afProd[i] = 0.0f;
        }
        Iterator<Map.Entry<SparseMatrix.Index, Float>> pkIter = rkA.iterator();
        while (pkIter.hasNext()) {
            Map.Entry<SparseMatrix.Index, Float> kEntry = pkIter.next();
            SparseMatrix.Index kIndex = kEntry.getKey();
            Float kValue = kEntry.getValue();
            int i = kIndex.m_iRow;
            int j = kIndex.m_iCol;
            float fValue = kValue.floatValue();
            int n = i;
            afProd[n] = afProd[n] + fValue * afX[j];
            if (i == j) continue;
            int n2 = j;
            afProd[n2] = afProd[n2] + fValue * afX[i];
        }
    }

    private static void UpdateP(int iSize, float[] afP, float fBeta, float[] afR) {
        for (int i = 0; i < iSize; ++i) {
            afP[i] = afR[i] + fBeta * afP[i];
        }
    }

    private static void UpdateR(int iSize, float[] afR, float fAlpha, float[] afW) {
        for (int i = 0; i < iSize; ++i) {
            int n = i;
            afR[n] = afR[n] - fAlpha * afW[i];
        }
    }

    private static void UpdateX(int iSize, float[] afX, float fAlpha, float[] afP) {
        for (int i = 0; i < iSize; ++i) {
            int n = i;
            afX[n] = afX[n] + fAlpha * afP[i];
        }
    }
}

