/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import WildMagic.LibFoundation.NumericalAnalysis.PowellCostFunction;

public class Minimize1 {
    private PowellCostFunction m_oFunction;
    private int[] m_iMaxLevel = new int[1];
    private int[] m_iMaxBracket = new int[1];
    private double m_fTMin;
    private double m_fFMin;
    private double[] m_afData;

    public Minimize1(PowellCostFunction oFunction, int iMaxLevel, int iMaxBracket, double[] afData) {
        if (oFunction == null) {
            System.err.println("Minimize1 : null cost function");
        }
        this.m_oFunction = oFunction;
        this.m_iMaxLevel[0] = iMaxLevel;
        this.m_iMaxBracket[0] = iMaxBracket;
        this.m_afData = afData;
    }

    public int[] MaxLevel() {
        return this.m_iMaxLevel;
    }

    public int[] MaxBracket() {
        return this.m_iMaxBracket;
    }

    public void GetMinimum(double fT0, double fT1, double fTInitial, double[] rfTMin, double[] rfFMin) {
        assert (fT0 <= fTInitial && fTInitial <= fT1);
        this.m_fTMin = Double.MAX_VALUE;
        this.m_fFMin = Double.MAX_VALUE;
        double fF0 = this.m_oFunction.cost(fT0, this.m_afData);
        double fFInitial = this.m_oFunction.cost(fTInitial, this.m_afData);
        double fF1 = this.m_oFunction.cost(fT1, this.m_afData);
        this.GetMinimum(fT0, fF0, fTInitial, fFInitial, fT1, fF1, this.m_iMaxLevel[0]);
        rfTMin[0] = this.m_fTMin;
        rfFMin[0] = this.m_fFMin;
    }

    private void GetMinimum(double fT0, double fF0, double fTm, double fFm, double fT1, double fF1, int iLevel) {
        if (fF0 < this.m_fFMin) {
            this.m_fTMin = fT0;
            this.m_fFMin = fF0;
        }
        if (fFm < this.m_fFMin) {
            this.m_fTMin = fTm;
            this.m_fFMin = fFm;
        }
        if (fF1 < this.m_fFMin) {
            this.m_fTMin = fT1;
            this.m_fFMin = fF1;
        }
        if (iLevel-- == 0) {
            return;
        }
        if ((fT1 - fTm) * (fF0 - fFm) > (fTm - fT0) * (fFm - fF1)) {
            if (fF1 > fF0) {
                if (fFm >= fF0) {
                    this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
                } else {
                    this.GetBracketedMinimum(fT0, fF0, fTm, fFm, fT1, fF1, iLevel);
                }
            } else if (fF1 < fF0) {
                if (fFm >= fF1) {
                    this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
                } else {
                    this.GetBracketedMinimum(fT0, fF0, fTm, fFm, fT1, fF1, iLevel);
                }
            } else {
                this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
                this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
            }
        } else if (fF1 > fF0) {
            this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
        } else if (fF1 < fF0) {
            this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
        } else {
            this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
            this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
        }
    }

    private void GetMinimum(double fT0, double fF0, double fT1, double fF1, int iLevel) {
        if (fF0 < this.m_fFMin) {
            this.m_fTMin = fT0;
            this.m_fFMin = fF0;
        }
        if (fF1 < this.m_fFMin) {
            this.m_fTMin = fT1;
            this.m_fFMin = fF1;
        }
        if (iLevel-- == 0) {
            return;
        }
        double fTm = 0.5 * (fT0 + fT1);
        double fFm = this.m_oFunction.cost(fTm, this.m_afData);
        if (fF0 - 2.0 * fFm + fF1 > 0.0) {
            if (fF1 > fF0) {
                if (fFm >= fF0) {
                    this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
                } else {
                    this.GetBracketedMinimum(fT0, fF0, fTm, fFm, fT1, fF1, iLevel);
                }
            } else if (fF1 < fF0) {
                if (fFm >= fF1) {
                    this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
                } else {
                    this.GetBracketedMinimum(fT0, fF0, fTm, fFm, fT1, fF1, iLevel);
                }
            } else {
                this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
                this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
            }
        } else if (fF1 > fF0) {
            this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
        } else if (fF1 < fF0) {
            this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
        } else {
            this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
            this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
        }
    }

    private void GetBracketedMinimum(double fT0, double fF0, double fTm, double fFm, double fT1, double fF1, int iLevel) {
        for (int i = 0; i < this.m_iMaxBracket[0]; ++i) {
            if (fFm < this.m_fFMin) {
                this.m_fTMin = fTm;
                this.m_fFMin = fFm;
            }
            double fEps = 1.0E-8;
            double fTol = 1.0E-4;
            if (Math.abs(fT1 - fT0) <= 2.0E-4 * Math.abs(fTm) + 1.0E-8) break;
            double fDT1 = fT1 - fTm;
            double fDF0 = fF0 - fFm;
            double fTmp1 = fDT1 * fDF0;
            double fDT0 = fT0 - fTm;
            double fDF1 = fF1 - fFm;
            double fTmp0 = fDT0 * fDF1;
            double fDenom = fTmp1 - fTmp0;
            if (Math.abs(fDenom) < 1.0E-8) {
                return;
            }
            double fTv = fTm + 0.5 * (fDT1 * fTmp1 - fDT0 * fTmp0) / fDenom;
            assert (fT0 <= fTv && fTv <= fT1);
            double fFv = this.m_oFunction.cost(fTv, this.m_afData);
            if (fTv < fTm) {
                if (fFv < fFm) {
                    fT1 = fTm;
                    fF1 = fFm;
                    fTm = fTv;
                    fFm = fFv;
                    continue;
                }
                fT0 = fTv;
                fF0 = fFv;
                continue;
            }
            if (fTv > fTm) {
                if (fFv < fFm) {
                    fT0 = fTm;
                    fF0 = fFm;
                    fTm = fTv;
                    fFm = fFv;
                    continue;
                }
                fT1 = fTv;
                fF1 = fFv;
                continue;
            }
            this.GetMinimum(fT0, fF0, fTm, fFm, iLevel);
            this.GetMinimum(fTm, fFm, fT1, fF1, iLevel);
        }
    }
}

