/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import WildMagic.LibFoundation.NumericalAnalysis.Minimize1;
import WildMagic.LibFoundation.NumericalAnalysis.PowellCostFunction;

public class MinimizeN
implements PowellCostFunction {
    private int m_iDimensions;
    private PowellCostFunction m_oFunction;
    private int m_iMaxIterations;
    private double[] m_afData;
    private Minimize1 m_kMinimizer;
    private double[][] m_aafDirection;
    private double[] m_afDConj;
    private double[] m_afDCurr;
    private double[] m_afTSave;
    private double[] m_afTCurr;
    private double[] m_fFCurr = new double[1];
    private double[] m_afLineArg;

    public MinimizeN(int iDimensions, PowellCostFunction oFunction, int iMaxLevel, int iMaxBracket, int iMaxIterations, double[] afData) {
        this.m_kMinimizer = new Minimize1(this, iMaxLevel, iMaxBracket, null);
        if (iDimensions < 1 || oFunction == null) {
            System.err.println("MinimizeN error: dimensions = " + iDimensions + " cost function = " + oFunction);
        }
        this.m_iDimensions = iDimensions;
        this.m_oFunction = oFunction;
        this.m_iMaxIterations = iMaxIterations;
        this.m_afData = afData;
        this.m_afTCurr = new double[this.m_iDimensions];
        this.m_afTSave = new double[this.m_iDimensions];
        this.m_aafDirection = new double[this.m_iDimensions + 1][this.m_iDimensions];
        this.m_afDConj = this.m_aafDirection[this.m_iDimensions];
        this.m_afLineArg = new double[this.m_iDimensions];
    }

    public void dispose() {
        this.m_afTCurr = null;
        this.m_afTSave = null;
        this.m_aafDirection = null;
        this.m_afLineArg = null;
    }

    public int[] MaxLevel() {
        return this.m_kMinimizer.MaxLevel();
    }

    public int[] MaxBracket() {
        return this.m_kMinimizer.MaxBracket();
    }

    public double[] UserData() {
        return this.m_afData;
    }

    public void GetMinimum(double[] afT0, double[] afT1, double[] afTInitial, double[] afTMin, double[] rfFMin) {
        int i;
        this.m_fFCurr[0] = this.m_oFunction.cost(afTInitial, this.m_afData);
        System.arraycopy(afTInitial, 0, this.m_afTSave, 0, afTInitial.length);
        System.arraycopy(afTInitial, 0, this.m_afTCurr, 0, afTInitial.length);
        for (i = 0; i < this.m_iDimensions; ++i) {
            for (int j = 0; j < this.m_aafDirection[i].length; ++j) {
                this.m_aafDirection[i][j] = 0.0;
            }
            this.m_aafDirection[i][i] = 1.0;
        }
        double[] fL0 = new double[1];
        double[] fL1 = new double[1];
        double[] fLMin = new double[1];
        for (int iIter = 0; iIter < this.m_iMaxIterations; ++iIter) {
            for (i = 0; i < this.m_iDimensions; ++i) {
                this.m_afDCurr = this.m_aafDirection[i];
                this.ComputeDomain(afT0, afT1, fL0, fL1);
                this.m_kMinimizer.GetMinimum(fL0[0], fL1[0], 0.0, fLMin, this.m_fFCurr);
                for (int j = 0; j < this.m_iDimensions; ++j) {
                    int n = j;
                    this.m_afTCurr[n] = this.m_afTCurr[n] + fLMin[0] * this.m_afDCurr[j];
                }
            }
            double fLength = 0.0;
            for (i = 0; i < this.m_iDimensions; ++i) {
                this.m_afDConj[i] = this.m_afTCurr[i] - this.m_afTSave[i];
                fLength += this.m_afDConj[i] * this.m_afDConj[i];
            }
            double fEpsilon = 1.0E-6;
            if ((fLength = Math.sqrt(fLength)) < 1.0E-6) break;
            double fInvLength = 1.0 / fLength;
            i = 0;
            while (i < this.m_iDimensions) {
                int n = i++;
                this.m_afDConj[n] = this.m_afDConj[n] * fInvLength;
            }
            this.m_afDCurr = this.m_afDConj;
            this.ComputeDomain(afT0, afT1, fL0, fL1);
            this.m_kMinimizer.GetMinimum(fL0[0], fL1[0], 0.0, fLMin, this.m_fFCurr);
            for (i = 0; i < this.m_iDimensions; ++i) {
                int n = i;
                this.m_afTCurr[n] = this.m_afTCurr[n] + fLMin[0] * this.m_afDCurr[i];
            }
            this.m_afDConj = this.m_aafDirection[0];
            for (i = 0; i < this.m_iDimensions; ++i) {
                this.m_aafDirection[i] = this.m_aafDirection[i + 1];
            }
            System.arraycopy(this.m_afTCurr, 0, this.m_afTSave, 0, this.m_afTCurr.length);
        }
        System.arraycopy(this.m_afTCurr, 0, afTMin, 0, this.m_afTCurr.length);
        rfFMin[0] = this.m_fFCurr[0];
    }

    private void ComputeDomain(double[] afT0, double[] afT1, double[] rfL0, double[] rfL1) {
        rfL0[0] = -1.7976931348623157E308;
        rfL1[0] = Double.MAX_VALUE;
        for (int i = 0; i < this.m_iDimensions; ++i) {
            double fInv;
            double fB0 = afT0[i] - this.m_afTCurr[i];
            double fB1 = afT1[i] - this.m_afTCurr[i];
            if (this.m_afDCurr[i] > 0.0) {
                fInv = 1.0 / this.m_afDCurr[i];
                if ((fB0 *= fInv) > rfL0[0]) {
                    rfL0[0] = fB0;
                }
                if (!((fB1 *= fInv) < rfL1[0])) continue;
                rfL1[0] = fB1;
                continue;
            }
            if (!(this.m_afDCurr[i] < 0.0)) continue;
            fInv = 1.0 / this.m_afDCurr[i];
            if ((fB0 *= fInv) < rfL1[0]) {
                rfL1[0] = fB0;
            }
            if (!((fB1 *= fInv) > rfL0[0])) continue;
            rfL0[0] = fB1;
        }
        if (rfL0[0] > 0.0) {
            rfL0[0] = 0.0;
        }
        if (rfL1[0] < 0.0) {
            rfL1[0] = 0.0;
        }
    }

    @Override
    public double cost(double fT, double[] afData) {
        for (int i = 0; i < this.m_iDimensions; ++i) {
            this.m_afLineArg[i] = this.m_afTCurr[i] + fT * this.m_afDCurr[i];
        }
        double fResult = this.m_oFunction.cost(this.m_afLineArg, this.m_afData);
        return fResult;
    }

    @Override
    public double cost(double[] fT, double[] afData) {
        return 0.0;
    }
}

