/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Collision;

import WildMagic.LibFoundation.Containment.ContBox3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Collision.BoundingVolumeTree;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.BoxBV;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import java.io.Serializable;
import java.util.Vector;

public class BoxBVTree
extends BoundingVolumeTree
implements Serializable {
    private static final long serialVersionUID = 7372013192987417163L;

    public BoxBVTree() {
    }

    public BoxBVTree(TriMesh pkMesh) {
        this.m_pkMesh = pkMesh;
        this.m_pkLChild = null;
        this.m_pkRChild = null;
        this.m_iTriangleQuantity = 0;
        this.m_kTriangles = null;
    }

    public BoxBVTree(TriMesh pkMesh, int iMaxTrisPerLeaf, boolean bStoreInteriorTris) {
        super(BoundingVolume.BVType.BV_BOX, pkMesh, iMaxTrisPerLeaf, bStoreInteriorTris);
    }

    protected static BoundingVolume CreateModelBound(TriMesh pkMesh, int i0, int i1, int[] aiISplit, Line3f rkLine) {
        int i;
        int iVQuantity = pkMesh.VBuffer.GetVertexQuantity();
        int[] aiIndex = pkMesh.IBuffer.GetData();
        boolean[] abValid = new boolean[iVQuantity];
        for (i = i0; i <= i1; ++i) {
            int j = 3 * aiISplit[i];
            abValid[aiIndex[j++]] = true;
            abValid[aiIndex[j++]] = true;
            abValid[aiIndex[j++]] = true;
        }
        Vector<Vector3f> kMeshVertices = new Vector<Vector3f>();
        for (i = 0; i < iVQuantity; ++i) {
            if (!abValid[i]) continue;
            kMeshVertices.add(pkMesh.VBuffer.GetPosition3(i));
        }
        abValid = null;
        BoxBV pkModelBound = new BoxBV();
        pkModelBound.SetBox(ContBox3f.ContOrientedBox(kMeshVertices.size(), kMeshVertices));
        rkLine.Origin = new Vector3f(pkModelBound.GetBox().Center);
        rkLine.Direction = new Vector3f(pkModelBound.GetBox().Axis[2]);
        return pkModelBound;
    }

    protected static BoundingVolume CreateWorldBound() {
        return new BoxBV();
    }
}

