/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Collision;

import WildMagic.LibFoundation.Intersection.IntrLine3Triangle3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Collision.BoundingVolumeTree;
import WildMagic.LibGraphics.Collision.PickRecord;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;
import java.util.Vector;

public class HierarchicalTriMesh
extends TriMesh
implements Serializable {
    private static final long serialVersionUID = 376066505718492274L;
    private BoundingVolumeTree m_kBoundingTree = null;

    public HierarchicalTriMesh(TriMesh kMesh) {
        super(kMesh);
    }

    public HierarchicalTriMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer) {
        super(pkVBuffer, pkIBuffer);
    }

    public HierarchicalTriMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, BoundingVolume kBounds) {
        super(pkVBuffer, pkIBuffer, kBounds);
    }

    public BoundingVolumeTree GetBoundingVolumeTree() {
        return this.m_kBoundingTree;
    }

    public void SetBoundingVolumeTree(BoundingVolumeTree kTree) {
        this.m_kBoundingTree = kTree;
    }

    public Vector<PickRecord> TestIntersection(Vector3f rkOrigin, Vector3f rkDirection, float fTMin, float fTMax) {
        TriMesh pkMesh = this.m_kBoundingTree.GetMesh();
        Vector3f kOrigin = pkMesh.World.ApplyInverse(rkOrigin);
        Vector3f kDirection = pkMesh.World.InvertVector(rkDirection);
        BoundingVolume kBV = this.m_kBoundingTree.GetModelBound();
        if (kBV.TestIntersection(kOrigin, kDirection, fTMin, fTMax)) {
            return this.TestIntersection(this.m_kBoundingTree, kOrigin, kDirection, fTMin, fTMax);
        }
        return null;
    }

    private Vector<PickRecord> TestIntersection(BoundingVolumeTree kTree, Vector3f kOrigin, Vector3f kDirection, float fTMin, float fTMax) {
        if (kTree.IsInteriorNode()) {
            Vector<PickRecord> kAddRecords;
            BoundingVolumeTree kRight;
            Vector<PickRecord> kAddRecords2;
            Vector<PickRecord> kRecords = new Vector<PickRecord>();
            BoundingVolumeTree kLeft = kTree.GetLChild();
            BoundingVolume kBV = kLeft.GetModelBound();
            if (kBV.TestIntersection(kOrigin, kDirection, fTMin, fTMax) && (kAddRecords2 = this.TestIntersection(kLeft, kOrigin, kDirection, fTMin, fTMax)) != null) {
                kRecords.addAll(kAddRecords2);
            }
            if ((kBV = (kRight = kTree.GetRChild()).GetModelBound()).TestIntersection(kOrigin, kDirection, fTMin, fTMax) && (kAddRecords = this.TestIntersection(kRight, kOrigin, kDirection, fTMin, fTMax)) != null) {
                kRecords.addAll(kAddRecords);
            }
            return kRecords;
        }
        TriMesh pkMesh = kTree.GetMesh();
        Line3f kLine = new Line3f(kOrigin, kDirection);
        Vector<PickRecord> kRecords = null;
        int iTQuantity = kTree.GetTriangleQuantity();
        Vector<Integer> kTriangles = kTree.GetTriangles();
        for (int i = 0; i < iTQuantity; ++i) {
            int[] aiTris = new int[3];
            if (!pkMesh.GetTriangle(kTriangles.get(i), aiTris)) continue;
            int iV0 = aiTris[0];
            int iV1 = aiTris[1];
            int iV2 = aiTris[2];
            Triangle3f kTriangle = new Triangle3f(pkMesh.VBuffer.GetPosition3(iV0), pkMesh.VBuffer.GetPosition3(iV1), pkMesh.VBuffer.GetPosition3(iV2));
            IntrLine3Triangle3f kIntr = new IntrLine3Triangle3f(kLine, kTriangle);
            if (!kIntr.Find() || !(fTMin <= kIntr.GetLineT()) || !(kIntr.GetLineT() <= fTMax)) continue;
            PickRecord kRecord = new PickRecord();
            kRecord.Intersected = pkMesh;
            kRecord.T = kIntr.GetLineT();
            kRecord.Triangle = i;
            kRecord.iV0 = iV0;
            kRecord.iV1 = iV1;
            kRecord.iV2 = iV2;
            kRecord.B0 = kIntr.GetTriB0();
            kRecord.B1 = kIntr.GetTriB1();
            kRecord.B2 = kIntr.GetTriB2();
            if (kRecords == null) {
                kRecords = new Vector<PickRecord>();
            }
            kRecords.add(kRecord);
        }
        return kRecords;
    }
}

