/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Collision;

import WildMagic.LibFoundation.Intersection.IntrLine3Triangle3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Collision.HierarchicalTriMesh;
import WildMagic.LibGraphics.Collision.PickRecord;
import WildMagic.LibGraphics.SceneGraph.Node;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.Triangles;
import java.io.Serializable;
import java.util.Vector;

public class Picker
implements Serializable {
    private static final long serialVersionUID = -9171618026409224678L;
    public Vector<PickRecord> Records = new Vector();
    private Vector3f m_kOrigin = new Vector3f(Vector3f.ZERO);
    private Vector3f m_kDirection = new Vector3f(Vector3f.ZERO);
    private float m_fTMin = 0.0f;
    private float m_fTMax = 0.0f;
    private static final PickRecord ms_kInvalid = null;

    public void Execute(Spatial pkScene, Vector3f rkOrigin, Vector3f rkDirection, float fTMin, float fTMax) {
        this.m_kOrigin = rkOrigin;
        this.m_kDirection = rkDirection;
        this.m_fTMin = fTMin;
        this.m_fTMax = fTMax;
        this.Records.clear();
        pkScene.UpdateGS();
        this.ExecuteRecursive(pkScene);
    }

    public final PickRecord GetClosestNonnegative() {
        int iClosest;
        if (this.Records.size() == 0) {
            return ms_kInvalid;
        }
        float fClosest = Float.MAX_VALUE;
        for (iClosest = 0; iClosest < this.Records.size(); ++iClosest) {
            if (!(this.Records.get((int)iClosest).T >= 0.0f)) continue;
            fClosest = this.Records.get((int)iClosest).T;
            break;
        }
        if (iClosest == this.Records.size()) {
            return ms_kInvalid;
        }
        for (int i = iClosest + 1; i < this.Records.size(); ++i) {
            if (!(0.0f <= this.Records.get((int)i).T) || !(this.Records.get((int)i).T < fClosest)) continue;
            fClosest = this.Records.get((int)i).T;
            iClosest = i;
        }
        return this.Records.get(iClosest);
    }

    public final PickRecord GetClosestNonpositive() {
        int iClosest;
        if (this.Records.size() == 0) {
            return ms_kInvalid;
        }
        float fClosest = -3.4028235E38f;
        for (iClosest = 0; iClosest < this.Records.size(); ++iClosest) {
            if (!(this.Records.get((int)iClosest).T <= 0.0f)) continue;
            fClosest = this.Records.get((int)iClosest).T;
            break;
        }
        if (iClosest == this.Records.size()) {
            return ms_kInvalid;
        }
        for (int i = iClosest + 1; i < this.Records.size(); ++i) {
            if (!(fClosest < this.Records.get((int)i).T) || !(this.Records.get((int)i).T <= 0.0f)) continue;
            fClosest = this.Records.get((int)i).T;
            iClosest = i;
        }
        return this.Records.get(iClosest);
    }

    public final PickRecord GetClosestToZero() {
        if (this.Records.size() == 0) {
            return ms_kInvalid;
        }
        float fClosest = Math.abs(this.Records.get((int)0).T);
        int iClosest = 0;
        for (int i = 1; i < this.Records.size(); ++i) {
            float fTmp = Math.abs(this.Records.get((int)i).T);
            if (!(fTmp < fClosest)) continue;
            fClosest = fTmp;
            iClosest = i;
        }
        return this.Records.get(iClosest);
    }

    private void ExecuteRecursive(Spatial pkObject) {
        if (pkObject instanceof Triangles) {
            HierarchicalTriMesh pkHMesh;
            boolean bTestMesh = true;
            if (pkObject instanceof HierarchicalTriMesh && (pkHMesh = (HierarchicalTriMesh)pkObject).GetBoundingVolumeTree() != null) {
                Vector<PickRecord> addRecords = pkHMesh.TestIntersection(this.m_kOrigin, this.m_kDirection, this.m_fTMin, this.m_fTMax);
                if (addRecords != null) {
                    for (int i = 0; i < addRecords.size(); ++i) {
                        this.Records.add(addRecords.get(i));
                    }
                }
                bTestMesh = false;
            }
            if (bTestMesh) {
                Triangles pkMesh = (Triangles)pkObject;
                if (pkMesh.WorldBound.TestIntersection(this.m_kOrigin, this.m_kDirection, this.m_fTMin, this.m_fTMax)) {
                    Line3f kLine = new Line3f(pkMesh.World.ApplyInverse(this.m_kOrigin), pkMesh.World.InvertVector(this.m_kDirection));
                    int iTQuantity = pkMesh.GetTriangleQuantity();
                    for (int i = 0; i < iTQuantity; ++i) {
                        int[] aiTris = new int[3];
                        if (!pkMesh.GetTriangle(i, aiTris)) continue;
                        int iV0 = aiTris[0];
                        int iV1 = aiTris[1];
                        int iV2 = aiTris[2];
                        Triangle3f kTriangle = new Triangle3f(pkMesh.VBuffer.GetPosition3(iV0), pkMesh.VBuffer.GetPosition3(iV1), pkMesh.VBuffer.GetPosition3(iV2));
                        IntrLine3Triangle3f kIntr = new IntrLine3Triangle3f(kLine, kTriangle);
                        if (!kIntr.Find() || !(this.m_fTMin <= kIntr.GetLineT()) || !(kIntr.GetLineT() <= this.m_fTMax)) continue;
                        PickRecord kRecord = new PickRecord();
                        kRecord.Intersected = pkMesh;
                        kRecord.T = kIntr.GetLineT();
                        kRecord.Triangle = i;
                        kRecord.iV0 = iV0;
                        kRecord.iV1 = iV1;
                        kRecord.iV2 = iV2;
                        kRecord.B0 = kIntr.GetTriB0();
                        kRecord.B1 = kIntr.GetTriB1();
                        kRecord.B2 = kIntr.GetTriB2();
                        this.Records.add(kRecord);
                    }
                }
            }
            return;
        }
        if (pkObject instanceof Node) {
            Node pkNode = (Node)pkObject;
            if (pkNode.WorldBound.TestIntersection(this.m_kOrigin, this.m_kDirection, this.m_fTMin, this.m_fTMax)) {
                for (int i = 0; i < pkNode.GetQuantity(); ++i) {
                    Spatial pkChild = pkNode.GetChild(i);
                    if (pkChild == null) continue;
                    this.ExecuteRecursive(pkChild);
                }
            }
        }
    }
}

