/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Detail;

import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.SceneGraph.Node;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import java.util.Vector;

public class BillboardNode
extends Node
implements NameIdInterface,
StreamInterface {
    private static final long serialVersionUID = 420916083603318269L;
    protected Camera m_spkCamera;
    protected Matrix3f m_kRotate = null;

    public BillboardNode(Camera pkCamera) {
        this.m_spkCamera = pkCamera;
    }

    public BillboardNode() {
    }

    @Override
    public void dispose() {
        if (this.m_spkCamera != null) {
            this.m_spkCamera.dispose();
            this.m_spkCamera = null;
        }
    }

    public void AlignTo(Camera pkCamera) {
        this.m_spkCamera = pkCamera;
    }

    @Override
    protected void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        if (this.m_spkCamera != null) {
            Vector3f kCLoc = new Vector3f();
            this.World.ApplyInverse(this.m_spkCamera.GetLocation(), kCLoc);
            float fAngle = (float)Math.atan2(kCLoc.X, kCLoc.Z);
            Matrix3f kOrient = new Matrix3f(Vector3f.UNIT_Y, fAngle);
            this.World.GetRotate().Mult(kOrient);
            if (this.m_kRotate != null) {
                Vector3f kUP = new Vector3f();
                this.World.ApplyForward(Vector3f.UNIT_Y, kUP);
                kUP.Normalize();
                fAngle = (float)Math.acos(kUP.Y);
                kOrient = new Matrix3f(Vector3f.UNIT_X, fAngle);
                this.World.GetRotate().Mult(kOrient);
            }
            kCLoc = null;
        }
        for (int i = 0; i < this.m_kChild.size(); ++i) {
            Spatial pkChild = (Spatial)this.m_kChild.get(i);
            if (pkChild == null) continue;
            pkChild.UpdateGS(dAppTime, false);
        }
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = this.GetObjectByNameBase(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkCamera != null && (pkFound = this.m_spkCamera.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.m_spkCamera != null) {
            this.m_spkCamera.GetAllObjectsByName(rkName, rkObjects);
        }
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = this.GetObjectByIDBase(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkCamera != null && (pkFound = this.m_spkCamera.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iObjectID = rkStream.ReadInt();
        pkLink.Add(iObjectID);
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        Integer iLinkID = pkLink.GetLinkID();
        this.m_spkCamera = (Camera)rkStream.GetFromMap(iLinkID);
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.m_spkCamera != null) {
            this.m_spkCamera.Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_spkCamera.GetID());
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("BillboardNode", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        if (this.m_spkCamera != null) {
            pkTree.Append(this.m_spkCamera.SaveStrings(null));
        }
        return pkTree;
    }

    public void SetLocalRotate(Matrix3f kRotate) {
        this.m_kRotate = new Matrix3f(kRotate);
    }
}

