/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Detail;

import WildMagic.LibGraphics.Detail.CollapseRecord;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import java.io.Serializable;

public class CollapseRecordArray
extends GraphicsObject
implements Serializable {
    private static final long serialVersionUID = 3255078367889959694L;
    protected int m_iQuantity;
    protected CollapseRecord[] m_akArray;

    public CollapseRecordArray() {
        this(0, null);
    }

    public CollapseRecordArray(int iQuantity, CollapseRecord[] akArray) {
        this.m_iQuantity = iQuantity;
        this.m_akArray = akArray;
    }

    @Override
    public void dispose() {
        this.m_akArray = null;
    }

    public CollapseRecord[] GetData() {
        return this.m_akArray;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
        for (int i = 0; i < this.m_iQuantity; ++i) {
            iSize += Stream.SIZEOF_INT;
            iSize += Stream.SIZEOF_INT;
            iSize += Stream.SIZEOF_INT;
            iSize += Stream.SIZEOF_INT;
            iSize += Stream.SIZEOF_INT;
            iSize += this.m_akArray[i].IQuantity * Stream.SIZEOF_INT;
        }
        return iSize;
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iQuantity = rkStream.ReadInt();
        this.m_akArray = new CollapseRecord[this.m_iQuantity];
        for (int i = 0; i < this.m_iQuantity; ++i) {
            this.m_akArray[i].VKeep = rkStream.ReadInt();
            this.m_akArray[i].VThrow = rkStream.ReadInt();
            this.m_akArray[i].VQuantity = rkStream.ReadInt();
            this.m_akArray[i].TQuantity = rkStream.ReadInt();
            this.m_akArray[i].IQuantity = rkStream.ReadInt();
            if (this.m_akArray[i].IQuantity > 0) {
                this.m_akArray[i].Index = new int[this.m_akArray[i].IQuantity];
                rkStream.Read(this.m_akArray[i].IQuantity, this.m_akArray[i].Index);
                continue;
            }
            this.m_akArray[i].Index = null;
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iQuantity);
        for (int i = 0; i < this.m_iQuantity; ++i) {
            rkStream.Write(this.m_akArray[i].VKeep);
            rkStream.Write(this.m_akArray[i].VThrow);
            rkStream.Write(this.m_akArray[i].VQuantity);
            rkStream.Write(this.m_akArray[i].TQuantity);
            rkStream.Write(this.m_akArray[i].IQuantity);
            if (this.m_akArray[i].IQuantity <= 0) continue;
            rkStream.Write(this.m_akArray[i].IQuantity, this.m_akArray[i].Index);
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("CollapseRecordArray", this.GetName()));
        pkTree.Append(super.SaveStrings(acTitle));
        StringTree pkChild = new StringTree();
        pkChild.Append(StringTree.Format("records"));
        pkChild.Append(StringTree.Format("quantity =", this.m_iQuantity));
        for (int i = 0; i < this.m_iQuantity; ++i) {
            CollapseRecord rkRecord = this.m_akArray[i];
            String acString = new String(i + ": keep = " + rkRecord.VKeep + ", throw = " + rkRecord.VThrow + ", vq = " + rkRecord.VQuantity + ", tq = " + rkRecord.TQuantity + ", iq = " + rkRecord.IQuantity);
            pkChild.Append(acString);
        }
        pkTree.Append(pkChild);
        return pkTree;
    }
}

