/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Detail;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Detail.CollapseRecord;
import WildMagic.LibGraphics.Detail.CollapseRecordArray;
import WildMagic.LibGraphics.Detail.Edge;
import WildMagic.LibGraphics.Detail.ModelSet;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class CreateClodMesh
implements Serializable {
    private static final long serialVersionUID = 707448636601133868L;
    protected HashMap<Edge, EdgeAttribute> m_kEMap;
    protected HashMap<Triangle, TriangleAttribute> m_kTMap;
    protected HashMap<Vertex, VertexAttribute> m_kVMap;
    Vector<CollapseRecord> m_kEDelete;
    HashSet<Vertex> m_kVDelete;
    private int[] m_aiConnect;
    private int[] m_aiIndex;
    private int[] m_aiNewConnect;
    private int[] m_aiVOrdered;
    private int[] m_aiVPermute;
    private HeapRecord[] m_akHeap;
    private VertexBuffer m_kNewVBuffer;
    private CollapseRecordArray m_akRecord;
    private VertexBuffer m_kVBuffer;
    private IndexBuffer m_kIBuffer;
    private boolean m_bCollapsing;
    private int m_iHQuantity;
    private int m_iTCurrent;
    private int m_iTQuantity;
    private int m_iVCurrent;
    private int m_iVQuantity;
    private Vector3f m_kE0;
    private Vector3f m_kE1;
    private Vector3f m_kN0;
    private Vector3f m_kN1;
    private Vector3f m_kCross;
    private Vector3f m_kDiff;
    float m_fAngleCutoff = (float)Math.cos(0.0872664626);

    public CreateClodMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer) {
        this.m_kVMap = new HashMap();
        this.m_kEMap = new HashMap();
        this.m_kTMap = new HashMap();
        this.m_kVBuffer = pkVBuffer;
        this.m_kIBuffer = pkIBuffer;
        int iVQuantity = pkVBuffer.GetVertexQuantity();
        int iIndexQuantity = pkIBuffer.GetIndexQuantity();
        this.m_aiVOrdered = new int[iVQuantity];
        this.m_aiVPermute = new int[iVQuantity];
        this.m_aiNewConnect = new int[iIndexQuantity];
        this.m_kVDelete = new HashSet();
        this.m_kEDelete = new Vector();
        this.m_akHeap = new HeapRecord[iIndexQuantity];
        this.m_kNewVBuffer = new VertexBuffer(pkVBuffer);
        this.m_kE0 = new Vector3f();
        this.m_kE1 = new Vector3f();
        this.m_kN0 = new Vector3f();
        this.m_kN1 = new Vector3f();
        this.m_kCross = new Vector3f();
        this.m_kDiff = new Vector3f();
        this.m_aiIndex = new int[iIndexQuantity];
    }

    public void decimate() {
        this.m_kVMap.clear();
        this.m_kEMap.clear();
        this.m_kTMap.clear();
        this.m_kVDelete.clear();
        this.m_kEDelete.clear();
        this.m_iVQuantity = this.m_kVBuffer.GetVertexQuantity();
        this.m_iTQuantity = this.m_kIBuffer.GetIndexQuantity() / 3;
        this.m_aiConnect = this.m_kIBuffer.GetData();
        this.m_iVCurrent = this.m_iVQuantity - 1;
        this.m_iTCurrent = this.m_iTQuantity - 1;
        this.m_bCollapsing = false;
        for (int i = 0; i < this.m_iTQuantity; ++i) {
            Triangle kT = new Triangle(this.m_aiConnect[3 * i], this.m_aiConnect[3 * i + 1], this.m_aiConnect[3 * i + 2]);
            this.insertTriangle(kT);
            this.setData(kT, new Integer(i));
        }
        this.initializeHeap();
        this.m_bCollapsing = true;
        while (this.m_iHQuantity > 0) {
            if (this.m_akHeap[0].m_fMetric == Float.POSITIVE_INFINITY) {
                this.flushVertices();
                this.flushTriangles();
                break;
            }
            this.doCollapse();
        }
        this.m_bCollapsing = false;
        this.reorder();
        this.computeRecords();
    }

    public void getConsistentComponents() {
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return;
        }
        HashMap<Triangle, Boolean> kVisitedMap = new HashMap<Triangle, Boolean>();
        for (Map.Entry<Triangle, TriangleAttribute> kEntry : this.m_kTMap.entrySet()) {
            kVisitedMap.put(kEntry.getKey(), Boolean.FALSE);
        }
        while (iTSize > 0) {
            Stack<Object> kStack = new Stack<Object>();
            for (Map.Entry entry : kVisitedMap.entrySet()) {
                if (entry.getValue() != Boolean.FALSE) continue;
                kStack.push(entry.getKey());
                entry.setValue(Boolean.TRUE);
                --iTSize;
                break;
            }
            while (!kStack.empty()) {
                Triangle triangle = (Triangle)kStack.pop();
                int iV0 = 0;
                int iV1 = 0;
                int iV2 = 0;
                for (int i = 0; i < 3; ++i) {
                    Boolean kVisited;
                    switch (i) {
                        case 0: {
                            iV0 = triangle.m_iV0;
                            iV1 = triangle.m_iV1;
                            break;
                        }
                        case 1: {
                            iV0 = triangle.m_iV1;
                            iV1 = triangle.m_iV2;
                            break;
                        }
                        case 2: {
                            iV0 = triangle.m_iV2;
                            iV1 = triangle.m_iV0;
                        }
                    }
                    Edge kE = new Edge(iV0, iV1);
                    EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                    if (kEAttr.m_kTSet.size() != 2) continue;
                    Triangle kTAdj = (Triangle)kEAttr.m_kTSet.get(0);
                    if (kTAdj == triangle) {
                        kTAdj = (Triangle)kEAttr.m_kTSet.get(1);
                    }
                    if ((kVisited = (Boolean)kVisitedMap.get(kTAdj)) != Boolean.FALSE) continue;
                    if (kTAdj.m_iV0 == iV0 && kTAdj.m_iV1 == iV1 || kTAdj.m_iV1 == iV0 && kTAdj.m_iV2 == iV1 || kTAdj.m_iV2 == iV0 && kTAdj.m_iV0 == iV1) {
                        iV0 = kTAdj.m_iV0;
                        iV1 = kTAdj.m_iV1;
                        iV2 = kTAdj.m_iV2;
                        kVisitedMap.remove(kTAdj);
                        this.removeTriangle(iV0, iV1, iV2);
                        this.insertTriangle(iV1, iV0, iV2);
                        kVisitedMap.put(new Triangle(iV1, iV0, iV2), Boolean.FALSE);
                        kEAttr = this.m_kEMap.get(kE);
                        kTAdj = (Triangle)kEAttr.m_kTSet.get(0);
                        if (kTAdj == triangle) {
                            kTAdj = (Triangle)kEAttr.m_kTSet.get(1);
                        }
                        kVisited = (Boolean)kVisitedMap.get(kTAdj);
                    }
                    kStack.push(kTAdj);
                    kVisitedMap.put(kTAdj, Boolean.TRUE);
                    --iTSize;
                }
            }
        }
    }

    public Object getData(Triangle kT) {
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        return kTAttr != null ? kTAttr.m_kData : null;
    }

    public CollapseRecordArray getRecords() {
        return this.m_akRecord;
    }

    public void insertTriangle(int iV0, int iV1, int iV2) {
        boolean bE2Created;
        boolean bE1Created;
        boolean bE0Created;
        boolean bV2Created;
        boolean bV1Created;
        VertexAttribute kV0Attr;
        boolean bV0Created;
        boolean bTCreated;
        Vertex kV0 = new Vertex(iV0);
        Vertex kV1 = new Vertex(iV1);
        Vertex kV2 = new Vertex(iV2);
        Edge kE0 = new Edge(iV0, iV1);
        Edge kE1 = new Edge(iV1, iV2);
        Edge kE2 = new Edge(iV2, iV0);
        Triangle kT = new Triangle(iV0, iV1, iV2);
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        boolean bl = bTCreated = kTAttr == null;
        if (bTCreated) {
            kTAttr = new TriangleAttribute();
            this.m_kTMap.put(kT, kTAttr);
        }
        boolean bl2 = bV0Created = (kV0Attr = this.m_kVMap.get(kV0)) == null;
        if (bV0Created) {
            kV0Attr = new VertexAttribute();
            this.m_kVMap.put(kV0, kV0Attr);
        }
        kV0Attr.m_kESet.add(kE0);
        kV0Attr.m_kESet.add(kE2);
        kV0Attr.m_kTSet.add(kT);
        VertexAttribute kV1Attr = this.m_kVMap.get(kV1);
        boolean bl3 = bV1Created = kV1Attr == null;
        if (bV1Created) {
            kV1Attr = new VertexAttribute();
            this.m_kVMap.put(kV1, kV1Attr);
        }
        kV1Attr.m_kESet.add(kE0);
        kV1Attr.m_kESet.add(kE1);
        kV1Attr.m_kTSet.add(kT);
        VertexAttribute kV2Attr = this.m_kVMap.get(kV2);
        boolean bl4 = bV2Created = kV2Attr == null;
        if (bV2Created) {
            kV2Attr = new VertexAttribute();
            this.m_kVMap.put(kV2, kV2Attr);
        }
        kV2Attr.m_kESet.add(kE1);
        kV2Attr.m_kESet.add(kE2);
        kV2Attr.m_kTSet.add(kT);
        EdgeAttribute kE0Attr = this.m_kEMap.get(kE0);
        boolean bl5 = bE0Created = kE0Attr == null;
        if (bE0Created) {
            kE0Attr = new EdgeAttribute();
            this.m_kEMap.put(kE0, kE0Attr);
        }
        kE0Attr.m_kTSet.add(kT);
        EdgeAttribute kE1Attr = this.m_kEMap.get(kE1);
        boolean bl6 = bE1Created = kE1Attr == null;
        if (bE1Created) {
            kE1Attr = new EdgeAttribute();
            this.m_kEMap.put(kE1, kE1Attr);
        }
        kE1Attr.m_kTSet.add(kT);
        EdgeAttribute kE2Attr = this.m_kEMap.get(kE2);
        boolean bl7 = bE2Created = kE2Attr == null;
        if (bE2Created) {
            kE2Attr = new EdgeAttribute();
            this.m_kEMap.put(kE2, kE2Attr);
        }
        kE2Attr.m_kTSet.add(kT);
        this.OnVertexInsert(kV0, bV0Created, kV0Attr);
        this.OnVertexInsert(kV1, bV1Created, kV1Attr);
        this.OnVertexInsert(kV2, bV2Created, kV2Attr);
        this.OnEdgeInsert(kE0, bE0Created, kE0Attr);
        this.OnEdgeInsert(kE1, bE1Created, kE1Attr);
        this.OnEdgeInsert(kE2, bE2Created, kE2Attr);
        this.OnTriangleInsert(kT, bTCreated, kTAttr);
    }

    public void insertTriangle(Triangle kT) {
        this.insertTriangle(kT.m_iV0, kT.m_iV1, kT.m_iV2);
    }

    public void OnEdgeInsert(Edge kE, boolean bCreate, EdgeAttribute kEAttr) {
        if (bCreate) {
            kEAttr.m_kData = new HeapRecord();
            if (this.m_bCollapsing) {
                this.m_akHeap[this.m_iHQuantity] = (HeapRecord)kEAttr.m_kData;
                this.m_akHeap[this.m_iHQuantity].m_kEdge = kE;
                this.m_akHeap[this.m_iHQuantity].m_iHIndex = this.m_iHQuantity;
                this.add(this.getMetric(kE, kEAttr));
            }
        } else if (this.m_bCollapsing) {
            HeapRecord kRecord = (HeapRecord)kEAttr.m_kData;
            if (kRecord.m_iHIndex >= 0) {
                this.update(kRecord.m_iHIndex, this.getMetric(kE, kEAttr));
            } else {
                kRecord.m_iHIndex = this.m_iHQuantity;
                this.add(this.getMetric(kE, kEAttr));
            }
        }
    }

    public void OnEdgeRemove(Edge kE, boolean bDestroy, EdgeAttribute kEAttr) {
        if (bDestroy) {
            HeapRecord kRecord = (HeapRecord)kEAttr.m_kData;
            if (kRecord.m_iHIndex >= 0) {
                this.update(kRecord.m_iHIndex, Float.NEGATIVE_INFINITY);
                this.remove();
            }
            kEAttr.m_kData = null;
        }
    }

    public void OnTriangleInsert(Triangle kT, boolean bCreate, TriangleAttribute kTAttr) {
        if (bCreate) {
            kTAttr.m_kData = new Integer(-1);
        }
    }

    public void OnTriangleRemove(Triangle kT, boolean bDestroy, TriangleAttribute kTAttr) {
        if (bDestroy) {
            kTAttr.m_kData = null;
        }
    }

    public void OnVertexInsert(Vertex kV, boolean bCreate, VertexAttribute kVAttr) {
        if (bCreate && this.m_bCollapsing) {
            this.m_kVDelete.remove(kV);
        }
    }

    public void OnVertexRemove(Vertex kV, boolean bDestroy, VertexAttribute kVAttr) {
        if (bDestroy && this.m_bCollapsing) {
            this.m_kVDelete.add(kV);
        }
    }

    public void removeTriangle(int iV0, int iV1, int iV2) {
        Triangle kT = new Triangle(iV0, iV1, iV2);
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        if (kTAttr == null) {
            return;
        }
        Edge kE0 = new Edge(iV0, iV1);
        EdgeAttribute kE0Attr = this.m_kEMap.get(kE0);
        kE0Attr.m_kTSet.remove(kT);
        Edge kE1 = new Edge(iV1, iV2);
        EdgeAttribute kE1Attr = this.m_kEMap.get(kE1);
        kE1Attr.m_kTSet.remove(kT);
        Edge kE2 = new Edge(iV2, iV0);
        EdgeAttribute kE2Attr = this.m_kEMap.get(kE2);
        kE2Attr.m_kTSet.remove(kT);
        Vertex kV0 = new Vertex(iV0);
        VertexAttribute kV0Attr = this.m_kVMap.get(kV0);
        kV0Attr.m_kTSet.remove(kT);
        Vertex kV1 = new Vertex(iV1);
        VertexAttribute kV1Attr = this.m_kVMap.get(kV1);
        kV1Attr.m_kTSet.remove(kT);
        Vertex kV2 = new Vertex(iV2);
        VertexAttribute kV2Attr = this.m_kVMap.get(kV2);
        kV2Attr.m_kTSet.remove(kT);
        if (kE0Attr.m_kTSet.isEmpty()) {
            kV0Attr.m_kESet.remove(kE0);
            kV1Attr.m_kESet.remove(kE0);
        }
        if (kE1Attr.m_kTSet.isEmpty()) {
            kV1Attr.m_kESet.remove(kE1);
            kV2Attr.m_kESet.remove(kE1);
        }
        if (kE2Attr.m_kTSet.isEmpty()) {
            kV0Attr.m_kESet.remove(kE2);
            kV2Attr.m_kESet.remove(kE2);
        }
        boolean bDestroyed = kV0Attr.isEmpty();
        this.OnVertexRemove(kV0, bDestroyed, kV0Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV0);
        }
        bDestroyed = kV1Attr.isEmpty();
        this.OnVertexRemove(kV1, bDestroyed, kV1Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV1);
        }
        bDestroyed = kV2Attr.isEmpty();
        this.OnVertexRemove(kV2, bDestroyed, kV2Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV2);
        }
        bDestroyed = kE0Attr.isEmpty();
        this.OnEdgeRemove(kE0, bDestroyed, kE0Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE0);
        }
        bDestroyed = kE1Attr.isEmpty();
        this.OnEdgeRemove(kE1, bDestroyed, kE1Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE1);
        }
        bDestroyed = kE2Attr.isEmpty();
        this.OnEdgeRemove(kE2, bDestroyed, kE2Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE2);
        }
        this.OnTriangleRemove(kT, true, kTAttr);
        this.m_kTMap.remove(kT);
    }

    public void removeTriangle(Triangle kT) {
        Integer kTIndex = (Integer)this.getData(kT);
        int iTIndex = kTIndex;
        if (iTIndex >= 0) {
            this.m_aiNewConnect[3 * this.m_iTCurrent] = this.m_aiConnect[3 * iTIndex];
            this.m_aiNewConnect[3 * this.m_iTCurrent + 1] = this.m_aiConnect[3 * iTIndex + 1];
            this.m_aiNewConnect[3 * this.m_iTCurrent + 2] = this.m_aiConnect[3 * iTIndex + 2];
            --this.m_iTCurrent;
        }
        this.superRemoveTriangle(kT);
    }

    public void setData(Triangle kT, Object kData) {
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        if (kTAttr != null) {
            kTAttr.m_kData = kData;
        }
    }

    public void superRemoveTriangle(Triangle kT) {
        this.removeTriangle(kT.m_iV0, kT.m_iV1, kT.m_iV2);
    }

    private void add(float fMetric) {
        ++this.m_iHQuantity;
        int iCh = this.m_iHQuantity - 1;
        HeapRecord kRecord = this.m_akHeap[iCh];
        while (iCh > 0) {
            int iPa = (iCh - 1) / 2;
            if (this.m_akHeap[iPa].m_fMetric <= fMetric) break;
            this.m_akHeap[iPa].m_iHIndex = iCh;
            this.m_akHeap[iCh] = this.m_akHeap[iPa];
            kRecord.m_iHIndex = iPa;
            kRecord.m_fMetric = fMetric;
            this.m_akHeap[iPa] = kRecord;
            iCh = iPa;
        }
        this.m_akHeap[iCh].m_fMetric = fMetric;
    }

    private boolean collapseCausesFolding(int iVKeep, int iVThrow) {
        VertexAttribute kVTAttr = this.m_kVMap.get(new Vertex(iVThrow));
        for (int j = 0; j < kVTAttr.m_kTSet.size(); ++j) {
            Triangle kT = (Triangle)kVTAttr.m_kTSet.get(j);
            if (iVKeep == kT.m_iV0 && iVThrow == kT.m_iV1 || iVKeep == kT.m_iV1 && iVThrow == kT.m_iV0 || iVKeep == kT.m_iV0 && iVThrow == kT.m_iV2 || iVKeep == kT.m_iV2 && iVThrow == kT.m_iV0 || iVKeep == kT.m_iV1 && iVThrow == kT.m_iV2 || iVKeep == kT.m_iV2 && iVThrow == kT.m_iV1) continue;
            block6: for (int i = 0; i < 3; ++i) {
                int iV0 = iVKeep;
                int iV1 = 0;
                int iV2 = 0;
                switch (i) {
                    case 0: {
                        if (kT.m_iV0 != iVThrow) continue block6;
                        iV1 = kT.m_iV1;
                        iV2 = kT.m_iV2;
                        if (this.m_kTMap.get(new Triangle(iV0, iV1, iV2)) != null || this.m_kTMap.get(new Triangle(iV0, iV2, iV1)) != null) {
                            return true;
                        }
                        if (!this.collapseCausesNormalsFlip(iVThrow, iVKeep, kT.m_iV1, kT.m_iV2)) continue block6;
                        return true;
                    }
                    case 1: {
                        if (kT.m_iV1 != iVThrow) continue block6;
                        iV1 = kT.m_iV2;
                        iV2 = kT.m_iV0;
                        if (this.m_kTMap.get(new Triangle(iV0, iV1, iV2)) != null || this.m_kTMap.get(new Triangle(iV0, iV2, iV1)) != null) {
                            return true;
                        }
                        if (!this.collapseCausesNormalsFlip(iVThrow, iVKeep, kT.m_iV0, kT.m_iV2)) continue block6;
                        return true;
                    }
                    case 2: {
                        if (kT.m_iV2 != iVThrow) continue block6;
                        iV1 = kT.m_iV0;
                        iV2 = kT.m_iV1;
                        if (this.m_kTMap.get(new Triangle(iV0, iV1, iV2)) != null || this.m_kTMap.get(new Triangle(iV0, iV2, iV1)) != null) {
                            return true;
                        }
                        if (!this.collapseCausesNormalsFlip(iVThrow, iVKeep, kT.m_iV0, kT.m_iV1)) continue block6;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean collapseCausesNormalsFlip(int iVThrow, int iVKeep, int iV1, int iV2) {
        Vector3f kThrow = this.m_kVBuffer.GetPosition3(iVThrow);
        Vector3f kKeep = this.m_kVBuffer.GetPosition3(iVKeep);
        Vector3f kEnd1 = this.m_kVBuffer.GetPosition3(iV1);
        Vector3f kEnd2 = this.m_kVBuffer.GetPosition3(iV2);
        Vector3f kE1 = new Vector3f();
        kE1.Sub(kEnd1, kKeep);
        Vector3f kE2 = new Vector3f();
        kE2.Sub(kEnd2, kKeep);
        float fAngle1 = kE1.Dot(kE2) / (kE1.Length() * kE2.Length());
        if (fAngle1 > this.m_fAngleCutoff) {
            return true;
        }
        Vector3f kE3 = new Vector3f();
        kE3.Sub(kKeep, kEnd1);
        Vector3f kE4 = new Vector3f();
        kE4.Sub(kEnd2, kEnd1);
        float fAngle2 = kE4.Dot(kE3) / (kE4.Length() * kE3.Length());
        if (fAngle2 > this.m_fAngleCutoff) {
            return true;
        }
        Vector3f kE5 = new Vector3f();
        kE5.Sub(kKeep, kEnd2);
        Vector3f kE6 = new Vector3f();
        kE6.Sub(kEnd1, kEnd2);
        float fAngle3 = kE5.Dot(kE6) / (kE5.Length() * kE6.Length());
        if (fAngle3 > this.m_fAngleCutoff) {
            return true;
        }
        Vector3f kNormalKeep = new Vector3f();
        kNormalKeep.UnitCross(kE1, kE2);
        kE1.Sub(kEnd1, kThrow);
        kE2.Sub(kEnd2, kThrow);
        Vector3f kNormalThrow = new Vector3f();
        kNormalThrow.UnitCross(kE1, kE2);
        if (kNormalKeep.Dot(kNormalThrow) < 0.0f) {
            return true;
        }
        float fAngle = kNormalThrow.Angle(kNormalKeep);
        return (double)fAngle >= 0.7853981633974483;
    }

    private void collapseEdge(int iVKeep, int iVThrow) {
        int j;
        Edge kCollapse = new Edge(iVKeep, iVThrow);
        EdgeAttribute kCollapseAttr = this.m_kEMap.get(kCollapse);
        this.m_kVDelete.clear();
        ModelSet kTSet = new ModelSet(kCollapseAttr.m_kTSet);
        int iTDeletions = kTSet.size();
        for (j = 0; j < kTSet.size(); ++j) {
            Triangle kT = (Triangle)kTSet.get(j);
            this.removeTriangle(kT);
        }
        Vertex kVThrow = new Vertex(iVThrow);
        VertexAttribute kVThrowAttr = this.m_kVMap.get(kVThrow);
        if (kVThrowAttr != null) {
            kTSet = new ModelSet(kVThrowAttr.m_kTSet);
            for (j = 0; j < kTSet.size(); ++j) {
                Triangle kT = (Triangle)kTSet.get(j);
                this.modifyTriangle(kT, iVKeep, iVThrow);
            }
        }
        HashSet<Edge> kModified = new HashSet<Edge>();
        Vertex kVKeep = new Vertex(iVKeep);
        VertexAttribute kVKeepAttr = this.m_kVMap.get(kVKeep);
        if (kVKeepAttr != null) {
            kTSet = new ModelSet(kVKeepAttr.m_kTSet);
            for (j = 0; j < kTSet.size(); ++j) {
                Triangle kT = (Triangle)kTSet.get(j);
                kModified.add(new Edge(kT.m_iV0, kT.m_iV1));
                kModified.add(new Edge(kT.m_iV1, kT.m_iV2));
                kModified.add(new Edge(kT.m_iV2, kT.m_iV0));
            }
            for (Edge kE : kModified) {
                EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                HeapRecord kRecord = (HeapRecord)kEAttr.m_kData;
                float fMetric = this.getMetric(kE, kEAttr);
                this.update(kRecord.m_iHIndex, fMetric);
            }
        }
        for (Vertex kV : this.m_kVDelete) {
            this.m_aiVOrdered[this.m_iVCurrent] = kV.m_iV;
            this.m_aiVPermute[kV.m_iV] = this.m_iVCurrent--;
        }
        CollapseRecord kCR = new CollapseRecord(iVKeep, iVThrow, this.m_kVDelete.size(), iTDeletions);
        this.m_kEDelete.add(kCR);
    }

    private float compareNormalsAcrossTriangles(int iV1, int iV2) {
        Vector<Vector3f> kV1List = new Vector<Vector3f>();
        VertexAttribute kVTAttr = this.m_kVMap.get(new Vertex(iV1));
        for (int j = 0; j < kVTAttr.m_kTSet.size(); ++j) {
            Triangle kT = (Triangle)kVTAttr.m_kTSet.get(j);
            if (iV1 == kT.m_iV0 && iV2 == kT.m_iV1 || iV1 == kT.m_iV1 && iV2 == kT.m_iV0 || iV1 == kT.m_iV0 && iV2 == kT.m_iV2 || iV1 == kT.m_iV2 && iV2 == kT.m_iV0 || iV1 == kT.m_iV1 && iV2 == kT.m_iV2 || iV1 == kT.m_iV2 && iV2 == kT.m_iV1) continue;
            kV1List.add(this.getNormal(kT));
        }
        Vector<Vector3f> kV2List = new Vector<Vector3f>();
        kVTAttr = this.m_kVMap.get(new Vertex(iV2));
        for (int j = 0; j < kVTAttr.m_kTSet.size(); ++j) {
            Triangle kT = (Triangle)kVTAttr.m_kTSet.get(j);
            if (iV1 == kT.m_iV0 && iV2 == kT.m_iV1 || iV1 == kT.m_iV1 && iV2 == kT.m_iV0 || iV1 == kT.m_iV0 && iV2 == kT.m_iV2 || iV1 == kT.m_iV2 && iV2 == kT.m_iV0 || iV1 == kT.m_iV1 && iV2 == kT.m_iV2 || iV1 == kT.m_iV2 && iV2 == kT.m_iV1) continue;
            kV2List.add(this.getNormal(kT));
        }
        float fMaxDiff = 0.0f;
        for (int i = 0; i < kV1List.size(); ++i) {
            for (int j = 0; j < kV2List.size(); ++j) {
                Vector3f kV2;
                Vector3f kV1 = (Vector3f)kV1List.get(i);
                float fAngle = kV1.Angle(kV2 = (Vector3f)kV2List.get(j));
                if (!(fMaxDiff < fAngle)) continue;
                fMaxDiff = fAngle;
            }
        }
        return fMaxDiff;
    }

    private void computeRecords() {
        int iR;
        int i;
        int iCQuantity = this.m_kEDelete.size() + 1;
        CollapseRecord[] akRecord = new CollapseRecord[iCQuantity];
        for (i = 0; i < iCQuantity; ++i) {
            akRecord[i] = new CollapseRecord();
        }
        this.m_akRecord = new CollapseRecordArray(iCQuantity, akRecord);
        akRecord[0].VQuantity = this.m_iVQuantity;
        akRecord[0].TQuantity = this.m_iTQuantity;
        int iVQuantity = this.m_iVQuantity;
        int iTQuantity = this.m_iTQuantity;
        int length = this.m_kEDelete.size();
        for (iR = 0; iR < length; ++iR) {
            CollapseRecord kERecord = this.m_kEDelete.get(iR);
            CollapseRecord kRecord = akRecord[iR + 1];
            kRecord.VKeep = kERecord.VKeep;
            kRecord.VThrow = kERecord.VThrow;
            kRecord.VQuantity = iVQuantity -= kERecord.VQuantity;
            kRecord.TQuantity = iTQuantity -= kERecord.TQuantity;
            kRecord.IQuantity = 0;
            if (iTQuantity > 0) {
                int iIMax = 3 * iTQuantity;
                for (i = 0; i < iIMax; ++i) {
                    if (this.m_aiConnect[i] != kRecord.VThrow) continue;
                    this.m_aiConnect[i] = kRecord.VKeep;
                    this.m_aiIndex[kRecord.IQuantity++] = i;
                }
                if (kRecord.IQuantity <= 0) continue;
                kRecord.Index = new int[kRecord.IQuantity];
                for (i = 0; i < kRecord.IQuantity; ++i) {
                    kRecord.Index[i] = this.m_aiIndex[i];
                }
                continue;
            }
            kRecord.Index = null;
        }
        for (iR = iCQuantity - 1; iR > 0; --iR) {
            CollapseRecord kRecord = akRecord[iR];
            for (i = 0; i < kRecord.IQuantity; ++i) {
                int iC = kRecord.Index[i];
                this.m_aiConnect[iC] = kRecord.VThrow;
            }
        }
    }

    private void doCollapse() {
        int i;
        Edge kEdge = this.m_akHeap[0].m_kEdge;
        for (i = 0; i < 2; ++i) {
            int j;
            int iV = i == 0 ? kEdge.m_iV0 : kEdge.m_iV1;
            VertexAttribute kVAttr = this.m_kVMap.get(new Vertex(iV));
            for (j = 0; j < kVAttr.m_kESet.size(); ++j) {
                Edge kEAdj = (Edge)kVAttr.m_kESet.get(j);
                EdgeAttribute kEAdjAttr = this.m_kEMap.get(kEAdj);
                if (kEAdjAttr.m_kTSet.size() != 2) break;
            }
            if (j == kVAttr.m_kESet.size()) break;
        }
        if (i < 2) {
            int iVKeep;
            int iVThrow;
            if (i == 0) {
                iVThrow = kEdge.m_iV0;
                iVKeep = kEdge.m_iV1;
            } else {
                iVThrow = kEdge.m_iV1;
                iVKeep = kEdge.m_iV0;
            }
            if (!this.collapseCausesFolding(iVKeep, iVThrow)) {
                this.remove();
                this.collapseEdge(iVKeep, iVThrow);
                return;
            }
        }
        this.update(0, Float.POSITIVE_INFINITY);
    }

    private void flushTriangles() {
        for (Map.Entry<Triangle, TriangleAttribute> kEntry : this.m_kTMap.entrySet()) {
            TriangleAttribute kTAttr = kEntry.getValue();
            Integer iTInteger = (Integer)kTAttr.m_kData;
            int iTIndex = iTInteger;
            if (iTIndex < 0) continue;
            this.m_aiNewConnect[3 * this.m_iTCurrent] = this.m_aiConnect[3 * iTIndex];
            this.m_aiNewConnect[3 * this.m_iTCurrent + 1] = this.m_aiConnect[3 * iTIndex + 1];
            this.m_aiNewConnect[3 * this.m_iTCurrent + 2] = this.m_aiConnect[3 * iTIndex + 2];
            --this.m_iTCurrent;
        }
    }

    private void flushVertices() {
        for (Map.Entry<Vertex, VertexAttribute> kEntry : this.m_kVMap.entrySet()) {
            int iV;
            Vertex kV = kEntry.getKey();
            this.m_aiVOrdered[this.m_iVCurrent] = iV = kV.m_iV;
            this.m_aiVPermute[iV] = this.m_iVCurrent--;
        }
    }

    private float getMetric(Edge kE, EdgeAttribute kEAttr) {
        float fLengthWeight = 10.0f;
        float fAngleWeight = 1.0f;
        if (kEAttr.m_kTSet.size() == 2) {
            Vector3f kEnd0 = this.m_kVBuffer.GetPosition3(kE.m_iV0);
            Vector3f kEnd1 = this.m_kVBuffer.GetPosition3(kE.m_iV1);
            this.m_kDiff.Sub(kEnd1, kEnd0);
            float fMetric = fLengthWeight * this.m_kDiff.Length();
            Triangle kT = (Triangle)kEAttr.m_kTSet.get(0);
            Vector3f kV0 = this.m_kVBuffer.GetPosition3(kT.m_iV0);
            Vector3f kV1 = this.m_kVBuffer.GetPosition3(kT.m_iV1);
            Vector3f kV2 = this.m_kVBuffer.GetPosition3(kT.m_iV2);
            this.m_kE0.Sub(kV1, kV0);
            this.m_kE1.Sub(kV2, kV0);
            this.m_kN0.Cross(this.m_kE0, this.m_kE1);
            kT = (Triangle)kEAttr.m_kTSet.get(1);
            kV0 = this.m_kVBuffer.GetPosition3(kT.m_iV0);
            kV1 = this.m_kVBuffer.GetPosition3(kT.m_iV1);
            kV2 = this.m_kVBuffer.GetPosition3(kT.m_iV2);
            this.m_kE0.Sub(kV1, kV0);
            this.m_kE1.Sub(kV2, kV0);
            this.m_kN1.Cross(this.m_kE0, this.m_kE1);
            this.m_kCross.Cross(this.m_kN0, this.m_kN1);
            fMetric += fAngleWeight * this.m_kCross.Length();
            return fMetric += 100.0f * this.compareNormalsAcrossTriangles(kE.m_iV0, kE.m_iV1);
        }
        return Float.POSITIVE_INFINITY;
    }

    private Vector3f getNormal(Triangle kT) {
        Vector3f kEnd0 = this.m_kVBuffer.GetPosition3(kT.m_iV0);
        Vector3f kEnd1 = this.m_kVBuffer.GetPosition3(kT.m_iV1);
        Vector3f kEnd2 = this.m_kVBuffer.GetPosition3(kT.m_iV2);
        Vector3f kE1 = new Vector3f();
        kE1.Sub(kEnd1, kEnd0);
        Vector3f kE2 = new Vector3f();
        kE2.Sub(kEnd2, kEnd0);
        Vector3f kNormal = new Vector3f();
        kNormal.UnitCross(kE1, kE2);
        return kNormal;
    }

    private void initializeHeap() {
        this.m_iHQuantity = this.m_kEMap.size();
        int iHIndex = 0;
        for (Map.Entry<Edge, EdgeAttribute> kEntry : this.m_kEMap.entrySet()) {
            Edge kE = kEntry.getKey();
            EdgeAttribute kEAttr = kEntry.getValue();
            this.m_akHeap[iHIndex] = (HeapRecord)kEAttr.m_kData;
            this.m_akHeap[iHIndex].m_kEdge = kE;
            this.m_akHeap[iHIndex].m_iHIndex = iHIndex;
            this.m_akHeap[iHIndex].m_fMetric = this.getMetric(kE, kEAttr);
            ++iHIndex;
        }
        this.sort();
    }

    private void modifyTriangle(Triangle kT, int iVKeep, int iVThrow) {
        int iV0 = kT.m_iV0;
        int iV1 = kT.m_iV1;
        int iV2 = kT.m_iV2;
        Integer kTIndex = (Integer)this.getData(kT);
        this.superRemoveTriangle(kT);
        if (iV0 == iVThrow) {
            iV0 = iVKeep;
        } else if (iV1 == iVThrow) {
            iV1 = iVKeep;
        } else {
            iV2 = iVKeep;
        }
        Triangle kTSave = new Triangle(iV0, iV1, iV2);
        this.insertTriangle(kTSave);
        this.setData(kTSave, kTIndex);
    }

    private void remove() {
        HeapRecord kRoot = this.m_akHeap[0];
        int iLast = this.m_iHQuantity - 1;
        HeapRecord kRecord = this.m_akHeap[iLast];
        int iPa = 0;
        int iCh = 1;
        while (iCh <= iLast) {
            if (iCh < iLast) {
                int iChP = iCh + 1;
                if (this.m_akHeap[iCh].m_fMetric > this.m_akHeap[iChP].m_fMetric) {
                    iCh = iChP;
                }
            }
            if (this.m_akHeap[iCh].m_fMetric >= kRecord.m_fMetric) break;
            this.m_akHeap[iCh].m_iHIndex = iPa;
            this.m_akHeap[iPa] = this.m_akHeap[iCh];
            iPa = iCh;
            iCh = 2 * iCh + 1;
        }
        kRecord.m_iHIndex = iPa;
        this.m_akHeap[iPa] = kRecord;
        --this.m_iHQuantity;
        kRoot.m_iHIndex = -1;
    }

    private void reorder() {
        int i;
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_kNewVBuffer.SetVertex(i, this.m_kVBuffer.GetVertex(this.m_aiVOrdered[i]));
        }
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_kVBuffer.SetVertex(i, this.m_kNewVBuffer.GetVertex(i));
        }
        for (i = 0; i < 3 * this.m_iTQuantity; ++i) {
            this.m_aiConnect[i] = this.m_aiVPermute[this.m_aiNewConnect[i]];
        }
        for (i = 0; i < this.m_kEDelete.size(); ++i) {
            CollapseRecord kCR = this.m_kEDelete.get(i);
            kCR.VKeep = this.m_aiVPermute[kCR.VKeep];
            kCR.VThrow = this.m_aiVPermute[kCR.VThrow];
        }
    }

    private void sort() {
        int iLast = this.m_iHQuantity - 1;
        for (int iLeft = iLast / 2; iLeft >= 0; --iLeft) {
            HeapRecord kRecord = this.m_akHeap[iLeft];
            int iPa = iLeft;
            int iCh = 2 * iLeft + 1;
            while (iCh <= iLast) {
                if (iCh < iLast) {
                    int iChP = iCh + 1;
                    if (this.m_akHeap[iCh].m_fMetric > this.m_akHeap[iChP].m_fMetric) {
                        iCh = iChP;
                    }
                }
                if (this.m_akHeap[iCh].m_fMetric >= kRecord.m_fMetric) break;
                this.m_akHeap[iCh].m_iHIndex = iPa;
                this.m_akHeap[iPa] = this.m_akHeap[iCh];
                iPa = iCh;
                iCh = 2 * iCh + 1;
            }
            kRecord.m_iHIndex = iPa;
            this.m_akHeap[iPa] = kRecord;
        }
    }

    private void update(int iHIndex, float fMetric) {
        block6: {
            HeapRecord kRecord;
            block7: {
                kRecord = this.m_akHeap[iHIndex];
                if (!(fMetric > kRecord.m_fMetric)) break block7;
                kRecord.m_fMetric = fMetric;
                int iPa = iHIndex;
                int iCh = 2 * iPa + 1;
                while (iCh < this.m_iHQuantity) {
                    int iMaxCh;
                    if (iCh < this.m_iHQuantity - 1) {
                        int iChP = iCh + 1;
                        iMaxCh = this.m_akHeap[iCh].m_fMetric <= this.m_akHeap[iChP].m_fMetric ? iCh : iChP;
                    } else {
                        iMaxCh = iCh;
                    }
                    if (!(this.m_akHeap[iMaxCh].m_fMetric >= fMetric)) {
                        this.m_akHeap[iMaxCh].m_iHIndex = iPa;
                        this.m_akHeap[iPa] = this.m_akHeap[iMaxCh];
                        kRecord.m_iHIndex = iMaxCh;
                        this.m_akHeap[iMaxCh] = kRecord;
                        iPa = iMaxCh;
                        iCh = 2 * iPa + 1;
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            if (!(fMetric < kRecord.m_fMetric)) break block6;
            kRecord.m_fMetric = fMetric;
            int iCh = iHIndex;
            while (iCh > 0) {
                int iPa = (iCh - 1) / 2;
                if (!(this.m_akHeap[iPa].m_fMetric <= fMetric)) {
                    this.m_akHeap[iPa].m_iHIndex = iCh;
                    this.m_akHeap[iCh] = this.m_akHeap[iPa];
                    kRecord.m_iHIndex = iPa;
                    kRecord.m_fMetric = fMetric;
                    this.m_akHeap[iPa] = kRecord;
                    iCh = iPa;
                    continue;
                }
                break;
            }
        }
    }

    private class HeapRecord {
        public float m_fMetric = -1.0f;
        public int m_iHIndex = -1;
        public Edge m_kEdge = new Edge(-1, -1);
    }

    protected class VertexAttribute {
        public Object m_kData = null;
        public ModelSet m_kESet = new ModelSet(8, 8);
        public ModelSet m_kTSet = new ModelSet(8, 8);

        public boolean isEmpty() {
            return this.m_kESet.isEmpty() && this.m_kTSet.isEmpty();
        }
    }

    protected class TriangleAttribute {
        public Object m_kData = null;
    }

    protected class EdgeAttribute {
        public Object m_kData = null;
        public ModelSet m_kTSet = new ModelSet(4, 4);

        public boolean isEmpty() {
            return this.m_kTSet.isEmpty();
        }
    }

    public class Vertex {
        public int m_iV;

        public Vertex(int iV) {
            this.m_iV = iV;
        }

        public boolean equals(Object kObject) {
            Vertex kV = (Vertex)kObject;
            return this.m_iV == kV.m_iV;
        }

        public int hashCode() {
            return this.m_iV;
        }
    }

    public class Triangle {
        public int m_iV0;
        public int m_iV1;
        public int m_iV2;

        public Triangle(int iV0, int iV1, int iV2) {
            if (iV0 < iV1) {
                if (iV0 < iV2) {
                    this.m_iV0 = iV0;
                    this.m_iV1 = iV1;
                    this.m_iV2 = iV2;
                } else {
                    this.m_iV0 = iV2;
                    this.m_iV1 = iV0;
                    this.m_iV2 = iV1;
                }
            } else if (iV1 < iV2) {
                this.m_iV0 = iV1;
                this.m_iV1 = iV2;
                this.m_iV2 = iV0;
            } else {
                this.m_iV0 = iV2;
                this.m_iV1 = iV0;
                this.m_iV2 = iV1;
            }
        }

        public boolean equals(Object kObject) {
            Triangle kT = (Triangle)kObject;
            return this.m_iV0 == kT.m_iV0 && this.m_iV1 == kT.m_iV1 && this.m_iV2 == kT.m_iV2;
        }

        public int hashCode() {
            int iCmp = this.m_iV1 < this.m_iV2 ? this.m_iV1 << 8 ^ (this.m_iV0 << 16 | this.m_iV2) : this.m_iV2 << 8 ^ (this.m_iV0 << 16 | this.m_iV1);
            return iCmp;
        }
    }
}

