/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Detail;

import java.io.Serializable;

public class ModelSet
implements Serializable {
    private static final long serialVersionUID = -1776199087556477381L;
    private Object[] m_atElement;
    private int m_iCapacity;
    private int m_iGrowBy;
    private int m_iSize;

    public ModelSet() {
        this.m_iCapacity = 1;
        this.m_iGrowBy = 1;
        this.m_iSize = 0;
        this.m_atElement = new Object[1];
    }

    public ModelSet(int iCapacity, int iGrowBy) {
        this.m_iCapacity = iCapacity;
        this.m_iGrowBy = iGrowBy;
        this.m_iSize = 0;
        this.m_atElement = new Object[iCapacity];
    }

    public ModelSet(ModelSet kSet) {
        this.m_iCapacity = kSet.m_iCapacity;
        this.m_iGrowBy = kSet.m_iGrowBy;
        this.m_iSize = kSet.m_iSize;
        this.m_atElement = new Object[this.m_iCapacity];
        System.arraycopy(kSet.m_atElement, 0, this.m_atElement, 0, this.m_iCapacity);
    }

    public boolean add(Object kElement) {
        for (int i = 0; i < this.m_iSize; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            return false;
        }
        if (this.m_iSize == this.m_iCapacity) {
            int iNewCapacity = this.m_iCapacity + this.m_iGrowBy;
            Object[] atNewElement = new Object[iNewCapacity];
            System.arraycopy(this.m_atElement, 0, atNewElement, 0, this.m_iCapacity);
            this.m_atElement = atNewElement;
            this.m_iCapacity = iNewCapacity;
        }
        this.m_atElement[this.m_iSize++] = kElement;
        return true;
    }

    public void clear(int iCapacity, int iGrowBy) {
        this.m_iCapacity = iCapacity;
        this.m_iGrowBy = iGrowBy;
        this.m_iSize = 0;
        this.m_atElement = new Object[iCapacity];
    }

    public boolean exists(Object kElement) {
        for (int i = 0; i < this.m_iSize; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            return true;
        }
        return false;
    }

    public Object get(int i) {
        if (0 <= i && i < this.m_iSize) {
            return this.m_atElement[i];
        }
        return null;
    }

    public void insertNoCheck(Object kElement) {
        if (this.m_iSize == this.m_iCapacity) {
            int iNewCapacity = this.m_iCapacity + this.m_iGrowBy;
            Object[] atNewElement = new Object[iNewCapacity];
            System.arraycopy(this.m_atElement, 0, atNewElement, 0, this.m_iCapacity);
            this.m_atElement = atNewElement;
            this.m_iCapacity = iNewCapacity;
        }
        this.m_atElement[this.m_iSize++] = kElement;
    }

    public boolean isEmpty() {
        return this.m_iSize == 0;
    }

    public boolean remove(Object kElement) {
        for (int i = 0; i < this.m_iSize; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            int j = i + 1;
            while (j < this.m_iSize) {
                this.m_atElement[i] = this.m_atElement[j];
                ++j;
                ++i;
            }
            --this.m_iSize;
            return true;
        }
        return false;
    }

    public int size() {
        return this.m_iSize;
    }
}

