/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class BlendedTerrainEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 8670299937255298577L;
    protected float[] m_afFlowDirection = new float[4];
    protected float[] m_afPowerFactor = new float[4];

    public BlendedTerrainEffect() {
    }

    public BlendedTerrainEffect(String acGrassName, String acStoneName, String acBlendName, String acCloudName) {
        super(1);
        this.m_kVShader.set(0, new VertexShader("BlendedTerrain"));
        this.m_kPShader.set(0, new PixelShader("BlendedTerrain"));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(4);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(0, acGrassName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(1, acStoneName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(2, acBlendName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(3, acCloudName);
        Texture pkGrass = ((PixelShader)this.m_kPShader.get(0)).GetTexture(0);
        pkGrass.SetFilterType(Texture.FilterType.LINEAR_LINEAR);
        pkGrass.SetWrapType(0, Texture.WrapType.REPEAT);
        pkGrass.SetWrapType(1, Texture.WrapType.REPEAT);
        Texture pkStone = ((PixelShader)this.m_kPShader.get(0)).GetTexture(1);
        pkStone.SetFilterType(Texture.FilterType.LINEAR_LINEAR);
        pkStone.SetWrapType(0, Texture.WrapType.REPEAT);
        pkStone.SetWrapType(1, Texture.WrapType.REPEAT);
        Texture pkBlend = ((PixelShader)this.m_kPShader.get(0)).GetTexture(2);
        pkBlend.SetFilterType(Texture.FilterType.LINEAR);
        pkBlend.SetWrapType(0, Texture.WrapType.CLAMP_EDGE);
        Texture pkCloud = ((PixelShader)this.m_kPShader.get(0)).GetTexture(3);
        pkCloud.SetFilterType(Texture.FilterType.LINEAR_LINEAR);
        pkCloud.SetWrapType(0, Texture.WrapType.REPEAT);
        pkCloud.SetWrapType(1, Texture.WrapType.REPEAT);
        this.m_afFlowDirection[0] = 0.0f;
        this.m_afFlowDirection[1] = 0.0f;
        this.m_afPowerFactor[0] = 0.5f;
    }

    @Override
    public void dispose() {
        this.m_afFlowDirection = null;
        this.m_afPowerFactor = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    public Vector2f GetFlowDirection() {
        return new Vector2f(this.m_afFlowDirection[0], this.m_afFlowDirection[1]);
    }

    public float GetPowerFactor() {
        return this.m_afPowerFactor[0];
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_afFlowDirection[0] = rkStream.ReadFloat();
        this.m_afFlowDirection[1] = rkStream.ReadFloat();
        this.m_afPowerFactor[0] = rkStream.ReadFloat();
    }

    @Override
    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
        pkVProgram.GetUC("FlowDirection").SetDataSource(this.m_afFlowDirection);
        pkPProgram.GetUC("PowerFactor").SetDataSource(this.m_afPowerFactor);
        pkCProgram.GetUC("FlowDirection").SetDataSource(this.m_afFlowDirection);
        pkCProgram.GetUC("PowerFactor").SetDataSource(this.m_afPowerFactor);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_afFlowDirection[0]);
        rkStream.Write(this.m_afFlowDirection[1]);
        rkStream.Write(this.m_afPowerFactor[0]);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("BlendedTerrainEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        Vector2f kFlowDirection = new Vector2f(this.m_afFlowDirection[0], this.m_afFlowDirection[1]);
        pkTree.Append(StringTree.Format("flow direction =", kFlowDirection));
        pkTree.Append(StringTree.Format("power factor =", this.m_afPowerFactor[0]));
        return pkTree;
    }

    public void SetFlowDirection(Vector2f rkFlowDirection) {
        this.m_afFlowDirection[0] = rkFlowDirection.X;
        this.m_afFlowDirection[1] = rkFlowDirection.Y;
    }

    public void SetPowerFactor(float fPowerFactor) {
        this.m_afPowerFactor[0] = fPowerFactor;
    }
}

