/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.ZBufferState;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class GoochEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 3830270768612244033L;
    ZBufferState m_spkSaveZState;
    ZBufferState m_spkZState;
    protected float[] m_afLightPosition = new float[4];

    public GoochEffect() {
        super(1);
        this.m_kVShader.set(0, new VertexShader("GoochV.glsl"));
        this.m_kPShader.set(0, new PixelShader("GoochP.glsl"));
        this.m_afLightPosition[0] = 0.0f;
        this.m_afLightPosition[1] = 10.0f;
        this.m_afLightPosition[2] = 4.0f;
        this.m_spkZState = new ZBufferState();
        this.m_spkSaveZState = null;
    }

    @Override
    public void dispose() {
        this.m_afLightPosition = null;
        this.m_spkZState = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_FLOAT * 3;
    }

    public Vector3f GetLightPosition() {
        return new Vector3f(this.m_afLightPosition[0], this.m_afLightPosition[1], this.m_afLightPosition[2]);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_afLightPosition[0] = rkStream.ReadFloat();
        this.m_afLightPosition[1] = rkStream.ReadFloat();
        this.m_afLightPosition[2] = rkStream.ReadFloat();
    }

    @Override
    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
    }

    @Override
    public void RestoreGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        pkRenderer.SetZBufferState(this.m_spkSaveZState);
        super.RestoreGlobalState(iPass, pkRenderer, bPrimaryEffect);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_afLightPosition[0]);
        rkStream.Write(this.m_afLightPosition[1]);
        rkStream.Write(this.m_afLightPosition[2]);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("GoochEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        Vector3f kLightPosition = new Vector3f(this.m_afLightPosition[0], this.m_afLightPosition[1], this.m_afLightPosition[2]);
        pkTree.Append(StringTree.Format("light position =", kLightPosition));
        return pkTree;
    }

    @Override
    public void SetGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        super.SetGlobalState(iPass, pkRenderer, bPrimaryEffect);
        this.m_spkSaveZState = pkRenderer.GetZBufferState();
        this.m_spkZState.Enabled = true;
        this.m_spkZState.Writable = true;
        this.m_spkZState.Compare = ZBufferState.CompareMode.CF_LESS;
        pkRenderer.SetZBufferState(this.m_spkZState);
    }

    public void SetLightPosition(Vector3f rkLightPosition) {
        this.m_afLightPosition[0] = rkLightPosition.X;
        this.m_afLightPosition[1] = rkLightPosition.Y;
        this.m_afLightPosition[2] = rkLightPosition.Z;
    }
}

