/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.Rendering.MaterialState;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;
import java.util.Vector;

public class LightingEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 5160353398988582167L;
    protected ColorRGB m_kSaveEmissive;
    protected Light m_kLight0Save;
    protected Vector<Light> m_kLights = new Vector();

    public LightingEffect() {
        super(1);
    }

    public void AttachLight(Light pkLight) {
        assert (pkLight != null);
        for (int i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) != pkLight) continue;
            return;
        }
        this.m_kLights.add(pkLight);
    }

    public void Configure() {
        int iType;
        int i;
        if (this.m_kLights.size() == 0) {
            this.SetPassQuantity(1);
            this.m_kVShader.set(0, new VertexShader("Material"));
            this.m_kPShader.set(0, new PixelShader("PassThrough4"));
            return;
        }
        Vector m_akBucket = new Vector();
        for (int i2 = 0; i2 < 4; ++i2) {
            m_akBucket.add(new Vector());
        }
        int iLQuantity = this.m_kLights.size();
        for (i = 0; i < iLQuantity; ++i) {
            iType = this.m_kLights.get((int)i).Type.Value();
            ((Vector)m_akBucket.get(iType)).add(this.m_kLights.get(i));
        }
        this.SetPassQuantity(iLQuantity);
        for (i = 1; i < iLQuantity; ++i) {
            AlphaState pkAS = (AlphaState)this.m_kAlphaState.get(i);
            pkAS.BlendEnabled = true;
            pkAS.SrcBlend = AlphaState.SrcBlendMode.SBF_ONE;
            pkAS.DstBlend = AlphaState.DstBlendMode.DBF_ONE;
        }
        char[] acType = new char[]{'a', 'd', 'p', 's'};
        String kShaderName = new String("L1");
        int iLight = 0;
        for (iType = 0; iType < 4; ++iType) {
            for (i = 0; i < ((Vector)m_akBucket.get(iType)).size(); ++i) {
                this.m_kVShader.set(iLight, new VertexShader(new String(kShaderName + acType[iType])));
                this.m_kPShader.set(iLight, new PixelShader("PassThrough4"));
                ++iLight;
            }
        }
    }

    public void DetachAllLights() {
        this.m_kLights.clear();
    }

    public void DetachLight(Light pkLight) {
        for (int i = 0; i < this.m_kLights.size(); ++i) {
            if (pkLight != this.m_kLights.get(i)) continue;
            this.m_kLights.remove(i);
            return;
        }
    }

    @Override
    public void dispose() {
        this.m_kSaveEmissive = null;
        this.m_kLights.clear();
        this.m_kLights = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion);
    }

    public Light GetLight(int i) {
        assert (0 <= i && i < this.m_kLights.size());
        return this.m_kLights.get(i);
    }

    public int GetLightQuantity() {
        return this.m_kLights.size();
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void RestoreGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        super.RestoreGlobalState(iPass, pkRenderer, bPrimaryEffect);
        pkRenderer.SetLight(0, this.m_kLight0Save);
        if (iPass == this.m_iPassQuantity - 1) {
            MaterialState pkMS = pkRenderer.GetMaterialState();
            pkMS.Emissive = this.m_kSaveEmissive;
        }
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("LightingEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        return pkTree;
    }

    @Override
    public void SetGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        super.SetGlobalState(iPass, pkRenderer, bPrimaryEffect);
        MaterialState pkMS = pkRenderer.GetMaterialState();
        if (iPass == 0) {
            this.m_kSaveEmissive = pkMS.Emissive;
        } else {
            pkMS.Emissive = ColorRGB.BLACK;
        }
        this.m_kLight0Save = pkRenderer.GetLight(0);
        pkRenderer.SetLight(0, this.m_kLights.get(iPass));
    }
}

