/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class MultitextureEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -1447729485349922635L;
    protected int m_iTextureQuantity;
    protected String[] m_akImageName;

    public MultitextureEffect() {
        this.m_iTextureQuantity = 0;
        this.m_akImageName = null;
    }

    public MultitextureEffect(int iTextureQuantity) {
        super(1);
        this.m_akImageName = null;
        this.SetTextureQuantity(iTextureQuantity);
    }

    public void Configure() {
        int i;
        if (this.m_iTextureQuantity == 1) {
            this.m_kVShader.set(0, new VertexShader("Texture"));
            this.m_kPShader.set(0, new PixelShader("Texture"));
            ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(1);
            ((PixelShader)this.m_kPShader.get(0)).SetImageName(0, this.m_akImageName[0]);
            return;
        }
        String kVShaderName = new String("T0d2");
        String kPShaderName = new String("T0s1d0");
        for (i = 1; i < this.m_iTextureQuantity; ++i) {
            kVShaderName = kVShaderName.concat("T" + i + "d2");
            kPShaderName = kPShaderName.concat("T" + i);
            AlphaState pkAS = (AlphaState)this.m_kAlphaState.get(i);
            kPShaderName = kPShaderName.concat("s" + pkAS.SrcBlend.Value());
            kPShaderName = kPShaderName.concat("d" + pkAS.DstBlend.Value());
        }
        kVShaderName = kVShaderName.concat("PassThrough");
        this.m_kVShader.set(0, new VertexShader(kVShaderName));
        this.m_kPShader.set(0, new PixelShader(kPShaderName));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(this.m_iTextureQuantity);
        for (i = 0; i < this.m_iTextureQuantity; ++i) {
            ((PixelShader)this.m_kPShader.get(0)).SetImageName(i, this.m_akImageName[i]);
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_iTextureQuantity; ++i) {
            this.m_akImageName[i] = null;
        }
        this.m_akImageName = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
        for (int i = 0; i < this.m_iTextureQuantity; ++i) {
            iSize += Stream.SIZEOF_INT + this.m_akImageName[i].length();
        }
        return iSize;
    }

    public String GetImageName(int i) {
        assert (0 <= i && i < this.m_iTextureQuantity);
        return this.m_akImageName[i];
    }

    public int GetTextureQuantity() {
        return this.m_iTextureQuantity;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iTextureQuantity = rkStream.ReadInt();
        this.SetTextureQuantity(this.m_iTextureQuantity);
        for (int i = 0; i < this.m_iTextureQuantity; ++i) {
            this.m_akImageName[i] = rkStream.ReadString();
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iTextureQuantity);
        for (int i = 0; i < this.m_iTextureQuantity; ++i) {
            rkStream.Write(this.m_akImageName[i]);
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("MultitextureEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("texture quantity =", this.m_iTextureQuantity));
        for (int i = 0; i < this.m_iTextureQuantity; ++i) {
            String kPrefix = new String("image[" + i + "] =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_akImageName[i]));
        }
        return pkTree;
    }

    public void SetImageName(int i, String rkImageName) {
        assert (0 <= i && i < this.m_iTextureQuantity);
        this.m_akImageName[i] = new String(rkImageName);
    }

    public void SetTextureQuantity(int iTextureQuantity) {
        assert (iTextureQuantity >= 1);
        this.m_iTextureQuantity = iTextureQuantity;
        this.m_akImageName = null;
        this.m_akImageName = new String[this.m_iTextureQuantity];
        this.m_kAlphaState.setSize(this.m_iTextureQuantity);
        this.SetDefaultAlphaState();
    }
}

