/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Matrix4f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.StencilState;
import WildMagic.LibGraphics.Rendering.ZBufferState;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VisibleObject;
import java.io.Serializable;
import java.util.Vector;

public class PlanarReflectionEffect
extends Effect
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = 8255056726350106524L;
    protected int m_iQuantity;
    protected TriMesh[] m_aspkPlane;
    protected float[] m_afReflectance;
    protected AlphaState m_spkAState;
    protected StencilState m_spkSState;
    protected ZBufferState m_spkZState;

    public PlanarReflectionEffect() {
        this.m_iQuantity = 0;
        this.m_aspkPlane = null;
        this.m_afReflectance = null;
    }

    public PlanarReflectionEffect(int iQuantity) {
        assert (iQuantity > 0);
        this.m_iQuantity = iQuantity;
        this.m_aspkPlane = new TriMesh[this.m_iQuantity];
        this.m_afReflectance = new float[this.m_iQuantity];
        this.m_spkAState = new AlphaState();
        this.m_spkSState = new StencilState();
        this.m_spkZState = new ZBufferState();
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            this.m_aspkPlane[i].dispose();
            this.m_aspkPlane[i] = null;
        }
        this.m_aspkPlane = null;
        if (this.m_spkAState != null) {
            this.m_spkAState.dispose();
            this.m_spkAState = null;
        }
        if (this.m_spkSState != null) {
            this.m_spkSState.dispose();
            this.m_spkSState = null;
        }
        if (this.m_spkZState != null) {
            this.m_spkZState.dispose();
            this.m_spkZState = null;
        }
        this.m_afReflectance = null;
        super.dispose();
    }

    @Override
    public void Draw(Renderer pkRenderer, Spatial pkGlobalObject, int iMin, int iMax, VisibleObject[] akVisible) {
        int j;
        StencilState spkSaveSState = pkRenderer.GetStencilState();
        ZBufferState spkSaveZState = pkRenderer.GetZBufferState();
        this.m_spkZState.Enabled = true;
        this.m_spkZState.Writable = true;
        this.m_spkZState.Compare = ZBufferState.CompareMode.CF_LEQUAL;
        pkRenderer.SetZBufferState(this.m_spkZState);
        this.m_spkSState.Enabled = true;
        pkRenderer.SetStencilState(this.m_spkSState);
        int iQuantity = this.m_iQuantity;
        if (iQuantity >= pkRenderer.GetMaxStencilIndices()) {
            iQuantity = pkRenderer.GetMaxStencilIndices() - 1;
        }
        Camera pkCamera = pkRenderer.GetCamera();
        float fPortN = pkCamera.GetPortN();
        float fPortF = pkCamera.GetPortF();
        for (int i = 0; i < iQuantity; ++i) {
            this.m_spkSState.Compare = StencilState.CompareFunction.CF_ALWAYS;
            this.m_spkSState.Reference = i + 1;
            this.m_spkSState.OnFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZPass = StencilState.OperationType.OT_REPLACE;
            pkRenderer.SetStencilState(this.m_spkSState);
            this.m_spkZState.Enabled = false;
            pkRenderer.SetZBufferState(this.m_spkZState);
            pkRenderer.SetColorMask(false, false, false, false);
            pkRenderer.Draw(this.m_aspkPlane[i]);
            pkRenderer.SetColorMask(true, true, true, true);
            pkCamera.SetDepthRange(1.0f, 1.0f);
            this.m_spkZState.Enabled = true;
            this.m_spkZState.Compare = ZBufferState.CompareMode.CF_ALWAYS;
            pkRenderer.SetZBufferState(this.m_spkZState);
            this.m_spkSState.Compare = StencilState.CompareFunction.CF_EQUAL;
            this.m_spkSState.Reference = i + 1;
            this.m_spkSState.OnFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZPass = StencilState.OperationType.OT_KEEP;
            pkRenderer.SetStencilState(this.m_spkSState);
            pkRenderer.Draw(this.m_aspkPlane[i]);
            this.m_spkZState.Compare = ZBufferState.CompareMode.CF_LEQUAL;
            pkRenderer.SetZBufferState(this.m_spkZState);
            pkCamera.SetDepthRange(fPortN, fPortF);
            Matrix4f kReflection = new Matrix4f();
            Plane3f kPlane = new Plane3f();
            this.GetReflectionMatrixAndPlane(i, kReflection, kPlane);
            pkRenderer.EnableUserClipPlane(0, kPlane);
            pkRenderer.SetPostWorldTransformation(kReflection);
            pkRenderer.SetReverseCullFace(true);
            pkRenderer.SetCullState(pkRenderer.GetCullState());
            for (j = iMin; j <= iMax; ++j) {
                if (!akVisible[j].IsDrawable()) continue;
                pkRenderer.Draw((Geometry)akVisible[j].Object);
            }
            pkRenderer.SetReverseCullFace(false);
            pkRenderer.SetCullState(pkRenderer.GetCullState());
            pkRenderer.RestorePostWorldTransformation();
            pkRenderer.DisableUserClipPlane(0);
            this.m_spkAState.BlendEnabled = true;
            this.m_spkAState.SrcBlend = AlphaState.SrcBlendMode.SBF_ONE_MINUS_CONSTANT_ALPHA;
            this.m_spkAState.DstBlend = AlphaState.DstBlendMode.DBF_CONSTANT_ALPHA;
            this.m_spkAState.ConstantColor = new ColorRGBA(0.0f, 0.0f, 0.0f, this.m_afReflectance[i]);
            pkRenderer.SetAlphaState(this.m_spkAState);
            this.m_spkSState.Compare = StencilState.CompareFunction.CF_EQUAL;
            this.m_spkSState.Reference = i + 1;
            this.m_spkSState.OnFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZPass = StencilState.OperationType.OT_INVERT;
            pkRenderer.SetStencilState(this.m_spkSState);
            pkRenderer.Draw(this.m_aspkPlane[i]);
            this.m_spkAState.BlendEnabled = false;
            pkRenderer.SetAlphaState(this.m_spkAState);
        }
        this.m_spkZState.Enabled = false;
        this.m_spkSState.Enabled = false;
        pkRenderer.SetStencilState(spkSaveSState);
        pkRenderer.SetZBufferState(spkSaveZState);
        for (j = iMin; j <= iMax; ++j) {
            if (!akVisible[j].IsDrawable()) continue;
            pkRenderer.Draw((Geometry)akVisible[j].Object);
        }
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.m_aspkPlane != null) {
            for (int i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                this.m_aspkPlane[i].GetAllObjectsByName(rkName, rkObjects);
            }
        }
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
        if (this.m_iQuantity > 0) {
            iSize += this.m_iQuantity * Stream.SIZEOF_FLOAT;
            iSize += this.m_iQuantity * Stream.SIZEOF_INT;
        }
        return iSize;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_aspkPlane != null) {
            for (int i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null || (pkFound = this.m_aspkPlane[i].GetObjectByID(uiID)) == null) continue;
                return pkFound;
            }
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_aspkPlane != null) {
            for (int i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null || (pkFound = this.m_aspkPlane[i].GetObjectByName(rkName)) == null) continue;
                return pkFound;
            }
        }
        return null;
    }

    public TriMesh GetPlane(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_aspkPlane[i];
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public float GetReflectance(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_afReflectance[i];
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        for (int i = 0; i < this.m_iQuantity; ++i) {
            int pkLinkID = pkLink.GetLinkID();
            this.m_aspkPlane[i] = (TriMesh)rkStream.GetFromMap(pkLinkID);
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iQuantity = rkStream.ReadInt();
        if (this.m_iQuantity > 0) {
            this.m_aspkPlane = new TriMesh[this.m_iQuantity];
            this.m_afReflectance = new float[this.m_iQuantity];
            rkStream.Read(this.m_iQuantity, this.m_afReflectance);
            for (int i = 0; i < this.m_iQuantity; ++i) {
                int iLinkID = rkStream.ReadInt();
                pkLink.Add(iLinkID);
            }
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.m_aspkPlane != null) {
            for (int i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                this.m_aspkPlane[i].Register(rkStream);
            }
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iQuantity);
        if (this.m_iQuantity > 0) {
            rkStream.Write(this.m_iQuantity, this.m_afReflectance);
            for (int i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                rkStream.Write(this.m_aspkPlane[i].GetID());
            }
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        int i;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("PlanarReflectionEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("plane quantity =", this.m_iQuantity));
        for (i = 0; i < this.m_iQuantity; ++i) {
            String kPrefix = new String("reflectance[" + i + "] =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_afReflectance[i]));
        }
        for (i = 0; i < this.m_iQuantity; ++i) {
            pkTree.Append(this.m_aspkPlane[i].SaveStrings(null));
        }
        return pkTree;
    }

    public void SetPlane(int i, TriMesh spkPlane) {
        assert (0 <= i && i < this.m_iQuantity);
        this.m_aspkPlane[i] = spkPlane;
        this.m_aspkPlane[i].Culling = Spatial.CullingMode.CULL_ALWAYS;
    }

    public void SetReflectance(int i, float fReflectance) {
        assert (0 <= i && i < this.m_iQuantity);
        this.m_afReflectance[i] = fReflectance;
    }

    protected void GetReflectionMatrixAndPlane(int i, Matrix4f rkReflection, Plane3f rkPlane) {
        Triangle3f kTri = new Triangle3f();
        this.m_aspkPlane[i].GetWorldTriangle(0, kTri);
        rkPlane = new Plane3f(kTri.V[0], kTri.V[1], kTri.V[2]);
        rkReflection.MakeReflection(rkPlane.Normal, kTri.V[0]);
        this.m_aspkPlane[i].GetModelTriangle(0, kTri);
        rkPlane = new Plane3f(kTri.V[0], kTri.V[1], kTri.V[2]);
    }
}

