/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Matrix4f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.Effects.MaterialEffect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Rendering.GlobalState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.Rendering.MaterialState;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.StencilState;
import WildMagic.LibGraphics.Rendering.ZBufferState;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VisibleObject;
import java.io.Serializable;
import java.util.Vector;

public class PlanarShadowEffect
extends Effect
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = 3267627463796955518L;
    protected int m_iQuantity;
    protected TriMesh[] m_aspkPlane;
    protected Light[] m_aspkProjector;
    protected ColorRGBA[] m_akShadowColor;
    protected AlphaState m_spkAState;
    protected MaterialState m_spkMState;
    protected StencilState m_spkSState;
    protected ZBufferState m_spkZState;
    protected MaterialEffect m_spkMEffect;

    public PlanarShadowEffect() {
        this.m_iQuantity = 0;
        this.m_aspkPlane = null;
        this.m_aspkProjector = null;
        this.m_akShadowColor = null;
    }

    public PlanarShadowEffect(int iQuantity) {
        assert (iQuantity > 0);
        this.m_iQuantity = iQuantity;
        this.m_aspkPlane = new TriMesh[this.m_iQuantity];
        this.m_aspkProjector = new Light[this.m_iQuantity];
        this.m_akShadowColor = new ColorRGBA[this.m_iQuantity];
        this.m_spkAState = new AlphaState();
        this.m_spkMState = new MaterialState();
        this.m_spkSState = new StencilState();
        this.m_spkZState = new ZBufferState();
        this.m_spkMEffect = new MaterialEffect();
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            this.m_aspkPlane[i].dispose();
            this.m_aspkPlane[i] = null;
            this.m_aspkProjector[i].dispose();
            this.m_aspkProjector[i] = null;
            this.m_akShadowColor[i] = null;
        }
        this.m_aspkPlane = null;
        this.m_akShadowColor = null;
        if (this.m_spkAState != null) {
            this.m_spkAState.dispose();
            this.m_spkAState = null;
        }
        if (this.m_spkSState != null) {
            this.m_spkSState.dispose();
            this.m_spkSState = null;
        }
        if (this.m_spkZState != null) {
            this.m_spkZState.dispose();
            this.m_spkZState = null;
        }
        if (this.m_spkMState != null) {
            this.m_spkMState.dispose();
            this.m_spkMState = null;
        }
        if (this.m_spkMEffect != null) {
            this.m_spkMEffect.dispose();
            this.m_spkMEffect = null;
        }
        super.dispose();
    }

    @Override
    public void Draw(Renderer pkRenderer, Spatial pkGlobalObject, int iMin, int iMax, VisibleObject[] akVisible) {
        int j;
        for (j = iMin; j <= iMax; ++j) {
            if (!akVisible[j].IsDrawable()) continue;
            pkRenderer.Draw((Geometry)akVisible[j].Object);
        }
        int iQuantity = this.m_iQuantity;
        if (iQuantity >= pkRenderer.GetMaxStencilIndices()) {
            iQuantity = pkRenderer.GetMaxStencilIndices() - 1;
        }
        AlphaState spkSaveAState = pkRenderer.GetAlphaState();
        MaterialState spkSaveMState = pkRenderer.GetMaterialState();
        StencilState spkSaveSState = pkRenderer.GetStencilState();
        ZBufferState spkSaveZState = pkRenderer.GetZBufferState();
        for (int i = 0; i < iQuantity; ++i) {
            this.m_spkZState.Enabled = true;
            pkRenderer.SetZBufferState(this.m_spkZState);
            this.m_spkSState.Enabled = true;
            this.m_spkSState.Compare = StencilState.CompareFunction.CF_ALWAYS;
            this.m_spkSState.Reference = i + 1;
            this.m_spkSState.OnFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZPass = StencilState.OperationType.OT_REPLACE;
            pkRenderer.SetStencilState(this.m_spkSState);
            pkRenderer.Draw(this.m_aspkPlane[i]);
            Matrix4f kProjection = new Matrix4f();
            if (!this.GetProjectionMatrix(i, pkGlobalObject.WorldBound, kProjection)) continue;
            pkRenderer.SetPostWorldTransformation(kProjection);
            this.m_spkAState.BlendEnabled = true;
            this.m_spkAState.SrcBlend = AlphaState.SrcBlendMode.SBF_SRC_ALPHA;
            this.m_spkAState.DstBlend = AlphaState.DstBlendMode.DBF_ONE_MINUS_SRC_ALPHA;
            pkRenderer.SetAlphaState(this.m_spkAState);
            this.m_spkMState.Diffuse.R = this.m_akShadowColor[i].R;
            this.m_spkMState.Diffuse.G = this.m_akShadowColor[i].G;
            this.m_spkMState.Diffuse.B = this.m_akShadowColor[i].B;
            this.m_spkMState.Alpha = this.m_akShadowColor[i].A;
            pkRenderer.SetMaterialState(this.m_spkMState);
            this.m_spkZState.Enabled = false;
            pkRenderer.SetZBufferState(this.m_spkZState);
            this.m_spkSState.Enabled = true;
            this.m_spkSState.Compare = StencilState.CompareFunction.CF_EQUAL;
            this.m_spkSState.Reference = i + 1;
            this.m_spkSState.OnFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZFail = StencilState.OperationType.OT_KEEP;
            this.m_spkSState.OnZPass = StencilState.OperationType.OT_ZERO;
            pkRenderer.SetStencilState(this.m_spkSState);
            for (j = iMin; j <= iMax; ++j) {
                if (!akVisible[j].IsDrawable()) continue;
                Geometry pkGeom = (Geometry)akVisible[j].Object;
                GlobalState spkSaveMaterialState = pkGeom.States[GlobalState.StateType.MATERIAL.Value()];
                pkGeom.States[GlobalState.StateType.MATERIAL.Value()] = null;
                pkGeom.AttachEffect(this.m_spkMEffect);
                pkGeom.SetStartEffect(pkGeom.GetEffectQuantity() - 1);
                pkRenderer.Draw((Geometry)akVisible[j].Object);
                pkGeom.SetStartEffect(0);
                pkGeom.DetachEffect(this.m_spkMEffect);
                pkGeom.States[GlobalState.StateType.MATERIAL.Value()] = spkSaveMaterialState;
            }
            this.m_spkSState.Enabled = false;
            pkRenderer.SetStencilState(this.m_spkSState);
            this.m_spkAState.BlendEnabled = false;
            pkRenderer.SetAlphaState(this.m_spkAState);
            pkRenderer.RestorePostWorldTransformation();
        }
        pkRenderer.SetAlphaState(spkSaveAState);
        pkRenderer.SetMaterialState(spkSaveMState);
        pkRenderer.SetStencilState(spkSaveSState);
        pkRenderer.SetZBufferState(spkSaveZState);
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        int i;
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.m_aspkPlane != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                this.m_aspkPlane[i].GetAllObjectsByName(rkName, rkObjects);
            }
        }
        if (this.m_aspkProjector != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkProjector[i] == null) continue;
                this.m_aspkProjector[i].GetAllObjectsByName(rkName, rkObjects);
            }
        }
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
        if (this.m_iQuantity > 0) {
            iSize += this.m_iQuantity * 4 * Stream.SIZEOF_FLOAT;
            iSize += this.m_iQuantity * Stream.SIZEOF_INT;
            iSize += this.m_iQuantity * Stream.SIZEOF_INT;
        }
        return iSize;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        int i;
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_aspkPlane != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null || (pkFound = this.m_aspkPlane[i].GetObjectByID(uiID)) == null) continue;
                return pkFound;
            }
        }
        if (this.m_aspkProjector != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkProjector[i] == null || (pkFound = this.m_aspkProjector[i].GetObjectByID(uiID)) == null) continue;
                return pkFound;
            }
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        int i;
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_aspkPlane != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null || (pkFound = this.m_aspkPlane[i].GetObjectByName(rkName)) == null) continue;
                return pkFound;
            }
        }
        if (this.m_aspkProjector != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkProjector[i] == null || (pkFound = this.m_aspkProjector[i].GetObjectByName(rkName)) == null) continue;
                return pkFound;
            }
        }
        return null;
    }

    public TriMesh GetPlane(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_aspkPlane[i];
    }

    public Light GetProjector(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_aspkProjector[i];
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public ColorRGBA GetShadowColor(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akShadowColor[i];
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        int iLinkID;
        int i;
        super.Link(rkStream, pkLink);
        for (i = 0; i < this.m_iQuantity; ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_aspkPlane[i] = (TriMesh)rkStream.GetFromMap(iLinkID);
        }
        for (i = 0; i < this.m_iQuantity; ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_aspkProjector[i] = (Light)rkStream.GetFromMap(iLinkID);
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iQuantity = rkStream.ReadInt();
        if (this.m_iQuantity > 0) {
            int iLinkID;
            int i;
            this.m_aspkPlane = new TriMesh[this.m_iQuantity];
            this.m_aspkProjector = new Light[this.m_iQuantity];
            this.m_akShadowColor = new ColorRGBA[this.m_iQuantity];
            rkStream.Read(this.m_iQuantity, this.m_akShadowColor);
            for (i = 0; i < this.m_iQuantity; ++i) {
                iLinkID = rkStream.ReadInt();
                pkLink.Add(iLinkID);
            }
            for (i = 0; i < this.m_iQuantity; ++i) {
                iLinkID = rkStream.ReadInt();
                pkLink.Add(iLinkID);
            }
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        int i;
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.m_aspkPlane != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                this.m_aspkPlane[i].Register(rkStream);
            }
        }
        if (this.m_aspkProjector != null) {
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkProjector[i] == null) continue;
                this.m_aspkProjector[i].Register(rkStream);
            }
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iQuantity);
        if (this.m_iQuantity > 0) {
            int i;
            rkStream.Write(this.m_iQuantity, this.m_akShadowColor);
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkPlane[i] == null) continue;
                rkStream.Write(this.m_aspkPlane[i].GetID());
            }
            for (i = 0; i < this.m_iQuantity; ++i) {
                if (this.m_aspkProjector[i] == null) continue;
                rkStream.Write(this.m_aspkProjector[i].GetID());
            }
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        int i;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("PlanarShadowEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("plane quantity =", this.m_iQuantity));
        for (i = 0; i < this.m_iQuantity; ++i) {
            String kPrefix = new String("shadow color[" + i + "] =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_akShadowColor[i]));
        }
        for (i = 0; i < this.m_iQuantity; ++i) {
            pkTree.Append(this.m_aspkPlane[i].SaveStrings(null));
            pkTree.Append(this.m_aspkProjector[i].SaveStrings(null));
        }
        return pkTree;
    }

    public void SetPlane(int i, TriMesh spkPlane) {
        assert (0 <= i && i < this.m_iQuantity);
        this.m_aspkPlane[i] = spkPlane;
        this.m_aspkPlane[i].Culling = Spatial.CullingMode.CULL_ALWAYS;
    }

    public void SetProjector(int i, Light spkProjector) {
        assert (0 <= i && i < this.m_iQuantity);
        this.m_aspkProjector[i] = spkProjector;
    }

    public void SetShadowColor(int i, ColorRGBA rkShadowColor) {
        assert (0 <= i && i < this.m_iQuantity);
        this.m_akShadowColor[i] = rkShadowColor;
    }

    protected boolean GetProjectionMatrix(int i, BoundingVolume pkGlobalObjectWorldBound, Matrix4f rkProjection) {
        Triangle3f kTri = new Triangle3f();
        this.m_aspkPlane[i].GetWorldTriangle(0, kTri);
        Plane3f kPlane = new Plane3f(kTri.V[0], kTri.V[1], kTri.V[2]);
        if (pkGlobalObjectWorldBound.WhichSide(kPlane) < 0) {
            return false;
        }
        Light pkProjector = this.m_aspkProjector[i];
        if (pkProjector.Type == Light.LightType.LT_DIRECTIONAL) {
            float fNdD = kPlane.Normal.Dot(pkProjector.DVector);
            if (fNdD >= 0.0f) {
                return false;
            }
            rkProjection.MakeObliqueProjection(kPlane.Normal, kTri.V[0], pkProjector.DVector);
        } else if (pkProjector.Type == Light.LightType.LT_POINT || pkProjector.Type == Light.LightType.LT_SPOT) {
            float fNdE = kPlane.Normal.Dot(pkProjector.Position);
            if (fNdE <= 0.0f) {
                return false;
            }
            rkProjection.MakePerspectiveProjection(kPlane.Normal, kTri.V[0], pkProjector.Position);
        } else {
            assert (false);
            return false;
        }
        return true;
    }
}

