/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class RipplingOceanEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -1128562055208924005L;
    protected float[] m_afLightDir = new float[4];
    protected float[] m_afWaveDirX = new float[4];
    protected float[] m_afWaveDirY = new float[4];
    protected float[] m_afWaveSpeed = new float[4];
    protected float[] m_afWaveOffset = new float[4];
    protected float[] m_afWaveHeight = new float[4];
    protected float[] m_afBumpSpeed = new float[4];
    protected float[] m_afConstants = new float[4];

    public RipplingOceanEffect() {
    }

    public RipplingOceanEffect(String acBumpName, String acWaterName, String acEnvName) {
        super(1);
        this.m_kVShader.set(0, new VertexShader("RipplingOceanV"));
        this.m_kPShader.set(0, new PixelShader("RipplingOceanP"));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(3);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(0, acBumpName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(1, acWaterName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(2, acEnvName);
        Texture pkBump = ((PixelShader)this.m_kPShader.get(0)).GetTexture(0);
        pkBump.SetFilterType(Texture.FilterType.LINEAR);
        pkBump.SetWrapType(0, Texture.WrapType.REPEAT);
        pkBump.SetWrapType(1, Texture.WrapType.REPEAT);
        Texture pkWater = ((PixelShader)this.m_kPShader.get(0)).GetTexture(1);
        pkWater.SetFilterType(Texture.FilterType.LINEAR);
        pkWater.SetWrapType(0, Texture.WrapType.CLAMP);
        pkWater.SetWrapType(1, Texture.WrapType.CLAMP);
        Texture pkEnv = ((PixelShader)this.m_kPShader.get(0)).GetTexture(2);
        pkEnv.SetFilterType(Texture.FilterType.LINEAR);
    }

    @Override
    public void dispose() {
        this.m_afLightDir = null;
        this.m_afWaveDirX = null;
        this.m_afWaveDirY = null;
        this.m_afWaveSpeed = null;
        this.m_afWaveOffset = null;
        this.m_afWaveHeight = null;
        this.m_afBumpSpeed = null;
        this.m_afConstants = null;
        super.dispose();
    }

    public float GetAmbient() {
        return this.m_afConstants[1];
    }

    public float GetAverageDuDxDvDy() {
        return this.m_afConstants[0];
    }

    public void GetBumpSpeed(float[] afValue) {
        afValue[0] = this.m_afBumpSpeed[0];
        afValue[1] = this.m_afBumpSpeed[1];
        afValue[2] = this.m_afBumpSpeed[2];
        afValue[3] = this.m_afBumpSpeed[3];
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT + 4 * Stream.SIZEOF_FLOAT;
    }

    public Vector3f GetLightDir() {
        return new Vector3f(this.m_afLightDir[0], this.m_afLightDir[1], this.m_afLightDir[2]);
    }

    public float GetTextureRepeat() {
        return this.m_afConstants[2];
    }

    public float GetTime() {
        return this.m_afConstants[3];
    }

    public void GetWaveDirX(float[] afValue) {
        afValue[0] = this.m_afWaveDirX[0];
        afValue[1] = this.m_afWaveDirX[1];
        afValue[2] = this.m_afWaveDirX[2];
        afValue[3] = this.m_afWaveDirX[3];
    }

    public void GetWaveDirY(float[] afValue) {
        afValue[0] = this.m_afWaveDirY[0];
        afValue[1] = this.m_afWaveDirY[1];
        afValue[2] = this.m_afWaveDirY[2];
        afValue[3] = this.m_afWaveDirY[3];
    }

    public void GetWaveHeight(float[] afValue) {
        afValue[0] = this.m_afWaveHeight[0];
        afValue[1] = this.m_afWaveHeight[1];
        afValue[2] = this.m_afWaveHeight[2];
        afValue[3] = this.m_afWaveHeight[3];
    }

    public void GetWaveOffset(float[] afValue) {
        afValue[0] = this.m_afWaveOffset[0];
        afValue[1] = this.m_afWaveOffset[1];
        afValue[2] = this.m_afWaveOffset[2];
        afValue[3] = this.m_afWaveOffset[3];
    }

    public void GetWaveSpeed(float[] afValue) {
        afValue[0] = this.m_afWaveSpeed[0];
        afValue[1] = this.m_afWaveSpeed[1];
        afValue[2] = this.m_afWaveSpeed[2];
        afValue[3] = this.m_afWaveSpeed[3];
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(3, this.m_afLightDir);
        rkStream.Read(4, this.m_afWaveDirX);
        rkStream.Read(4, this.m_afWaveDirY);
        rkStream.Read(4, this.m_afWaveSpeed);
        rkStream.Read(4, this.m_afWaveOffset);
        rkStream.Read(4, this.m_afWaveHeight);
        rkStream.Read(4, this.m_afBumpSpeed);
        rkStream.Read(4, this.m_afConstants);
    }

    @Override
    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
        pkVProgram.GetUC("LightDir").SetDataSource(this.m_afLightDir);
        pkVProgram.GetUC("WaveDirX").SetDataSource(this.m_afWaveDirX);
        pkVProgram.GetUC("WaveDirY").SetDataSource(this.m_afWaveDirY);
        pkVProgram.GetUC("WaveSpeed").SetDataSource(this.m_afWaveSpeed);
        pkVProgram.GetUC("WaveOffset").SetDataSource(this.m_afWaveOffset);
        pkVProgram.GetUC("WaveHeight").SetDataSource(this.m_afWaveHeight);
        pkVProgram.GetUC("BumpSpeed").SetDataSource(this.m_afBumpSpeed);
        pkVProgram.GetUC("Constants").SetDataSource(this.m_afConstants);
        pkCProgram.GetUC("LightDir").SetDataSource(this.m_afLightDir);
        pkCProgram.GetUC("WaveDirX").SetDataSource(this.m_afWaveDirX);
        pkCProgram.GetUC("WaveDirY").SetDataSource(this.m_afWaveDirY);
        pkCProgram.GetUC("WaveSpeed").SetDataSource(this.m_afWaveSpeed);
        pkCProgram.GetUC("WaveOffset").SetDataSource(this.m_afWaveOffset);
        pkCProgram.GetUC("WaveHeight").SetDataSource(this.m_afWaveHeight);
        pkCProgram.GetUC("BumpSpeed").SetDataSource(this.m_afBumpSpeed);
        pkCProgram.GetUC("Constants").SetDataSource(this.m_afConstants);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(3, this.m_afLightDir);
        rkStream.Write(4, this.m_afWaveDirX);
        rkStream.Write(4, this.m_afWaveDirY);
        rkStream.Write(4, this.m_afWaveSpeed);
        rkStream.Write(4, this.m_afWaveOffset);
        rkStream.Write(4, this.m_afWaveHeight);
        rkStream.Write(4, this.m_afBumpSpeed);
        rkStream.Write(4, this.m_afConstants);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("RipplingOceanEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        Vector3f kDirection = new Vector3f(this.m_afLightDir[0], this.m_afLightDir[1], this.m_afLightDir[2]);
        pkTree.Append(StringTree.Format("light direction =", kDirection));
        pkTree.Append(StringTree.Format("wave0 x-direction =", this.m_afWaveDirX[0]));
        pkTree.Append(StringTree.Format("wave1 x-direction =", this.m_afWaveDirX[1]));
        pkTree.Append(StringTree.Format("wave2 x-direction =", this.m_afWaveDirX[2]));
        pkTree.Append(StringTree.Format("wave3 x-direction =", this.m_afWaveDirX[3]));
        pkTree.Append(StringTree.Format("wave0 y-direction =", this.m_afWaveDirY[0]));
        pkTree.Append(StringTree.Format("wave1 y-direction =", this.m_afWaveDirY[1]));
        pkTree.Append(StringTree.Format("wave2 y-direction =", this.m_afWaveDirY[2]));
        pkTree.Append(StringTree.Format("wave3 y-direction =", this.m_afWaveDirY[3]));
        pkTree.Append(StringTree.Format("wave0 speed =", this.m_afWaveSpeed[0]));
        pkTree.Append(StringTree.Format("wave1 speed =", this.m_afWaveSpeed[1]));
        pkTree.Append(StringTree.Format("wave2 speed =", this.m_afWaveSpeed[2]));
        pkTree.Append(StringTree.Format("wave3 speed =", this.m_afWaveSpeed[3]));
        pkTree.Append(StringTree.Format("wave0 offset =", this.m_afWaveOffset[0]));
        pkTree.Append(StringTree.Format("wave1 offset =", this.m_afWaveOffset[1]));
        pkTree.Append(StringTree.Format("wave2 offset =", this.m_afWaveOffset[2]));
        pkTree.Append(StringTree.Format("wave3 offset =", this.m_afWaveOffset[3]));
        pkTree.Append(StringTree.Format("wave0 bump speed =", this.m_afBumpSpeed[0]));
        pkTree.Append(StringTree.Format("wave1 bump speed =", this.m_afBumpSpeed[1]));
        pkTree.Append(StringTree.Format("wave2 bump speed =", this.m_afBumpSpeed[2]));
        pkTree.Append(StringTree.Format("wave3 bump speed =", this.m_afBumpSpeed[3]));
        pkTree.Append(StringTree.Format("average DuDxDvDy =", this.m_afConstants[0]));
        pkTree.Append(StringTree.Format("ambient =", this.m_afConstants[1]));
        pkTree.Append(StringTree.Format("texture repeat =", this.m_afConstants[2]));
        pkTree.Append(StringTree.Format("time =", this.m_afConstants[3]));
        return pkTree;
    }

    public void SetAmbient(float fValue) {
        this.m_afConstants[1] = fValue;
    }

    public void SetAverageDuDxDvDy(float fValue) {
        this.m_afConstants[0] = fValue;
    }

    public void SetBumpSpeed(float[] afValue) {
        this.m_afBumpSpeed[0] = afValue[0];
        this.m_afBumpSpeed[1] = afValue[1];
        this.m_afBumpSpeed[2] = afValue[2];
        this.m_afBumpSpeed[3] = afValue[3];
    }

    public void SetLightDir(Vector3f rkLightDir) {
        this.m_afLightDir[0] = rkLightDir.X;
        this.m_afLightDir[1] = rkLightDir.Y;
        this.m_afLightDir[2] = rkLightDir.Z;
    }

    public void SetTextureRepeat(float fValue) {
        this.m_afConstants[2] = fValue;
    }

    public void SetTime(float fValue) {
        this.m_afConstants[3] = fValue;
    }

    public void SetWaveDirX(float[] afValue) {
        this.m_afWaveDirX[0] = afValue[0];
        this.m_afWaveDirX[1] = afValue[1];
        this.m_afWaveDirX[2] = afValue[2];
        this.m_afWaveDirX[3] = afValue[3];
    }

    public void SetWaveDirY(float[] afValue) {
        this.m_afWaveDirY[0] = afValue[0];
        this.m_afWaveDirY[1] = afValue[1];
        this.m_afWaveDirY[2] = afValue[2];
        this.m_afWaveDirY[3] = afValue[3];
    }

    public void SetWaveHeight(float[] afValue) {
        this.m_afWaveHeight[0] = afValue[0];
        this.m_afWaveHeight[1] = afValue[1];
        this.m_afWaveHeight[2] = afValue[2];
        this.m_afWaveHeight[3] = afValue[3];
    }

    public void SetWaveOffset(float[] afValue) {
        this.m_afWaveOffset[0] = afValue[0];
        this.m_afWaveOffset[1] = afValue[1];
        this.m_afWaveOffset[2] = afValue[2];
        this.m_afWaveOffset[3] = afValue[3];
    }

    public void SetWaveSpeed(float[] afValue) {
        this.m_afWaveSpeed[0] = afValue[0];
        this.m_afWaveSpeed[1] = afValue[1];
        this.m_afWaveSpeed[2] = afValue[2];
        this.m_afWaveSpeed[3] = afValue[3];
    }
}

