/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.Shaders.CompiledProgramCatalog;
import WildMagic.LibGraphics.Shaders.PixelProgramCatalog;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.SamplerInformation;
import WildMagic.LibGraphics.Shaders.VertexProgramCatalog;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;
import java.util.Vector;

public class ShaderEffect
extends Effect
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = 7887164777167655050L;
    protected int m_iPassQuantity;
    protected Vector<VertexShader> m_kVShader = new Vector();
    protected Vector<PixelShader> m_kPShader = new Vector();
    protected Vector<Program> m_kCompiledPrograms = new Vector();
    protected Vector<AlphaState> m_kAlphaState = new Vector();

    public ShaderEffect() {
        this.m_iPassQuantity = 0;
    }

    public ShaderEffect(int iPassQuantity) {
        assert (iPassQuantity > 0);
        this.SetPassQuantity(iPassQuantity);
    }

    @Override
    public void dispose() {
        this.m_kVShader.clear();
        this.m_kVShader = null;
        this.m_kPShader.clear();
        this.m_kPShader = null;
        this.m_kCompiledPrograms.clear();
        this.m_kCompiledPrograms = null;
        this.m_kAlphaState.clear();
        this.m_kAlphaState = null;
        super.dispose();
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            if (this.m_kVShader.get(iPass) != null) {
                this.m_kVShader.get(iPass).GetAllObjectsByName(rkName, rkObjects);
            }
            if (this.m_kPShader.get(iPass) == null) continue;
            this.m_kPShader.get(iPass).GetAllObjectsByName(rkName, rkObjects);
        }
    }

    public AlphaState GetBlending(int iPass) {
        assert (0 <= iPass && iPass < this.m_kAlphaState.size());
        return this.m_kAlphaState.get(iPass);
    }

    public Program GetCProgram(int iPass) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        return this.m_kCompiledPrograms.get(iPass);
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + this.m_iPassQuantity * Stream.SIZEOF_INT + this.m_iPassQuantity * Stream.SIZEOF_INT + Stream.SIZEOF_INT + this.m_kAlphaState.size() * Stream.SIZEOF_INT;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            if (this.m_kVShader.get(iPass) != null && (pkFound = this.m_kVShader.get(iPass).GetObjectByID(uiID)) != null) {
                return pkFound;
            }
            if (this.m_kPShader.get(iPass) == null || (pkFound = this.m_kPShader.get(iPass).GetObjectByID(uiID)) == null) continue;
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            if (this.m_kVShader.get(iPass) != null && (pkFound = this.m_kVShader.get(iPass).GetObjectByName(rkName)) != null) {
                return pkFound;
            }
            if (this.m_kPShader.get(iPass) == null || (pkFound = this.m_kPShader.get(iPass).GetObjectByName(rkName)) == null) continue;
            return pkFound;
        }
        return null;
    }

    public int GetPassQuantity() {
        return this.m_iPassQuantity;
    }

    public SamplerInformation GetSamplerInformation(int iPass, int i) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        return this.m_kPShader.get(iPass).GetGetSamplerInformation(i);
    }

    public Texture GetTexture(int iPass, int i) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        return this.m_kPShader.get(iPass).GetTexture(i);
    }

    public int GetTextureQuantity(int iPass) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        if (this.m_kCompiledPrograms == null) {
            return 0;
        }
        Program pkCProgram = this.m_kCompiledPrograms.get(iPass);
        return pkCProgram != null ? pkCProgram.GetSIQuantity() : 0;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        int iLinkID;
        super.Link(rkStream, pkLink);
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            iLinkID = pkLink.GetLinkID();
            this.m_kVShader.set(iPass, (VertexShader)rkStream.GetFromMap(iLinkID));
            iLinkID = pkLink.GetLinkID();
            this.m_kPShader.set(iPass, (PixelShader)rkStream.GetFromMap(iLinkID));
        }
        int iQuantity = this.m_kAlphaState.size();
        for (int i = 0; i < iQuantity; ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_kAlphaState.set(i, (AlphaState)rkStream.GetFromMap(iLinkID));
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        int iLinkID;
        super.Load(rkStream, pkLink);
        this.m_iPassQuantity = rkStream.ReadInt();
        this.m_kVShader.setSize(this.m_iPassQuantity);
        this.m_kPShader.setSize(this.m_iPassQuantity);
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
        int iQuantity = rkStream.ReadInt();
        this.m_kAlphaState.setSize(iQuantity);
        for (int i = 0; i < iQuantity; ++i) {
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
    }

    public void LoadPrograms(Renderer kRenderer, int iPass, int iMaxColors, int iMaxTCoords, int iMaxVShaderImages, int iMaxPShaderImages) {
        Attributes rkVIAttr;
        Attributes rkPIAttr;
        Attributes rkVOAttr;
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        assert (this.m_kVShader.get(iPass) != null && this.m_kPShader.get(iPass) != null);
        Program pkVProgram = this.m_kVShader.get(iPass).GetProgram();
        Program pkPProgram = this.m_kPShader.get(iPass).GetProgram();
        if (pkVProgram != null && !pkVProgram.IsParsed()) {
            kRenderer.ParseProgram(pkVProgram, Program.VERTEX);
            VertexProgramCatalog.GetActive().Insert(pkVProgram);
        }
        if (pkPProgram != null && !pkPProgram.IsParsed()) {
            kRenderer.ParseProgram(pkPProgram, Program.PIXEL);
            PixelProgramCatalog.GetActive().Insert(pkPProgram);
        }
        Program kCompiledProgram = null;
        if (pkVProgram != null && pkPProgram != null) {
            if (pkVProgram.GetProgramID() != pkPProgram.GetProgramID()) {
                kCompiledProgram = CompiledProgramCatalog.GetActive().Find(pkVProgram.GetShaderID(), pkPProgram.GetShaderID());
                if (kCompiledProgram == null) {
                    kCompiledProgram = kRenderer.CompilePrograms(pkVProgram, pkPProgram);
                    CompiledProgramCatalog.GetActive().Insert(kCompiledProgram, pkVProgram.GetID(), pkPProgram.GetID());
                    this.m_kVShader.get(iPass).OnLoadProgram(pkVProgram);
                    this.m_kPShader.get(iPass).OnLoadProgram(pkPProgram);
                    this.m_kCompiledPrograms.set(iPass, kCompiledProgram);
                    this.OnLoadPrograms(iPass, pkVProgram, pkPProgram, kCompiledProgram);
                } else {
                    this.m_kCompiledPrograms.set(iPass, kCompiledProgram);
                    pkVProgram.SetProgramID(kCompiledProgram.GetProgramID());
                    pkPProgram.SetProgramID(kCompiledProgram.GetProgramID());
                }
            }
            return;
        }
        boolean bLoadedVProgram = false;
        boolean bLoadedPProgram = false;
        if (pkPProgram == null) {
            pkPProgram = this.m_kPShader.get(iPass).GetUnique() || kRenderer.GetUnique() ? kRenderer.ReadProgram(this.m_kPShader.get(iPass).GetShaderName(), PixelProgramCatalog.GetActive().GetDefaultDir(), Program.PIXEL) : PixelProgramCatalog.GetActive().Find(kRenderer, this.m_kPShader.get(iPass).GetShaderName(), PixelProgramCatalog.GetActive().GetDefaultDir());
            bLoadedPProgram = true;
        }
        if (pkVProgram == null) {
            pkVProgram = this.m_kVShader.get(iPass).GetUnique() || kRenderer.GetUnique() ? kRenderer.ReadProgram(this.m_kVShader.get(iPass).GetShaderName(), VertexProgramCatalog.GetActive().GetDefaultDir(), Program.VERTEX) : VertexProgramCatalog.GetActive().Find(kRenderer, this.m_kVShader.get(iPass).GetShaderName(), VertexProgramCatalog.GetActive().GetDefaultDir());
            bLoadedVProgram = true;
        }
        String kDefaultV = new String("DefaultV");
        String kDefaultP = new String("DefaultP");
        if (pkVProgram == null) {
            this.m_kVShader.set(iPass, new VertexShader(kDefaultV));
            pkVProgram = VertexProgramCatalog.GetActive().Find(kRenderer, kDefaultV, VertexProgramCatalog.GetActive().GetDefaultDir());
        }
        if (pkPProgram == null) {
            this.m_kPShader.set(iPass, new PixelShader(kDefaultP));
            pkPProgram = PixelProgramCatalog.GetActive().Find(kRenderer, kDefaultP, PixelProgramCatalog.GetActive().GetDefaultDir());
        }
        if (!pkVProgram.IsCompiled() || !pkPProgram.IsCompiled()) {
            kCompiledProgram = kRenderer.CompilePrograms(pkVProgram, pkPProgram);
            CompiledProgramCatalog.GetActive().Insert(kCompiledProgram, pkVProgram.GetID(), pkPProgram.GetID());
            this.OnLoadPrograms(iPass, pkVProgram, pkPProgram, kCompiledProgram);
        }
        if (!(rkVOAttr = pkVProgram.GetOutputAttributes()).Matches(rkPIAttr = pkPProgram.GetInputAttributes(), false, true, true, true)) {
            if (!pkVProgram.GetName().equals(kDefaultV)) {
                this.m_kVShader.set(iPass, new VertexShader(kDefaultV));
                pkVProgram = VertexProgramCatalog.GetActive().Find(kRenderer, kDefaultV, VertexProgramCatalog.GetActive().GetDefaultDir());
                assert (pkVProgram != null);
            }
            if (!pkPProgram.GetName().equals(kDefaultP)) {
                this.m_kPShader.set(iPass, new PixelShader(kDefaultP));
                pkPProgram = PixelProgramCatalog.GetActive().Find(kRenderer, kDefaultP, PixelProgramCatalog.GetActive().GetDefaultDir());
                assert (pkPProgram != null);
            }
        }
        if ((rkVIAttr = pkVProgram.GetInputAttributes()).GetMaxColors() > iMaxColors || rkVIAttr.GetMaxTCoords() > iMaxTCoords || rkVOAttr.GetMaxColors() > iMaxColors || rkVOAttr.GetMaxTCoords() > iMaxTCoords || rkPIAttr.GetMaxColors() > iMaxColors || rkPIAttr.GetMaxTCoords() > iMaxTCoords || pkVProgram.GetSIQuantity() > iMaxVShaderImages || pkPProgram.GetSIQuantity() > iMaxPShaderImages) {
            if (pkVProgram.GetName().equals(kDefaultV)) {
                this.m_kVShader.set(iPass, new VertexShader(kDefaultV));
                pkVProgram = VertexProgramCatalog.GetActive().Find(kRenderer, kDefaultV, VertexProgramCatalog.GetActive().GetDefaultDir());
                assert (pkVProgram != null);
            }
            if (!pkPProgram.GetName().equals(kDefaultP)) {
                this.m_kPShader.set(iPass, new PixelShader(kDefaultP));
                pkPProgram = PixelProgramCatalog.GetActive().Find(kRenderer, kDefaultP, PixelProgramCatalog.GetActive().GetDefaultDir());
                assert (pkPProgram != null);
            }
        }
        if (bLoadedVProgram) {
            this.m_kVShader.get(iPass).OnLoadProgram(pkVProgram);
        }
        if (bLoadedPProgram) {
            this.m_kPShader.get(iPass).OnLoadProgram(pkPProgram);
        }
        this.m_kCompiledPrograms.set(iPass, kCompiledProgram);
        this.OnLoadPrograms(iPass, pkVProgram, pkPProgram, kCompiledProgram);
    }

    @Override
    public void LoadResources(Renderer pkRenderer, Geometry pkGeometry) {
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            this.LoadPrograms(pkRenderer, iPass, pkRenderer.GetMaxColors(), pkRenderer.GetMaxTCoords(), pkRenderer.GetMaxVShaderImages(), pkRenderer.GetMaxPShaderImages());
            Program pkVProgram = this.m_kCompiledPrograms.get(iPass);
            pkRenderer.LoadVProgram(pkVProgram);
            int iPTQuantity = this.GetTextureQuantity(iPass);
            for (int i = 0; i < iPTQuantity; ++i) {
                pkRenderer.LoadTexture(this.m_kPShader.get(iPass).GetTexture(i));
            }
            if (pkGeometry == null) continue;
            Attributes rkIAttr = pkVProgram.GetInputAttributes();
            Attributes rkOAttr = pkVProgram.GetOutputAttributes();
            pkRenderer.LoadVBuffer(rkIAttr, rkOAttr, pkGeometry.VBuffer);
        }
    }

    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
    }

    public void OnReleasePrograms(int iPass, Program pkVProgram, Program pkPProgram) {
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            if (this.m_kVShader.get(iPass) != null) {
                this.m_kVShader.get(iPass).Register(rkStream);
            }
            if (this.m_kPShader.get(iPass) == null) continue;
            this.m_kPShader.get(iPass).Register(rkStream);
        }
        for (int i = 0; i < this.m_kAlphaState.size(); ++i) {
            if (this.m_kAlphaState.get(i) == null) continue;
            this.m_kAlphaState.get(i).Register(rkStream);
        }
        return true;
    }

    public void ReleasePrograms(int iPass) {
        this.OnReleasePrograms(iPass, this.m_kVShader.get(iPass).GetProgram(), this.m_kPShader.get(iPass).GetProgram());
        this.m_kVShader.get(iPass).OnReleaseProgram();
        this.m_kPShader.get(iPass).OnReleaseProgram();
        if (this.m_kCompiledPrograms != null && this.m_kCompiledPrograms.get(iPass) != null) {
            this.m_kCompiledPrograms.get(iPass).Remove();
        }
    }

    @Override
    public void ReleaseResources(Renderer pkRenderer, Geometry pkGeometry) {
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            int iPTQuantity = this.GetTextureQuantity(iPass);
            for (int i = 0; i < iPTQuantity; ++i) {
                pkRenderer.ReleaseTexture(this.m_kPShader.get(iPass).GetTexture(i));
            }
            if (this.m_kCompiledPrograms == null) continue;
            Program pkVProgram = this.m_kCompiledPrograms.get(iPass);
            pkRenderer.ReleaseVProgram(pkVProgram);
            this.ReleasePrograms(iPass);
        }
    }

    public void RestoreGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity && pkRenderer != null);
        if (!bPrimaryEffect || iPass > 0) {
            AlphaState spkSave = pkRenderer.GetAlphaState();
            pkRenderer.SetAlphaState(this.m_kAlphaState.get(iPass));
            this.m_kAlphaState.set(iPass, spkSave);
        }
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iPassQuantity);
        for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
            rkStream.Write(this.m_kVShader.get(iPass).GetID());
            rkStream.Write(this.m_kPShader.get(iPass).GetID());
        }
        int iQuantity = this.m_kAlphaState.size();
        rkStream.Write(iQuantity);
        for (int i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kAlphaState.get(i).GetID());
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        int iQuantity;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("ShaderEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("pass quantity =", this.m_iPassQuantity));
        if (this.m_iPassQuantity > 0) {
            StringTree pkCTree = new StringTree();
            pkCTree.Append(StringTree.Format("shaders"));
            for (int iPass = 0; iPass < this.m_iPassQuantity; ++iPass) {
                pkCTree.Append(this.m_kVShader.get(iPass).SaveStrings(null));
                pkCTree.Append(this.m_kPShader.get(iPass).SaveStrings(null));
            }
            pkTree.Append(pkCTree);
        }
        if ((iQuantity = this.m_kAlphaState.size()) > 0) {
            StringTree pkCTree = new StringTree();
            pkCTree.Append(StringTree.Format("blending states"));
            for (int i = 0; i < iQuantity; ++i) {
                pkCTree.Append(this.m_kAlphaState.get(i).SaveStrings(null));
            }
            pkTree.Append(pkCTree);
        }
        return pkTree;
    }

    public void SetCProgram(int iPass, Program kCProgram) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        this.m_kCompiledPrograms.set(iPass, kCProgram);
    }

    public void SetGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity && pkRenderer != null);
        if (!bPrimaryEffect || iPass > 0) {
            this.m_kAlphaState.get((int)iPass).BlendEnabled = true;
            AlphaState spkSave = pkRenderer.GetAlphaState();
            pkRenderer.SetAlphaState(this.m_kAlphaState.get(iPass));
            this.m_kAlphaState.set(iPass, spkSave);
        }
    }

    public void SetPassQuantity(int iPassQuantity) {
        assert (iPassQuantity > 0);
        this.m_iPassQuantity = iPassQuantity;
        this.m_kVShader.setSize(this.m_iPassQuantity);
        this.m_kPShader.setSize(this.m_iPassQuantity);
        this.m_kCompiledPrograms.setSize(this.m_iPassQuantity);
        this.m_kAlphaState.setSize(this.m_iPassQuantity);
        this.SetDefaultAlphaState();
    }

    public void SetPShader(int iPass, PixelShader pkPShader) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        this.m_kPShader.set(iPass, pkPShader);
    }

    public void SetTexture(Texture kTex, int iPass, int i) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        this.m_kPShader.get(iPass).SetTexture(i, kTex);
    }

    public void SetVShader(int iPass, VertexShader pkVShader) {
        assert (0 <= iPass && iPass < this.m_iPassQuantity);
        this.m_kVShader.set(iPass, pkVShader);
    }

    protected void SetDefaultAlphaState() {
        this.m_kAlphaState.set(0, new AlphaState());
        this.m_kAlphaState.get((int)0).BlendEnabled = true;
        for (int i = 1; i < this.m_kAlphaState.size(); ++i) {
            this.m_kAlphaState.set(i, new AlphaState());
            this.m_kAlphaState.get((int)i).BlendEnabled = true;
            this.m_kAlphaState.get((int)i).SrcBlend = AlphaState.SrcBlendMode.SBF_DST_COLOR;
            this.m_kAlphaState.get((int)i).DstBlend = AlphaState.DstBlendMode.DBF_ZERO;
        }
    }
}

