/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.Triangles;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class SimpleBumpMapEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 7594003472477546356L;
    protected Vector3f m_kLightDirection;

    public SimpleBumpMapEffect() {
        this.m_kLightDirection = new Vector3f();
    }

    public SimpleBumpMapEffect(String acBaseName, String acNormalName, Vector3f rkLightDirection) {
        super(1);
        this.m_kLightDirection = new Vector3f(rkLightDirection);
        this.m_kVShader.set(0, new VertexShader("SimpleBumpMapV"));
        this.m_kPShader.set(0, new PixelShader("SimpleBumpMapP"));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(2);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(0, acBaseName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(1, acNormalName);
    }

    public void ComputeLightVectors(Triangles pkMesh) {
        int i;
        assert (pkMesh != null && pkMesh.VBuffer != null && pkMesh.IBuffer != null);
        assert (pkMesh.VBuffer.GetAttributes().GetPChannels() == 3);
        assert (pkMesh.VBuffer.GetAttributes().GetNChannels() == 3);
        assert (pkMesh.VBuffer.GetAttributes().GetCChannels(0) == 3);
        assert (pkMesh.VBuffer.GetAttributes().GetTChannels(0) == 2);
        Vector3f kModelLightDirection = new Vector3f(this.m_kLightDirection);
        kModelLightDirection.Neg();
        kModelLightDirection = pkMesh.World.InvertVector(kModelLightDirection);
        VertexBuffer pkVB = pkMesh.VBuffer;
        int iVQuantity = pkMesh.VBuffer.GetVertexQuantity();
        for (i = 0; i < iVQuantity; ++i) {
            pkVB.SetColor3(0, i, ColorRGB.BLACK);
        }
        int iTQuantity = pkMesh.GetTriangleQuantity();
        Vector3f[] apkV = new Vector3f[3];
        Vector3f[] apkN = new Vector3f[3];
        ColorRGB[] apkC = new ColorRGB[3];
        Vector2f[] apkST = new Vector2f[3];
        for (i = 0; i < 3; ++i) {
            apkV[i] = new Vector3f();
            apkN[i] = new Vector3f();
            apkC[i] = new ColorRGB();
            apkST[i] = new Vector2f();
        }
        Vector3f kBitangent = new Vector3f();
        for (int iT = 0; iT < iTQuantity; ++iT) {
            int[] aiVerts = new int[3];
            if (!pkMesh.GetTriangle(iT, aiVerts)) continue;
            int iV0 = aiVerts[0];
            int iV1 = aiVerts[1];
            int iV2 = aiVerts[2];
            pkVB.GetPosition3(iV0, apkV[0]);
            pkVB.GetPosition3(iV1, apkV[1]);
            pkVB.GetPosition3(iV2, apkV[2]);
            pkVB.GetNormal3(iV0, apkN[0]);
            pkVB.GetNormal3(iV1, apkN[1]);
            pkVB.GetNormal3(iV2, apkN[2]);
            pkVB.GetColor3(0, iV0, apkC[0]);
            pkVB.GetColor3(0, iV1, apkC[1]);
            pkVB.GetColor3(0, iV2, apkC[2]);
            pkVB.GetTCoord2(0, iV0, apkST[0]);
            pkVB.GetTCoord2(0, iV1, apkST[1]);
            pkVB.GetTCoord2(0, iV2, apkST[2]);
            for (i = 0; i < 3; ++i) {
                Vector3f kTangent;
                ColorRGB rkColor = apkC[i];
                if (rkColor.R != ColorRGB.BLACK.R || rkColor.G != ColorRGB.BLACK.G || rkColor.B != ColorRGB.BLACK.B) continue;
                int iN = (i + 1) % 3;
                int iP = i == 0 ? 2 : i - 1;
                if (!this.ComputeTangent(apkV[i], apkST[i], apkV[iN], apkST[iN], apkV[iP], apkST[iP], kTangent = new Vector3f())) {
                    rkColor.R = apkN[i].X;
                    rkColor.G = apkN[i].Y;
                    rkColor.B = apkN[i].Z;
                    if (i == 0) {
                        pkVB.SetColor3(0, iV0, rkColor);
                        continue;
                    }
                    if (i == 1) {
                        pkVB.SetColor3(0, iV1, rkColor);
                        continue;
                    }
                    pkVB.SetColor3(0, iV2, rkColor);
                    continue;
                }
                Vector3f kScale = new Vector3f(apkN[i]);
                kScale.Scale(apkN[i].Dot(kTangent));
                kTangent.Sub(kScale);
                kScale = null;
                kTangent.Normalize();
                kBitangent.UnitCross(apkN[i], kTangent);
                float fDotUT = kModelLightDirection.Dot(kTangent);
                float fDotUB = kModelLightDirection.Dot(kBitangent);
                float fDotUN = kModelLightDirection.Dot(apkN[i]);
                rkColor.R = 0.5f * (fDotUT + 1.0f);
                rkColor.G = 0.5f * (fDotUB + 1.0f);
                rkColor.B = 0.5f * (fDotUN + 1.0f);
                if (i == 0) {
                    pkVB.SetColor3(0, iV0, rkColor);
                    continue;
                }
                if (i == 1) {
                    pkVB.SetColor3(0, iV1, rkColor);
                    continue;
                }
                pkVB.SetColor3(0, iV2, rkColor);
            }
        }
        kBitangent = null;
        for (i = 0; i < 3; ++i) {
            apkV[i] = null;
            apkN[i] = null;
            apkC[i] = null;
            apkST[i] = null;
        }
    }

    @Override
    public void dispose() {
        this.m_kLightDirection = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT;
    }

    public Vector3f GetLightDirection() {
        return this.m_kLightDirection;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.m_kLightDirection);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_kLightDirection);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("SimpleBumpMapEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("light direction =", this.m_kLightDirection));
        return pkTree;
    }

    public void SetLightDirection(Vector3f rkLightDirection) {
        this.m_kLightDirection = rkLightDirection;
    }

    protected boolean ComputeTangent(Vector3f rkPos0, Vector2f rkTCoord0, Vector3f rkPos1, Vector2f rkTCoord1, Vector3f rkPos2, Vector2f rkTCoord2, Vector3f rkTangent) {
        Vector3f kDP1 = new Vector3f();
        kDP1.Sub(rkPos1, rkPos0);
        Vector3f kDP2 = new Vector3f();
        kDP2.Sub(rkPos2, rkPos0);
        if (Math.abs(kDP1.Length()) < 1.0E-6f || Math.abs(kDP2.Length()) < 1.0E-6f) {
            kDP1 = null;
            kDP2 = null;
            return false;
        }
        float fDU1 = rkTCoord1.X - rkTCoord0.X;
        float fDV1 = rkTCoord1.Y - rkTCoord0.Y;
        if (Math.abs(fDV1) < 1.0E-6f) {
            if (Math.abs(fDU1) < 1.0E-6f) {
                kDP1 = null;
                kDP2 = null;
                return false;
            }
            rkTangent.Copy(kDP1);
            rkTangent.Div(fDU1);
            kDP1 = null;
            kDP2 = null;
            return true;
        }
        float fDU2 = rkTCoord2.X - rkTCoord0.X;
        float fDV2 = rkTCoord2.Y - rkTCoord0.Y;
        float fDet = fDV1 * fDU2 - fDV2 * fDU1;
        if (Math.abs(fDet) < 1.0E-6f) {
            kDP1 = null;
            kDP2 = null;
            return false;
        }
        Vector3f kTemp = new Vector3f(kDP2);
        kTemp.Scale(fDV1);
        Vector3f kScale = new Vector3f(kDP1);
        kScale.Scale(fDV2);
        kTemp.Sub(kScale);
        rkTangent.Scale((float)(1.0 / (double)fDet), kTemp);
        kScale = null;
        kTemp = null;
        return true;
    }
}

