/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.CullState;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.WireframeState;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class WireframeBehindEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -5673436849765050752L;
    private CullState m_spkSaveCullState;
    private CullState m_spkCullState;
    private WireframeState m_spkSaveWireframeState;
    private WireframeState m_spkWireframeState;
    private float m_fSaveLineWidth;

    public WireframeBehindEffect() {
        super(1);
        this.m_kVShader.set(0, new VertexShader("BlackColor4.glsl"));
        this.m_kPShader.set(0, new PixelShader("PassThrough4.glsl"));
        this.m_spkCullState = new CullState();
        this.m_spkSaveCullState = null;
        this.m_spkSaveWireframeState = null;
        this.m_spkWireframeState = new WireframeState();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion);
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void RestoreGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        pkRenderer.SetCullState(this.m_spkSaveCullState);
        pkRenderer.SetWireframeState(this.m_spkSaveWireframeState);
        pkRenderer.SetLineWidth(this.m_fSaveLineWidth);
        super.RestoreGlobalState(iPass, pkRenderer, bPrimaryEffect);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("WireframeBehindEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        return pkTree;
    }

    @Override
    public void SetGlobalState(int iPass, Renderer pkRenderer, boolean bPrimaryEffect) {
        super.SetGlobalState(iPass, pkRenderer, bPrimaryEffect);
        this.m_spkSaveCullState = pkRenderer.GetCullState();
        this.m_spkCullState.CullFace = CullState.CullMode.CT_FRONT;
        pkRenderer.SetCullState(this.m_spkCullState);
        this.m_spkSaveWireframeState = pkRenderer.GetWireframeState();
        this.m_spkWireframeState.Enabled = true;
        pkRenderer.SetWireframeState(this.m_spkWireframeState);
        this.m_fSaveLineWidth = pkRenderer.GetLineWidth();
        pkRenderer.SetLineWidth(3.3f);
    }
}

