/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Renderer;
import java.io.Serializable;

public class Camera
extends GraphicsObject
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 1064305262929929672L;
    public boolean Perspective;
    protected Vector3f m_kLocation;
    protected Vector3f m_kDVector;
    protected Vector3f m_kUVector;
    protected Vector3f m_kRVector;
    protected float[] m_afFrustum = new float[ViewFrustum.VF_QUANTITY.Value()];
    protected float m_fPortL;
    protected float m_fPortR;
    protected float m_fPortT;
    protected float m_fPortB;
    protected float m_fPortN;
    protected float m_fPortF;
    protected Renderer m_pkRenderer = null;

    public Camera() {
        this.SetFrustum(-0.5f, 0.5f, -0.5f, 0.5f, 1.0f, 2.0f);
        this.SetViewport(0.0f, 1.0f, 1.0f, 0.0f);
        this.SetDepthRange(0.0f, 1.0f);
        this.SetFrame(Vector3f.ZERO, Vector3f.UNIT_Z_NEG, Vector3f.UNIT_Y, Vector3f.UNIT_X);
        this.Perspective = true;
    }

    @Override
    public void dispose() {
        this.m_kLocation = null;
        this.m_kDVector = null;
        this.m_kUVector = null;
        this.m_kRVector = null;
        this.m_afFrustum = null;
        this.m_pkRenderer = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        int iSize = super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
        return iSize;
    }

    public final float GetDMax() {
        return this.m_afFrustum[ViewFrustum.VF_DMAX.Value()];
    }

    public final float GetDMin() {
        return this.m_afFrustum[ViewFrustum.VF_DMIN.Value()];
    }

    public final Vector3f GetDVector() {
        return this.m_kDVector;
    }

    public final float[] GetFrustum() {
        return this.m_afFrustum;
    }

    public final Vector3f GetLocation() {
        return this.m_kLocation;
    }

    public boolean GetPickRay(int iX, int iY, int iWidth, int iHeight, Vector3f rkOrigin, Vector3f rkDirection) {
        float fPortX = (float)iX / (float)(iWidth - 1);
        if (fPortX < this.m_fPortL || fPortX > this.m_fPortR) {
            return false;
        }
        float fPortY = (float)(iHeight - 1 - iY) / (float)(iHeight - 1);
        if (fPortY < this.m_fPortB || fPortY > this.m_fPortT) {
            return false;
        }
        float fXWeight = (fPortX - this.m_fPortL) / (this.m_fPortR - this.m_fPortL);
        float fViewX = (1.0f - fXWeight) * this.m_afFrustum[ViewFrustum.VF_RMIN.Value()] + fXWeight * this.m_afFrustum[ViewFrustum.VF_RMAX.Value()];
        float fYWeight = (fPortY - this.m_fPortB) / (this.m_fPortT - this.m_fPortB);
        float fViewY = (1.0f - fYWeight) * this.m_afFrustum[ViewFrustum.VF_UMIN.Value()] + fYWeight * this.m_afFrustum[ViewFrustum.VF_UMAX.Value()];
        rkOrigin.Copy(this.m_kLocation);
        Vector3f kUVectorScale = new Vector3f(this.m_kUVector);
        kUVectorScale.Scale(fViewY);
        Vector3f kRVectorScale = new Vector3f(this.m_kRVector);
        kRVectorScale.Scale(fViewX);
        Vector3f kDVectorScale = new Vector3f(this.m_kDVector);
        kDVectorScale.Scale(this.m_afFrustum[ViewFrustum.VF_DMIN.Value()]);
        rkDirection.Copy(kDVectorScale);
        rkDirection.Add(kRVectorScale);
        rkDirection.Add(kUVectorScale);
        rkDirection.Normalize();
        return true;
    }

    public final float GetPortB() {
        return this.m_fPortB;
    }

    public final float GetPortF() {
        return this.m_fPortF;
    }

    public final float GetPortL() {
        return this.m_fPortL;
    }

    public final float GetPortN() {
        return this.m_fPortN;
    }

    public final float GetPortR() {
        return this.m_fPortR;
    }

    public final float GetPortT() {
        return this.m_fPortT;
    }

    public final float GetRMax() {
        return this.m_afFrustum[ViewFrustum.VF_RMAX.Value()];
    }

    public final float GetRMin() {
        return this.m_afFrustum[ViewFrustum.VF_RMIN.Value()];
    }

    public final Vector3f GetRVector() {
        return this.m_kRVector;
    }

    public final float GetUMax() {
        return this.m_afFrustum[ViewFrustum.VF_UMAX.Value()];
    }

    public final float GetUMin() {
        return this.m_afFrustum[ViewFrustum.VF_UMIN.Value()];
    }

    public final Vector3f GetUVector() {
        return this.m_kUVector;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.m_kLocation);
        rkStream.Read(this.m_kDVector);
        rkStream.Read(this.m_kUVector);
        rkStream.Read(this.m_kRVector);
        this.m_afFrustum[ViewFrustum.VF_DMIN.Value()] = rkStream.ReadFloat();
        this.m_afFrustum[ViewFrustum.VF_DMAX.Value()] = rkStream.ReadFloat();
        this.m_afFrustum[ViewFrustum.VF_UMIN.Value()] = rkStream.ReadFloat();
        this.m_afFrustum[ViewFrustum.VF_UMAX.Value()] = rkStream.ReadFloat();
        this.m_afFrustum[ViewFrustum.VF_RMIN.Value()] = rkStream.ReadFloat();
        this.m_afFrustum[ViewFrustum.VF_RMAX.Value()] = rkStream.ReadFloat();
        this.m_fPortL = rkStream.ReadFloat();
        this.m_fPortR = rkStream.ReadFloat();
        this.m_fPortT = rkStream.ReadFloat();
        this.m_fPortB = rkStream.ReadFloat();
        this.m_fPortN = rkStream.ReadFloat();
        this.m_fPortF = rkStream.ReadFloat();
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_kLocation);
        rkStream.Write(this.m_kDVector);
        rkStream.Write(this.m_kUVector);
        rkStream.Write(this.m_kRVector);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_DMIN.Value()]);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_DMAX.Value()]);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_UMIN.Value()]);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_UMAX.Value()]);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_RMIN.Value()]);
        rkStream.Write(this.m_afFrustum[ViewFrustum.VF_RMAX.Value()]);
        rkStream.Write(this.m_fPortL);
        rkStream.Write(this.m_fPortR);
        rkStream.Write(this.m_fPortT);
        rkStream.Write(this.m_fPortB);
        rkStream.Write(this.m_fPortN);
        rkStream.Write(this.m_fPortF);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Camera", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("location =", this.m_kLocation));
        pkTree.Append(StringTree.Format("d vector =", this.m_kDVector));
        pkTree.Append(StringTree.Format("u vector =", this.m_kUVector));
        pkTree.Append(StringTree.Format("r vector =", this.m_kRVector));
        pkTree.Append(StringTree.Format("dmin =", this.m_afFrustum[ViewFrustum.VF_DMIN.Value()]));
        pkTree.Append(StringTree.Format("dmax =", this.m_afFrustum[ViewFrustum.VF_DMAX.Value()]));
        pkTree.Append(StringTree.Format("umin =", this.m_afFrustum[ViewFrustum.VF_UMIN.Value()]));
        pkTree.Append(StringTree.Format("umax =", this.m_afFrustum[ViewFrustum.VF_UMAX.Value()]));
        pkTree.Append(StringTree.Format("rmin =", this.m_afFrustum[ViewFrustum.VF_RMIN.Value()]));
        pkTree.Append(StringTree.Format("rmax =", this.m_afFrustum[ViewFrustum.VF_RMAX.Value()]));
        pkTree.Append(StringTree.Format("port L =", this.m_fPortL));
        pkTree.Append(StringTree.Format("port R =", this.m_fPortR));
        pkTree.Append(StringTree.Format("port T =", this.m_fPortT));
        pkTree.Append(StringTree.Format("port B =", this.m_fPortB));
        pkTree.Append(StringTree.Format("port N =", this.m_fPortN));
        pkTree.Append(StringTree.Format("port F =", this.m_fPortF));
        return pkTree;
    }

    public void SetAxes(Vector3f rkDVector, Vector3f rkUVector, Vector3f rkRVector) {
        this.m_kDVector = rkDVector;
        this.m_kUVector = rkUVector;
        this.m_kRVector = rkRVector;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnFrameChange();
        }
    }

    public void SetDepthRange(float fNear, float fFar) {
        this.m_fPortN = fNear;
        this.m_fPortF = fFar;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnDepthRangeChange();
        }
    }

    public void SetFrame(Vector3f rkLocation, Vector3f rkDVector, Vector3f rkUVector, Vector3f rkRVector) {
        this.m_kLocation = rkLocation;
        this.m_kDVector = rkDVector;
        this.m_kUVector = rkUVector;
        this.m_kRVector = rkRVector;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnFrameChange();
        }
    }

    public void SetFrustum(float fUpFovDegrees, float fAspectRatio, float fDMin, float fDMax) {
        float fHalfAngleRadians = 0.5f * fUpFovDegrees * ((float)Math.PI / 180);
        this.m_afFrustum[ViewFrustum.VF_UMAX.Value()] = (float)((double)fDMin * Math.tan(fHalfAngleRadians));
        this.m_afFrustum[ViewFrustum.VF_RMAX.Value()] = fAspectRatio * this.m_afFrustum[ViewFrustum.VF_UMAX.Value()];
        this.m_afFrustum[ViewFrustum.VF_UMIN.Value()] = -this.m_afFrustum[ViewFrustum.VF_UMAX.Value()];
        this.m_afFrustum[ViewFrustum.VF_RMIN.Value()] = -this.m_afFrustum[ViewFrustum.VF_RMAX.Value()];
        this.m_afFrustum[ViewFrustum.VF_DMIN.Value()] = fDMin;
        this.m_afFrustum[ViewFrustum.VF_DMAX.Value()] = fDMax;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnFrustumChange();
        }
    }

    public void SetFrustum(float fRMin, float fRMax, float fUMin, float fUMax, float fDMin, float fDMax) {
        this.m_afFrustum[ViewFrustum.VF_DMIN.Value()] = fDMin;
        this.m_afFrustum[ViewFrustum.VF_DMAX.Value()] = fDMax;
        this.m_afFrustum[ViewFrustum.VF_UMIN.Value()] = fUMin;
        this.m_afFrustum[ViewFrustum.VF_UMAX.Value()] = fUMax;
        this.m_afFrustum[ViewFrustum.VF_RMIN.Value()] = fRMin;
        this.m_afFrustum[ViewFrustum.VF_RMAX.Value()] = fRMax;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnFrustumChange();
        }
    }

    public void SetLocation(Vector3f rkLocation) {
        this.m_kLocation = rkLocation;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnFrameChange();
        }
    }

    public void SetViewport(float fLeft, float fRight, float fTop, float fBottom) {
        this.m_fPortL = fLeft;
        this.m_fPortR = fRight;
        this.m_fPortT = fTop;
        this.m_fPortB = fBottom;
        if (this.m_pkRenderer != null) {
            this.m_pkRenderer.OnViewportChange();
        }
    }

    public static enum ViewFrustum {
        VF_DMIN(0),
        VF_DMAX(1),
        VF_UMIN(2),
        VF_UMAX(3),
        VF_RMIN(4),
        VF_RMAX(5),
        VF_QUANTITY(6);

        private final int m_iValue;

        private ViewFrustum(int iValue) {
            this.m_iValue = iValue;
        }

        public int Value() {
            return this.m_iValue;
        }
    }
}

