/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;

public class MaterialState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -8201992892833690688L;
    public ColorRGB Emissive = new ColorRGB(0.0f, 0.0f, 0.0f);
    public ColorRGB Ambient = new ColorRGB(0.2f, 0.2f, 0.2f);
    public ColorRGB Diffuse = new ColorRGB(0.8f, 0.8f, 0.8f);
    public ColorRGB Specular = new ColorRGB(0.0f, 0.0f, 0.0f);
    public float Alpha = 1.0f;
    public float Shininess = 1.0f;

    @Override
    public void dispose() {
        this.Emissive = null;
        this.Ambient = null;
        this.Diffuse = null;
        this.Specular = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + 3 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.MATERIAL;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.Emissive);
        rkStream.Read(this.Ambient);
        rkStream.Read(this.Diffuse);
        rkStream.Read(this.Specular);
        this.Alpha = rkStream.ReadFloat();
        this.Shininess = rkStream.ReadFloat();
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Emissive);
        rkStream.Write(this.Ambient);
        rkStream.Write(this.Diffuse);
        rkStream.Write(this.Specular);
        rkStream.Write(this.Alpha);
        rkStream.Write(this.Shininess);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("MaterialState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("emissive =", this.Emissive));
        pkTree.Append(StringTree.Format("ambient =", this.Ambient));
        pkTree.Append(StringTree.Format("diffuse =", this.Diffuse));
        pkTree.Append(StringTree.Format("alpha =", this.Alpha));
        pkTree.Append(StringTree.Format("shininess =", this.Shininess));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.MATERIAL.Value()]) {
            MaterialState.DefaultInitialized[GlobalState.StateType.MATERIAL.Value()] = true;
            MaterialState.Default[GlobalState.StateType.MATERIAL.Value()] = new MaterialState();
        }
    }
}

