/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Matrix4f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.Rendering.AlphaState;
import WildMagic.LibGraphics.Rendering.Bindable;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.Rendering.CullState;
import WildMagic.LibGraphics.Rendering.FrameBuffer;
import WildMagic.LibGraphics.Rendering.GlobalState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.Rendering.MaterialState;
import WildMagic.LibGraphics.Rendering.PolygonOffsetState;
import WildMagic.LibGraphics.Rendering.ReleaseFunction;
import WildMagic.LibGraphics.Rendering.ReleaseFunctionIBuffer;
import WildMagic.LibGraphics.Rendering.ReleaseFunctionPixel;
import WildMagic.LibGraphics.Rendering.ReleaseFunctionTexture;
import WildMagic.LibGraphics.Rendering.ReleaseFunctionVertex;
import WildMagic.LibGraphics.Rendering.ResourceIdentifier;
import WildMagic.LibGraphics.Rendering.StencilState;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Rendering.WireframeState;
import WildMagic.LibGraphics.Rendering.ZBufferState;
import WildMagic.LibGraphics.SceneGraph.Attributes;
import WildMagic.LibGraphics.SceneGraph.Geometry;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.Node;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import WildMagic.LibGraphics.SceneGraph.VisibleObject;
import WildMagic.LibGraphics.SceneGraph.VisibleSet;
import WildMagic.LibGraphics.Shaders.CompiledProgramCatalog;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.RendererConstant;
import WildMagic.LibGraphics.Shaders.SamplerInformation;
import WildMagic.LibGraphics.Shaders.UserConstant;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class Renderer
implements Serializable {
    private static final long serialVersionUID = -3189264957800935141L;
    public ReleaseFunction m_kReleaseFunction;
    protected int m_iMaxLights;
    protected int m_iMaxColors;
    protected int m_iMaxTCoords;
    protected int m_iMax3DTexSize;
    protected int m_iMaxVShaderImages;
    protected int m_iMaxPShaderImages;
    protected int m_iMaxStencilIndices;
    protected int m_iMaxUserClipPlanes;
    protected FrameBuffer.FormatType m_eFormat;
    protected FrameBuffer.DepthType m_eDepth;
    protected FrameBuffer.StencilType m_eStencil;
    protected FrameBuffer.BufferingType m_eBuffering;
    protected FrameBuffer.MultisamplingType m_eMultisampling;
    protected int m_iWidth;
    protected int m_iHeight;
    protected ColorRGBA m_kBackgroundColor;
    protected boolean m_bAllowRed;
    protected boolean m_bAllowGreen;
    protected boolean m_bAllowBlue;
    protected boolean m_bAllowAlpha;
    protected Camera m_pkCamera;
    protected GlobalState[] m_aspkState = new GlobalState[GlobalState.StateType.MAX_STATE_TYPE.Value()];
    protected GraphicsObject[] m_aspkLight;
    protected Camera m_pkProjector;
    protected Geometry m_pkGeometry;
    protected Matrix4f m_kWorldMatrix;
    protected Matrix4f m_kSaveWorldMatrix;
    protected Matrix4f m_kViewMatrix = new Matrix4f();
    protected Matrix4f m_kSaveViewMatrix;
    protected Matrix4f m_kProjectionMatrix;
    protected Matrix4f m_kSaveProjectionMatrix;
    private Matrix4f m_kTemp = new Matrix4f();
    protected int m_iFontID;
    protected boolean m_bReverseCullFace;
    protected boolean m_bFullscreen;
    protected float m_fPointSize = 1.0f;
    protected float m_fLineWidth = 1.0f;
    protected int m_iLineStippleRepeat = 0;
    protected short m_usLineStipplePattern = 0;
    final int iMaxTuples = 64;
    int[][] aaiStack = new int[64][2];
    Matrix4f m_kConstantMatrix = new Matrix4f();
    protected boolean m_bTextureLoadFail = false;

    protected Renderer(FrameBuffer.FormatType eFormat, FrameBuffer.DepthType eDepth, FrameBuffer.StencilType eStencil, FrameBuffer.BufferingType eBuffering, FrameBuffer.MultisamplingType eMultisampling, int iWidth, int iHeight) {
        this.m_eFormat = eFormat;
        this.m_eDepth = eDepth;
        this.m_eStencil = eStencil;
        this.m_eBuffering = eBuffering;
        this.m_eMultisampling = eMultisampling;
        this.m_iWidth = iWidth;
        this.m_iHeight = iHeight;
        this.m_kBackgroundColor = new ColorRGBA(ColorRGBA.WHITE);
        this.m_kWorldMatrix = new Matrix4f(Matrix4f.IDENTITY);
        this.m_kSaveWorldMatrix = new Matrix4f(Matrix4f.IDENTITY);
        this.m_kViewMatrix = new Matrix4f(Matrix4f.IDENTITY);
        this.m_kSaveViewMatrix = new Matrix4f(Matrix4f.IDENTITY);
        this.m_kProjectionMatrix = new Matrix4f(Matrix4f.IDENTITY);
        this.m_kSaveProjectionMatrix = new Matrix4f(Matrix4f.IDENTITY);
    }

    public void Activate() {
        this.SetBackgroundColor(this.m_kBackgroundColor);
        this.OnViewportChange();
        this.OnFrustumChange();
        if (this.m_pkCamera != null) {
            this.OnFrameChange();
        }
    }

    public boolean ApplyEffect(ShaderEffect pkEffect, boolean rbPrimaryEffect) {
        int iPassQuantity = pkEffect.GetPassQuantity();
        for (int iPass = 0; iPass < iPassQuantity; ++iPass) {
            Attributes rkOAttr;
            int iTexture;
            pkEffect.LoadPrograms(this, iPass, this.m_iMaxColors, this.m_iMaxTCoords, this.m_iMaxVShaderImages, this.m_iMaxPShaderImages);
            pkEffect.SetGlobalState(iPass, this, rbPrimaryEffect);
            Program pkCProgram = pkEffect.GetCProgram(iPass);
            if (pkCProgram.GetUC("iPass") != null) {
                pkCProgram.GetUC("iPass").SetData(0, iPassQuantity - iPass);
            }
            if (pkCProgram.GetUC("iPassQuantity") != null) {
                pkCProgram.GetUC((String)"iPassQuantity").GetData()[0] = iPassQuantity;
            }
            this.EnableVProgram(pkCProgram);
            int iPTQuantity = pkEffect.GetTextureQuantity(iPass);
            for (iTexture = 0; iTexture < iPTQuantity; ++iTexture) {
                this.EnableTexture(pkEffect.GetTexture(iPass, iTexture), pkEffect.GetSamplerInformation(iPass, iTexture));
            }
            Attributes rkIAttr = pkCProgram.GetInputAttributes();
            ResourceIdentifier pkID = this.EnableVBuffer(rkIAttr, rkOAttr = pkCProgram.GetOutputAttributes());
            if (pkID != null) {
                this.DrawElements();
                this.DisableVBuffer(pkID);
            }
            for (iTexture = 0; iTexture < iPTQuantity; ++iTexture) {
                this.DisableTexture(pkEffect.GetTexture(iPass, iTexture));
            }
            this.DisableVProgram(pkCProgram);
            pkEffect.RestoreGlobalState(iPass, this, rbPrimaryEffect);
        }
        rbPrimaryEffect = false;
        return rbPrimaryEffect;
    }

    public boolean BeginScene() {
        return true;
    }

    public abstract void ClearBackBuffer();

    public abstract void ClearBackBuffer(int var1, int var2, int var3, int var4);

    public abstract void ClearBuffers();

    public abstract void ClearBuffers(int var1, int var2, int var3, int var4);

    public abstract void ClearColorDepth();

    public abstract void ClearStencilBuffer();

    public abstract void ClearStencilBuffer(int var1, int var2, int var3, int var4);

    public abstract void ClearZBuffer();

    public abstract void ClearZBuffer(int var1, int var2, int var3, int var4);

    public abstract Program CompilePrograms(Program var1, Program var2);

    public void DisableIBuffer() {
        if (this.m_pkGeometry.IBuffer == null) {
            return;
        }
        IndexBuffer pkIBuffer = this.m_pkGeometry.IBuffer;
        ResourceIdentifier pkID = pkIBuffer.GetIdentifier(this);
        assert (pkID != null);
        this.OnDisableIBuffer(pkID);
    }

    public void DisablePProgram(Program pkPProgram) {
        assert (pkPProgram != null);
        ResourceIdentifier pkID = pkPProgram.GetIdentifier(this);
        assert (pkID != null);
        this.OnDisablePProgram(pkID);
    }

    public void DisablePrograms(Program pkVProgram, Program pkPProgram) {
        Program kCompiledProgram = CompiledProgramCatalog.GetActive().Find(pkVProgram.GetShaderID(), pkPProgram.GetShaderID());
        if (kCompiledProgram == null) {
            this.DisableVProgram(pkVProgram);
            this.DisablePProgram(pkVProgram);
        } else {
            this.DisableVProgram(kCompiledProgram);
        }
    }

    public void DisableTexture(Texture pkTexture) {
        ResourceIdentifier pkID = pkTexture.GetIdentifier(this);
        assert (pkID != null);
        this.OnDisableTexture(pkID);
    }

    public abstract void DisableUserClipPlane(int var1);

    public void DisableVBuffer(ResourceIdentifier pkID) {
        this.OnDisableVBuffer(pkID);
    }

    public void DisableVProgram(Program pkVProgram) {
        assert (pkVProgram != null);
        ResourceIdentifier pkID = pkVProgram.GetIdentifier(this);
        assert (pkID != null);
        this.OnDisableVProgram(pkID);
    }

    public abstract void DisplayBackBuffer();

    public void dispose() {
        this.m_kBackgroundColor = null;
        this.m_kWorldMatrix = null;
        this.m_kSaveWorldMatrix = null;
        this.m_kViewMatrix = null;
        this.m_kSaveViewMatrix = null;
        this.m_kProjectionMatrix = null;
        this.m_kSaveProjectionMatrix = null;
        if (this.m_aspkState != null) {
            for (int i = 0; i < GlobalState.StateType.MAX_STATE_TYPE.Value(); ++i) {
                if (this.m_aspkState[i] == null) continue;
                this.m_aspkState[i].dispose();
                this.m_aspkState[i] = null;
            }
            this.m_aspkState = null;
        }
        this.m_aspkLight = null;
    }

    public abstract void Draw(byte[] var1);

    public void Draw(Geometry pkGeometry) {
        this.m_pkGeometry = pkGeometry;
        this.SetGlobalState(this.m_pkGeometry.States);
        this.SetWorldTransformation();
        this.EnableIBuffer();
        boolean bPrimaryEffect = true;
        int iMin = this.m_pkGeometry.GetStartEffect();
        int iMax = this.m_pkGeometry.GetEffectQuantity();
        for (int i = iMin; i < iMax; ++i) {
            ShaderEffect pkEffect = (ShaderEffect)this.m_pkGeometry.GetEffect(i);
            if (pkEffect == null) continue;
            bPrimaryEffect = this.ApplyEffect(pkEffect, bPrimaryEffect);
        }
        this.DisableIBuffer();
        this.RestoreWorldTransformation();
        this.RestoreGlobalState(this.m_pkGeometry.States);
        this.m_pkGeometry = null;
    }

    public abstract void Draw(int var1, int var2, ColorRGBA var3, char[] var4);

    public abstract void Draw(float var1, float var2, float var3, ColorRGBA var4, char[] var5);

    public abstract void DrawElements();

    public abstract void DrawLeft();

    public abstract void DrawRight();

    public abstract void DrawDefault();

    public void DrawScene(VisibleSet rkVisibleSet) {
        int iTop = -1;
        int iVisibleQuantity = rkVisibleSet.GetQuantity();
        VisibleObject[] akVisible = rkVisibleSet.GetVisible();
        for (int i = 0; i < iVisibleQuantity; ++i) {
            if (akVisible[i].Object != null) {
                if (akVisible[i].GlobalEffect != null) {
                    assert (++iTop < 64);
                    this.aaiStack[iTop][0] = i;
                    this.aaiStack[iTop][1] = i;
                    continue;
                }
                if (iTop == -1) {
                    this.Draw((Geometry)akVisible[i].Object);
                    continue;
                }
                int[] nArray = this.aaiStack[iTop];
                nArray[1] = nArray[1] + 1;
                continue;
            }
            assert (akVisible[i].GlobalEffect == null);
            int jMin = this.aaiStack[iTop][0];
            int jMax = this.aaiStack[iTop][1];
            akVisible[jMin].GlobalEffect.Draw(this, akVisible[jMin].Object, jMin + 1, jMax, akVisible);
            if (--iTop < 0) continue;
            this.aaiStack[iTop][1] = jMax + 1;
        }
    }

    public void EnableIBuffer() {
        if (this.m_pkGeometry.IBuffer == null) {
            return;
        }
        IndexBuffer pkIBuffer = this.m_pkGeometry.IBuffer;
        this.LoadIBuffer(pkIBuffer);
        ResourceIdentifier pkID = pkIBuffer.GetIdentifier(this);
        assert (pkID != null);
        this.OnEnableIBuffer(pkID);
    }

    public void EnablePProgram(Program pkPProgram) {
        int i;
        assert (pkPProgram != null);
        this.LoadPProgram(pkPProgram);
        ResourceIdentifier pkID = pkPProgram.GetIdentifier(this);
        assert (pkID != null);
        this.OnEnablePProgram(pkID);
        for (i = 0; i < pkPProgram.GetRCQuantity(); ++i) {
            RendererConstant pkRC = pkPProgram.GetRC(i);
            assert (pkRC != null);
            this.SetRendererConstant(pkRC.GetType(), pkRC.GetData());
            this.SetPProgramConstant(ConstantType.CT_RENDERER, pkRC.GetType(), pkRC.GetBaseRegister(), pkRC.GetRegisterQuantity(), pkRC.GetNumFloats(), pkRC.GetData());
        }
        for (i = 0; i < pkPProgram.GetUCQuantity(); ++i) {
            UserConstant pkUC = pkPProgram.GetUC(i);
            assert (pkUC != null);
            this.SetPProgramConstant(ConstantType.CT_USER, RendererConstant.Type.MAX_TYPES, pkUC.GetBaseRegister(), pkUC.GetRegisterQuantity(), pkUC.GetDataSize(), pkUC.GetData());
        }
    }

    public void EnablePrograms(Program pkVProgram, Program pkPProgram) {
        if (pkVProgram == pkPProgram) {
            this.EnableVProgram(pkVProgram);
            return;
        }
        Program kCompiledProgram = CompiledProgramCatalog.GetActive().Find(pkVProgram.GetShaderID(), pkPProgram.GetShaderID());
        if (kCompiledProgram == null) {
            this.EnableVProgram(pkVProgram);
            this.EnablePProgram(pkPProgram);
        } else {
            this.EnableVProgram(kCompiledProgram);
        }
    }

    public void EnableTexture(Texture pkTexture, SamplerInformation pkSI) {
        assert (pkTexture != null);
        this.LoadTexture(pkTexture);
        ResourceIdentifier pkID = pkTexture.GetIdentifier(this);
        assert (pkID != null);
        this.OnEnableTexture(pkID, pkSI);
    }

    public abstract void EnableUserClipPlane(int var1, Plane3f var2);

    public abstract ResourceIdentifier EnableVBuffer(Attributes var1, Attributes var2);

    public void EnableVProgram(Program pkVProgram) {
        int i;
        assert (pkVProgram != null);
        ResourceIdentifier pkID = this.LoadVProgram(pkVProgram);
        assert (pkID != null);
        this.OnEnableVProgram(pkID);
        for (i = 0; i < pkVProgram.GetRCQuantity(); ++i) {
            RendererConstant pkRC = pkVProgram.GetRC(i);
            assert (pkRC != null);
            this.SetRendererConstant(pkRC.GetType(), pkRC.GetData());
            this.SetVProgramConstant(ConstantType.CT_RENDERER, pkRC.GetType(), pkRC.GetBaseRegister(), pkRC.GetRegisterQuantity(), pkRC.GetNumFloats(), pkRC.GetData());
        }
        for (i = 0; i < pkVProgram.GetUCQuantity(); ++i) {
            UserConstant pkUC = pkVProgram.GetUC(i);
            assert (pkUC != null);
            this.SetVProgramConstant(ConstantType.CT_USER, RendererConstant.Type.MAX_TYPES, pkUC.GetBaseRegister(), pkUC.GetRegisterQuantity(), pkUC.GetDataSize(), pkUC.GetData());
        }
    }

    public void EndScene() {
    }

    public abstract void Finish();

    public abstract void FrameBufferToTexSubImage3D(Texture var1, int var2, boolean var3);

    public abstract void FrameBufferToTexSubImage3D(Texture var1, int var2);

    public abstract void FrameBufferToTexture(Texture var1);

    public final AlphaState GetAlphaState() {
        return (AlphaState)this.m_aspkState[GlobalState.StateType.ALPHA.Value()];
    }

    public final ColorRGBA GetBackgroundColor() {
        return this.m_kBackgroundColor;
    }

    public final FrameBuffer.BufferingType GetBufferingType() {
        return this.m_eBuffering;
    }

    public final Camera GetCamera() {
        return this.m_pkCamera;
    }

    public void GetColorMask(boolean[] rbAllowColor) {
        rbAllowColor[0] = this.m_bAllowRed;
        rbAllowColor[1] = this.m_bAllowGreen;
        rbAllowColor[2] = this.m_bAllowBlue;
        rbAllowColor[3] = this.m_bAllowAlpha;
    }

    public abstract char GetCommentCharacter();

    public final CullState GetCullState() {
        return (CullState)this.m_aspkState[GlobalState.StateType.CULL.Value()];
    }

    public final FrameBuffer.DepthType GetDepthType() {
        return this.m_eDepth;
    }

    public abstract int GetDrawBuffer();

    public abstract String GetExtension();

    public final FrameBuffer.FormatType GetFormatType() {
        return this.m_eFormat;
    }

    public final Geometry GetGeometry() {
        return this.m_pkGeometry;
    }

    public final int GetHeight() {
        return this.m_iHeight;
    }

    public Light GetLight(int i) {
        assert (0 <= i && i < this.m_iMaxLights);
        return (Light)this.m_aspkLight[i];
    }

    public final short GetLineStipplePattern() {
        return this.m_usLineStipplePattern;
    }

    public final int GetLineStippleRepeat() {
        return this.m_iLineStippleRepeat;
    }

    public final float GetLineWidth() {
        return this.m_fLineWidth;
    }

    public final MaterialState GetMaterialState() {
        return (MaterialState)this.m_aspkState[GlobalState.StateType.MATERIAL.Value()];
    }

    public final int GetMaxColors() {
        return this.m_iMaxColors;
    }

    public final int GetMaxLights() {
        return this.m_iMaxLights;
    }

    public final int GetMaxPShaderImages() {
        return this.m_iMaxPShaderImages;
    }

    public final int GetMaxStencilIndices() {
        return this.m_iMaxStencilIndices;
    }

    public final int GetMaxTCoords() {
        return this.m_iMaxTCoords;
    }

    public final int GetMaxUserClipPlanes() {
        return this.m_iMaxUserClipPlanes;
    }

    public final int GetMaxVShaderImages() {
        return this.m_iMaxVShaderImages;
    }

    public final FrameBuffer.MultisamplingType GetMultisamplingType() {
        return this.m_eMultisampling;
    }

    public abstract ColorRGBA GetPixelColor(int var1, int var2);

    public final float GetPointSize() {
        return this.m_fPointSize;
    }

    public final PolygonOffsetState GetPolygonOffsetState() {
        return (PolygonOffsetState)this.m_aspkState[GlobalState.StateType.POLYGONOFFSET.Value()];
    }

    public Camera GetProjector() {
        return this.m_pkProjector;
    }

    public final boolean GetReverseCullFace() {
        return this.m_bReverseCullFace;
    }

    public abstract ByteBuffer GetScreenImage(int var1, int var2);

    public abstract int[] GetSizeOnScreen(char[] var1);

    public final StencilState GetStencilState() {
        return (StencilState)this.m_aspkState[GlobalState.StateType.STENCIL.Value()];
    }

    public final FrameBuffer.StencilType GetStencilType() {
        return this.m_eStencil;
    }

    public abstract void GetTexImage(Texture var1);

    public void GetTransform(Matrix4f rkMat, int iOperation, float[] afData) {
        if (iOperation == 0) {
            rkMat.GetData(afData);
        } else if (iOperation == 1) {
            this.m_kTemp.Transpose(rkMat);
            this.m_kTemp.GetData(afData);
        } else if (iOperation == 2) {
            this.m_kTemp.Inverse(rkMat);
            this.m_kTemp.GetData(afData);
        } else {
            this.m_kTemp.Inverse(rkMat);
            this.m_kTemp.Transpose();
            this.m_kTemp.GetData(afData);
        }
    }

    public abstract boolean GetUnique();

    public abstract Attributes GetVBufferInputAttributes(Bindable var1);

    public final int GetWidth() {
        return this.m_iWidth;
    }

    public final WireframeState GetWireframeState() {
        return (WireframeState)this.m_aspkState[GlobalState.StateType.WIREFRAME.Value()];
    }

    public final ZBufferState GetZBufferState() {
        return (ZBufferState)this.m_aspkState[GlobalState.StateType.ZBUFFER.Value()];
    }

    public abstract void InitializeState();

    public boolean IsActive() {
        return true;
    }

    public void LoadAllResources(Spatial pkScene) {
        if (pkScene instanceof Geometry) {
            this.LoadResources((Geometry)pkScene);
            return;
        }
        Node pkNode = (Node)pkScene;
        if (pkNode != null) {
            for (int i = 0; i < pkNode.GetQuantity(); ++i) {
                Spatial pkChild = pkNode.GetChild(i);
                if (pkChild == null) continue;
                this.LoadAllResources(pkChild);
            }
        }
    }

    public void LoadIBuffer(IndexBuffer pkIBuffer) {
        if (pkIBuffer == null) {
            return;
        }
        ResourceIdentifier pkID = pkIBuffer.GetIdentifier(this);
        if (pkID == null) {
            pkID = this.OnLoadIBuffer(pkIBuffer);
            pkIBuffer.OnLoad(this, new ReleaseFunctionIBuffer(this), pkID);
        }
    }

    public void LoadPProgram(Program pkPProgram) {
        if (pkPProgram == null) {
            return;
        }
        ResourceIdentifier pkID = pkPProgram.GetIdentifier(this);
        if (pkID == null) {
            pkID = this.OnLoadPProgram(pkPProgram);
            pkPProgram.OnLoad(this, new ReleaseFunctionPixel(this), pkID);
        }
    }

    public void LoadResources(Effect pkEffect) {
        assert (pkEffect != null);
        pkEffect.LoadResources(this, null);
    }

    public void LoadResources(Geometry pkGeometry) {
        assert (pkGeometry != null);
        assert (pkGeometry.VBuffer != null);
        assert (pkGeometry.IBuffer != null);
        this.LoadIBuffer(pkGeometry.IBuffer);
        int iEffectQuantity = pkGeometry.GetEffectQuantity();
        for (int i = 0; i < iEffectQuantity; ++i) {
            Effect pkEffect = pkGeometry.GetEffect(i);
            pkEffect.LoadResources(this, pkGeometry);
        }
    }

    public boolean LoadTexture(Texture pkTexture) {
        this.m_bTextureLoadFail = false;
        if (pkTexture == null) {
            return false;
        }
        ResourceIdentifier pkID = pkTexture.GetIdentifier(this);
        if (pkID == null) {
            pkID = this.OnLoadTexture(pkTexture);
            pkTexture.OnLoad(this, new ReleaseFunctionTexture(this), pkID);
        } else if (pkTexture.Reload()) {
            this.OnReloadTexture(pkID);
            pkTexture.Reload(false);
        }
        return !this.m_bTextureLoadFail;
    }

    public abstract ResourceIdentifier LoadVBuffer(Attributes var1, Attributes var2, VertexBuffer var3);

    public ResourceIdentifier LoadVProgram(Program pkVProgram) {
        if (pkVProgram == null) {
            return null;
        }
        ResourceIdentifier pkID = pkVProgram.GetIdentifier(this);
        if (pkID == null) {
            pkID = this.OnLoadVProgram(pkVProgram);
            pkVProgram.OnLoad(this, new ReleaseFunctionVertex(this), pkID);
        }
        return pkID;
    }

    public abstract void OnDepthRangeChange();

    public abstract void OnDisableIBuffer(ResourceIdentifier var1);

    public abstract void OnDisablePProgram(ResourceIdentifier var1);

    public abstract void OnDisableTexture(ResourceIdentifier var1);

    public abstract void OnDisableVBuffer(ResourceIdentifier var1);

    public abstract void OnDisableVProgram(ResourceIdentifier var1);

    public abstract void OnEnableIBuffer(ResourceIdentifier var1);

    public abstract void OnEnablePProgram(ResourceIdentifier var1);

    public abstract void OnEnableTexture(ResourceIdentifier var1, SamplerInformation var2);

    public abstract void OnEnableVBuffer(ResourceIdentifier var1);

    public abstract void OnEnableVProgram(ResourceIdentifier var1);

    public void OnFrameChange() {
        if (this.m_pkCamera == null) {
            return;
        }
        Vector3f rkEye = this.m_pkCamera.GetLocation();
        Vector3f rkRVector = this.m_pkCamera.GetRVector();
        Vector3f rkUVector = this.m_pkCamera.GetUVector();
        Vector3f rkDVector = this.m_pkCamera.GetDVector();
        this.m_kViewMatrix.Set(rkRVector.X, rkUVector.X, rkDVector.X, 0.0f, rkRVector.Y, rkUVector.Y, rkDVector.Y, 0.0f, rkRVector.Z, rkUVector.Z, rkDVector.Z, 0.0f, -rkRVector.Dot(rkEye), -rkUVector.Dot(rkEye), -rkDVector.Dot(rkEye), 1.0f);
    }

    public void OnFrustumChange() {
        if (this.m_pkCamera == null) {
            return;
        }
        float fRMin = this.m_pkCamera.GetRMin();
        float fRMax = this.m_pkCamera.GetRMax();
        float fUMin = this.m_pkCamera.GetUMin();
        float fUMax = this.m_pkCamera.GetUMax();
        float fDMin = this.m_pkCamera.GetDMin();
        float fDMax = this.m_pkCamera.GetDMax();
        float fInvRDiff = 1.0f / (fRMax - fRMin);
        float fInvUDiff = 1.0f / (fUMax - fUMin);
        float fInvDDiff = 1.0f / (fDMax - fDMin);
        if (this.m_pkCamera.Perspective) {
            this.m_kProjectionMatrix.Set(2.0f * fDMin * fInvRDiff, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f * fDMin * fInvUDiff, 0.0f, 0.0f, -(fRMin + fRMax) * fInvRDiff, -(fUMin + fUMax) * fInvUDiff, (fDMin + fDMax) * fInvDDiff, 1.0f, 0.0f, 0.0f, -2.0f * fDMax * fDMin * fInvDDiff, 0.0f);
        } else {
            this.m_kProjectionMatrix.Set(2.0f * fInvRDiff, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f * fInvUDiff, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f * fInvDDiff, 0.0f, -(fRMin + fRMax) * fInvRDiff, -(fUMin + fUMax) * fInvUDiff, -(fDMin + fDMax) * fInvDDiff, 1.0f);
        }
    }

    public abstract ResourceIdentifier OnLoadIBuffer(IndexBuffer var1);

    public abstract ResourceIdentifier OnLoadPProgram(Program var1);

    public abstract void OnLoadSubVBuffer(Attributes var1, Attributes var2, VertexBuffer var3, ResourceIdentifier var4);

    public abstract ResourceIdentifier OnLoadTexture(Texture var1);

    public abstract ResourceIdentifier OnLoadVBuffer(Attributes var1, Attributes var2, VertexBuffer var3);

    public abstract ResourceIdentifier OnLoadVProgram(Program var1);

    public abstract void OnReleaseIBuffer(ResourceIdentifier var1);

    public abstract void OnReleasePProgram(ResourceIdentifier var1);

    public abstract void OnReleaseTexture(ResourceIdentifier var1);

    public abstract void OnReleaseVBuffer(ResourceIdentifier var1);

    public abstract void OnReleaseVProgram(ResourceIdentifier var1);

    public abstract void OnReloadTexture(ResourceIdentifier var1);

    public abstract void OnViewportChange();

    public abstract void ParseProgram(Program var1, int var2);

    public abstract Program ReadProgram(String var1, String var2, int var3);

    public void ReleaseAllResources(Spatial pkScene) {
        if (pkScene instanceof Geometry) {
            this.ReleaseResources((Geometry)pkScene);
            return;
        }
        Node pkNode = (Node)pkScene;
        if (pkNode != null) {
            for (int i = 0; i < pkNode.GetQuantity(); ++i) {
                Spatial pkChild = pkNode.GetChild(i);
                if (pkChild == null) continue;
                this.ReleaseAllResources(pkChild);
            }
        }
    }

    public void ReleaseIBuffer(Bindable pkIBuffer) {
        if (pkIBuffer == null) {
            return;
        }
        ResourceIdentifier pkID = pkIBuffer.GetIdentifier(this);
        if (pkID != null) {
            this.OnReleaseIBuffer(pkID);
            pkIBuffer.OnRelease(this, pkID);
        }
    }

    public void ReleasePProgram(Bindable pkPProgram) {
        if (pkPProgram == null) {
            return;
        }
        ResourceIdentifier pkID = pkPProgram.GetIdentifier(this);
        if (pkID != null) {
            this.OnReleasePProgram(pkID);
            pkPProgram.OnRelease(this, pkID);
        }
    }

    public void ReleaseResources(Effect pkEffect) {
        assert (pkEffect != null);
        pkEffect.ReleaseResources(this, null);
    }

    public void ReleaseResources(Geometry pkGeometry) {
        if (pkGeometry == null) {
            return;
        }
        if (pkGeometry.IBuffer != null) {
            this.ReleaseIBuffer(pkGeometry.IBuffer);
        }
        if (pkGeometry.VBuffer != null) {
            while (pkGeometry.VBuffer.GetInfoQuantity() > 0) {
                this.ReleaseVBuffer(pkGeometry.VBuffer);
            }
        }
        int iEffectQuantity = pkGeometry.GetEffectQuantity();
        for (int i = 0; i < iEffectQuantity; ++i) {
            Effect pkEffect = pkGeometry.GetEffect(i);
            pkEffect.ReleaseResources(this, pkGeometry);
        }
    }

    public void ReleaseTexture(Bindable pkTexture) {
        if (pkTexture == null) {
            return;
        }
        ResourceIdentifier pkID = pkTexture.GetIdentifier(this);
        if (pkID != null) {
            this.OnReleaseTexture(pkID);
            pkTexture.OnRelease(this, pkID);
        }
    }

    public void ReleaseVBuffer(Bindable pkVBuffer) {
        if (pkVBuffer == null) {
            return;
        }
        for (int i = 0; i < pkVBuffer.GetInfoQuantity(); ++i) {
            ResourceIdentifier pkID = pkVBuffer.GetIdentifier(i, this);
            if (pkID == null) continue;
            this.OnReleaseVBuffer(pkID);
            pkVBuffer.OnRelease(this, pkID);
            return;
        }
    }

    public void ReleaseVProgram(Bindable pkVProgram) {
        if (pkVProgram == null) {
            return;
        }
        ResourceIdentifier pkID = pkVProgram.GetIdentifier(this);
        if (pkID != null) {
            this.OnReleaseVProgram(pkID);
            pkVProgram.OnRelease(this, pkID);
        }
    }

    public void Resize(int iWidth, int iHeight) {
        this.m_iWidth = iWidth;
        this.m_iHeight = iHeight;
        this.OnViewportChange();
    }

    public void RestoreGlobalState(GlobalState[] aspkState) {
        GlobalState pkState;
        if (aspkState[GlobalState.StateType.ALPHA.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.ALPHA.Value()];
            this.SetAlphaState((AlphaState)pkState);
        }
        if (aspkState[GlobalState.StateType.CULL.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.CULL.Value()];
            this.SetCullState((CullState)pkState);
        }
        if (aspkState[GlobalState.StateType.MATERIAL.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.MATERIAL.Value()];
            this.SetMaterialState((MaterialState)pkState);
        }
        if (aspkState[GlobalState.StateType.POLYGONOFFSET.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.POLYGONOFFSET.Value()];
            this.SetPolygonOffsetState((PolygonOffsetState)pkState);
        }
        if (aspkState[GlobalState.StateType.STENCIL.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.STENCIL.Value()];
            this.SetStencilState((StencilState)pkState);
        }
        if (aspkState[GlobalState.StateType.WIREFRAME.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.WIREFRAME.Value()];
            this.SetWireframeState((WireframeState)pkState);
        }
        if (aspkState[GlobalState.StateType.ZBUFFER.Value()] != null) {
            pkState = GlobalState.Default[GlobalState.StateType.ZBUFFER.Value()];
            this.SetZBufferState((ZBufferState)pkState);
        }
    }

    public void RestorePostWorldTransformation() {
        this.m_kViewMatrix = this.m_kSaveViewMatrix;
    }

    public void RestoreWorldTransformation() {
    }

    public abstract BufferedImage Screenshot();

    public abstract boolean SelectFont(int var1);

    public void SetAlphaState(AlphaState pkState) {
        this.m_aspkState[GlobalState.StateType.ALPHA.Value()] = pkState;
    }

    public void SetBackgroundColor(ColorRGBA rkColor) {
        this.m_kBackgroundColor = rkColor;
    }

    public void SetCamera(Camera pkCamera) {
        if (this.m_pkCamera != null) {
            this.m_pkCamera.m_pkRenderer = null;
        }
        if (pkCamera != null) {
            pkCamera.m_pkRenderer = this;
        }
        this.m_pkCamera = pkCamera;
        if (this.m_pkCamera != null) {
            this.OnFrustumChange();
            this.OnViewportChange();
            this.OnFrameChange();
        }
    }

    public void SetColorMask(boolean bAllowRed, boolean bAllowGreen, boolean bAllowBlue, boolean bAllowAlpha) {
        this.m_bAllowRed = bAllowRed;
        this.m_bAllowGreen = bAllowGreen;
        this.m_bAllowBlue = bAllowBlue;
        this.m_bAllowAlpha = bAllowAlpha;
    }

    public void SetConstantCameraModelDirection(int iPlaceHolder, float[] afData) {
        Vector3f kMDVector = this.m_pkGeometry.World.InvertVector(this.m_pkCamera.GetDVector());
        afData[0] = kMDVector.X;
        afData[1] = kMDVector.Y;
        afData[2] = kMDVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantCameraModelPosition(int iPlaceHolder, float[] afData) {
        Vector3f kMLocation = new Vector3f();
        this.m_pkGeometry.World.ApplyInverse(this.m_pkCamera.GetLocation(), kMLocation);
        afData[0] = kMLocation.X;
        afData[1] = kMLocation.Y;
        afData[2] = kMLocation.Z;
        afData[3] = 1.0f;
        kMLocation = null;
    }

    public void SetConstantCameraModelRight(int iPlaceHolder, float[] afData) {
        Vector3f kMRVector = this.m_pkGeometry.World.InvertVector(this.m_pkCamera.GetRVector());
        afData[0] = kMRVector.X;
        afData[1] = kMRVector.Y;
        afData[2] = kMRVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantCameraModelUp(int iPlaceHolder, float[] afData) {
        Vector3f kMUVector = this.m_pkGeometry.World.InvertVector(this.m_pkCamera.GetUVector());
        afData[0] = kMUVector.X;
        afData[1] = kMUVector.Y;
        afData[2] = kMUVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantCameraWorldDirection(int iPlaceHolder, float[] afData) {
        Vector3f kWDVector = this.m_pkCamera.GetDVector();
        afData[0] = kWDVector.X;
        afData[1] = kWDVector.Y;
        afData[2] = kWDVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantCameraWorldPosition(int iPlaceHolder, float[] afData) {
        Vector3f kWLocation = this.m_pkCamera.GetLocation();
        afData[0] = kWLocation.X;
        afData[1] = kWLocation.Y;
        afData[2] = kWLocation.Z;
        afData[3] = 1.0f;
    }

    public void SetConstantCameraWorldRight(int iPlaceHolder, float[] afData) {
        Vector3f kWRVector = this.m_pkCamera.GetRVector();
        afData[0] = kWRVector.X;
        afData[1] = kWRVector.Y;
        afData[2] = kWRVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantCameraWorldUp(int iPlaceHolder, float[] afData) {
        Vector3f kWUVector = this.m_pkCamera.GetUVector();
        afData[0] = kWUVector.X;
        afData[1] = kWUVector.Y;
        afData[2] = kWUVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantLightAmbient(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        assert (pkLight != null);
        afData[0] = pkLight.Ambient.R;
        afData[1] = pkLight.Ambient.G;
        afData[2] = pkLight.Ambient.B;
        afData[3] = 1.0f;
    }

    public void SetConstantLightAttenuation(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            afData[0] = pkLight.Constant;
            afData[1] = pkLight.Linear;
            afData[2] = pkLight.Quadratic;
            afData[3] = pkLight.Intensity;
        } else {
            afData[0] = 1.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 1.0f;
        }
    }

    public void SetConstantLightDiffuse(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            afData[0] = pkLight.Diffuse.R;
            afData[1] = pkLight.Diffuse.G;
            afData[2] = pkLight.Diffuse.B;
            afData[3] = 1.0f;
        } else {
            afData[0] = 0.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 1.0f;
        }
    }

    public void SetConstantLightModelDirection(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            Vector3f kMDVector = this.m_pkGeometry.World.InvertVector(pkLight.DVector);
            afData[0] = kMDVector.X;
            afData[1] = kMDVector.Y;
            afData[2] = kMDVector.Z;
            afData[3] = 0.0f;
        } else {
            afData[0] = 0.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 0.0f;
        }
    }

    public void SetConstantLightModelPosition(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            Vector3f kMPosition = new Vector3f();
            this.m_pkGeometry.World.ApplyInverse(pkLight.Position, kMPosition);
            afData[0] = kMPosition.X;
            afData[1] = kMPosition.Y;
            afData[2] = kMPosition.Z;
            afData[3] = 1.0f;
            kMPosition = null;
        } else {
            afData[0] = 0.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 1.0f;
        }
    }

    public void SetConstantLightSpecular(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        assert (pkLight != null);
        afData[0] = pkLight.Specular.R;
        afData[1] = pkLight.Specular.G;
        afData[2] = pkLight.Specular.B;
        afData[3] = 1.0f;
    }

    public void SetConstantLightSpotCutoff(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            afData[0] = pkLight.Angle;
            afData[1] = pkLight.CosAngle;
            afData[2] = pkLight.SinAngle;
            afData[3] = pkLight.Exponent;
        } else {
            afData[0] = (float)Math.PI;
            afData[1] = -1.0f;
            afData[2] = 0.0f;
            afData[3] = 1.0f;
        }
    }

    public void SetConstantLightWorldDirection(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            afData[0] = pkLight.DVector.X;
            afData[1] = pkLight.DVector.Y;
            afData[2] = pkLight.DVector.Z;
            afData[3] = 0.0f;
        } else {
            afData[0] = 0.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 0.0f;
        }
    }

    public void SetConstantLightWorldPosition(int iLight, float[] afData) {
        Light pkLight = this.GetLight(iLight);
        if (pkLight != null) {
            afData[0] = pkLight.Position.X;
            afData[1] = pkLight.Position.Y;
            afData[2] = pkLight.Position.Z;
            afData[3] = 1.0f;
        } else {
            afData[0] = 0.0f;
            afData[1] = 0.0f;
            afData[2] = 0.0f;
            afData[3] = 1.0f;
        }
    }

    public void SetConstantMaterialAmbient(int iPlaceHolder, float[] afData) {
        MaterialState pkMaterial = (MaterialState)this.m_aspkState[GlobalState.StateType.MATERIAL.Value()];
        afData[0] = pkMaterial.Ambient.R;
        afData[1] = pkMaterial.Ambient.G;
        afData[2] = pkMaterial.Ambient.B;
        afData[3] = 1.0f;
    }

    public void SetConstantMaterialDiffuse(int iPlaceHolder, float[] afData) {
        MaterialState pkMaterial = (MaterialState)this.m_aspkState[GlobalState.StateType.MATERIAL.Value()];
        afData[0] = pkMaterial.Diffuse.R;
        afData[1] = pkMaterial.Diffuse.G;
        afData[2] = pkMaterial.Diffuse.B;
        afData[3] = pkMaterial.Alpha;
    }

    public void SetConstantMaterialEmissive(int iPlaceHolder, float[] afData) {
        MaterialState pkMaterial = (MaterialState)this.m_aspkState[GlobalState.StateType.MATERIAL.Value()];
        afData[0] = pkMaterial.Emissive.R;
        afData[1] = pkMaterial.Emissive.G;
        afData[2] = pkMaterial.Emissive.B;
        afData[3] = 1.0f;
    }

    public void SetConstantMaterialSpecular(int iPlaceHolder, float[] afData) {
        MaterialState pkMaterial = (MaterialState)this.m_aspkState[GlobalState.StateType.MATERIAL.Value()];
        afData[0] = pkMaterial.Specular.R;
        afData[1] = pkMaterial.Specular.G;
        afData[2] = pkMaterial.Specular.B;
        afData[3] = pkMaterial.Shininess;
    }

    public void SetConstantPMatrix(int iOperation, float[] afData) {
        this.GetTransform(this.m_kProjectionMatrix, iOperation, afData);
    }

    public void SetConstantProjectorMatrix(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f rkEye = this.m_pkProjector.GetLocation();
        Vector3f rkRVector = this.m_pkProjector.GetRVector();
        Vector3f rkUVector = this.m_pkProjector.GetUVector();
        Vector3f rkDVector = this.m_pkProjector.GetDVector();
        float fRdE = rkRVector.Dot(rkEye);
        float fUdE = rkUVector.Dot(rkEye);
        float fDdE = rkDVector.Dot(rkEye);
        Matrix4f kProjVMatrix = new Matrix4f(rkRVector.X, rkUVector.X, rkDVector.X, 0.0f, rkRVector.Y, rkUVector.Y, rkDVector.Y, 0.0f, rkRVector.Z, rkUVector.Z, rkDVector.Z, 0.0f, -fRdE, -fUdE, -fDdE, 1.0f);
        float fRMin = this.m_pkProjector.GetRMin();
        float fRMax = this.m_pkProjector.GetRMax();
        float fUMin = this.m_pkProjector.GetUMin();
        float fUMax = this.m_pkProjector.GetUMax();
        float fDMin = this.m_pkProjector.GetDMin();
        float fDMax = this.m_pkProjector.GetDMax();
        float fInvRDiff = 1.0f / (fRMax - fRMin);
        float fInvUDiff = 1.0f / (fUMax - fUMin);
        float fInvDDiff = 1.0f / (fDMax - fDMin);
        float fRTerm0 = fDMin * fInvRDiff;
        float fUTerm0 = fDMin * fInvUDiff;
        float fDTerm0 = fDMin * fInvDDiff;
        float fRTerm1 = -(fRMin + fRMax) * fInvRDiff;
        float fUTerm1 = -(fUMin + fUMax) * fInvUDiff;
        float fDTerm1 = fDMax * fInvDDiff;
        Matrix4f kProjPMatrix = new Matrix4f(2.0f * fRTerm0, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f * fUTerm0, 0.0f, 0.0f, fRTerm1, fUTerm1, fDTerm1, 1.0f, 0.0f, 0.0f, -fDMax * fDTerm0, 0.0f);
        Matrix4f kProjBSMatrix = new Matrix4f(0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.0f, 1.0f);
        Matrix4f kProjectorMatrix = new Matrix4f();
        kProjectorMatrix.Mult(kProjPMatrix, kProjBSMatrix);
        kProjectorMatrix.MultLeft(kProjVMatrix);
        kProjectorMatrix.MultLeft(this.m_kWorldMatrix);
        this.GetTransform(kProjectorMatrix, 0, afData);
    }

    public void SetConstantProjectorModelDirection(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kMDVector = this.m_pkGeometry.World.InvertVector(this.m_pkProjector.GetDVector());
        afData[0] = kMDVector.X;
        afData[1] = kMDVector.Y;
        afData[2] = kMDVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantProjectorModelPosition(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kMLocation = this.m_pkGeometry.World.ApplyInverse(this.m_pkProjector.GetLocation());
        afData[0] = kMLocation.X;
        afData[1] = kMLocation.Y;
        afData[2] = kMLocation.Z;
        afData[3] = 1.0f;
    }

    public void SetConstantProjectorModelRight(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kMRVector = this.m_pkGeometry.World.InvertVector(this.m_pkProjector.GetRVector());
        afData[0] = kMRVector.X;
        afData[1] = kMRVector.Y;
        afData[2] = kMRVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantProjectorModelUp(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kMUVector = this.m_pkGeometry.World.InvertVector(this.m_pkProjector.GetUVector());
        afData[0] = kMUVector.X;
        afData[1] = kMUVector.Y;
        afData[2] = kMUVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantProjectorWorldDirection(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kWDVector = this.m_pkProjector.GetDVector();
        afData[0] = kWDVector.X;
        afData[1] = kWDVector.Y;
        afData[2] = kWDVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantProjectorWorldPosition(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kWLocation = this.m_pkProjector.GetLocation();
        afData[0] = kWLocation.X;
        afData[1] = kWLocation.Y;
        afData[2] = kWLocation.Z;
        afData[3] = 1.0f;
    }

    public void SetConstantProjectorWorldRight(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kWRVector = this.m_pkProjector.GetRVector();
        afData[0] = kWRVector.X;
        afData[1] = kWRVector.Y;
        afData[2] = kWRVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantProjectorWorldUp(int iPlaceHolder, float[] afData) {
        assert (this.m_pkProjector != null);
        Vector3f kWUVector = this.m_pkProjector.GetUVector();
        afData[0] = kWUVector.X;
        afData[1] = kWUVector.Y;
        afData[2] = kWUVector.Z;
        afData[3] = 0.0f;
    }

    public void SetConstantVMatrix(int iOperation, float[] afData) {
        this.GetTransform(this.m_kViewMatrix, iOperation, afData);
    }

    public void SetConstantVPMatrix(int iOperation, float[] afData) {
        this.m_kConstantMatrix.Mult(this.m_kViewMatrix, this.m_kProjectionMatrix);
        this.GetTransform(this.m_kConstantMatrix, iOperation, afData);
    }

    public void SetConstantWMatrix(int iOperation, float[] afData) {
        this.GetTransform(this.m_kWorldMatrix, iOperation, afData);
    }

    public void SetConstantWVMatrix(int iOperation, float[] afData) {
        this.m_kConstantMatrix.Mult(this.m_kWorldMatrix, this.m_kViewMatrix);
        this.GetTransform(this.m_kConstantMatrix, iOperation, afData);
    }

    public void SetConstantWVPMatrix(int iOperation, float[] afData) {
        this.m_kConstantMatrix.Mult(this.m_kViewMatrix, this.m_kProjectionMatrix);
        this.m_kConstantMatrix.Mult(this.m_kWorldMatrix, this.m_kConstantMatrix);
        this.GetTransform(this.m_kConstantMatrix, iOperation, afData);
    }

    public void SetCullState(CullState pkState) {
        this.m_aspkState[GlobalState.StateType.CULL.Value()] = pkState;
    }

    public final void SetGeometry(Geometry pkGeometry) {
        this.m_pkGeometry = pkGeometry;
    }

    public void SetGlobalState(GlobalState[] aspkState) {
        GlobalState pkState = aspkState[GlobalState.StateType.ALPHA.Value()];
        if (pkState != null) {
            this.SetAlphaState((AlphaState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.CULL.Value()]) != null) {
            this.SetCullState((CullState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.MATERIAL.Value()]) != null) {
            this.SetMaterialState((MaterialState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.POLYGONOFFSET.Value()]) != null) {
            this.SetPolygonOffsetState((PolygonOffsetState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.STENCIL.Value()]) != null) {
            this.SetStencilState((StencilState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.WIREFRAME.Value()]) != null) {
            this.SetWireframeState((WireframeState)pkState);
        }
        if ((pkState = aspkState[GlobalState.StateType.ZBUFFER.Value()]) != null) {
            this.SetZBufferState((ZBufferState)pkState);
        }
    }

    public void SetLight(int i, Light pkLight) {
        assert (0 <= i && i < this.m_iMaxLights);
        this.m_aspkLight[i] = pkLight;
    }

    public void SetLineStipple(int iRepeat, short usPattern) {
        if (iRepeat < 0) {
            iRepeat = 0;
        }
        this.m_iLineStippleRepeat = iRepeat;
        this.m_usLineStipplePattern = usPattern;
    }

    public void SetLineWidth(float fWidth) {
        if (fWidth > 0.0f) {
            this.m_fLineWidth = fWidth;
        }
    }

    public void SetMaterialState(MaterialState pkState) {
        this.m_aspkState[GlobalState.StateType.MATERIAL.Value()] = pkState;
    }

    public void SetPointSize(float fSize) {
        if (fSize > 0.0f) {
            this.m_fPointSize = fSize;
        }
    }

    public void SetPolygonOffsetState(PolygonOffsetState pkState) {
        this.m_aspkState[GlobalState.StateType.POLYGONOFFSET.Value()] = pkState;
    }

    public void SetPostWorldTransformation(Matrix4f rkMatrix) {
        this.m_kSaveViewMatrix = this.m_kViewMatrix;
        this.m_kViewMatrix.TransposeTimes(rkMatrix, this.m_kSaveViewMatrix);
    }

    public abstract void SetPProgramConstant(ConstantType var1, RendererConstant.Type var2, int var3, int var4, int var5, float[] var6);

    public void SetProjector(Camera pkProjector) {
        this.m_pkProjector = pkProjector;
    }

    public void SetRendererConstant(RendererConstant.Type eRCType, float[] afData) {
        int iRCType = eRCType.Value();
        if (iRCType <= RendererConstant.Type.WVP_MATRIX_INVERSE_TRANSPOSE.Value()) {
            int iOperation = iRCType / 6;
            int iFunction = iRCType % 6;
            this.SCFunction(iFunction, iOperation, afData);
        } else if (iRCType <= RendererConstant.Type.PROJECTOR_MATRIX.Value()) {
            int iFunction = 6 + iRCType - RendererConstant.Type.MATERIAL_EMISSIVE.Value();
            this.SCFunction(iFunction, 0, afData);
        } else {
            int iDiff = iRCType - RendererConstant.Type.LIGHT0_MODEL_POSITION.Value();
            int iLight = iDiff / 9;
            int iAttribute = iDiff % 9;
            int iFunction = 27 + iAttribute;
            this.SCFunction(iFunction, iLight, afData);
        }
    }

    public void SetReverseCullFace(boolean bReverseCullFace) {
        this.m_bReverseCullFace = bReverseCullFace;
    }

    public void SetStencilState(StencilState pkState) {
        this.m_aspkState[GlobalState.StateType.STENCIL.Value()] = pkState;
    }

    public abstract void SetVProgramConstant(ConstantType var1, RendererConstant.Type var2, int var3, int var4, int var5, float[] var6);

    public void SetWireframeState(WireframeState pkState) {
        this.m_aspkState[GlobalState.StateType.WIREFRAME.Value()] = pkState;
    }

    public void SetWorldTransformation() {
        this.m_kWorldMatrix = this.m_pkGeometry.HWorld;
    }

    public void SetWorldTransformation(Matrix4f kMat) {
        this.m_kWorldMatrix = kMat;
    }

    public void SetZBufferState(ZBufferState pkState) {
        this.m_aspkState[GlobalState.StateType.ZBUFFER.Value()] = pkState;
    }

    public void ToggleFullscreen() {
        this.m_bFullscreen = !this.m_bFullscreen;
    }

    public abstract void UnloadFont(int var1);

    private void SCFunction(int iFunction, int iParam, float[] afData) {
        switch (iFunction) {
            case 0: {
                this.SetConstantWMatrix(iParam, afData);
                return;
            }
            case 1: {
                this.SetConstantVMatrix(iParam, afData);
                return;
            }
            case 2: {
                this.SetConstantPMatrix(iParam, afData);
                return;
            }
            case 3: {
                this.SetConstantWVMatrix(iParam, afData);
                return;
            }
            case 4: {
                this.SetConstantVPMatrix(iParam, afData);
                return;
            }
            case 5: {
                this.SetConstantWVPMatrix(iParam, afData);
                return;
            }
            case 6: {
                this.SetConstantMaterialEmissive(iParam, afData);
                return;
            }
            case 7: {
                this.SetConstantMaterialAmbient(iParam, afData);
                return;
            }
            case 8: {
                this.SetConstantMaterialDiffuse(iParam, afData);
                return;
            }
            case 9: {
                this.SetConstantMaterialSpecular(iParam, afData);
                return;
            }
            case 10: {
                this.SetConstantCameraModelPosition(iParam, afData);
                return;
            }
            case 11: {
                this.SetConstantCameraModelDirection(iParam, afData);
                return;
            }
            case 12: {
                this.SetConstantCameraModelUp(iParam, afData);
                return;
            }
            case 13: {
                this.SetConstantCameraModelRight(iParam, afData);
                return;
            }
            case 14: {
                this.SetConstantCameraWorldPosition(iParam, afData);
                return;
            }
            case 15: {
                this.SetConstantCameraWorldDirection(iParam, afData);
                return;
            }
            case 16: {
                this.SetConstantCameraWorldUp(iParam, afData);
                return;
            }
            case 17: {
                this.SetConstantCameraWorldRight(iParam, afData);
                return;
            }
            case 18: {
                this.SetConstantProjectorModelPosition(iParam, afData);
                return;
            }
            case 19: {
                this.SetConstantProjectorModelDirection(iParam, afData);
                return;
            }
            case 20: {
                this.SetConstantProjectorModelUp(iParam, afData);
                return;
            }
            case 21: {
                this.SetConstantProjectorModelRight(iParam, afData);
                return;
            }
            case 22: {
                this.SetConstantProjectorWorldPosition(iParam, afData);
                return;
            }
            case 23: {
                this.SetConstantProjectorWorldDirection(iParam, afData);
                return;
            }
            case 24: {
                this.SetConstantProjectorWorldUp(iParam, afData);
                return;
            }
            case 25: {
                this.SetConstantProjectorWorldRight(iParam, afData);
                return;
            }
            case 26: {
                this.SetConstantProjectorMatrix(iParam, afData);
                return;
            }
            case 27: {
                this.SetConstantLightModelPosition(iParam, afData);
                return;
            }
            case 28: {
                this.SetConstantLightModelDirection(iParam, afData);
                return;
            }
            case 29: {
                this.SetConstantLightWorldPosition(iParam, afData);
                return;
            }
            case 30: {
                this.SetConstantLightWorldDirection(iParam, afData);
                return;
            }
            case 31: {
                this.SetConstantLightAmbient(iParam, afData);
                return;
            }
            case 32: {
                this.SetConstantLightDiffuse(iParam, afData);
                return;
            }
            case 33: {
                this.SetConstantLightSpecular(iParam, afData);
                return;
            }
            case 34: {
                this.SetConstantLightSpotCutoff(iParam, afData);
                return;
            }
            case 35: {
                this.SetConstantLightAttenuation(iParam, afData);
                return;
            }
        }
    }

    public static enum RendererType {
        OPENGL,
        DIRECTX,
        SOFTWARE,
        MAX_RENDERER_TYPES;

    }

    public static enum ConstantType {
        CT_RENDERER,
        CT_NUMERICAL,
        CT_USER;

    }
}

