/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;
import java.util.HashMap;

public class StencilState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 3287233860729384094L;
    private static HashMap<Integer, CompareFunction> ms_pkCompareFunctionMap = new HashMap();
    private static HashMap<Integer, OperationType> ms_pkOperationTypeMap = new HashMap();
    private static CompareFunction ms_eCompareFunctionStatic;
    private static OperationType ms_eOperationTypeStatic;
    public boolean Enabled = false;
    public CompareFunction Compare = CompareFunction.CF_NEVER;
    public int Reference = 0;
    public int Mask = -1;
    public int WriteMask = -1;
    public OperationType OnFail = OperationType.OT_KEEP;
    public OperationType OnZFail = OperationType.OT_KEEP;
    public OperationType OnZPass = OperationType.OT_KEEP;

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.STENCIL;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.Enabled = rkStream.ReadBoolean();
        int iCompare = rkStream.ReadInt();
        this.Compare = ms_pkCompareFunctionMap.get(iCompare);
        this.Reference = rkStream.ReadInt();
        this.Mask = rkStream.ReadInt();
        this.WriteMask = rkStream.ReadInt();
        int iOnFail = rkStream.ReadInt();
        this.OnFail = ms_pkOperationTypeMap.get(iOnFail);
        int iOnZFail = rkStream.ReadInt();
        this.OnZFail = ms_pkOperationTypeMap.get(iOnZFail);
        int iOnZPass = rkStream.ReadInt();
        this.OnZPass = ms_pkOperationTypeMap.get(iOnZPass);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Enabled);
        rkStream.Write(this.Compare.Value());
        rkStream.Write(this.Reference);
        rkStream.Write(this.Mask);
        rkStream.Write(this.WriteMask);
        rkStream.Write(this.OnFail.Value());
        rkStream.Write(this.OnZFail.Value());
        rkStream.Write(this.OnZPass.Value());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("StencilState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("enabled =", this.Enabled));
        pkTree.Append(StringTree.Format("compare =", this.Compare.Name()));
        pkTree.Append(StringTree.Format("reference =", this.Reference));
        pkTree.Append(StringTree.Format("mask =", this.Mask));
        pkTree.Append(StringTree.Format("write mask =", this.WriteMask));
        pkTree.Append(StringTree.Format("on fail =", this.OnFail.Name()));
        pkTree.Append(StringTree.Format("on z-fail =", this.OnZFail.Name()));
        pkTree.Append(StringTree.Format("on z-pass =", this.OnZPass.Name()));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.STENCIL.Value()]) {
            StencilState.DefaultInitialized[GlobalState.StateType.STENCIL.Value()] = true;
            StencilState.Default[GlobalState.StateType.STENCIL.Value()] = new StencilState();
        }
        ms_eCompareFunctionStatic = CompareFunction.CF_QUANTITY;
        ms_eOperationTypeStatic = OperationType.OT_QUANTITY;
    }

    public static enum OperationType {
        OT_KEEP("OT_KEEP"),
        OT_ZERO("OT_ZERO"),
        OT_REPLACE("OT_REPLACE"),
        OT_INCREMENT("OT_INCREMENT"),
        OT_DECREMENT("OT_DECREMENT"),
        OT_INVERT("OT_INVERT"),
        OT_QUANTITY("OT_QUANTITY");

        private String m_kName;
        private int m_iValue;
        private static int m_iInitValue;

        private OperationType(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkOperationTypeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum CompareFunction {
        CF_NEVER("CF_NEVER"),
        CF_LESS("CF_LESS"),
        CF_EQUAL("CF_EQUAL"),
        CF_LEQUAL("CF_LEQUAL"),
        CF_GREATER("CF_GREATER"),
        CF_NOTEQUAL("CF_NOTEQUAL"),
        CF_GEQUAL("CF_GEQUAL"),
        CF_ALWAYS("CF_ALWAYS"),
        CF_QUANTITY("CF_QUANTITY");

        private String m_kName;
        private int m_iValue;
        private static int m_iInitValue;

        private CompareFunction(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkCompareFunctionMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

