/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Bindable;
import WildMagic.LibGraphics.Rendering.GraphicsImage;
import java.io.Serializable;
import java.util.HashMap;

public class Texture
extends Bindable
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -2901243463468873337L;
    private static HashMap<Integer, FilterType> ms_pkFilterTypeMap = new HashMap();
    private static HashMap<Integer, WrapType> ms_pkWrapTypeMap = new HashMap();
    private static HashMap<Integer, DepthCompare> ms_pkDepthCompareMap = new HashMap();
    private static FilterType ms_eFilterTypeStatic = FilterType.MAX_FILTER_TYPES;
    private static WrapType ms_eWrapTypeStatic = WrapType.MAX_WRAP_TYPES;
    private static DepthCompare ms_eDepthCompareStatic = DepthCompare.DC_QUANTITY;
    protected GraphicsImage m_spkImage;
    protected FilterType m_eFType = FilterType.LINEAR;
    protected WrapType[] m_aeWType = new WrapType[]{WrapType.CLAMP_EDGE, WrapType.CLAMP_EDGE, WrapType.CLAMP_EDGE};
    protected ColorRGBA m_kBorderColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    protected DepthCompare m_eCompare = DepthCompare.DC_QUANTITY;
    protected boolean m_bOffscreenTexture = false;
    protected boolean m_bReload = false;
    private Type m_eType;

    public Texture() {
        this.m_spkImage = null;
        this.m_eType = Type.MAX_SAMPLER_TYPES;
    }

    public Texture(GraphicsImage pkImage) {
        this.m_spkImage = pkImage;
        int iDim = pkImage.GetDimension();
        switch (iDim) {
            case 1: {
                this.m_eType = Type.SAMPLER_1D;
                break;
            }
            case 2: {
                this.m_eType = Type.SAMPLER_2D;
                break;
            }
            case 3: {
                this.m_eType = Type.SAMPLER_3D;
                break;
            }
            default: {
                this.m_eType = Type.MAX_SAMPLER_TYPES;
            }
        }
    }

    @Override
    public void dispose() {
        this.m_aeWType = null;
        this.m_kBorderColor = null;
        this.Release();
        super.dispose();
    }

    public final ColorRGBA GetBorderColor() {
        return this.m_kBorderColor;
    }

    public final DepthCompare GetDepthCompare() {
        return this.m_eCompare;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + 3 * Stream.SIZEOF_INT + 4 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_INT + Stream.SIZEOF_BOOLEAN;
    }

    public final FilterType GetFilterType() {
        return this.m_eFType;
    }

    public final GraphicsImage GetImage() {
        return this.m_spkImage;
    }

    @Override
    public final String GetName() {
        if (this.m_spkImage != null) {
            return this.m_spkImage.GetName();
        }
        return super.GetName();
    }

    public final Type GetType() {
        return this.m_eType;
    }

    public WrapType GetWrapType(int i) {
        assert (0 <= i && i < 3);
        return this.m_aeWType[i];
    }

    public final boolean IsDepthTexture() {
        return this.m_eCompare != DepthCompare.DC_QUANTITY;
    }

    public final boolean IsOffscreenTexture() {
        return this.m_bOffscreenTexture;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iFType = rkStream.ReadInt();
        this.m_eFType = ms_pkFilterTypeMap.get(iFType);
        for (int i = 0; i < 3; ++i) {
            int iWType = rkStream.ReadInt();
            this.m_aeWType[i] = ms_pkWrapTypeMap.get(iWType);
        }
        rkStream.Read(this.m_kBorderColor);
        int iCompare = rkStream.ReadInt();
        this.m_eCompare = ms_pkDepthCompareMap.get(iCompare);
        this.m_bOffscreenTexture = rkStream.ReadBoolean();
    }

    public boolean Reload() {
        return this.m_bReload;
    }

    public void Reload(boolean bReload) {
        this.m_bReload = bReload;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_eFType.Value());
        for (int i = 0; i < 3; ++i) {
            rkStream.Write(this.m_aeWType[i].Value());
        }
        rkStream.Write(this.m_kBorderColor);
        rkStream.Write(this.m_eCompare.Value());
        rkStream.Write(this.m_bOffscreenTexture);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Texture", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("filter = ", this.m_eFType.Name()));
        for (int i = 0; i < 3; ++i) {
            String kPrefix = new String("wrap[" + i + "] =");
            pkTree.Append(StringTree.Format(kPrefix, this.m_aeWType[i].Name()));
        }
        pkTree.Append(StringTree.Format("border color =", this.m_kBorderColor));
        if (this.m_eCompare != DepthCompare.DC_QUANTITY) {
            pkTree.Append(StringTree.Format("depth compare = ", this.m_eCompare.Name()));
        }
        pkTree.Append(StringTree.Format("offscreen =", this.m_bOffscreenTexture));
        return pkTree;
    }

    public void SetBorderColor(ColorRGBA rkBorderColor) {
        this.m_kBorderColor = rkBorderColor;
    }

    public void SetDepthCompare(DepthCompare eCompare) {
        this.m_eCompare = eCompare;
    }

    public void SetFilterType(FilterType eFType) {
        this.m_eFType = eFType;
    }

    public void SetImage(GraphicsImage pkImage) {
        this.m_spkImage = pkImage;
        int iDim = pkImage.GetDimension();
        switch (iDim) {
            case 1: {
                this.m_eType = Type.SAMPLER_1D;
                break;
            }
            case 2: {
                this.m_eType = Type.SAMPLER_2D;
                break;
            }
            case 3: {
                this.m_eType = Type.SAMPLER_3D;
                break;
            }
            default: {
                this.m_eType = Type.MAX_SAMPLER_TYPES;
            }
        }
    }

    public void SetImage(GraphicsImage pkImage, Type eType) {
        this.m_spkImage = pkImage;
        this.m_eType = eType;
    }

    public void SetOffscreenTexture(boolean bOffscreenTexture) {
        this.m_bOffscreenTexture = bOffscreenTexture;
    }

    public void SetWrapType(int i, WrapType eWType) {
        assert (0 <= i && i < 3);
        this.m_aeWType[i] = eWType;
    }

    public static enum WrapType {
        CLAMP("CLAMP"),
        REPEAT("REPEAT"),
        MIRRORED_REPEAT("MIRRORED_REPEAT"),
        CLAMP_BORDER("CLAMP_BORDER"),
        CLAMP_EDGE("CLAMP_EDGE"),
        MAX_WRAP_TYPES("MAX_WRAP_TYPES");

        private int m_iValue = this.Init();
        private String m_kName;
        private static int m_iInitValue;

        private WrapType(String kName) {
            this.m_kName = kName;
            ms_pkWrapTypeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum Type {
        SAMPLER_1D,
        SAMPLER_2D,
        SAMPLER_3D,
        SAMPLER_CUBE,
        SAMPLER_PROJ,
        SAMPLER_RECTANGLE,
        MAX_SAMPLER_TYPES;

        private int m_iValue = this.Init();
        private static int m_iInitValue;

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum FilterType {
        NEAREST("NEAREST"),
        LINEAR("LINEAR"),
        NEAREST_NEAREST("NEAREST_NEAREST"),
        NEAREST_LINEAR("NEAREST_LINEAR"),
        LINEAR_NEAREST("LINEAR_NEAREST"),
        LINEAR_LINEAR("LINEAR_LINEAR"),
        MAX_FILTER_TYPES("MAX_FILTER_TYPES");

        private int m_iValue = this.Init();
        private String m_kName;
        private static int m_iInitValue;

        private FilterType(String kName) {
            this.m_kName = kName;
            ms_pkFilterTypeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum DepthCompare {
        DC_NEVER("DC_NEVER"),
        DC_LESS("DC_LESS"),
        DC_EQUAL("DC_EQUAL"),
        DC_LEQUAL("DC_LEQUAL"),
        DC_GREATER("DC_GREATER"),
        DC_NOTEQUAL("DC_NOTEQUAL"),
        DC_GEQUAL("DC_GEQUAL"),
        DC_ALWAYS("DC_ALWAYS"),
        DC_QUANTITY("DC_QUANTITY");

        private int m_iValue = this.Init();
        private String m_kName;
        private static int m_iInitValue;

        private DepthCompare(String kName) {
            this.m_kName = kName;
            ms_pkDepthCompareMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

