/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;
import java.util.HashMap;

public class ZBufferState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 1191938418963038877L;
    private static HashMap<Integer, CompareMode> ms_pkCompareModeMap = new HashMap();
    private static CompareMode ms_eCompareModeStatic;
    public boolean Enabled = true;
    public boolean Writable = true;
    public CompareMode Compare = CompareMode.CF_LEQUAL;

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.ZBUFFER;
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.Enabled = rkStream.ReadBoolean();
        this.Writable = rkStream.ReadBoolean();
        int iCompare = rkStream.ReadInt();
        this.Compare = ms_pkCompareModeMap.get(iCompare);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.Enabled);
        rkStream.Write(this.Writable);
        rkStream.Write(this.Compare.Value());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("ZBufferState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("enabled =", this.Enabled));
        pkTree.Append(StringTree.Format("writable = ", this.Writable));
        pkTree.Append(StringTree.Format("compare = ", this.Compare.Name()));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.ZBUFFER.Value()]) {
            ZBufferState.DefaultInitialized[GlobalState.StateType.ZBUFFER.Value()] = true;
            ZBufferState.Default[GlobalState.StateType.ZBUFFER.Value()] = new ZBufferState();
        }
        ms_eCompareModeStatic = CompareMode.CF_QUANTITY;
    }

    public static enum CompareMode {
        CF_NEVER("CF_NEVER"),
        CF_LESS("CF_LESS"),
        CF_EQUAL("CF_EQUAL"),
        CF_LEQUAL("CF_LEQUAL"),
        CF_GREATER("CF_GREATER"),
        CF_NOTEQUAL("CF_NOTEQUAL"),
        CF_GEQUAL("CF_GEQUAL"),
        CF_ALWAYS("CF_ALWAYS"),
        CF_QUANTITY("CF_QUANTITY");

        private int m_iValue = this.Init();
        private String m_kName;
        private static int m_iInitValue;

        private CompareMode(String kName) {
            this.m_kName = kName;
            ms_pkCompareModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

