/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import java.io.Serializable;
import java.util.Vector;

public class Attributes
implements Serializable {
    private static final long serialVersionUID = -4695421197374836925L;
    private int m_iChannelQuantity;
    private int m_iPOffset;
    private int m_iPChannels;
    private int m_iNOffset;
    private int m_iNChannels;
    private Vector<Integer> m_kCOffset = new Vector();
    private Vector<Integer> m_kCChannels = new Vector();
    private Vector<Integer> m_kTOffset = new Vector();
    private Vector<Integer> m_kTChannels = new Vector();

    public Attributes() {
        this.m_iChannelQuantity = 0;
        this.m_iPOffset = -1;
        this.m_iPChannels = 0;
        this.m_iNOffset = -1;
        this.m_iNChannels = 0;
    }

    public Attributes(Attributes rkA) {
        int iUnit;
        this.m_iChannelQuantity = rkA.m_iChannelQuantity;
        this.m_iPOffset = rkA.m_iPOffset;
        this.m_iPChannels = rkA.m_iPChannels;
        this.m_iNOffset = rkA.m_iNOffset;
        this.m_iNChannels = rkA.m_iNChannels;
        for (iUnit = 0; iUnit < rkA.m_kCChannels.size(); ++iUnit) {
            this.SetCChannels(iUnit, rkA.m_kCChannels.get(iUnit));
        }
        for (iUnit = 0; iUnit < rkA.m_kTChannels.size(); ++iUnit) {
            this.SetTChannels(iUnit, rkA.m_kTChannels.get(iUnit));
        }
    }

    public void dispose() {
        if (this.m_kCOffset != null) {
            this.m_kCOffset.clear();
            this.m_kCOffset = null;
        }
        if (this.m_kCChannels != null) {
            this.m_kCChannels.clear();
            this.m_kCChannels = null;
        }
        if (this.m_kTOffset != null) {
            this.m_kTOffset.clear();
            this.m_kTOffset = null;
        }
        if (this.m_kTChannels != null) {
            this.m_kTChannels.clear();
            this.m_kTChannels = null;
        }
    }

    public int GetCChannels(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kCChannels.size()) {
            return this.m_kCChannels.get(iUnit);
        }
        return 0;
    }

    public final int GetChannelQuantity() {
        return this.m_iChannelQuantity;
    }

    public int GetCOffset(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kCOffset.size()) {
            return this.m_kCOffset.get(iUnit);
        }
        return -1;
    }

    public final int GetMaxColors() {
        return this.m_kCChannels.size();
    }

    public final int GetMaxTCoords() {
        return this.m_kTChannels.size();
    }

    public final int GetNChannels() {
        return this.m_iNChannels;
    }

    public final int GetNOffset() {
        return this.m_iNOffset;
    }

    public final int GetPChannels() {
        return this.m_iPChannels;
    }

    public final int GetPOffset() {
        return this.m_iPOffset;
    }

    public int GetTChannels(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kTChannels.size()) {
            return this.m_kTChannels.get(iUnit);
        }
        return 0;
    }

    public int GetTOffset(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kTOffset.size()) {
            return this.m_kTOffset.get(iUnit);
        }
        return -1;
    }

    public boolean HasColor(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kCChannels.size()) {
            return this.m_kCChannels.get(iUnit) > 0;
        }
        return false;
    }

    public final boolean HasNormal() {
        return this.m_iNChannels > 0;
    }

    public final boolean HasPosition() {
        return this.m_iPChannels > 0;
    }

    public boolean HasTCoord(int iUnit) {
        if (0 <= iUnit && iUnit < this.m_kTChannels.size()) {
            return this.m_kTChannels.get(iUnit) > 0;
        }
        return false;
    }

    public boolean Matches(Attributes rkAttr, boolean bIncludeP, boolean bIncludeN, boolean bIncludeC, boolean bIncludeT) {
        int i;
        if (bIncludeP && this.m_iPChannels != rkAttr.m_iPChannels) {
            return false;
        }
        if (bIncludeN && this.m_iNChannels != rkAttr.m_iNChannels) {
            return false;
        }
        if (bIncludeC) {
            if (this.m_kCChannels.size() != rkAttr.m_kCChannels.size()) {
                return false;
            }
            for (i = 0; i < this.m_kCChannels.size(); ++i) {
                if (this.m_kCChannels.get(i) == rkAttr.m_kCChannels.get(i)) continue;
                return false;
            }
        }
        if (bIncludeT) {
            if (this.m_kTChannels.size() != rkAttr.m_kTChannels.size()) {
                return false;
            }
            for (i = 0; i < this.m_kTChannels.size(); ++i) {
                if (this.m_kTChannels.get(i) == rkAttr.m_kTChannels.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public void SetCChannels(int iUnit, int iCChannels) {
        assert (0 <= iUnit && 0 <= iCChannels && iCChannels <= 4);
        this.m_kCChannels.add(iUnit, iCChannels);
        this.UpdateOffsets();
    }

    public void SetNChannels(int iNChannels) {
        assert (0 <= iNChannels && iNChannels <= 4);
        this.m_iNChannels = iNChannels;
        this.UpdateOffsets();
    }

    public void SetPChannels(int iPChannels) {
        assert (0 <= iPChannels && iPChannels <= 4);
        this.m_iPChannels = iPChannels;
        this.UpdateOffsets();
    }

    public void SetTChannels(int iUnit, int iTChannels) {
        assert (0 <= iUnit && 0 <= iTChannels && iTChannels <= 4);
        this.m_kTChannels.add(iUnit, iTChannels);
        this.UpdateOffsets();
    }

    private void UpdateOffsets() {
        int i;
        this.m_iChannelQuantity = 0;
        this.m_iPOffset = -1;
        this.m_iNOffset = -1;
        this.m_kCOffset.setSize(this.m_kCChannels.size());
        this.m_kTOffset.setSize(this.m_kTChannels.size());
        if (this.m_iPChannels > 0) {
            this.m_iPOffset = this.m_iChannelQuantity;
            this.m_iChannelQuantity += this.m_iPChannels;
        }
        if (this.m_iNChannels > 0) {
            this.m_iNOffset = this.m_iChannelQuantity;
            this.m_iChannelQuantity += this.m_iNChannels;
        }
        for (i = 0; i < this.m_kCChannels.size(); ++i) {
            if (this.m_kCChannels.get(i) <= 0) continue;
            this.m_kCOffset.set(i, this.m_iChannelQuantity);
            this.m_iChannelQuantity += this.m_kCChannels.get(i).intValue();
        }
        for (i = 0; i < this.m_kTChannels.size(); ++i) {
            if (this.m_kTChannels.get(i) <= 0) continue;
            this.m_kTOffset.set(i, this.m_iChannelQuantity);
            this.m_iChannelQuantity += this.m_kTChannels.get(i).intValue();
        }
    }
}

