/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Camera;
import WildMagic.LibGraphics.SceneGraph.Node;
import java.io.Serializable;
import java.util.Vector;

public class CameraNode
extends Node
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = -3362038539380722455L;
    protected Camera m_spkCamera;

    public CameraNode() {
    }

    public CameraNode(Camera pkCamera) {
        this.m_spkCamera = pkCamera;
        if (this.m_spkCamera != null) {
            this.Local.SetTranslate(this.m_spkCamera.GetLocation());
            this.Local.SetRotate(new Matrix3f(this.m_spkCamera.GetDVector(), this.m_spkCamera.GetUVector(), this.m_spkCamera.GetRVector(), true));
        }
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.m_spkCamera != null) {
            this.m_spkCamera.GetAllObjectsByName(rkName, rkObjects);
        }
    }

    public final Camera GetCamera() {
        return this.m_spkCamera;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkCamera != null && (pkFound = this.m_spkCamera.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkCamera != null && (pkFound = this.m_spkCamera.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        int iLinkID = pkLink.GetLinkID();
        this.m_spkCamera = (Camera)rkStream.GetFromMap(iLinkID);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.m_spkCamera != null) {
            this.m_spkCamera.Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_spkCamera.GetID());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("CameraNode", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        if (this.m_spkCamera != null) {
            pkTree.Append(this.m_spkCamera.SaveStrings(null));
        }
        return pkTree;
    }

    public void SetCamera(Camera pkCamera) {
        this.m_spkCamera = pkCamera;
        if (this.m_spkCamera != null) {
            this.Local.SetTranslate(this.m_spkCamera.GetLocation());
            this.Local.SetRotate(new Matrix3f(this.m_spkCamera.GetDVector(), this.m_spkCamera.GetUVector(), this.m_spkCamera.GetRVector(), true));
            this.UpdateGS();
        }
    }

    @Override
    public void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        if (this.m_spkCamera != null) {
            Vector3f kD = new Vector3f();
            this.World.GetRotate().GetColumn(0, kD);
            Vector3f kU = new Vector3f();
            this.World.GetRotate().GetColumn(1, kU);
            Vector3f kR = new Vector3f();
            this.World.GetRotate().GetColumn(2, kR);
            this.m_spkCamera.SetFrame(this.World.GetTranslate(), kD, kU, kR);
        }
    }
}

