/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Matrix4f;
import WildMagic.LibGraphics.Effects.LightingEffect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Culler;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.Spatial;
import WildMagic.LibGraphics.SceneGraph.SphereBV;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;
import java.util.Vector;

public abstract class Geometry
extends Spatial
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = -1145452502002489558L;
    public VertexBuffer VBuffer;
    public IndexBuffer IBuffer;
    public BoundingVolume ModelBound;
    protected LightingEffect m_spkLEffect;
    public GeometryType Type;
    public GlobalState[] States = new GlobalState[GlobalState.StateType.MAX_STATE_TYPE.Value()];
    public Matrix4f HWorld = new Matrix4f(false);

    public Geometry() {
        this.ModelBound = new SphereBV();
    }

    protected Geometry(Geometry kG) {
        this.VBuffer = kG.VBuffer;
        this.IBuffer = kG.IBuffer;
        this.ModelBound = new SphereBV(((SphereBV)kG.GetModelBound()).GetSphere());
    }

    protected Geometry(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer) {
        this.VBuffer = pkVBuffer;
        this.IBuffer = pkIBuffer;
        this.ModelBound = new SphereBV();
        this.UpdateModelBound();
    }

    protected Geometry(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, BoundingVolume kBounds) {
        this.VBuffer = pkVBuffer;
        this.IBuffer = pkIBuffer;
        this.ModelBound = kBounds;
    }

    @Override
    public void dispose() {
        if (this.ModelBound != null) {
            this.ModelBound.dispose();
            this.ModelBound = null;
        }
        if (this.m_spkLEffect != null) {
            this.m_spkLEffect.dispose();
            this.m_spkLEffect = null;
        }
        if (this.States != null) {
            for (int i = 0; i < GlobalState.StateType.MAX_STATE_TYPE.Value(); ++i) {
                if (this.States[i] == null) continue;
                this.States[i].dispose();
                this.States[i] = null;
            }
            this.States = null;
        }
        this.HWorld = null;
        if (this.VBuffer != null) {
            this.VBuffer.dispose();
            this.VBuffer = null;
        }
        if (this.IBuffer != null) {
            this.IBuffer.dispose();
            this.IBuffer = null;
        }
        super.dispose();
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.ModelBound != null) {
            this.ModelBound.GetAllObjectsByName(rkName, rkObjects);
        }
        if (this.VBuffer != null) {
            this.VBuffer.GetAllObjectsByName(rkName, rkObjects);
        }
        if (this.IBuffer != null) {
            this.IBuffer.GetAllObjectsByName(rkName, rkObjects);
        }
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT;
    }

    public BoundingVolume GetModelBound() {
        return this.ModelBound;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.ModelBound != null && (pkFound = this.ModelBound.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        if (this.VBuffer != null && (pkFound = this.VBuffer.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        if (this.IBuffer != null && (pkFound = this.IBuffer.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.ModelBound != null && (pkFound = this.ModelBound.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        if (this.VBuffer != null && (pkFound = this.VBuffer.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        if (this.IBuffer != null && (pkFound = this.IBuffer.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        int iLinkID = pkLink.GetLinkID();
        this.ModelBound = (BoundingVolume)rkStream.GetFromMap(iLinkID);
        iLinkID = pkLink.GetLinkID();
        this.VBuffer = (VertexBuffer)rkStream.GetFromMap(iLinkID);
        iLinkID = pkLink.GetLinkID();
        this.IBuffer = (IndexBuffer)rkStream.GetFromMap(iLinkID);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
        iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
        iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.ModelBound != null) {
            this.ModelBound.Register(rkStream);
        }
        if (this.VBuffer != null) {
            this.VBuffer.Register(rkStream);
        }
        if (this.IBuffer != null) {
            this.IBuffer.Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.ModelBound.GetID());
        rkStream.Write(this.VBuffer.GetID());
        rkStream.Write(this.IBuffer.GetID());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Geometry", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        if (this.ModelBound != null) {
            pkTree.Append(this.ModelBound.SaveStrings(null));
        }
        if (this.VBuffer != null) {
            pkTree.Append(this.VBuffer.SaveStrings("vertices"));
        }
        if (this.IBuffer != null) {
            pkTree.Append(this.IBuffer.SaveStrings("indices"));
        }
        return pkTree;
    }

    public void UpdateMS() {
        this.UpdateMS(true);
    }

    public void UpdateMS(boolean bUpdateNormals) {
        this.UpdateModelBound();
        if (bUpdateNormals) {
            this.UpdateModelNormals();
        }
    }

    @Override
    public void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        this.World.GetHomogeneous(this.HWorld);
    }

    protected void Copy(Geometry kG) {
        this.VBuffer = new VertexBuffer(kG.VBuffer);
        this.IBuffer = new IndexBuffer(kG.IBuffer);
        this.ModelBound = new SphereBV(((SphereBV)kG.GetModelBound()).GetSphere());
    }

    @Override
    protected void GetVisibleSet(Culler rkCuller, boolean bNoCull) {
        rkCuller.Insert(this, null);
    }

    protected void UpdateModelBound() {
        this.ModelBound.ComputeFromData(this.VBuffer);
    }

    protected void UpdateModelNormals() {
    }

    @Override
    protected void UpdateState(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        int i;
        for (i = 0; i < GlobalState.StateType.MAX_STATE_TYPE.Value(); ++i) {
            GlobalState pkGState = null;
            this.States[i] = pkGState = akGStack.get(i).lastElement();
        }
        int iLQuantity = pkLStack.size();
        if (iLQuantity > 0) {
            if (this.m_spkLEffect != null) {
                this.m_spkLEffect.DetachAllLights();
            } else {
                this.m_spkLEffect = new LightingEffect();
                this.m_kEffects.add(0, this.m_spkLEffect);
            }
            for (i = 0; i < iLQuantity; ++i) {
                this.m_spkLEffect.AttachLight(pkLStack.get(i));
            }
            this.m_spkLEffect.Configure();
        } else {
            if (this.m_spkLEffect != null) {
                assert (this.m_kEffects.firstElement() == this.m_spkLEffect);
                this.m_kEffects.remove(0);
            }
            this.m_spkLEffect = null;
        }
    }

    @Override
    protected void UpdateWorldBound() {
        this.ModelBound.TransformBy(this.World, this.WorldBound);
    }

    public static enum GeometryType {
        GT_POLYPOINT,
        GT_POLYLINE_SEGMENTS,
        GT_POLYLINE_OPEN,
        GT_POLYLINE_CLOSED,
        GT_TRIMESH,
        GT_TRISTRIP,
        GT_TRIFAN,
        GT_MAX_QUANTITY;

        private int m_iValue = this.Init();
        private static int m_iInitValue;

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

