/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Bindable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IndexBuffer
extends Bindable
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 5965912575723656014L;
    protected int m_iIQuantity;
    protected int[] m_aiIndex;
    protected int m_iOffset;

    public IndexBuffer() {
        this.m_iIQuantity = 0;
        this.m_aiIndex = null;
        this.m_iOffset = 0;
    }

    public IndexBuffer(IndexBuffer pkIBuffer) {
        assert (pkIBuffer != null);
        this.m_iIQuantity = pkIBuffer.m_iIQuantity;
        this.m_aiIndex = new int[this.m_iIQuantity];
        for (int i = 0; i < this.m_iIQuantity; ++i) {
            this.m_aiIndex[i] = pkIBuffer.m_aiIndex[i];
        }
        this.m_iOffset = pkIBuffer.m_iOffset;
    }

    public IndexBuffer(int iIQuantity) {
        assert (iIQuantity > 0);
        this.m_iIQuantity = iIQuantity;
        this.m_aiIndex = new int[this.m_iIQuantity];
        this.m_iOffset = 0;
    }

    public IndexBuffer(int iIQuantity, int[] aiIndex) {
        assert (iIQuantity > 0);
        this.m_iIQuantity = iIQuantity;
        this.m_aiIndex = aiIndex;
        this.m_iOffset = 0;
    }

    public IndexBuffer(int[] aiIndex) {
        assert (aiIndex.length > 0);
        this.m_iIQuantity = aiIndex.length;
        this.m_aiIndex = aiIndex;
        this.m_iOffset = 0;
    }

    public IndexBuffer(int[] aiIndex, int iSize) {
        assert (aiIndex.length > 0);
        this.m_iIQuantity = iSize;
        this.m_aiIndex = null;
        this.m_aiIndex = new int[iSize];
        for (int i = 0; i < iSize; ++i) {
            this.m_aiIndex[i] = aiIndex[i];
        }
        this.m_iOffset = 0;
    }

    @Override
    public void dispose() {
        this.Release();
        this.m_aiIndex = null;
        super.dispose();
    }

    public final int[] GetData() {
        return this.m_aiIndex;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT + this.m_iIQuantity * Stream.SIZEOF_INT + Stream.SIZEOF_INT;
    }

    public final int GetIndexQuantity() {
        return this.m_iIQuantity;
    }

    public final int GetOffset() {
        return this.m_iOffset;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_iIQuantity = rkStream.ReadInt();
        this.m_aiIndex = new int[this.m_iIQuantity];
        rkStream.Read(this.m_iIQuantity, this.m_aiIndex);
        if (rkStream.GetVersion().GreaterEqual(new StreamVersion(4, 2))) {
            this.m_iOffset = rkStream.ReadInt();
        }
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_iIQuantity);
        rkStream.Write(this.m_iIQuantity, this.m_aiIndex);
        rkStream.Write(this.m_iOffset);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("IndexBuffer", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format(acTitle, this.m_iIQuantity, this.m_aiIndex));
        return pkTree;
    }

    public final void SetIndexQuantity(int iIQuantity) {
        this.m_iIQuantity = iIQuantity;
    }

    public void SetOffset(int iOffset) {
        assert (iOffset >= 0);
        this.m_iOffset = iOffset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.m_iIQuantity);
        out.writeObject(this.m_aiIndex);
        out.writeInt(this.m_iOffset);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_iIQuantity = in.readInt();
        this.m_aiIndex = (int[])in.readObject();
        this.m_iOffset = in.readInt();
    }
}

