/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.SceneGraph.Node;
import java.io.Serializable;
import java.util.Vector;

public class LightNode
extends Node
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = 9104654239376409775L;
    protected Light m_spkLight;

    public LightNode() {
        this.m_spkLight = null;
    }

    public LightNode(Light pkLight) {
        this.m_spkLight = pkLight;
        if (this.m_spkLight != null) {
            this.Local.SetTranslate(this.m_spkLight.Position);
            this.Local.SetRotate(new Matrix3f(this.m_spkLight.DVector, this.m_spkLight.UVector, this.m_spkLight.RVector, true));
        }
    }

    @Override
    public void dispose() {
        if (this.m_spkLight != null) {
            this.m_spkLight.dispose();
            this.m_spkLight = null;
        }
        super.dispose();
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.m_spkLight != null) {
            this.m_spkLight.GetAllObjectsByName(rkName, rkObjects);
        }
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_INT;
    }

    public final Light GetLight() {
        return this.m_spkLight;
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkLight != null && (pkFound = this.m_spkLight.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.m_spkLight != null && (pkFound = this.m_spkLight.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        return null;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
        int iLinkID = pkLink.GetLinkID();
        this.m_spkLight = (Light)rkStream.GetFromMap(iLinkID);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        int iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
    }

    @Override
    public boolean Register(Stream rkStream) {
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.m_spkLight != null) {
            this.m_spkLight.Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_spkLight.GetID());
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("LightNode", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        if (this.m_spkLight != null) {
            pkTree.Append(this.m_spkLight.SaveStrings(null));
        }
        return pkTree;
    }

    public void SetLight(Light pkLight) {
        this.m_spkLight = pkLight;
        if (this.m_spkLight != null) {
            this.Local.SetTranslate(this.m_spkLight.Position);
            this.Local.SetRotate(new Matrix3f(this.m_spkLight.DVector, this.m_spkLight.UVector, this.m_spkLight.RVector, true));
            this.UpdateGS();
        }
    }

    @Override
    public void UpdateWorldData(double dAppTime) {
        super.UpdateWorldData(dAppTime);
        if (this.m_spkLight != null) {
            this.m_spkLight.Position = this.World.GetTranslate();
            if (this.m_spkLight.DVector == null) {
                this.m_spkLight.DVector = new Vector3f();
            }
            this.World.GetRotate().GetColumn(0, this.m_spkLight.DVector);
            if (this.m_spkLight.UVector == null) {
                this.m_spkLight.UVector = new Vector3f();
            }
            this.World.GetRotate().GetColumn(1, this.m_spkLight.UVector);
            if (this.m_spkLight.RVector == null) {
                this.m_spkLight.RVector = new Vector3f();
            }
            this.World.GetRotate().GetColumn(2, this.m_spkLight.RVector);
        }
    }
}

