/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibGraphics.Effects.Effect;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.NameIdInterface;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import WildMagic.LibGraphics.Rendering.Light;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Culler;
import WildMagic.LibGraphics.SceneGraph.SphereBV;
import WildMagic.LibGraphics.SceneGraph.Transformation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public abstract class Spatial
extends GraphicsObject
implements NameIdInterface,
StreamInterface,
Serializable {
    private static final long serialVersionUID = -4927343885838902575L;
    private static HashMap<Integer, CullingMode> ms_pkCullingModeMap = new HashMap();
    public Transformation Local = new Transformation();
    public Transformation World = new Transformation();
    public boolean WorldIsCurrent = false;
    public BoundingVolume WorldBound;
    public boolean WorldBoundIsCurrent = false;
    public CullingMode Culling;
    protected Spatial m_pkParent = null;
    protected Vector<GlobalState> m_kGlobalStates = new Vector();
    protected Vector<GraphicsObject> m_kLights = new Vector();
    protected Vector<Effect> m_kEffects = new Vector();
    protected int m_iStartEffect;

    public Spatial() {
        this.WorldBound = new SphereBV();
        this.Culling = CullingMode.CULL_DYNAMIC;
    }

    public void AttachEffect(Effect pkEffect) {
        assert (pkEffect != null);
        for (int i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) != pkEffect) continue;
            return;
        }
        this.m_kEffects.add(pkEffect);
    }

    public void AttachGlobalState(GlobalState pkState) {
        assert (pkState != null);
        for (int i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i).GetStateType() != pkState.GetStateType()) continue;
            this.m_kGlobalStates.set(i, pkState);
            return;
        }
        this.m_kGlobalStates.add(pkState);
    }

    public void AttachLight(Light pkLight) {
        assert (pkLight != null);
        for (int i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) != pkLight) continue;
            return;
        }
        this.m_kLights.add(pkLight);
    }

    public void DetachAllEffects() {
        this.m_kEffects.clear();
    }

    public void DetachAllGlobalStates() {
        this.m_kGlobalStates.clear();
    }

    public void DetachAllLights() {
        this.m_kLights.clear();
    }

    public void DetachEffect(Effect pkEffect) {
        for (int i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) != pkEffect) continue;
            this.m_kEffects.remove(i);
            return;
        }
    }

    public void DetachGlobalState(GlobalState.StateType eType) {
        for (int i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i).GetStateType() != eType) continue;
            this.m_kGlobalStates.remove(i);
            return;
        }
    }

    public void DetachLight(Light pkLight) {
        for (int i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) != pkLight) continue;
            this.m_kLights.remove(i);
            return;
        }
    }

    @Override
    public void dispose() {
        this.DetachAllGlobalStates();
        this.DetachAllLights();
        this.DetachAllEffects();
        this.m_pkParent = null;
        if (this.Local != null) {
            this.Local.dispose();
            this.Local = null;
        }
        if (this.World != null) {
            this.World.dispose();
            this.World = null;
        }
        super.dispose();
    }

    @Override
    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        int i;
        super.GetAllObjectsByName(rkName, rkObjects);
        if (this.WorldBound != null) {
            this.WorldBound.GetAllObjectsByName(rkName, rkObjects);
        }
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i) == null) continue;
            this.m_kGlobalStates.get(i).GetAllObjectsByName(rkName, rkObjects);
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) == null) continue;
            this.m_kLights.get(i).GetAllObjectsByName(rkName, rkObjects);
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) == null) continue;
            this.m_kEffects.get(i).GetAllObjectsByName(rkName, rkObjects);
        }
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Transformation.DISK_USED + Transformation.DISK_USED + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_INT + this.m_kGlobalStates.size() * Stream.SIZEOF_INT + Stream.SIZEOF_INT + this.m_kLights.size() * Stream.SIZEOF_INT + Stream.SIZEOF_INT + this.m_kEffects.size() * Stream.SIZEOF_INT;
    }

    public Effect GetEffect(int i) {
        assert (0 <= i && i < this.m_kEffects.size());
        return this.m_kEffects.get(i);
    }

    public int GetEffectQuantity() {
        return this.m_kEffects.size();
    }

    public GlobalState GetGlobalState(GlobalState.StateType eType) {
        for (int i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i).GetStateType() != eType) continue;
            return this.m_kGlobalStates.get(i);
        }
        return null;
    }

    public GlobalState GetGlobalState(int i) {
        assert (0 <= i && i < this.m_kGlobalStates.size());
        return this.m_kGlobalStates.get(i);
    }

    public int GetGlobalStateQuantity() {
        return this.m_kGlobalStates.size();
    }

    public Light GetLight(int i) {
        assert (0 <= i && i < this.m_kLights.size());
        return (Light)this.m_kLights.get(i);
    }

    public int GetLightQuantity() {
        return this.m_kLights.size();
    }

    @Override
    public GraphicsObject GetObjectByID(int uiID) {
        int i;
        GraphicsObject pkFound = super.GetObjectByID(uiID);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.WorldBound != null && (pkFound = this.WorldBound.GetObjectByID(uiID)) != null) {
            return pkFound;
        }
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i) == null || (pkFound = this.m_kGlobalStates.get(i).GetObjectByID(uiID)) == null) continue;
            return pkFound;
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) == null || (pkFound = this.m_kLights.get(i).GetObjectByID(uiID)) == null) continue;
            return pkFound;
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) == null || (pkFound = this.m_kEffects.get(i).GetObjectByID(uiID)) == null) continue;
            return pkFound;
        }
        return null;
    }

    @Override
    public GraphicsObject GetObjectByName(String rkName) {
        int i;
        GraphicsObject pkFound = super.GetObjectByName(rkName);
        if (pkFound != null) {
            return pkFound;
        }
        if (this.WorldBound != null && (pkFound = this.WorldBound.GetObjectByName(rkName)) != null) {
            return pkFound;
        }
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i) == null || (pkFound = this.m_kGlobalStates.get(i).GetObjectByName(rkName)) == null) continue;
            return pkFound;
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) == null || (pkFound = this.m_kLights.get(i).GetObjectByName(rkName)) == null) continue;
            return pkFound;
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) == null || (pkFound = this.m_kEffects.get(i).GetObjectByName(rkName)) == null) continue;
            return pkFound;
        }
        return null;
    }

    public Spatial GetParent() {
        return this.m_pkParent;
    }

    public int GetStartEffect() {
        return this.m_iStartEffect;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        int i;
        super.Link(rkStream, pkLink);
        int iLinkID = pkLink.GetLinkID();
        this.WorldBound = (BoundingVolume)rkStream.GetFromMap(iLinkID);
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_kGlobalStates.set(i, (GlobalState)rkStream.GetFromMap(iLinkID));
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_kLights.set(i, rkStream.GetFromMap(iLinkID));
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            iLinkID = pkLink.GetLinkID();
            this.m_kEffects.set(i, (Effect)rkStream.GetFromMap(iLinkID));
        }
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        int i;
        super.Load(rkStream, pkLink);
        rkStream.Read(this.Local);
        rkStream.Read(this.World);
        int iCulling = rkStream.ReadInt();
        this.Culling = ms_pkCullingModeMap.get(iCulling);
        this.WorldIsCurrent = rkStream.ReadBoolean();
        this.WorldBoundIsCurrent = rkStream.ReadBoolean();
        int iLinkID = rkStream.ReadInt();
        pkLink.Add(iLinkID);
        int iQuantity = rkStream.ReadInt();
        this.m_kGlobalStates.setSize(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
        iQuantity = rkStream.ReadInt();
        this.m_kLights.setSize(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
        iQuantity = rkStream.ReadInt();
        this.m_kEffects.setSize(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            iLinkID = rkStream.ReadInt();
            pkLink.Add(iLinkID);
        }
    }

    public void OnGetVisibleSet(Culler rkCuller, boolean bNoCull) {
        if (this.Culling == CullingMode.CULL_ALWAYS) {
            return;
        }
        if (this.Culling == CullingMode.CULL_NEVER) {
            bNoCull = true;
        }
        int uiSavePlaneState = rkCuller.GetPlaneState();
        if (bNoCull || rkCuller.IsVisible(this.WorldBound)) {
            this.GetVisibleSet(rkCuller, bNoCull);
        }
        rkCuller.SetPlaneState(uiSavePlaneState);
    }

    @Override
    public boolean Register(Stream rkStream) {
        int i;
        if (!super.Register(rkStream)) {
            return false;
        }
        if (this.WorldBound != null) {
            this.WorldBound.Register(rkStream);
        }
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            if (this.m_kGlobalStates.get(i) == null) continue;
            this.m_kGlobalStates.get(i).Register(rkStream);
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            if (this.m_kLights.get(i) == null) continue;
            this.m_kLights.get(i).Register(rkStream);
        }
        for (i = 0; i < this.m_kEffects.size(); ++i) {
            if (this.m_kEffects.get(i) == null) continue;
            this.m_kEffects.get(i).Register(rkStream);
        }
        return true;
    }

    @Override
    public void Save(Stream rkStream) {
        int i;
        super.Save(rkStream);
        rkStream.Write(this.Local);
        rkStream.Write(this.World);
        rkStream.Write(this.Culling.Value());
        rkStream.Write(this.WorldIsCurrent);
        rkStream.Write(this.WorldBoundIsCurrent);
        rkStream.Write(this.WorldBound.GetID());
        int iQuantity = this.m_kGlobalStates.size();
        rkStream.Write(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kGlobalStates.get(i).GetID());
        }
        iQuantity = this.m_kLights.size();
        rkStream.Write(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kLights.get(i).GetID());
        }
        iQuantity = this.m_kEffects.size();
        rkStream.Write(iQuantity);
        for (i = 0; i < iQuantity; ++i) {
            rkStream.Write(this.m_kEffects.get(i).GetID());
        }
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        int i;
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("Spatial", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        if (this.Local.IsRSMatrix()) {
            pkTree.Append(StringTree.Format("local rotate =", this.Local.GetRotate()));
        } else {
            pkTree.Append(StringTree.Format("local matrix =", this.Local.GetMatrix()));
        }
        pkTree.Append(StringTree.Format("local trans =", this.Local.GetTranslate()));
        if (this.Local.IsRSMatrix()) {
            pkTree.Append(StringTree.Format("local scale =", this.Local.GetScale()));
        } else {
            pkTree.Append(StringTree.Format("local scale part of matrix"));
        }
        if (this.World.IsRSMatrix()) {
            pkTree.Append(StringTree.Format("world rotate =", this.World.GetRotate()));
        } else {
            pkTree.Append(StringTree.Format("world matrix =", this.World.GetMatrix()));
        }
        pkTree.Append(StringTree.Format("world trans =", this.World.GetTranslate()));
        if (this.World.IsRSMatrix()) {
            pkTree.Append(StringTree.Format("world scale =", this.World.GetScale()));
        } else {
            pkTree.Append(StringTree.Format("world scale part of matrix"));
        }
        pkTree.Append(StringTree.Format("world bound =", this.WorldBound));
        pkTree.Append(StringTree.Format("culling =", this.Culling.Name()));
        pkTree.Append(StringTree.Format("start effect =", this.m_iStartEffect));
        int iQuantity = this.m_kGlobalStates.size();
        for (i = 0; i < iQuantity; ++i) {
            pkTree.Append(this.m_kGlobalStates.get(i).SaveStrings(null));
        }
        iQuantity = this.m_kLights.size();
        for (i = 0; i < iQuantity; ++i) {
            pkTree.Append(this.m_kLights.get(i).SaveStrings(null));
        }
        iQuantity = this.m_kEffects.size();
        for (i = 0; i < iQuantity; ++i) {
            pkTree.Append(this.m_kEffects.get(i).SaveStrings(null));
        }
        return pkTree;
    }

    public void SetParent(Spatial pkParent) {
        this.m_pkParent = pkParent;
    }

    public void SetStartEffect(int i) {
        assert (0 <= i && i < this.m_kEffects.size());
        this.m_iStartEffect = i;
    }

    public void UpdateBS() {
        this.UpdateWorldBound();
        this.PropagateBoundToRoot();
    }

    public void UpdateGS() {
        this.UpdateWorldData(1.4E-45f);
        this.UpdateWorldBound();
        this.PropagateBoundToRoot();
    }

    public void UpdateGS(double dAppTime, boolean bInitiator) {
        this.UpdateWorldData(dAppTime);
        this.UpdateWorldBound();
        if (bInitiator) {
            this.PropagateBoundToRoot();
        }
    }

    public void UpdateRS() {
        this.UpdateRS(null, null);
    }

    public void UpdateRS(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        boolean bInitiator;
        boolean bl = bInitiator = akGStack == null;
        if (bInitiator) {
            akGStack = new Vector();
            for (int i = 0; i < GlobalState.StateType.MAX_STATE_TYPE.Value(); ++i) {
                Vector<Object> kVector = new Vector<Object>();
                kVector.add(null);
                akGStack.add(kVector);
            }
            pkLStack = new Vector();
            this.PropagateStateFromRoot(akGStack, pkLStack);
        } else {
            this.PushState(akGStack, pkLStack);
        }
        this.UpdateState(akGStack, pkLStack);
        if (bInitiator) {
            akGStack = null;
            pkLStack = null;
        } else {
            this.PopState(akGStack, pkLStack);
        }
    }

    protected abstract void GetVisibleSet(Culler var1, boolean var2);

    protected void PopState(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        int i;
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            GlobalState.StateType eType = this.m_kGlobalStates.get(i).GetStateType();
            akGStack.get(eType.Value()).remove(akGStack.get(eType.Value()).lastElement());
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            pkLStack.remove(pkLStack.lastElement());
        }
    }

    protected void PropagateBoundToRoot() {
        if (this.m_pkParent != null) {
            this.m_pkParent.UpdateWorldBound();
            this.m_pkParent.PropagateBoundToRoot();
        }
    }

    protected void PropagateStateFromRoot(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        if (this.m_pkParent != null) {
            this.m_pkParent.PropagateStateFromRoot(akGStack, pkLStack);
        }
        this.PushState(akGStack, pkLStack);
    }

    protected void PushState(Vector<Vector<GlobalState>> akGStack, Vector<Light> pkLStack) {
        int i;
        for (i = 0; i < this.m_kGlobalStates.size(); ++i) {
            GlobalState.StateType eType = this.m_kGlobalStates.get(i).GetStateType();
            akGStack.get(eType.Value()).add(this.m_kGlobalStates.get(i));
        }
        for (i = 0; i < this.m_kLights.size(); ++i) {
            Light pkLight = (Light)this.m_kLights.get(i);
            pkLStack.add(pkLight);
        }
    }

    protected abstract void UpdateState(Vector<Vector<GlobalState>> var1, Vector<Light> var2);

    protected abstract void UpdateWorldBound();

    protected void UpdateWorldData(double dAppTime) {
        if (!this.WorldIsCurrent) {
            if (this.m_pkParent != null) {
                this.World.Product(this.m_pkParent.World, this.Local);
            } else {
                this.World = this.Local;
            }
        }
    }

    public static enum CullingMode {
        CULL_DYNAMIC("CULL_DYNAMIC"),
        CULL_ALWAYS("CULL_ALWAYS"),
        CULL_NEVER("CULL_NEVER"),
        MAX_CULLING_MODE("MAX_CULLING_MODE");

        private String m_kName;
        private int m_iValue;
        private static int m_iInitValue;

        private CullingMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            ms_pkCullingModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

