/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.SceneGraph;

import WildMagic.LibFoundation.Intersection.IntrLine3Sphere3f;
import WildMagic.LibFoundation.Intersection.IntrRay3Sphere3f;
import WildMagic.LibFoundation.Intersection.IntrSegment3Sphere3f;
import WildMagic.LibFoundation.Intersection.IntrSphere3Sphere3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Ray3f;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Sphere3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.Transformation;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class SphereBV
extends BoundingVolume
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 8799025289619239390L;
    protected Sphere3f m_kSphere;

    public SphereBV() {
        this.m_kSphere = new Sphere3f(Vector3f.ZERO, 0.0f);
    }

    public SphereBV(Sphere3f rkSphere) {
        this.m_kSphere = rkSphere;
    }

    @Override
    public void ComputeFromData(Vector3f[] pkVertices) {
        if (pkVertices != null) {
            int iVQuantity = pkVertices.length;
            this.m_kSphere = Sphere3f.ContSphereAverage(iVQuantity, pkVertices);
        }
    }

    @Override
    public void ComputeFromData(VertexBuffer pkVBuffer) {
        if (pkVBuffer != null) {
            int i;
            int iPQuantity = pkVBuffer.GetVertexQuantity();
            if (this.m_kSphere.Center == null) {
                this.m_kSphere.Center = new Vector3f();
            }
            this.m_kSphere.Center.Copy(Vector3f.ZERO);
            this.m_kSphere.Radius = 0.0f;
            for (i = 0; i < iPQuantity; ++i) {
                this.m_kSphere.Center.Add(pkVBuffer.GetPosition3fX(i), pkVBuffer.GetPosition3fY(i), pkVBuffer.GetPosition3fZ(i));
            }
            this.m_kSphere.Center.Div(iPQuantity);
            Vector3f kDiff = new Vector3f();
            for (i = 0; i < iPQuantity; ++i) {
                kDiff.Set(pkVBuffer.GetPosition3fX(i), pkVBuffer.GetPosition3fY(i), pkVBuffer.GetPosition3fZ(i));
                kDiff.Sub(this.m_kSphere.Center);
                float fRadiusSqr = kDiff.SquaredLength();
                if (!(fRadiusSqr > this.m_kSphere.Radius)) continue;
                this.m_kSphere.Radius = fRadiusSqr;
            }
            kDiff = null;
            this.m_kSphere.Radius = (float)Math.sqrt(this.m_kSphere.Radius);
        }
    }

    @Override
    public boolean Contains(Vector3f rkPoint) {
        return Sphere3f.InSphere(rkPoint, this.m_kSphere);
    }

    @Override
    public void CopyFrom(BoundingVolume pkInput) {
        this.m_kSphere = ((SphereBV)pkInput).m_kSphere;
    }

    @Override
    public void dispose() {
        if (this.m_kSphere != null) {
            this.m_kSphere.dispose();
            this.m_kSphere = null;
        }
        super.dispose();
    }

    @Override
    public final BoundingVolume.BVType GetBVType() {
        return BoundingVolume.BVType.BV_SPHERE;
    }

    @Override
    public final Vector3f GetCenter() {
        return this.m_kSphere.Center;
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + 3 * Stream.SIZEOF_FLOAT + Stream.SIZEOF_FLOAT;
    }

    @Override
    public final float GetRadius() {
        return this.m_kSphere.Radius;
    }

    public final Sphere3f GetSphere() {
        return this.m_kSphere;
    }

    @Override
    public void GrowToContain(BoundingVolume pkInput) {
        this.m_kSphere.MergeSpheres(((SphereBV)pkInput).m_kSphere);
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        rkStream.Read(this.m_kSphere.Center);
        this.m_kSphere.Radius = rkStream.ReadFloat();
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_kSphere.Center);
        rkStream.Write(this.m_kSphere.Radius);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("SphereBV", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("center =", this.m_kSphere.Center));
        pkTree.Append(StringTree.Format("radius =", this.m_kSphere.Radius));
        return pkTree;
    }

    @Override
    public final void SetCenter(Vector3f rkCenter) {
        this.m_kSphere.Center = rkCenter;
    }

    @Override
    public final void SetRadius(float fRadius) {
        this.m_kSphere.Radius = fRadius;
    }

    public final Sphere3f Sphere() {
        return this.m_kSphere;
    }

    @Override
    public boolean TestIntersection(BoundingVolume pkInput) {
        Sphere3f kSphere = ((SphereBV)pkInput).m_kSphere;
        IntrSphere3Sphere3f kIntrSS = new IntrSphere3Sphere3f(this.m_kSphere, kSphere);
        return kIntrSS.Test();
    }

    @Override
    public boolean TestIntersection(Vector3f rkOrigin, Vector3f rkDirection, float fTMin, float fTMax) {
        if (fTMin == Float.MIN_VALUE) {
            Line3f kLine = new Line3f(rkOrigin, rkDirection);
            IntrLine3Sphere3f kIntrLS = new IntrLine3Sphere3f(kLine, this.m_kSphere);
            return kIntrLS.Test();
        }
        assert (fTMin == 0.0f);
        if (fTMax == Float.MAX_VALUE) {
            Ray3f kRay = new Ray3f(rkOrigin, rkDirection);
            IntrRay3Sphere3f kIntrRS = new IntrRay3Sphere3f(kRay, this.m_kSphere);
            return kIntrRS.Test();
        }
        assert (fTMax > fTMin);
        Segment3f kSegment = new Segment3f();
        kSegment.Extent = 0.5f * fTMax;
        Vector3f kScale = new Vector3f(rkDirection);
        kScale.Scale(kSegment.Extent);
        kSegment.Center.Add(rkOrigin, kScale);
        kScale = null;
        kSegment.Direction = rkDirection;
        IntrSegment3Sphere3f kIntrSegS = new IntrSegment3Sphere3f(kSegment, this.m_kSphere);
        return kIntrSegS.Test();
    }

    @Override
    public void TransformBy(Transformation rkTransform, BoundingVolume pkResult) {
        Sphere3f rkTarget = ((SphereBV)pkResult).m_kSphere;
        rkTransform.ApplyForward(this.m_kSphere.Center, rkTarget.Center);
        rkTarget.Radius = rkTransform.GetNorm() * this.m_kSphere.Radius;
    }

    @Override
    public int WhichSide(Plane3f rkPlane) {
        float fDistance = rkPlane.DistanceTo(this.m_kSphere.Center);
        if (fDistance <= -this.m_kSphere.Radius) {
            return -1;
        }
        if (fDistance >= this.m_kSphere.Radius) {
            return 1;
        }
        return 0;
    }
}

